/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class IfStmt
extends Statement {
    private Expression condition;
    private Statement thenStmt;
    private Statement elseStmt;

    public IfStmt() {
    }

    public IfStmt(Expression condition, Statement thenStmt, Statement elseStmt) {
        this.setCondition(condition);
        this.setThenStmt(thenStmt);
        this.setElseStmt(elseStmt);
    }

    public IfStmt(int beginLine, int beginColumn, int endLine, int endColumn, Expression condition, Statement thenStmt, Statement elseStmt) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setCondition(condition);
        this.setThenStmt(thenStmt);
        this.setElseStmt(elseStmt);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.condition == child) {
                this.condition = null;
                result = true;
            }
            if (!result && this.thenStmt == child) {
                this.thenStmt = null;
                result = true;
            }
            if (!result && this.elseStmt == child) {
                this.elseStmt = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.condition != null) {
            children.add(this.condition);
        }
        if (this.thenStmt != null) {
            children.add(this.thenStmt);
        }
        if (this.elseStmt != null) {
            children.add(this.elseStmt);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getElseStmt() {
        return this.elseStmt;
    }

    public Statement getThenStmt() {
        return this.thenStmt;
    }

    public void setCondition(Expression condition) {
        if (this.condition != null) {
            this.updateReferences(this.condition);
        }
        this.condition = condition;
        this.setAsParentNodeOf(condition);
    }

    public void setElseStmt(Statement elseStmt) {
        if (this.elseStmt != null) {
            this.updateReferences(this.elseStmt);
        }
        this.elseStmt = elseStmt;
        this.setAsParentNodeOf(elseStmt);
    }

    public void setThenStmt(Statement thenStmt) {
        if (this.thenStmt != null) {
            this.updateReferences(this.thenStmt);
        }
        this.thenStmt = thenStmt;
        this.setAsParentNodeOf(thenStmt);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.condition) {
            this.setCondition((Expression)newChild);
            updated = true;
        }
        if (!updated) {
            if (oldChild == this.thenStmt) {
                this.setThenStmt((Statement)newChild);
                updated = true;
            }
            if (!updated && oldChild == this.elseStmt) {
                this.setElseStmt((Statement)newChild);
                updated = true;
            }
        }
        return updated;
    }

    @Override
    public IfStmt clone() throws CloneNotSupportedException {
        return new IfStmt(this.clone(this.condition), this.clone(this.thenStmt), this.clone(this.elseStmt));
    }
}

