/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class SwitchEntryStmt
extends Statement {
    private Expression label;
    private List<Statement> stmts;

    public SwitchEntryStmt() {
    }

    public SwitchEntryStmt(Expression label, List<Statement> stmts) {
        this.setLabel(label);
        this.setStmts(stmts);
    }

    public SwitchEntryStmt(int beginLine, int beginColumn, int endLine, int endColumn, Expression label, List<Statement> stmts) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setLabel(label);
        this.setStmts(stmts);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.label == child) {
                this.label = null;
                result = true;
            }
            if (!result && child instanceof Statement && this.stmts != null) {
                LinkedList<Statement> stmtsAux = new LinkedList<Statement>(this.stmts);
                result = stmtsAux.remove(child);
                this.stmts = stmtsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.label != null) {
            children.add(this.label);
        }
        if (this.stmts != null) {
            children.addAll(this.stmts);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getLabel() {
        return this.label;
    }

    public List<Statement> getStmts() {
        return this.stmts;
    }

    public void setLabel(Expression label) {
        if (this.label != null) {
            this.updateReferences(this.label);
        }
        this.label = label;
        this.setAsParentNodeOf(label);
    }

    public void setStmts(List<Statement> stmts) {
        this.stmts = stmts;
        this.setAsParentNodeOf(stmts);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<Statement> auxStmts;
        boolean updated = false;
        if (oldChild == this.label) {
            this.setLabel((Expression)newChild);
            updated = true;
        }
        if (!updated && this.stmts != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxStmts = new LinkedList<Statement>(this.stmts)))) {
            this.stmts = auxStmts;
        }
        return updated;
    }

    @Override
    public SwitchEntryStmt clone() throws CloneNotSupportedException {
        return new SwitchEntryStmt(this.clone(this.label), this.clone(this.stmts));
    }
}

