/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.ast.stmt.SwitchEntryStmt;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class SwitchStmt
extends Statement {
    private Expression selector;
    private List<SwitchEntryStmt> entries;

    public SwitchStmt() {
    }

    public SwitchStmt(Expression selector, List<SwitchEntryStmt> entries) {
        this.setSelector(selector);
        this.setEntries(entries);
    }

    public SwitchStmt(int beginLine, int beginColumn, int endLine, int endColumn, Expression selector, List<SwitchEntryStmt> entries) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setSelector(selector);
        this.setEntries(entries);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (child == this.selector) {
                this.selector = null;
                result = true;
            }
            if (!result && child instanceof SwitchStmt && this.entries != null) {
                LinkedList<SwitchEntryStmt> entriesAux = new LinkedList<SwitchEntryStmt>(this.entries);
                result = entriesAux.remove(child);
                this.entries = entriesAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.selector != null) {
            children.add(this.selector);
        }
        if (this.entries != null) {
            children.addAll(this.entries);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<SwitchEntryStmt> getEntries() {
        return this.entries;
    }

    public Expression getSelector() {
        return this.selector;
    }

    public void setEntries(List<SwitchEntryStmt> entries) {
        this.entries = entries;
        this.setAsParentNodeOf(entries);
    }

    public void setSelector(Expression selector) {
        if (this.selector != null) {
            this.updateReferences(this.selector);
        }
        this.selector = selector;
        this.setAsParentNodeOf(selector);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<SwitchEntryStmt> auxEntries;
        boolean updated = false;
        if (oldChild == this.selector) {
            this.setSelector((Expression)newChild);
            updated = true;
        }
        if (!updated && this.entries != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxEntries = new LinkedList<SwitchEntryStmt>(this.entries)))) {
            this.entries = auxEntries;
        }
        return updated;
    }

    @Override
    public SwitchStmt clone() throws CloneNotSupportedException {
        return new SwitchStmt(this.clone(this.selector), this.clone(this.entries));
    }
}

