/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.type;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.type.ReferenceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public class IntersectionType
extends Type {
    private List<ReferenceType> bounds;

    public IntersectionType() {
    }

    public IntersectionType(List<ReferenceType> bounds) {
        this.setBounds(bounds);
    }

    public IntersectionType(int beginLine, int beginColumn, int endLine, int endColumn, List<ReferenceType> bounds) {
        super(beginLine, beginColumn, endLine, endColumn, null);
        this.setBounds(bounds);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.bounds != null && child instanceof ReferenceType) {
            LinkedList<ReferenceType> boundsAux = new LinkedList<ReferenceType>(this.bounds);
            result = boundsAux.remove(child);
            this.bounds = boundsAux;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.bounds != null) {
            children.addAll(this.bounds);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<ReferenceType> getBounds() {
        return this.bounds;
    }

    public void setBounds(List<ReferenceType> bounds) {
        this.bounds = bounds;
        this.setAsParentNodeOf(bounds);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        return super.replaceChildNode(oldChild, newChild);
    }

    @Override
    public IntersectionType clone() throws CloneNotSupportedException {
        return new IntersectionType(this.clone(this.getBounds()));
    }
}

