/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.type;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ReferenceType
extends Type {
    private Type type;
    private int arrayCount;
    private List<List<AnnotationExpr>> arraysAnnotations;

    public ReferenceType() {
    }

    public ReferenceType(Type type) {
        this.setType(type);
    }

    public ReferenceType(Type type, int arrayCount) {
        this.setType(type);
        this.arrayCount = arrayCount;
    }

    public ReferenceType(Type type, int arrayCount, List<AnnotationExpr> annotations) {
        super(annotations);
        this.setType(type);
        this.arrayCount = arrayCount;
    }

    public ReferenceType(Type type, int arrayCount, List<AnnotationExpr> annotations, List<List<AnnotationExpr>> arraysAnnotations) {
        super(annotations);
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setArraysAnnotations(arraysAnnotations);
    }

    public ReferenceType(int beginLine, int beginColumn, int endLine, int endColumn, Type type, int arrayCount) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setType(type);
        this.arrayCount = arrayCount;
    }

    public ReferenceType(int beginLine, int beginColumn, int endLine, int endColumn, Type type, int arrayCount, List<AnnotationExpr> annotations, List<List<AnnotationExpr>> arraysAnnotations) {
        super(beginLine, beginColumn, endLine, endColumn, annotations);
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setArraysAnnotations(arraysAnnotations);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (child == this.type) {
                this.type = null;
                result = true;
            }
            if (this.arraysAnnotations != null && child instanceof AnnotationExpr) {
                LinkedList<List<AnnotationExpr>> arraysAnnotationsAux = new LinkedList<List<AnnotationExpr>>();
                for (List<AnnotationExpr> next : this.arraysAnnotations) {
                    LinkedList<AnnotationExpr> nextAux = new LinkedList<AnnotationExpr>(next);
                    result = result || nextAux.remove(child);
                    arraysAnnotationsAux.add(nextAux);
                }
                this.arraysAnnotations = arraysAnnotationsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.arraysAnnotations != null) {
            for (List<AnnotationExpr> annList : this.arraysAnnotations) {
                children.addAll(annList);
            }
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public Type getType() {
        return this.type;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setType(Type type) {
        if (this.type != null) {
            this.updateReferences(this.type);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    public List<List<AnnotationExpr>> getArraysAnnotations() {
        return this.arraysAnnotations;
    }

    public void setArraysAnnotations(List<List<AnnotationExpr>> arraysAnnotations) {
        this.arraysAnnotations = arraysAnnotations;
        if (arraysAnnotations != null) {
            for (List<AnnotationExpr> ann : arraysAnnotations) {
                this.setAsParentNodeOf(ann);
            }
        }
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = super.replaceChildNode(oldChild, newChild);
        if (oldChild == this.type) {
            this.setType((ClassOrInterfaceType)newChild);
            updated = true;
        }
        if (!updated && this.arraysAnnotations != null) {
            LinkedList<List<AnnotationExpr>> auxArraysAnn = new LinkedList<List<AnnotationExpr>>(this.arraysAnnotations);
            for (List list : auxArraysAnn) {
                updated = updated || this.replaceChildNodeInList(oldChild, newChild, list);
            }
            if (updated) {
                this.arraysAnnotations = auxArraysAnn;
            }
        }
        return updated;
    }

    @Override
    public ReferenceType clone() throws CloneNotSupportedException {
        LinkedList<List<AnnotationExpr>> copy = null;
        if (this.arraysAnnotations != null) {
            copy = new LinkedList<List<AnnotationExpr>>();
            for (List<AnnotationExpr> item : this.arraysAnnotations) {
                copy.add(this.clone(item));
            }
        }
        return new ReferenceType(this.clone(this.type), this.arrayCount, this.clone(this.getAnnotations()), copy);
    }
}

