/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.type;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.ReferenceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class WildcardType
extends Type {
    private ReferenceType ext;
    private ReferenceType sup;

    public WildcardType() {
    }

    public WildcardType(ReferenceType ext) {
        this.setExtends(ext);
    }

    public WildcardType(ReferenceType ext, ReferenceType sup) {
        this.setExtends(ext);
        this.setSuper(sup);
    }

    public WildcardType(int beginLine, int beginColumn, int endLine, int endColumn, ReferenceType ext, ReferenceType sup) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setExtends(ext);
        this.setSuper(sup);
    }

    public WildcardType(int beginLine, int beginColumn, int endLine, int endColumn, ReferenceType ext, ReferenceType sup, List<AnnotationExpr> annotations) {
        super(beginLine, beginColumn, endLine, endColumn, annotations);
        this.setExtends(ext);
        this.setSuper(sup);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.ext == child) {
                this.ext = null;
                result = true;
            }
            if (!result && this.sup == child) {
                this.sup = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.ext != null) {
            children.add(this.ext);
        }
        if (this.sup != null) {
            children.add(this.sup);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public ReferenceType getExtends() {
        return this.ext;
    }

    public ReferenceType getSuper() {
        return this.sup;
    }

    public void setExtends(ReferenceType ext) {
        if (this.ext != null) {
            this.updateReferences(this.ext);
        }
        this.ext = ext;
        this.setAsParentNodeOf(ext);
    }

    public void setSuper(ReferenceType sup) {
        if (this.sup != null) {
            this.updateReferences(this.sup);
        }
        this.sup = sup;
        this.setAsParentNodeOf(sup);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = super.replaceChildNode(oldChild, newChild);
        if (!updated) {
            if (this.ext == oldChild) {
                this.setExtends((ReferenceType)newChild);
                updated = true;
            }
            if (!updated && this.sup == oldChild) {
                this.setSuper((ReferenceType)newChild);
            }
        }
        return updated;
    }

    @Override
    public WildcardType clone() throws CloneNotSupportedException {
        return new WildcardType(this.clone(this.ext), this.clone(this.sup));
    }
}

