/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.comparators;

import java.util.Comparator;
import java.util.List;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.PackageDeclaration;
import org.walkmod.javalang.ast.body.ModifierSet;
import org.walkmod.javalang.ast.body.TypeDeclaration;

public class CompilationUnitComparator
implements Comparator<CompilationUnit> {
    @Override
    public int compare(CompilationUnit cu1, CompilationUnit cu2) {
        if (cu1 != null && cu2 != null) {
            PackageDeclaration pd1 = cu1.getPackage();
            PackageDeclaration pd2 = cu2.getPackage();
            boolean samePackage = true;
            if (pd1 != pd2) {
                samePackage = pd1 != null && pd2 != null ? pd1.getName().equals(pd2.getName()) : false;
            }
            if (samePackage) {
                List<TypeDeclaration> types2;
                List<TypeDeclaration> types1 = cu1.getTypes();
                TypeDeclaration mainType = null;
                if (types1 != null) {
                    for (TypeDeclaration td : types1) {
                        if (!ModifierSet.isPublic(td.getModifiers())) continue;
                        mainType = td;
                    }
                }
                if (mainType != null && (types2 = cu2.getTypes()) != null) {
                    for (TypeDeclaration td : types2) {
                        if (!td.getName().equals(mainType.getName())) continue;
                        return 0;
                    }
                }
                return 1;
            }
        }
        if (cu1 != cu2) {
            return 1;
        }
        return 0;
    }
}

