/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.constraints;

import java.util.HashSet;
import org.walkmod.javalang.ast.Node;
import org.walkmod.modelchecker.Constraint;

public class NodesPerLineConstraint
implements Constraint<Node> {
    private HashSet<Integer> segments = new HashSet();

    public void addLine(int beginLine, int endLine) {
        for (int i = beginLine; i <= endLine; ++i) {
            this.segments.add(i);
        }
    }

    public void addLine(int lineNumber) {
        this.segments.add(lineNumber);
    }

    public boolean isConstrained(Node o) {
        if (o.isNewNode()) {
            return false;
        }
        int beginLine = o.getBeginLine();
        int endLine = o.getEndLine();
        if (this.segments.contains(beginLine) && this.segments.contains(endLine)) {
            return false;
        }
        boolean includesAChildrenNode = false;
        for (int i = beginLine; i <= endLine && !includesAChildrenNode; ++i) {
            includesAChildrenNode = this.segments.contains(i);
        }
        return !includesAChildrenNode;
    }
}

