/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.merger;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.merger.AppendMergePolicy;
import org.walkmod.merger.IdentificableNode;

public class FieldDeclarationPolicy
extends AppendMergePolicy<FieldDeclaration> {
    public void apply(FieldDeclaration remoteObject, List<FieldDeclaration> localList, List<FieldDeclaration> resultList) {
        LinkedList<FieldDeclaration> localFields = new LinkedList<FieldDeclaration>();
        if (localList != null) {
            for (FieldDeclaration localField : localList) {
                localFields.addAll(this.split(localField));
            }
        }
        if (remoteObject.getVariables() != null && remoteObject.getVariables().size() > 1) {
            List<FieldDeclaration> remoteFields = this.split(remoteObject);
            for (FieldDeclaration remoteField : remoteFields) {
                super.apply((IdentificableNode)remoteField, localFields, resultList);
            }
        } else {
            super.apply((IdentificableNode)remoteObject, localFields, resultList);
        }
    }

    private List<FieldDeclaration> split(FieldDeclaration fieldDeclaration) {
        LinkedList<FieldDeclaration> res = new LinkedList<FieldDeclaration>();
        if (fieldDeclaration.getVariables().size() > 1) {
            for (VariableDeclarator vd : fieldDeclaration.getVariables()) {
                FieldDeclaration fd = new FieldDeclaration();
                fd.setAnnotations(fieldDeclaration.getAnnotations());
                fd.setJavaDoc(fieldDeclaration.getJavaDoc());
                fd.setModifiers(fieldDeclaration.getModifiers());
                fd.setType(fieldDeclaration.getType());
                fd.setBeginLine(fieldDeclaration.getBeginLine());
                fd.setBeginColumn(fieldDeclaration.getBeginColumn());
                fd.setEndColumn(vd.getEndColumn());
                fd.setEndLine(vd.getEndLine());
                LinkedList<VariableDeclarator> vdList = new LinkedList<VariableDeclarator>();
                vdList.add(vd);
                fd.setVariables(vdList);
                res.add(fd);
            }
        } else {
            res.add(fieldDeclaration);
        }
        return res;
    }

    public void apply(List<FieldDeclaration> localList, List<FieldDeclaration> remoteList, List resultList) {
        LinkedList<FieldDeclaration> localFields = new LinkedList<FieldDeclaration>();
        if (localList != null) {
            for (FieldDeclaration localField : localList) {
                localFields.addAll(this.split(localField));
            }
        }
        LinkedList<FieldDeclaration> remoteFields = new LinkedList<FieldDeclaration>();
        if (remoteList != null) {
            for (FieldDeclaration remoteField : remoteList) {
                remoteFields.addAll(this.split(remoteField));
            }
        }
        super.apply(localFields, remoteFields, resultList);
    }
}

