/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.visitors;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.BlockComment;
import org.walkmod.javalang.ast.Comment;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.ImportDeclaration;
import org.walkmod.javalang.ast.LineComment;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.PackageDeclaration;
import org.walkmod.javalang.ast.TypeParameter;
import org.walkmod.javalang.ast.body.AnnotationDeclaration;
import org.walkmod.javalang.ast.body.AnnotationMemberDeclaration;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.ClassOrInterfaceDeclaration;
import org.walkmod.javalang.ast.body.ConstructorDeclaration;
import org.walkmod.javalang.ast.body.EmptyMemberDeclaration;
import org.walkmod.javalang.ast.body.EmptyTypeDeclaration;
import org.walkmod.javalang.ast.body.EnumConstantDeclaration;
import org.walkmod.javalang.ast.body.EnumDeclaration;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.InitializerDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.ModifierSet;
import org.walkmod.javalang.ast.body.MultiTypeParameter;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.ArrayAccessExpr;
import org.walkmod.javalang.ast.expr.ArrayCreationExpr;
import org.walkmod.javalang.ast.expr.ArrayInitializerExpr;
import org.walkmod.javalang.ast.expr.AssignExpr;
import org.walkmod.javalang.ast.expr.BinaryExpr;
import org.walkmod.javalang.ast.expr.BooleanLiteralExpr;
import org.walkmod.javalang.ast.expr.CastExpr;
import org.walkmod.javalang.ast.expr.CharLiteralExpr;
import org.walkmod.javalang.ast.expr.ClassExpr;
import org.walkmod.javalang.ast.expr.ConditionalExpr;
import org.walkmod.javalang.ast.expr.DoubleLiteralExpr;
import org.walkmod.javalang.ast.expr.EnclosedExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.FieldAccessExpr;
import org.walkmod.javalang.ast.expr.InstanceOfExpr;
import org.walkmod.javalang.ast.expr.IntegerLiteralExpr;
import org.walkmod.javalang.ast.expr.IntegerLiteralMinValueExpr;
import org.walkmod.javalang.ast.expr.LambdaExpr;
import org.walkmod.javalang.ast.expr.LongLiteralExpr;
import org.walkmod.javalang.ast.expr.LongLiteralMinValueExpr;
import org.walkmod.javalang.ast.expr.MarkerAnnotationExpr;
import org.walkmod.javalang.ast.expr.MemberValuePair;
import org.walkmod.javalang.ast.expr.MethodCallExpr;
import org.walkmod.javalang.ast.expr.MethodReferenceExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.expr.NormalAnnotationExpr;
import org.walkmod.javalang.ast.expr.NullLiteralExpr;
import org.walkmod.javalang.ast.expr.ObjectCreationExpr;
import org.walkmod.javalang.ast.expr.QualifiedNameExpr;
import org.walkmod.javalang.ast.expr.SingleMemberAnnotationExpr;
import org.walkmod.javalang.ast.expr.StringLiteralExpr;
import org.walkmod.javalang.ast.expr.SuperExpr;
import org.walkmod.javalang.ast.expr.ThisExpr;
import org.walkmod.javalang.ast.expr.TypeExpr;
import org.walkmod.javalang.ast.expr.UnaryExpr;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.AssertStmt;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.BreakStmt;
import org.walkmod.javalang.ast.stmt.CatchClause;
import org.walkmod.javalang.ast.stmt.ContinueStmt;
import org.walkmod.javalang.ast.stmt.DoStmt;
import org.walkmod.javalang.ast.stmt.EmptyStmt;
import org.walkmod.javalang.ast.stmt.ExplicitConstructorInvocationStmt;
import org.walkmod.javalang.ast.stmt.ExpressionStmt;
import org.walkmod.javalang.ast.stmt.ForStmt;
import org.walkmod.javalang.ast.stmt.ForeachStmt;
import org.walkmod.javalang.ast.stmt.IfStmt;
import org.walkmod.javalang.ast.stmt.LabeledStmt;
import org.walkmod.javalang.ast.stmt.ReturnStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.ast.stmt.SwitchEntryStmt;
import org.walkmod.javalang.ast.stmt.SwitchStmt;
import org.walkmod.javalang.ast.stmt.SynchronizedStmt;
import org.walkmod.javalang.ast.stmt.ThrowStmt;
import org.walkmod.javalang.ast.stmt.TryStmt;
import org.walkmod.javalang.ast.stmt.TypeDeclarationStmt;
import org.walkmod.javalang.ast.stmt.WhileStmt;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.ast.type.IntersectionType;
import org.walkmod.javalang.ast.type.PrimitiveType;
import org.walkmod.javalang.ast.type.ReferenceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.ast.type.VoidType;
import org.walkmod.javalang.ast.type.WildcardType;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class DumpVisitor
implements VoidVisitor<Object> {
    private List<Comment> comments = new LinkedList<Comment>();
    private boolean initializedComments = false;
    private final SourcePrinter printer = new SourcePrinter();

    public void setComments(List<Comment> comments) {
        this.comments = comments;
        this.initializedComments = true;
    }

    public void setIndentationLevel(int level) {
        this.printer.indent(level);
    }

    public void setIndentationSize(int size) {
        this.printer.setSize(size);
    }

    public void setIndentationChar(char indentationChar) {
        this.printer.setIndentationChar(indentationChar);
    }

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isProtected(modifiers)) {
            this.printer.print("protected ");
        }
        if (ModifierSet.isPublic(modifiers)) {
            this.printer.print("public ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(modifiers)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("final ");
        }
        if (ModifierSet.isNative(modifiers)) {
            this.printer.print("native ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            this.printer.print("strictfp ");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            this.printer.print("synchronized ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            this.printer.print("volatile ");
        }
    }

    private <T extends Node, K extends Node> void printChildrenNodes(K parent, List<T> members, String sepChar, Object arg) {
        Node previous = null;
        if (members != null) {
            Iterator<T> it = members.iterator();
            while (it.hasNext()) {
                Node member = (Node)it.next();
                if (previous != null) {
                    List<Node> comments;
                    JavadocComment comment = null;
                    if (member instanceof BodyDeclaration) {
                        comment = ((BodyDeclaration)member).getJavaDoc();
                    }
                    if ((comments = this.printInnerComments(previous, member, arg)).isEmpty()) {
                        if (!previous.isNewNode() && !member.isNewNode()) {
                            List<Statement> stmts;
                            int start = previous.getEndLine();
                            if (previous instanceof SwitchEntryStmt && (stmts = ((SwitchEntryStmt)previous).getStmts()) != null && !stmts.isEmpty()) {
                                ++start;
                            }
                            int end = member.getBeginLine();
                            if (comment != null && !comment.isNewNode()) {
                                end = comment.getBeginLine();
                            }
                            for (int i = start; i < end; ++i) {
                                this.printer.printLn();
                            }
                        } else {
                            this.printer.printLn();
                        }
                    } else {
                        previous = comments.get(comments.size() - 1);
                    }
                }
                member.accept(this, arg);
                if (sepChar != null && it.hasNext()) {
                    this.printer.print(sepChar);
                }
                previous = member;
            }
            if (previous != null && previous.isNewNode()) {
                this.printSameLineComments(previous, arg);
            }
        }
        if (!(sepChar != null || previous != null && previous instanceof SwitchEntryStmt)) {
            if (!parent.isNewNode()) {
                if (previous != null && parent.getEndLine() != previous.getEndLine()) {
                    this.printer.printLn();
                }
            } else {
                this.printer.printLn();
            }
        }
    }

    private void printParameterList(List<Parameter> list, Object arg) {
        Node previous = null;
        Iterator<Parameter> it = list.iterator();
        while (it.hasNext()) {
            Parameter member = it.next();
            if (previous != null) {
                List<Node> comments = this.printInnerComments(previous, member, arg);
                if (comments.isEmpty()) {
                    if (!previous.isNewNode() && !member.isNewNode()) {
                        int start = previous.getEndLine();
                        int end = member.getBeginLine();
                        for (int i = start; i < end; ++i) {
                            this.printer.printLn();
                        }
                    }
                } else {
                    previous = comments.get(comments.size() - 1);
                }
            }
            member.accept(this, arg);
            if (it.hasNext()) {
                this.printer.print(", ");
            }
            previous = member;
        }
        if (previous != null && previous.isNewNode()) {
            this.printSameLineComments(previous, arg);
        }
    }

    private void printMemberAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            Node previous = null;
            for (AnnotationExpr current : annotations) {
                if (previous != null) {
                    if (!previous.isNewNode() && !current.isNewNode()) {
                        this.addEntersBetween(previous, current);
                    } else {
                        this.printer.printLn();
                    }
                }
                current.accept(this, arg);
                previous = current;
            }
            if (!annotations.isEmpty()) {
                this.printer.printLn();
            }
        }
    }

    private void printAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            Node previous = null;
            for (AnnotationExpr current : annotations) {
                if (previous != null && !previous.isNewNode() && !current.isNewNode()) {
                    this.addEntersBetween(previous, current);
                }
                current.accept(this, arg);
                this.printer.print(" ");
                previous = current;
            }
        }
    }

    private void printTypeArgs(List<Type> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<Type> i = args.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(List<TypeParameter> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<TypeParameter> i = args.iterator();
            while (i.hasNext()) {
                TypeParameter t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printArguments(List<Expression> args, Object arg) {
        this.printer.print("(");
        if (args != null) {
            Iterator<Expression> i = args.iterator();
            while (i.hasNext()) {
                Expression e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    private void printJavadoc(JavadocComment javadoc, Object arg) {
        if (javadoc != null) {
            javadoc.accept(this, arg);
        }
    }

    private List<Node> printPreviousComments(Node n, Object arg) {
        LinkedList<Node> printedComments = new LinkedList<Node>();
        if (this.comments != null) {
            Iterator<Comment> it = this.comments.iterator();
            Comment previous = null;
            if (n instanceof BodyDeclaration) {
                previous = ((BodyDeclaration)n).getJavaDoc();
            }
            boolean isPrevious = true;
            while (it.hasNext() && isPrevious) {
                Comment c = it.next();
                boolean bl = isPrevious = !n.isNewNode() && !c.isNewNode() && c.isPreviousThan(n);
                if (isPrevious) {
                    if (previous != null) {
                        this.addEntersBetween(previous, c);
                    }
                    c.accept(this, arg);
                    printedComments.add(c);
                    previous = c;
                    it.remove();
                    continue;
                }
                if (!c.isNewNode() || c instanceof JavadocComment) continue;
                c.accept(this, arg);
                printedComments.add(c);
                it.remove();
            }
            if (previous != null && !previous.isNewNode()) {
                this.addEntersBetween(previous, n);
            }
        }
        return printedComments;
    }

    private void addSpacesBetween(Node n1, Node n2) {
        if (n1.getEndLine() == n2.getBeginLine()) {
            int endColumn = n1.getEndColumn();
            int beginLine = n2.getBeginColumn();
            if (n1 instanceof Statement) {
                ++endColumn;
            }
            for (int i = endColumn; i < beginLine; ++i) {
                this.printer.print(" ");
            }
        }
    }

    private List<Node> printInnerComments(Node previousNode, Node nextNode, Object arg) {
        LinkedList<Node> printedComments = new LinkedList<Node>();
        if (this.comments != null) {
            JavadocComment javadoc;
            Iterator<Comment> it = this.comments.iterator();
            Comment previous = null;
            if (nextNode instanceof BodyDeclaration && !nextNode.isNewNode() && (javadoc = ((BodyDeclaration)nextNode).getJavaDoc()) != null && !javadoc.isNewNode()) {
                nextNode = javadoc;
            }
            while (it.hasNext()) {
                Comment c = it.next();
                if (nextNode.isNewNode() || c.isNewNode() || !c.isPreviousThan(nextNode)) continue;
                if (previous != null) {
                    this.addEntersBetween(previous, c);
                    this.addSpacesBetween(previous, c);
                } else {
                    this.addEntersBetween(previousNode, c);
                    this.addSpacesBetween(previousNode, c);
                }
                c.accept(this, arg);
                printedComments.add(c);
                previous = c;
                it.remove();
            }
            if (previous != null) {
                this.addEntersBetween(previous, nextNode);
            }
        }
        return printedComments;
    }

    private List<Node> printSameLineComments(Node n, Object arg) {
        LinkedList<Node> printedComments = new LinkedList<Node>();
        if (this.comments != null) {
            Iterator<Comment> it = this.comments.iterator();
            while (it.hasNext()) {
                int i;
                Statement stmt;
                List<Statement> stmts;
                Comment c = it.next();
                if (n.isNewNode() || c.isNewNode()) continue;
                if (n instanceof BlockStmt) {
                    stmts = ((BlockStmt)n).getStmts();
                    if (n.getBeginLine() != c.getBeginLine()) continue;
                    if (stmts == null || stmts.isEmpty()) {
                        c.accept(this, arg);
                        printedComments.add(c);
                        it.remove();
                        continue;
                    }
                    stmt = stmts.iterator().next();
                    if (stmt.isNewNode() || stmt.getBeginLine() <= n.getBeginLine()) continue;
                    for (i = n.getBeginColumn() + 1; i < c.getBeginColumn(); ++i) {
                        this.printer.print(" ");
                    }
                    c.accept(this, arg);
                    printedComments.add(c);
                    it.remove();
                    continue;
                }
                if (n instanceof SwitchEntryStmt) {
                    stmts = ((SwitchEntryStmt)n).getStmts();
                    if (n.getBeginLine() != c.getBeginLine()) continue;
                    if (stmts == null || stmts.isEmpty()) {
                        c.accept(this, arg);
                        printedComments.add(c);
                        it.remove();
                        continue;
                    }
                    stmt = stmts.iterator().next();
                    if (stmt.isNewNode() || stmt.getBeginLine() <= n.getBeginLine()) continue;
                    for (i = n.getBeginColumn() + 1; i < c.getBeginColumn(); ++i) {
                        this.printer.print(" ");
                    }
                    c.accept(this, arg);
                    printedComments.add(c);
                    it.remove();
                    continue;
                }
                if (n.getEndLine() != c.getBeginLine()) continue;
                this.addSpacesBetween(n, c);
                c.accept(this, arg);
                printedComments.add(c);
                it.remove();
            }
        }
        return printedComments;
    }

    private List<Node> printMissingComments(Node n, Object arg) {
        LinkedList<Node> printedComments = new LinkedList<Node>();
        if (this.comments != null) {
            Iterator<Comment> it = this.comments.iterator();
            while (it.hasNext()) {
                Comment c = it.next();
                if (n.isNewNode() || c.isNewNode()) continue;
                c.accept(this, arg);
                printedComments.add(c);
                it.remove();
            }
        }
        return printedComments;
    }

    private void addEntersBetween(Node n1, Node n2) {
        JavadocComment jc;
        int end = n2.getBeginLine();
        if (n2 instanceof BodyDeclaration && (jc = ((BodyDeclaration)n2).getJavaDoc()) != null && !jc.isNewNode()) {
            end = jc.getBeginLine();
        }
        if (n1.getEndLine() < n2.getBeginLine()) {
            int start = n1.getEndLine();
            if (n1 instanceof LineComment || n1 instanceof JavadocComment || n1 instanceof SwitchEntryStmt) {
                ++start;
            }
            if (start > end) {
                end = n2.getBeginLine();
            }
            for (int i = start; i < end; ++i) {
                this.printer.printLn();
            }
        }
    }

    private Node printContainingComments(Node n, int startingLine, Object arg) {
        Comment lastNode = null;
        if (this.comments != null) {
            Iterator<Comment> it = this.comments.iterator();
            while (it.hasNext()) {
                Comment c = it.next();
                if (n.isNewNode() || c.isNewNode() || !n.contains(c)) continue;
                if (lastNode != null) {
                    this.addEntersBetween(lastNode, c);
                } else if (startingLine != -1 && startingLine < c.getBeginLine()) {
                    for (int i = startingLine; i < c.getBeginLine(); ++i) {
                        this.printer.printLn();
                    }
                }
                c.accept(this, arg);
                it.remove();
                lastNode = c;
            }
        }
        return lastNode;
    }

    private List<Node> getContainingComments(Node n) {
        LinkedList<Node> result = new LinkedList<Node>();
        if (this.comments != null) {
            for (Comment c : this.comments) {
                if (n.isNewNode() || c.isNewNode() || !n.contains(c)) continue;
                result.add(c);
            }
        }
        return result;
    }

    private void loadComments(Node n) {
        if (!this.initializedComments) {
            if (n == null) {
                return;
            }
            if (n instanceof CompilationUnit) {
                CompilationUnit unit = (CompilationUnit)n;
                List<Comment> aux = unit.getComments();
                if (aux != null) {
                    this.comments = new LinkedList<Comment>(aux);
                }
                this.initializedComments = true;
                Iterator<Comment> it = this.comments.iterator();
                while (it.hasNext()) {
                    Comment c = it.next();
                    if (!(c instanceof JavadocComment)) continue;
                    it.remove();
                }
            } else {
                this.loadComments(n.getParentNode());
            }
        }
    }

    private void prepareComments(Node n) {
        if (!this.initializedComments) {
            if (this.comments.isEmpty()) {
                this.loadComments(n);
            }
            if (!n.isNewNode()) {
                Iterator<Comment> it = this.comments.iterator();
                while (it.hasNext()) {
                    Comment current = it.next();
                    if (n.contains(current)) continue;
                    it.remove();
                }
            } else {
                this.initializedComments = false;
            }
        }
    }

    @Override
    public void visit(CompilationUnit n, Object arg) {
        this.loadComments(n);
        if (n.getPackage() != null) {
            n.getPackage().accept(this, arg);
        }
        List<Node> comments = null;
        if (n.getImports() != null) {
            Node previous = null;
            for (ImportDeclaration i : n.getImports()) {
                if (previous != null) {
                    if (previous.isNewNode() || i.isNewNode()) {
                        this.printer.printLn();
                    } else if (comments == null || comments.isEmpty()) {
                        int beginLine = previous.getEndLine();
                        int lastLine = i.getBeginLine();
                        for (int j = beginLine; j < lastLine; ++j) {
                            this.printer.printLn();
                        }
                    }
                }
                i.accept(this, arg);
                comments = this.printSameLineComments(i, arg);
                previous = i;
            }
            this.printer.printLn();
            this.printer.printLn();
        }
        if (n.getTypes() != null) {
            Iterator<TypeDeclaration> i = n.getTypes().iterator();
            while (i.hasNext()) {
                TypeDeclaration next = i.next();
                next.accept(this, arg);
                comments = this.printSameLineComments(next, arg);
                if (comments != null && !comments.isEmpty()) continue;
                this.printer.printLn();
                if (!i.hasNext()) continue;
                this.printer.printLn();
            }
        }
        this.printMissingComments(n, arg);
    }

    @Override
    public void visit(PackageDeclaration n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        this.printAnnotations(annotations, arg);
        this.printer.print("package ");
        n.getName().accept(this, arg);
        this.printer.printLn(";");
        this.printSameLineComments(n, arg);
        this.printer.printLn();
    }

    @Override
    public void visit(NameExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getName());
    }

    @Override
    public void visit(QualifiedNameExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getQualifier().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getName());
    }

    @Override
    public void visit(ImportDeclaration n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("import ");
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getName().accept(this, arg);
        if (n.isAsterisk()) {
            this.printer.print(".*");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        Iterator<ClassOrInterfaceType> i;
        ClassOrInterfaceType c;
        TypeParameter last;
        AnnotationExpr last2;
        this.prepareComments(n);
        JavadocComment comment = n.getJavaDoc();
        if (comment != null) {
            this.printPreviousComments(comment, arg);
        }
        this.printJavadoc(comment, arg);
        this.printPreviousComments(n, arg);
        int beginLineMembers = n.getBeginLine();
        List<AnnotationExpr> annotations = n.getAnnotations();
        this.printMemberAnnotations(annotations, arg);
        if (annotations != null && !annotations.isEmpty() && !(last2 = annotations.get(annotations.size() - 1)).isNewNode()) {
            beginLineMembers = last2.getEndLine() + 1;
        }
        List<ClassOrInterfaceType> extendsList = n.getExtends();
        List<ClassOrInterfaceType> implementsList = n.getImplements();
        List<TypeParameter> typeParameters = n.getTypeParameters();
        if (typeParameters != null && !typeParameters.isEmpty()) {
            TypeParameter first = typeParameters.get(0);
            this.printPreviousComments(first, arg);
        }
        if (extendsList != null && !extendsList.isEmpty()) {
            this.printPreviousComments(extendsList.get(0), arg);
        }
        if (implementsList != null && !implementsList.isEmpty()) {
            this.printPreviousComments(implementsList.get(0), arg);
        }
        this.printModifiers(n.getModifiers());
        if (n.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        this.printer.print(n.getName());
        this.printTypeParameters(typeParameters, arg);
        if (typeParameters != null && !typeParameters.isEmpty() && !(last = typeParameters.get(typeParameters.size() - 1)).isNewNode()) {
            beginLineMembers = last.getEndLine();
        }
        if (extendsList != null) {
            this.printer.print(" extends ");
            c = null;
            i = extendsList.iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            if (c != null && !c.isNewNode()) {
                beginLineMembers = c.getEndLine();
            }
        }
        if (implementsList != null) {
            this.printer.print(" implements ");
            c = null;
            i = implementsList.iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            if (c != null && !c.isNewNode()) {
                beginLineMembers = c.getEndLine();
            }
        }
        this.printer.print(" {");
        List<BodyDeclaration> members = n.getMembers();
        if (members != null && !members.isEmpty()) {
            this.printer.indent();
            this.printFirstBlankLines(n, members, beginLineMembers);
            this.printChildrenNodes(n, members, null, arg);
            this.printEntersAfterMembersAndBeforeComments(n, members);
        }
        this.printContainingCommentsAndEnters(n, members, arg, beginLineMembers);
        this.printer.unindent();
        this.printer.print("}");
    }

    private void printContainingCommentsAndEnters(Node n, List<?> members, Object arg, int beginLineMembers) {
        block8: {
            Node lastNode = null;
            lastNode = members != null && !members.isEmpty() ? this.printContainingComments(n, -1, arg) : this.printContainingComments(n, beginLineMembers, arg);
            if (lastNode == null && members != null && !members.isEmpty()) {
                lastNode = (Node)members.get(members.size() - 1);
            }
            if (n.isNewNode()) break block8;
            if (lastNode != null && !lastNode.isNewNode()) {
                int startLine = lastNode.getEndLine();
                if (lastNode instanceof BlockComment) {
                    --startLine;
                }
                if (beginLineMembers > startLine) {
                    startLine = beginLineMembers - 1;
                }
                int endLine = n.getEndLine();
                for (int i = startLine + 1; i < endLine; ++i) {
                    this.printer.printLn();
                }
            } else {
                int start = n.getBeginLine();
                if (beginLineMembers > start) {
                    start = beginLineMembers;
                }
                int end = n.getEndLine();
                for (int i = start; i < end; ++i) {
                    this.printer.printLn();
                }
            }
        }
    }

    @Override
    public void visit(EmptyTypeDeclaration n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        JavadocComment comment = n.getJavaDoc();
        this.printJavadoc(comment, arg);
        if (comment != null && !n.isNewNode() && !comment.isNewNode()) {
            int start = comment.getEndLine();
            int end = n.getBeginLine();
            for (int i = start + 1; i < end; ++i) {
                this.printer.printLn();
            }
        }
        this.printer.print(";");
    }

    @Override
    public void visit(JavadocComment n, Object arg) {
        this.printer.print("/**");
        this.printer.printJavadocText(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                ae.accept(this, arg);
                this.printer.print(" ");
            }
        }
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print(n.getName());
        this.printTypeArgs(n.getTypeArgs(), arg);
    }

    @Override
    public void visit(TypeParameter n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ann : n.getAnnotations()) {
                ann.accept(this, arg);
                this.printer.print(" ");
            }
        }
        this.printer.print(n.getName());
        if (n.getTypeBound() != null) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> i = n.getTypeBound().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
    }

    @Override
    public void visit(PrimitiveType n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                ae.accept(this, arg);
                this.printer.print(" ");
            }
        }
        switch (n.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
    }

    @Override
    public void visit(ReferenceType n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                ae.accept(this, arg);
                this.printer.print(" ");
            }
        }
        n.getType().accept(this, arg);
        List<List<AnnotationExpr>> arraysAnnotations = n.getArraysAnnotations();
        for (int i = 0; i < n.getArrayCount(); ++i) {
            List<AnnotationExpr> annotations;
            if (arraysAnnotations != null && i < arraysAnnotations.size() && (annotations = arraysAnnotations.get(i)) != null) {
                for (AnnotationExpr ae : annotations) {
                    this.printer.print(" ");
                    ae.accept(this, arg);
                }
            }
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(WildcardType n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                this.printer.print(" ");
                ae.accept(this, arg);
            }
        }
        this.printer.print("?");
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            n.getExtends().accept(this, arg);
        }
        if (n.getSuper() != null) {
            this.printer.print(" super ");
            n.getSuper().accept(this, arg);
        }
    }

    @Override
    public void visit(FieldDeclaration n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        JavadocComment comment = n.getJavaDoc();
        this.printJavadoc(comment, arg);
        this.printPreviousComments(n, arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        Type type = n.getType();
        this.printPreviousComments(type, arg);
        this.printModifiers(n.getModifiers());
        type.accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator var = i.next();
            var.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarator n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getId().accept(this, arg);
        if (n.getInit() != null) {
            this.printer.print(" = ");
            n.getInit().accept(this, arg);
        }
    }

    @Override
    public void visit(VariableDeclaratorId n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getName());
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(ArrayInitializerExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("{");
        if (n.getValues() != null) {
            this.printer.print(" ");
            Iterator<Expression> i = n.getValues().iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                expr.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        }
        this.printer.print("}");
    }

    @Override
    public void visit(VoidType n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("void");
    }

    @Override
    public void visit(ArrayAccessExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getName().accept(this, arg);
        this.printer.print("[");
        n.getIndex().accept(this, arg);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("new ");
        n.getType().accept(this, arg);
        List<List<AnnotationExpr>> arraysAnnotations = n.getArraysAnnotations();
        if (n.getDimensions() != null) {
            int j = 0;
            for (Expression dim : n.getDimensions()) {
                Object annotations;
                if (arraysAnnotations != null && j < arraysAnnotations.size() && (annotations = arraysAnnotations.get(j)) != null) {
                    Iterator<AnnotationExpr> iterator = annotations.iterator();
                    while (iterator.hasNext()) {
                        AnnotationExpr ae = iterator.next();
                        this.printer.print(" ");
                        ae.accept(this, arg);
                    }
                }
                this.printer.print("[");
                dim.accept(this, arg);
                this.printer.print("]");
                ++j;
            }
            for (int i = 0; i < n.getArrayCount(); ++i) {
                List<AnnotationExpr> annotations;
                if (arraysAnnotations != null && i < arraysAnnotations.size() && (annotations = arraysAnnotations.get(i)) != null) {
                    for (AnnotationExpr ae : annotations) {
                        this.printer.print(" ");
                        ae.accept(this, arg);
                    }
                }
                this.printer.print("[]");
            }
        } else {
            for (int i = 0; i < n.getArrayCount(); ++i) {
                List<AnnotationExpr> annotations;
                if (arraysAnnotations != null && i < arraysAnnotations.size() && (annotations = arraysAnnotations.get(i)) != null) {
                    for (AnnotationExpr ae : annotations) {
                        ae.accept(this, arg);
                        this.printer.print(" ");
                    }
                }
                this.printer.print("[]");
            }
            this.printer.print(" ");
            n.getInitializer().accept(this, arg);
        }
    }

    @Override
    public void visit(AssignExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getTarget().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("&=");
                break;
            }
            case or: {
                this.printer.print("|=");
                break;
            }
            case xor: {
                this.printer.print("^=");
                break;
            }
            case plus: {
                this.printer.print("+=");
                break;
            }
            case minus: {
                this.printer.print("-=");
                break;
            }
            case rem: {
                this.printer.print("%=");
                break;
            }
            case slash: {
                this.printer.print("/=");
                break;
            }
            case star: {
                this.printer.print("*=");
                break;
            }
            case lShift: {
                this.printer.print("<<=");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>=");
            }
        }
        this.printer.print(" ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(BinaryExpr n, Object arg) {
        Node comment;
        this.prepareComments(n);
        n.getLeft().accept(this, arg);
        this.printer.print(" ");
        Node lastNode = n.getLeft();
        List<Node> comments = this.printInnerComments(n.getLeft(), n.getRight(), arg);
        if (comments != null && !comments.isEmpty() && !(comment = comments.get(comments.size() - 1)).isNewNode()) {
            lastNode = comment;
        }
        if (!lastNode.isNewNode() && !n.getRight().isNewNode()) {
            this.addEntersBetween(lastNode, n.getRight());
        }
        switch (n.getOperator()) {
            case or: {
                this.printer.print("||");
                break;
            }
            case and: {
                this.printer.print("&&");
                break;
            }
            case binOr: {
                this.printer.print("|");
                break;
            }
            case binAnd: {
                this.printer.print("&");
                break;
            }
            case xor: {
                this.printer.print("^");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("!=");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print("<<");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>");
                break;
            }
            case plus: {
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("%");
            }
        }
        this.printer.print(" ");
        n.getRight().accept(this, arg);
    }

    @Override
    public void visit(CastExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("(");
        n.getType().accept(this, arg);
        this.printer.print(") ");
        n.getExpr().accept(this, arg);
    }

    @Override
    public void visit(ClassExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getType().accept(this, arg);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr n, Object arg) {
        Node comment;
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getCondition().accept(this, arg);
        Node lastNode = n.getCondition();
        List<Node> comments = this.printInnerComments(n.getCondition(), n.getThenExpr(), arg);
        if (comments != null && !comments.isEmpty() && !(comment = comments.get(comments.size() - 1)).isNewNode()) {
            lastNode = comment;
        }
        if (!lastNode.isNewNode() && !n.getThenExpr().isNewNode()) {
            this.addEntersBetween(lastNode, n.getThenExpr());
        }
        this.printer.print(" ? ");
        n.getThenExpr().accept(this, arg);
        lastNode = n.getThenExpr();
        comments = this.printInnerComments(lastNode, n.getElseExpr(), arg);
        if (comments != null && !comments.isEmpty() && !(comment = comments.get(comments.size() - 1)).isNewNode()) {
            lastNode = comment;
        }
        if (!lastNode.isNewNode() && !n.getElseExpr().isNewNode()) {
            this.addEntersBetween(lastNode, n.getElseExpr());
        }
        this.printer.print(" : ");
        n.getElseExpr().accept(this, arg);
    }

    @Override
    public void visit(EnclosedExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("(");
        if (n.getInner() != null) {
            n.getInner().accept(this, arg);
        }
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getScope().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getField());
    }

    @Override
    public void visit(InstanceOfExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getExpr().accept(this, arg);
        this.printer.print(" instanceof ");
        n.getType().accept(this, arg);
    }

    @Override
    public void visit(CharLiteralExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("'");
        this.printer.print(n.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralMinValueExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(StringLiteralExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("\"");
        this.printer.print(n.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(String.valueOf(n.getValue()));
    }

    @Override
    public void visit(NullLiteralExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printTypeArgs(n.getTypeArgs(), arg);
        this.printer.print(n.getName());
        this.printArguments(n.getArgs(), arg);
    }

    private void printEntersAfterMembersAndBeforeComments(Node n, List<?> members) {
        List<Node> comments = this.getContainingComments(n);
        if (!comments.isEmpty()) {
            Node last;
            Node c = comments.get(0);
            if (members != null && !members.isEmpty() && !(last = (Node)members.get(members.size() - 1)).isNewNode()) {
                int start = last.getEndLine() + 1;
                int end = c.getBeginLine();
                for (int i = start; i < end; ++i) {
                    this.printer.printLn();
                }
            }
        }
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        Expression lastType;
        int begin;
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        ClassOrInterfaceType type = n.getType();
        this.printPreviousComments(type, arg);
        int beginLine = n.getType().getEndLine();
        this.printer.print("new ");
        List<Type> typeArgs = n.getTypeArgs();
        if (typeArgs != null) {
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print(" ");
        }
        n.getType().accept(this, arg);
        List<Expression> args = n.getArgs();
        this.printArguments(args, arg);
        if (args != null && !args.isEmpty() && (begin = (lastType = args.get(args.size() - 1)).getEndLine()) > beginLine) {
            beginLine = begin;
        }
        if (n.getAnonymousClassBody() != null) {
            this.printer.print(" {");
            this.printer.indent();
            List<BodyDeclaration> members = n.getAnonymousClassBody();
            if (members != null && !members.isEmpty()) {
                this.printFirstBlankLines(n, members, beginLine);
                this.printChildrenNodes(n, members, null, arg);
                this.printEntersAfterMembersAndBeforeComments(n, members);
            }
            this.printContainingCommentsAndEnters(n, members, arg, beginLine);
            this.printer.unindent();
            this.printer.print("}");
        }
    }

    @Override
    public void visit(UnaryExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        switch (n.getOperator()) {
            case positive: {
                this.printer.print("+");
                break;
            }
            case negative: {
                this.printer.print("-");
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("!");
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
            }
        }
        n.getExpr().accept(this, arg);
        switch (n.getOperator()) {
            case posIncrement: {
                this.printer.print("++");
                break;
            }
            case posDecrement: {
                this.printer.print("--");
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration n, Object arg) {
        Iterator<Node> i;
        JavadocComment comment = n.getJavaDoc();
        if (comment != null) {
            this.printPreviousComments(comment, arg);
        }
        this.printJavadoc(comment, arg);
        this.printPreviousComments(n, arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            i = n.getThrows().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType name = (ClassOrInterfaceType)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(" ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        this.prepareComments(n);
        JavadocComment comment = n.getJavaDoc();
        if (comment != null) {
            this.printPreviousComments(comment, arg);
        }
        this.printJavadoc(comment, arg);
        this.printPreviousComments(n, arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        List<TypeParameter> typeParameters = n.getTypeParameters();
        if (typeParameters != null && !typeParameters.isEmpty()) {
            TypeParameter first = typeParameters.get(0);
            this.printPreviousComments(first, arg);
        }
        this.printPreviousComments(n.getType(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isDefault()) {
            this.printer.print("default ");
        }
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            this.printParameterList(n.getParameters(), arg);
        }
        this.printer.print(")");
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            Iterator<ClassOrInterfaceType> i = n.getThrows().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType name = i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getBody() == null) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            n.getBody().accept(this, arg);
        }
    }

    @Override
    public void visit(Parameter n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.getType() != null) {
            n.getType().accept(this, arg);
        }
        if (n.isVarArgs()) {
            this.printer.print("...");
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.isThis()) {
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("this");
        } else {
            if (n.getExpr() != null) {
                n.getExpr().accept(this, arg);
                this.printer.print(".");
            }
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("super");
        }
        this.printArguments(n.getArgs(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarationExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVars().iterator();
        while (i.hasNext()) {
            VariableDeclarator v = i.next();
            v.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
    }

    @Override
    public void visit(TypeDeclarationStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        n.getTypeDeclaration().accept(this, arg);
    }

    @Override
    public void visit(AssertStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("assert ");
        n.getCheck().accept(this, arg);
        if (n.getMessage() != null) {
            this.printer.print(" : ");
            n.getMessage().accept(this, arg);
        }
        this.printer.print(";");
    }

    private int getFirstWritenLine(int startLine, Node n2) {
        JavadocComment jc;
        int line = n2.getBeginLine();
        if (n2 instanceof BodyDeclaration && (jc = ((BodyDeclaration)n2).getJavaDoc()) != null && !jc.isNewNode()) {
            line = jc.getBeginLine();
        }
        if (this.comments != null) {
            Iterator<Comment> it = this.comments.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                Comment c = it.next();
                if (c.isNewNode() || startLine > c.getBeginLine() || !(found = c.isPreviousThan(n2) && c.getBeginLine() < line)) continue;
                line = c.getBeginLine();
            }
        }
        return line;
    }

    private void printFirstBlankLines(Node n, List<?> members, int lineNumber) {
        if (members != null && !members.isEmpty()) {
            Node member = (Node)members.get(0);
            if (!n.isNewNode() && !member.isNewNode()) {
                int beginLine = n.getBeginLine();
                if (lineNumber > beginLine) {
                    beginLine = lineNumber;
                }
                int endLine = this.getFirstWritenLine(beginLine, member);
                for (int i = beginLine; i < endLine; ++i) {
                    this.printer.printLn();
                }
            }
        }
    }

    private void printStmtList(Node n, List<Statement> stmts, Object arg) {
        int index = 0;
        Node previousNode = null;
        List<Node> comments = null;
        if (stmts != null && !stmts.isEmpty()) {
            this.printFirstBlankLines(n, stmts, n.getBeginLine() + 1);
            for (Statement s : stmts) {
                if (previousNode == null) {
                    this.printer.indent();
                    List<Node> firstComments = this.printSameLineComments(n, arg);
                    if (firstComments == null || firstComments.isEmpty()) {
                        this.printer.printLn();
                    }
                    s.accept(this, arg);
                    comments = index + 1 < stmts.size() ? this.printInnerComments(s, stmts.get(index + 1), arg) : null;
                } else if (!previousNode.isNewNode() && !s.isNewNode()) {
                    if (!(previousNode instanceof Comment)) {
                        int firstLine = previousNode.getEndLine();
                        int lastLine = this.getFirstWritenLine(firstLine, s);
                        for (int i = firstLine + 1; i < lastLine; ++i) {
                            this.printer.printLn();
                        }
                    }
                    this.printer.indent();
                    s.accept(this, arg);
                    comments = null;
                    if (index + 1 < stmts.size()) {
                        comments = this.printInnerComments(s, stmts.get(index + 1), arg);
                    }
                } else {
                    this.printer.indent();
                    s.accept(this, arg);
                    comments = null;
                }
                if (comments == null || comments.isEmpty()) {
                    if (index + 1 == stmts.size()) {
                        List<Node> com = this.printSameLineComments(s, arg);
                        if (com == null || com.isEmpty() || !(com.get(com.size() - 1) instanceof LineComment)) {
                            this.printer.printLn();
                        }
                    } else {
                        this.printer.printLn();
                    }
                    previousNode = s;
                    this.printEntersAfterMembersAndBeforeComments(n, stmts);
                } else {
                    previousNode = (Node)comments.get(comments.size() - 1);
                }
                this.printer.unindent();
                ++index;
            }
        }
    }

    @Override
    public void visit(BlockStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("{");
        List<Statement> stmts = n.getStmts();
        this.printStmtList(n, stmts, arg);
        this.printer.indent();
        int startingLine = n.getBeginLine();
        this.printContainingCommentsAndEnters(n, stmts, arg, startingLine);
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(LabeledStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getLabel());
        this.printer.print(": ");
        n.getStmt().accept(this, arg);
    }

    @Override
    public void visit(EmptyStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(ExpressionStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        Expression expr = n.getExpression();
        if (expr != null) {
            expr.accept(this, arg);
            this.printer.print(";");
        }
    }

    @Override
    public void visit(SwitchStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("switch(");
        n.getSelector().accept(this, arg);
        this.printer.print(") {");
        if (n.isNewNode()) {
            this.printer.printLn();
        }
        if (n.getEntries() != null) {
            this.printer.indent();
            List<SwitchEntryStmt> entries = n.getEntries();
            if (entries != null && !entries.isEmpty()) {
                this.printFirstBlankLines(n, entries, n.getBeginLine());
                this.printChildrenNodes(n, entries, null, arg);
                this.printEntersAfterMembersAndBeforeComments(n, entries);
            }
            this.printContainingCommentsAndEnters(n, entries, arg, n.getBeginLine());
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(SwitchEntryStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getLabel() != null) {
            this.printer.print("case ");
            n.getLabel().accept(this, arg);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.indent();
        List<Statement> stmts = n.getStmts();
        this.printStmtList(n, stmts, arg);
        int startingLine = n.getBeginLine();
        if (stmts != null && !stmts.isEmpty()) {
            this.printEntersAfterMembersAndBeforeComments(n, stmts);
            this.printContainingCommentsAndEnters(n, stmts, arg, startingLine);
        } else {
            this.printContainingComments(n, startingLine, arg);
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("break");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(ReturnStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("return");
        if (n.getExpr() != null) {
            this.printer.print(" ");
            n.getExpr().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(EnumDeclaration n, Object arg) {
        AnnotationExpr last;
        this.prepareComments(n);
        JavadocComment comment = n.getJavaDoc();
        if (comment != null) {
            this.printPreviousComments(comment, arg);
        }
        this.printJavadoc(comment, arg);
        this.printPreviousComments(n, arg);
        List<AnnotationExpr> annotations = n.getAnnotations();
        this.printMemberAnnotations(annotations, arg);
        int beginLineMembers = n.getBeginLine();
        if (annotations != null && !annotations.isEmpty() && !(last = annotations.get(annotations.size() - 1)).isNewNode()) {
            beginLineMembers = last.getEndLine() + 1;
        }
        this.printModifiers(n.getModifiers());
        this.printer.print("enum ");
        this.printer.print(n.getName());
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            Iterator<ClassOrInterfaceType> i = n.getImplements().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(" {");
        if (n.isNewNode()) {
            this.printer.printLn();
        }
        this.printer.indent();
        List<EnumConstantDeclaration> entries = n.getEntries();
        if (entries != null) {
            if (n.isNewNode()) {
                this.printer.printLn();
            } else {
                this.printFirstBlankLines(n, entries, beginLineMembers);
            }
        }
        this.printChildrenNodes(n, entries, ", ", arg);
        List<BodyDeclaration> members = n.getMembers();
        if (members != null && !members.isEmpty()) {
            EnumConstantDeclaration lastEntry;
            this.printer.printLn(";");
            if (!(entries == null || entries.isEmpty() || members.isEmpty() || (lastEntry = entries.get(entries.size() - 1)).isNewNode())) {
                this.printFirstBlankLines(n, members, lastEntry.getEndLine() + 1);
            }
            this.printChildrenNodes(n, members, null, arg);
            this.printEntersAfterMembersAndBeforeComments(n, members);
            this.printContainingCommentsAndEnters(n, members, arg, beginLineMembers);
        } else {
            this.printContainingCommentsAndEnters(n, entries, arg, n.getBeginLine());
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EnumConstantDeclaration n, Object arg) {
        AnnotationExpr last;
        this.prepareComments(n);
        JavadocComment comment = n.getJavaDoc();
        if (comment != null) {
            this.printPreviousComments(comment, arg);
        }
        this.printJavadoc(comment, arg);
        if (comment != null && !n.isNewNode() && !comment.isNewNode()) {
            int start = comment.getEndLine();
            int end = n.getBeginLine();
            for (int i = start + 1; i < end; ++i) {
                this.printer.printLn();
            }
        }
        int beginLineMembers = n.getBeginLine();
        List<AnnotationExpr> annotations = n.getAnnotations();
        this.printMemberAnnotations(annotations, arg);
        if (annotations != null && !annotations.isEmpty() && !(last = annotations.get(annotations.size() - 1)).isNewNode()) {
            beginLineMembers = last.getEndLine() + 1;
        }
        this.printer.print(n.getName());
        if (n.getArgs() != null) {
            this.printArguments(n.getArgs(), arg);
        }
        if (n.getClassBody() != null) {
            this.printer.print(" {");
            List<BodyDeclaration> classBody = n.getClassBody();
            if (n.isNewNode()) {
                this.printer.printLn();
            }
            this.printFirstBlankLines(n, classBody, beginLineMembers);
            this.printer.indent();
            this.printChildrenNodes(n, classBody, null, arg);
            this.printContainingComments(n, -1, arg);
            this.printer.unindent();
            this.printer.print("}");
        }
    }

    @Override
    public void visit(EmptyMemberDeclaration n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        JavadocComment comment = n.getJavaDoc();
        this.printJavadoc(comment, arg);
        if (comment != null && !n.isNewNode() && !comment.isNewNode()) {
            int start = comment.getEndLine();
            int end = n.getBeginLine();
            for (int i = start + 1; i < end; ++i) {
                this.printer.printLn();
            }
        }
        this.printer.print(";");
    }

    @Override
    public void visit(InitializerDeclaration n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        JavadocComment comment = n.getJavaDoc();
        this.printJavadoc(comment, arg);
        if (comment != null && !n.isNewNode() && !comment.isNewNode()) {
            int start = comment.getEndLine();
            int end = n.getBeginLine();
            for (int i = start + 1; i < end; ++i) {
                this.printer.printLn();
            }
        }
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(IfStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("if (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        Statement thenStmt = n.getThenStmt();
        thenStmt.accept(this, arg);
        Statement elseStmt = n.getElseStmt();
        if (elseStmt != null) {
            if (!thenStmt.isNewNode() && !elseStmt.isNewNode()) {
                int start = thenStmt.getEndLine();
                int end = elseStmt.getBeginLine();
                for (int i = start; i < end; ++i) {
                    this.printer.printLn();
                }
                if (start == end) {
                    this.printer.print(" else ");
                } else {
                    this.printer.print("else ");
                }
            } else {
                this.printer.print(" else ");
            }
            elseStmt.accept(this, arg);
        }
    }

    @Override
    public void visit(WhileStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("while (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ContinueStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("continue");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(DoStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("do ");
        n.getBody().accept(this, arg);
        this.printer.print(" while (");
        n.getCondition().accept(this, arg);
        this.printer.print(");");
    }

    @Override
    public void visit(ForeachStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("for (");
        n.getVariable().accept(this, arg);
        this.printer.print(" : ");
        n.getIterable().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ForStmt n, Object arg) {
        Expression e;
        Iterator<Expression> i;
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("for (");
        if (n.getInit() != null) {
            i = n.getInit().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print("; ");
        if (n.getCompare() != null) {
            n.getCompare().accept(this, arg);
        }
        this.printer.print("; ");
        if (n.getUpdate() != null) {
            i = n.getUpdate().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ThrowStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("throw ");
        n.getExpr().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SynchronizedStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("synchronized (");
        n.getExpr().accept(this, arg);
        this.printer.print(") ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(TryStmt n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("try ");
        if (n.getResources() != null && !n.getResources().isEmpty()) {
            this.printer.print("(");
            Iterator<VariableDeclarationExpr> resources = n.getResources().iterator();
            boolean first = true;
            while (resources.hasNext()) {
                VariableDeclarationExpr next = resources.next();
                this.visit(next, arg);
                if (resources.hasNext()) {
                    this.printer.print(";");
                    this.printer.printLn();
                    if (first) {
                        this.printer.indent();
                    }
                }
                first = false;
            }
            if (n.getResources().size() > 1) {
                this.printer.unindent();
            }
            this.printer.print(") ");
        }
        n.getTryBlock().accept(this, arg);
        if (n.getCatchs() != null) {
            for (CatchClause c : n.getCatchs()) {
                c.accept(this, arg);
            }
        }
        if (n.getFinallyBlock() != null) {
            this.printer.print(" finally ");
            n.getFinallyBlock().accept(this, arg);
        }
    }

    @Override
    public void visit(CatchClause n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(" catch (");
        n.getExcept().accept(this, arg);
        this.printer.print(") ");
        n.getCatchBlock().accept(this, arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, Object arg) {
        AnnotationExpr last;
        this.prepareComments(n);
        Node comment = n.getJavaDoc();
        if (comment != null) {
            this.printPreviousComments(comment, arg);
        }
        this.printJavadoc((JavadocComment)comment, arg);
        List<Node> comments = this.printPreviousComments(n, arg);
        if (comments != null && !comments.isEmpty()) {
            comment = comments.get(comments.size() - 1);
        }
        if (comment != null && !n.isNewNode() && !comment.isNewNode()) {
            int start = comment.getEndLine();
            int end = n.getBeginLine();
            for (int i = start + 1; i < end; ++i) {
                this.printer.printLn();
            }
        }
        List<AnnotationExpr> annotations = n.getAnnotations();
        int beginLineMembers = n.getBeginLine();
        this.printMemberAnnotations(annotations, arg);
        if (annotations != null && !annotations.isEmpty() && !(last = annotations.get(annotations.size() - 1)).isNewNode()) {
            beginLineMembers = last.getEndLine() + 1;
        }
        this.printModifiers(n.getModifiers());
        this.printer.print("@interface ");
        this.printer.print(n.getName());
        this.printer.print(" {");
        this.printer.indent();
        List<BodyDeclaration> members = n.getMembers();
        if (members != null) {
            this.printFirstBlankLines(n, members, beginLineMembers);
            this.printChildrenNodes(n, members, null, arg);
            this.printEntersAfterMembersAndBeforeComments(n, members);
        }
        this.printContainingCommentsAndEnters(n, members, arg, beginLineMembers);
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, Object arg) {
        this.prepareComments(n);
        JavadocComment comment = n.getJavaDoc();
        if (comment != null) {
            this.printPreviousComments(comment, arg);
        }
        this.printJavadoc(comment, arg);
        if (comment != null && !n.isNewNode() && !comment.isNewNode()) {
            int start = comment.getEndLine();
            int end = n.getBeginLine();
            for (int i = start + 1; i < end; ++i) {
                this.printer.printLn();
            }
        }
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("()");
        if (n.getDefaultValue() != null) {
            this.printer.print(" default ");
            n.getDefaultValue().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(MarkerAnnotationExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        n.getMemberValue().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        if (n.getPairs() != null) {
            Iterator<MemberValuePair> i = n.getPairs().iterator();
            while (i.hasNext()) {
                MemberValuePair m = i.next();
                m.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printer.print(n.getName());
        this.printer.print(" = ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(LineComment n, Object arg) {
        this.printer.print("//");
        String content = n.getContent();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        this.printer.printLn(content);
    }

    @Override
    public void visit(BlockComment n, Object arg) {
        this.printer.print("/*");
        this.printer.print(n.getContent());
        this.printer.print("*/");
    }

    @Override
    public void visit(MultiTypeParameter n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        Iterator<Type> types = n.getTypes().iterator();
        types.next().accept(this, arg);
        while (types.hasNext()) {
            this.printer.print(" | ");
            types.next().accept(this, arg);
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(LambdaExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        List<Parameter> parameters = n.getParameters();
        boolean printPar = false;
        printPar = n.isParametersEnclosed();
        if (printPar) {
            this.printer.print("(");
        }
        if (parameters != null) {
            Iterator<Parameter> i = parameters.iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (printPar) {
            this.printer.print(")");
        }
        this.printer.print("->");
        Statement body = n.getBody();
        if (body instanceof ExpressionStmt) {
            Expression e = ((ExpressionStmt)body).getExpression();
            e.accept(this, arg);
        } else {
            body.accept(this, arg);
        }
    }

    @Override
    public void visit(MethodReferenceExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        Expression scope = n.getScope();
        String identifier = n.getIdentifier();
        if (scope != null) {
            n.getScope().accept(this, arg);
        }
        this.printer.print("::");
        if (n.getTypeParameters() != null) {
            this.printer.print("<");
            Iterator<TypeParameter> i = n.getTypeParameters().iterator();
            while (i.hasNext()) {
                TypeParameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
        if (identifier != null) {
            this.printer.print(identifier);
        }
    }

    @Override
    public void visit(TypeExpr n, Object arg) {
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getType() != null) {
            n.getType().accept(this, arg);
        }
    }

    @Override
    public void visit(IntersectionType n, Object arg) {
        List<ReferenceType> types;
        this.prepareComments(n);
        this.printPreviousComments(n, arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                this.printer.print(" ");
                ae.accept(this, arg);
            }
        }
        if ((types = n.getBounds()) != null) {
            for (int i = 0; i < types.size(); ++i) {
                types.get(i).accept(this, arg);
                if (i + 1 >= types.size()) continue;
                this.printer.print(" & ");
            }
        }
    }

    private static class SourcePrinter {
        private int level = 0;
        private String indentationString = "    ";
        private char indentationChar = (char)32;
        private boolean indented = false;
        private final StringBuilder buf = new StringBuilder();

        private SourcePrinter() {
        }

        public void indent() {
            ++this.level;
        }

        public void indent(int level) {
            this.level = level;
        }

        public void setIndentationChar(char indentationChar) {
            this.indentationChar = indentationChar;
        }

        public void setSize(int size) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                buffer.append(this.indentationChar);
            }
            this.indentationString = buffer.toString();
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append(this.indentationString);
            }
        }

        public void print(String arg) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.buf.append(arg);
        }

        public void printJavadocText(String arg) {
            String[] parts = arg.split("\n");
            StringBuffer aux = new StringBuffer();
            for (int i = 0; i < parts.length; ++i) {
                String line = parts[i].replaceAll("^\\s+", "");
                aux.append(line);
                if (i + 1 >= parts.length) continue;
                aux.append("\n ");
            }
            this.print(aux.toString());
        }

        public void printLn(String arg) {
            this.print(arg);
            this.printLn();
        }

        public void printLn() {
            this.buf.append("\n");
            this.indented = false;
        }

        public String getSource() {
            return this.buf.toString();
        }

        public String toString() {
            return this.getSource();
        }
    }
}

