/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Fixed;
import org.web3j.abi.datatypes.FixedPointType;
import org.web3j.abi.datatypes.Int;
import org.web3j.abi.datatypes.IntType;
import org.web3j.abi.datatypes.NumericType;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint160;
import org.web3j.utils.Numeric;

public class TypeDecoder {
    static final int MAX_BYTE_LENGTH_FOR_HEX_STRING = 64;

    public static Type instantiateType(String solidityType, Object value) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return TypeDecoder.instantiateType(TypeReference.makeTypeReference(solidityType), value);
    }

    public static Type instantiateType(TypeReference ref, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class rc = ref.getClassType();
        if (Array.class.isAssignableFrom(rc)) {
            return TypeDecoder.instantiateArrayType(ref, value);
        }
        return TypeDecoder.instantiateAtomicType(rc, value);
    }

    public static <T extends Array> T decode(String input, int offset, TypeReference<T> typeReference) {
        Class<?> cls = ((ParameterizedType)typeReference.getType()).getRawType().getClass();
        if (StaticArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeStaticArray(input, offset, typeReference, 1));
        }
        if (DynamicArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeDynamicArray(input, offset, typeReference));
        }
        throw new UnsupportedOperationException("Unsupported TypeReference: " + cls.getName() + ", only Array types can be passed as TypeReferences");
    }

    static <T extends Type> T decode(String input, int offset, Class<T> type) {
        if (NumericType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Address.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeAddress(input.substring(offset));
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeUtf8String(input, offset);
        }
        if (Array.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Array types must be wrapped in a TypeReference");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    static <T extends Type> T decode(String input, Class<T> type) {
        return TypeDecoder.decode(input, 0, type);
    }

    static Address decodeAddress(String input) {
        return new Address(TypeDecoder.decodeNumeric(input, Uint160.class));
    }

    static <T extends NumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            byte[] inputByteArray = Numeric.hexStringToByteArray((String)input);
            int typeLengthAsBytes = TypeDecoder.getTypeLengthInBytes(type);
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int.class.isAssignableFrom(type) || Fixed.class.isAssignableFrom(type)) {
                resultByteArray[0] = inputByteArray[0];
            }
            int valueOffset = 32 - typeLengthAsBytes;
            System.arraycopy(inputByteArray, valueOffset, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static <T extends NumericType> int getTypeLengthInBytes(Class<T> type) {
        return TypeDecoder.getTypeLength(type) >> 3;
    }

    static <T extends NumericType> int getTypeLength(Class<T> type) {
        if (IntType.class.isAssignableFrom(type)) {
            String regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                return Integer.parseInt(splitName[1]);
            }
        } else if (FixedPointType.class.isAssignableFrom(type)) {
            String regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                String[] bitsCounts = splitName[1].split("x");
                return Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
            }
        }
        return 256;
    }

    static Type instantiateArrayType(TypeReference ref, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Constructor<Object> listcons;
        int arraySize;
        List values;
        if (value instanceof List) {
            values = (List)value;
        } else if (value.getClass().isArray()) {
            values = TypeDecoder.arrayToList(value);
        } else {
            throw new ClassCastException("Arg of type " + value.getClass() + " should be a list to instantiate web3j Array");
        }
        int n = arraySize = ref instanceof TypeReference.StaticArrayTypeReference ? ((TypeReference.StaticArrayTypeReference)ref).getSize() : -1;
        if (arraySize <= 0) {
            listcons = DynamicArray.class.getConstructor(Class.class, List.class);
        } else {
            Class<?> arrayClass = Class.forName("org.web3j.abi.datatypes.generated.StaticArray" + arraySize);
            listcons = arrayClass.getConstructor(Class.class, List.class);
        }
        ArrayList<Type> transformedList = new ArrayList<Type>(values.size());
        TypeReference subTypeReference = ref.getSubTypeReference();
        for (Object o : values) {
            transformedList.add(TypeDecoder.instantiateType(subTypeReference, o));
        }
        return (Type)listcons.newInstance(ref.getClassType(), transformedList);
    }

    static Type instantiateAtomicType(Class<?> referenceClass, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Object constructorArg = null;
        if (NumericType.class.isAssignableFrom(referenceClass)) {
            constructorArg = TypeDecoder.asBigInteger(value);
        } else if (BytesType.class.isAssignableFrom(referenceClass)) {
            if (value instanceof byte[]) {
                constructorArg = value;
            } else if (value instanceof BigInteger) {
                constructorArg = ((BigInteger)value).toByteArray();
            } else if (value instanceof String) {
                constructorArg = Numeric.hexStringToByteArray((String)((String)value));
            }
        } else if (Utf8String.class.isAssignableFrom(referenceClass)) {
            constructorArg = value.toString();
        } else if (Address.class.isAssignableFrom(referenceClass)) {
            constructorArg = value instanceof BigInteger || value instanceof Uint160 ? value : value.toString();
        } else if (Bool.class.isAssignableFrom(referenceClass)) {
            if (value instanceof Boolean) {
                constructorArg = value;
            } else {
                BigInteger bival = TypeDecoder.asBigInteger(value);
                Object object = bival == null ? null : (constructorArg = Boolean.valueOf(!bival.equals(BigInteger.ZERO)));
            }
        }
        if (constructorArg == null) {
            throw new InstantiationException("Could not create type " + referenceClass + " from arg " + value.toString() + " of type " + value.getClass());
        }
        Class[] types = new Class[]{constructorArg.getClass()};
        Constructor<?> cons = referenceClass.getConstructor(types);
        return (Type)cons.newInstance(constructorArg);
    }

    static <T extends Type> int getSingleElementLength(String input, int offset, Class<T> type) {
        if (input.length() == offset) {
            return 0;
        }
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset) / 32 + 2;
        }
        return 1;
    }

    static int decodeUintAsInt(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        return TypeDecoder.decode(input, 0, Uint.class).getValue().intValue();
    }

    static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        BigInteger numericValue = Numeric.toBigInt((String)input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    static <T extends Bytes> T decodeBytes(String input, Class<T> type) {
        return TypeDecoder.decodeBytes(input, 0, type);
    }

    static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray((String)input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static DynamicBytes decodeDynamicBytes(String input, int offset) {
        int encodedLength = TypeDecoder.decodeUintAsInt(input, offset);
        int hexStringEncodedLength = encodedLength << 1;
        int valueOffset = offset + 64;
        String data = input.substring(valueOffset, valueOffset + hexStringEncodedLength);
        byte[] bytes = Numeric.hexStringToByteArray((String)data);
        return new DynamicBytes(bytes);
    }

    static Utf8String decodeUtf8String(String input, int offset) {
        DynamicBytes dynamicBytesResult = TypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    static <T extends Type> T decodeStaticArray(String input, int offset, TypeReference<T> typeReference, int length) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStaticArray(typeReference, elements, length);
        };
        return (T)TypeDecoder.decodeArrayElements(input, offset, typeReference, length, function);
    }

    static <T extends Type> T decodeDynamicArray(String input, int offset, TypeReference<T> typeReference) {
        int length = TypeDecoder.decodeUintAsInt(input, offset);
        BiFunction<List, String, Type> function = (elements, typeName) -> new DynamicArray<Type>(AbiTypes.getType(typeName), (List<? extends Type>)elements);
        int valueOffset = offset + 64;
        return (T)TypeDecoder.decodeArrayElements(input, valueOffset, typeReference, length, function);
    }

    static BigInteger asBigInteger(Object arg) {
        if (arg instanceof BigInteger) {
            return (BigInteger)arg;
        }
        if (arg instanceof BigDecimal) {
            return ((BigDecimal)arg).toBigInteger();
        }
        if (arg instanceof String) {
            return Numeric.toBigInt((String)((String)arg));
        }
        if (arg instanceof byte[]) {
            return Numeric.toBigInt((byte[])((byte[])arg));
        }
        if (arg instanceof Number) {
            return BigInteger.valueOf(((Number)arg).longValue());
        }
        return null;
    }

    static List arrayToList(Object array) {
        int len = java.lang.reflect.Array.getLength(array);
        ArrayList<Object> rslt = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            rslt.add(java.lang.reflect.Array.get(array, i));
        }
        return rslt;
    }

    private static <T extends Type> T instantiateStaticArray(TypeReference<T> typeReference, List<T> elements, int length) {
        try {
            Class<?> arrayClass = Class.forName("org.web3j.abi.datatypes.generated.StaticArray" + length);
            return (T)((Type)arrayClass.getConstructor(List.class).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static <T extends Type> T decodeArrayElements(String input, int offset, TypeReference<T> typeReference, int length, BiFunction<List<T>, String, T> consumer) {
        try {
            Class cls = Utils.getParameterizedTypeFromArray(typeReference);
            if (Array.class.isAssignableFrom(cls)) {
                throw new UnsupportedOperationException("Arrays of arrays are not currently supported for external functions, seehttp://solidity.readthedocs.io/en/develop/types.html#members");
            }
            ArrayList elements = new ArrayList(length);
            int i = 0;
            int currOffset = offset;
            while (i < length) {
                Object value = TypeDecoder.decode(input, currOffset, cls);
                elements.add(value);
                ++i;
                currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 64;
            }
            String typeName = Utils.getSimpleTypeName(cls);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }
}

