/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.response.AccessListObject;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.utils.Numeric;

public class EthBlock
extends Response<Block> {
    @Override
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(Block result) {
        super.setResult(result);
    }

    public Block getBlock() {
        return (Block)this.getResult();
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<Block> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (Block)this.objectReader.readValue(jsonParser, Block.class);
            }
            return null;
        }
    }

    public static class ResultTransactionDeserialiser
    extends JsonDeserializer<List<TransactionResult>> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public List<TransactionResult> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<TransactionResult> transactionResults;
            block3: {
                JsonToken nextToken;
                block2: {
                    transactionResults = new ArrayList<TransactionResult>();
                    nextToken = jsonParser.nextToken();
                    if (nextToken != JsonToken.START_OBJECT) break block2;
                    Iterator transactionObjectIterator = this.objectReader.readValues(jsonParser, TransactionObject.class);
                    while (transactionObjectIterator.hasNext()) {
                        transactionResults.add((TransactionResult)transactionObjectIterator.next());
                    }
                    break block3;
                }
                if (nextToken != JsonToken.VALUE_STRING) break block3;
                jsonParser.getValueAsString();
                Iterator transactionHashIterator = this.objectReader.readValues(jsonParser, TransactionHash.class);
                while (transactionHashIterator.hasNext()) {
                    transactionResults.add((TransactionResult)transactionHashIterator.next());
                }
            }
            return transactionResults;
        }
    }

    public static class TransactionObject
    extends Transaction
    implements TransactionResult<Transaction> {
        public TransactionObject() {
        }

        public TransactionObject(String hash, String nonce, String blockHash, String blockNumber, String transactionIndex, String from, String to, String value, String gasPrice, String gas, String input, String creates, String publicKey, String raw, String r, String s, int v, String type, String maxFeePerGas, String maxPriorityFeePerGas, List<AccessListObject> accessList) {
            super(hash, nonce, blockHash, blockNumber, transactionIndex, from, to, value, gas, gasPrice, input, creates, publicKey, raw, r, s, v, type, maxFeePerGas, maxPriorityFeePerGas, accessList);
        }

        @Override
        public Transaction get() {
            return this;
        }
    }

    public static class TransactionHash
    implements TransactionResult<String> {
        private String value;

        public TransactionHash() {
        }

        public TransactionHash(String value) {
            this.value = value;
        }

        @Override
        public String get() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionHash)) {
                return false;
            }
            TransactionHash that = (TransactionHash)o;
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static interface TransactionResult<T> {
        public T get();
    }

    public static class Block {
        private String number;
        private String hash;
        private String parentHash;
        private String nonce;
        private String sha3Uncles;
        private String logsBloom;
        private String transactionsRoot;
        private String stateRoot;
        private String receiptsRoot;
        private String author;
        private String miner;
        private String mixHash;
        private String difficulty;
        private String totalDifficulty;
        private String extraData;
        private String size;
        private String gasLimit;
        private String gasUsed;
        private String timestamp;
        private List<TransactionResult> transactions;
        private List<String> uncles;
        private List<String> sealFields;
        private String baseFeePerGas;

        public Block() {
        }

        public Block(String number, String hash, String parentHash, String nonce, String sha3Uncles, String logsBloom, String transactionsRoot, String stateRoot, String receiptsRoot, String author, String miner, String mixHash, String difficulty, String totalDifficulty, String extraData, String size, String gasLimit, String gasUsed, String timestamp, List<TransactionResult> transactions, List<String> uncles, List<String> sealFields, String baseFeePerGas) {
            this.number = number;
            this.hash = hash;
            this.parentHash = parentHash;
            this.nonce = nonce;
            this.sha3Uncles = sha3Uncles;
            this.logsBloom = logsBloom;
            this.transactionsRoot = transactionsRoot;
            this.stateRoot = stateRoot;
            this.receiptsRoot = receiptsRoot;
            this.author = author;
            this.miner = miner;
            this.mixHash = mixHash;
            this.difficulty = difficulty;
            this.totalDifficulty = totalDifficulty;
            this.extraData = extraData;
            this.size = size;
            this.gasLimit = gasLimit;
            this.gasUsed = gasUsed;
            this.timestamp = timestamp;
            this.transactions = transactions;
            this.uncles = uncles;
            this.sealFields = sealFields;
            this.baseFeePerGas = baseFeePerGas;
        }

        public BigInteger getNumber() {
            return Numeric.decodeQuantity((String)this.number);
        }

        public String getNumberRaw() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getParentHash() {
            return this.parentHash;
        }

        public void setParentHash(String parentHash) {
            this.parentHash = parentHash;
        }

        public BigInteger getNonce() {
            return Numeric.decodeQuantity((String)this.nonce);
        }

        public String getNonceRaw() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getSha3Uncles() {
            return this.sha3Uncles;
        }

        public void setSha3Uncles(String sha3Uncles) {
            this.sha3Uncles = sha3Uncles;
        }

        public String getLogsBloom() {
            return this.logsBloom;
        }

        public void setLogsBloom(String logsBloom) {
            this.logsBloom = logsBloom;
        }

        public String getTransactionsRoot() {
            return this.transactionsRoot;
        }

        public void setTransactionsRoot(String transactionsRoot) {
            this.transactionsRoot = transactionsRoot;
        }

        public String getStateRoot() {
            return this.stateRoot;
        }

        public void setStateRoot(String stateRoot) {
            this.stateRoot = stateRoot;
        }

        public String getReceiptsRoot() {
            return this.receiptsRoot;
        }

        public void setReceiptsRoot(String receiptsRoot) {
            this.receiptsRoot = receiptsRoot;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getMiner() {
            return this.miner;
        }

        public void setMiner(String miner) {
            this.miner = miner;
        }

        public String getMixHash() {
            return this.mixHash;
        }

        public void setMixHash(String mixHash) {
            this.mixHash = mixHash;
        }

        public BigInteger getDifficulty() {
            return Numeric.decodeQuantity((String)this.difficulty);
        }

        public String getDifficultyRaw() {
            return this.difficulty;
        }

        public void setDifficulty(String difficulty) {
            this.difficulty = difficulty;
        }

        public BigInteger getTotalDifficulty() {
            return Numeric.decodeQuantity((String)this.totalDifficulty);
        }

        public String getTotalDifficultyRaw() {
            return this.totalDifficulty;
        }

        public void setTotalDifficulty(String totalDifficulty) {
            this.totalDifficulty = totalDifficulty;
        }

        public String getExtraData() {
            return this.extraData;
        }

        public void setExtraData(String extraData) {
            this.extraData = extraData;
        }

        public BigInteger getSize() {
            return this.size != null ? Numeric.decodeQuantity((String)this.size) : BigInteger.ZERO;
        }

        public String getSizeRaw() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public BigInteger getGasLimit() {
            return Numeric.decodeQuantity((String)this.gasLimit);
        }

        public String getGasLimitRaw() {
            return this.gasLimit;
        }

        public void setGasLimit(String gasLimit) {
            this.gasLimit = gasLimit;
        }

        public BigInteger getGasUsed() {
            return Numeric.decodeQuantity((String)this.gasUsed);
        }

        public String getGasUsedRaw() {
            return this.gasUsed;
        }

        public void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        public BigInteger getTimestamp() {
            return Numeric.decodeQuantity((String)this.timestamp);
        }

        public String getTimestampRaw() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public List<TransactionResult> getTransactions() {
            return this.transactions;
        }

        @JsonDeserialize(using=ResultTransactionDeserialiser.class)
        public void setTransactions(List<TransactionResult> transactions) {
            this.transactions = transactions;
        }

        public List<String> getUncles() {
            return this.uncles;
        }

        public void setUncles(List<String> uncles) {
            this.uncles = uncles;
        }

        public List<String> getSealFields() {
            return this.sealFields;
        }

        public void setSealFields(List<String> sealFields) {
            this.sealFields = sealFields;
        }

        public String getBaseFeePerGas() {
            return this.baseFeePerGas;
        }

        public void setBaseFeePerGas(String baseFeePerGas) {
            this.baseFeePerGas = baseFeePerGas;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block block = (Block)o;
            if (this.getNumberRaw() != null ? !this.getNumberRaw().equals(block.getNumberRaw()) : block.getNumberRaw() != null) {
                return false;
            }
            if (this.getHash() != null ? !this.getHash().equals(block.getHash()) : block.getHash() != null) {
                return false;
            }
            if (this.getParentHash() != null ? !this.getParentHash().equals(block.getParentHash()) : block.getParentHash() != null) {
                return false;
            }
            if (this.getNonceRaw() != null ? !this.getNonceRaw().equals(block.getNonceRaw()) : block.getNonceRaw() != null) {
                return false;
            }
            if (this.getSha3Uncles() != null ? !this.getSha3Uncles().equals(block.getSha3Uncles()) : block.getSha3Uncles() != null) {
                return false;
            }
            if (this.getLogsBloom() != null ? !this.getLogsBloom().equals(block.getLogsBloom()) : block.getLogsBloom() != null) {
                return false;
            }
            if (this.getTransactionsRoot() != null ? !this.getTransactionsRoot().equals(block.getTransactionsRoot()) : block.getTransactionsRoot() != null) {
                return false;
            }
            if (this.getStateRoot() != null ? !this.getStateRoot().equals(block.getStateRoot()) : block.getStateRoot() != null) {
                return false;
            }
            if (this.getReceiptsRoot() != null ? !this.getReceiptsRoot().equals(block.getReceiptsRoot()) : block.getReceiptsRoot() != null) {
                return false;
            }
            if (this.getAuthor() != null ? !this.getAuthor().equals(block.getAuthor()) : block.getAuthor() != null) {
                return false;
            }
            if (this.getMiner() != null ? !this.getMiner().equals(block.getMiner()) : block.getMiner() != null) {
                return false;
            }
            if (this.getMixHash() != null ? !this.getMixHash().equals(block.getMixHash()) : block.getMixHash() != null) {
                return false;
            }
            if (this.getDifficultyRaw() != null ? !this.getDifficultyRaw().equals(block.getDifficultyRaw()) : block.getDifficultyRaw() != null) {
                return false;
            }
            if (this.getTotalDifficultyRaw() != null ? !this.getTotalDifficultyRaw().equals(block.getTotalDifficultyRaw()) : block.getTotalDifficultyRaw() != null) {
                return false;
            }
            if (this.getExtraData() != null ? !this.getExtraData().equals(block.getExtraData()) : block.getExtraData() != null) {
                return false;
            }
            if (this.getSizeRaw() != null ? !this.getSizeRaw().equals(block.getSizeRaw()) : block.getSizeRaw() != null) {
                return false;
            }
            if (this.getGasLimitRaw() != null ? !this.getGasLimitRaw().equals(block.getGasLimitRaw()) : block.getGasLimitRaw() != null) {
                return false;
            }
            if (this.getGasUsedRaw() != null ? !this.getGasUsedRaw().equals(block.getGasUsedRaw()) : block.getGasUsedRaw() != null) {
                return false;
            }
            if (this.getTimestampRaw() != null ? !this.getTimestampRaw().equals(block.getTimestampRaw()) : block.getTimestampRaw() != null) {
                return false;
            }
            if (this.getTransactions() != null ? !this.getTransactions().equals(block.getTransactions()) : block.getTransactions() != null) {
                return false;
            }
            if (this.getUncles() != null ? !this.getUncles().equals(block.getUncles()) : block.getUncles() != null) {
                return false;
            }
            if (this.getBaseFeePerGas() != null ? !this.getBaseFeePerGas().equals(block.getBaseFeePerGas()) : block.getBaseFeePerGas() != null) {
                return false;
            }
            return this.getSealFields() != null ? this.getSealFields().equals(block.getSealFields()) : block.getSealFields() == null;
        }

        public int hashCode() {
            int result = this.getNumberRaw() != null ? this.getNumberRaw().hashCode() : 0;
            result = 31 * result + (this.getHash() != null ? this.getHash().hashCode() : 0);
            result = 31 * result + (this.getParentHash() != null ? this.getParentHash().hashCode() : 0);
            result = 31 * result + (this.getNonceRaw() != null ? this.getNonceRaw().hashCode() : 0);
            result = 31 * result + (this.getSha3Uncles() != null ? this.getSha3Uncles().hashCode() : 0);
            result = 31 * result + (this.getLogsBloom() != null ? this.getLogsBloom().hashCode() : 0);
            result = 31 * result + (this.getTransactionsRoot() != null ? this.getTransactionsRoot().hashCode() : 0);
            result = 31 * result + (this.getStateRoot() != null ? this.getStateRoot().hashCode() : 0);
            result = 31 * result + (this.getReceiptsRoot() != null ? this.getReceiptsRoot().hashCode() : 0);
            result = 31 * result + (this.getAuthor() != null ? this.getAuthor().hashCode() : 0);
            result = 31 * result + (this.getMiner() != null ? this.getMiner().hashCode() : 0);
            result = 31 * result + (this.getMixHash() != null ? this.getMixHash().hashCode() : 0);
            result = 31 * result + (this.getDifficultyRaw() != null ? this.getDifficultyRaw().hashCode() : 0);
            result = 31 * result + (this.getTotalDifficultyRaw() != null ? this.getTotalDifficultyRaw().hashCode() : 0);
            result = 31 * result + (this.getExtraData() != null ? this.getExtraData().hashCode() : 0);
            result = 31 * result + (this.getSizeRaw() != null ? this.getSizeRaw().hashCode() : 0);
            result = 31 * result + (this.getGasLimitRaw() != null ? this.getGasLimitRaw().hashCode() : 0);
            result = 31 * result + (this.getGasUsedRaw() != null ? this.getGasUsedRaw().hashCode() : 0);
            result = 31 * result + (this.getTimestampRaw() != null ? this.getTimestampRaw().hashCode() : 0);
            result = 31 * result + (this.getTransactions() != null ? this.getTransactions().hashCode() : 0);
            result = 31 * result + (this.getUncles() != null ? this.getUncles().hashCode() : 0);
            result = 31 * result + (this.getSealFields() != null ? this.getSealFields().hashCode() : 0);
            result = 31 * result + (this.getBaseFeePerGas() != null ? this.getBaseFeePerGas().hashCode() : 0);
            return result;
        }
    }
}

