/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.filters.Callback;
import org.web3j.protocol.core.filters.Filter;
import org.web3j.protocol.core.filters.FilterException;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.Log;

public class LogsFilter
extends Filter<List<Log>> {
    private final EthFilter ethFilter;

    public LogsFilter(Web3j web3j, Callback<List<Log>> callback, EthFilter ethFilter) {
        super(web3j, callback);
        this.ethFilter = ethFilter;
    }

    @Override
    protected org.web3j.protocol.core.methods.response.EthFilter sendRequest() throws IOException {
        return this.web3j.ethNewFilter(this.ethFilter).send();
    }

    @Override
    protected void process(List<EthLog.LogResult> logResults) {
        ArrayList<Log> logs = new ArrayList<Log>(logResults.size());
        for (EthLog.LogResult logResult : logResults) {
            if (!(logResult instanceof EthLog.LogObject)) {
                throw new FilterException("Unexpected result type: " + logResult.get() + " required LogObject");
            }
            logs.add(((EthLog.LogObject)logResult).get());
        }
        this.callback.onEvent(logs);
    }

    @Override
    protected Optional<Request<?, EthLog>> getFilterLogs(BigInteger filterId) {
        return Optional.of(this.web3j.ethGetFilterLogs(filterId));
    }
}

