/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.model.StateMutability;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AbiDefinition {
    private List<NamedType> inputs = new ArrayList<NamedType>();
    private String name;
    private List<NamedType> outputs = new ArrayList<NamedType>();
    private String type;
    private String stateMutability;

    public AbiDefinition() {
    }

    public AbiDefinition(AbiDefinition from) {
        this(from.isConstant(), AbiDefinition.clone(from.inputs), from.name, AbiDefinition.clone(from.outputs), from.type, from.isPayable(), from.getStateMutability());
    }

    public AbiDefinition(boolean constant, List<NamedType> inputs, String name, List<NamedType> outputs, String type, boolean payable) {
        this(constant, inputs, name, outputs, type, payable, null);
    }

    public AbiDefinition(boolean constant, List<NamedType> inputs, String name, List<NamedType> outputs, String type, boolean payable, String stateMutability) {
        this.inputs = inputs;
        this.name = name;
        this.outputs = outputs;
        this.type = type;
        this.stateMutability = payable ? StateMutability.PAYABLE.getName() : (constant ? StateMutability.PURE.getName() : stateMutability);
    }

    public boolean isConstant() {
        return StateMutability.isPure(this.stateMutability);
    }

    public void setConstant(boolean isConstant) {
        if (isConstant) {
            this.stateMutability = StateMutability.PURE.getName();
        }
    }

    public boolean isPureOrView() {
        return StateMutability.isPure(this.stateMutability) || StateMutability.isView(this.stateMutability);
    }

    public List<NamedType> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<NamedType> inputs) {
        this.inputs = inputs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<NamedType> getOutputs() {
        return this.outputs;
    }

    public boolean hasOutputs() {
        return !this.outputs.isEmpty();
    }

    public void setOutputs(List<NamedType> outputs) {
        this.outputs = outputs;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPayable() {
        return StateMutability.isPayable(this.stateMutability);
    }

    public void setPayable(boolean payable) {
        this.stateMutability = payable ? StateMutability.PAYABLE.getName() : StateMutability.NON_PAYABLE.getName();
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public void setStateMutability(String stateMutability) {
        this.stateMutability = stateMutability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbiDefinition)) {
            return false;
        }
        AbiDefinition that = (AbiDefinition)o;
        if (this.isConstant() != that.isConstant()) {
            return false;
        }
        if (this.isPayable() != that.isPayable()) {
            return false;
        }
        if (this.getInputs() != null ? !this.getInputs().equals(that.getInputs()) : that.getInputs() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getOutputs() != null ? !this.getOutputs().equals(that.getOutputs()) : that.getOutputs() != null) {
            return false;
        }
        if (this.getStateMutability() != null ? !this.getStateMutability().equals(that.getStateMutability()) : that.getStateMutability() != null) {
            return false;
        }
        return this.getType() != null ? this.getType().equals(that.getType()) : that.getType() == null;
    }

    public int hashCode() {
        int result = this.isConstant() ? 1 : 0;
        result = 31 * result + (this.getInputs() != null ? this.getInputs().hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getOutputs() != null ? this.getOutputs().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.isPayable() ? 1 : 0);
        result = 31 * result + (this.getStateMutability() != null ? this.getStateMutability().hashCode() : 0);
        return result;
    }

    private static List<NamedType> clone(List<NamedType> from) {
        return from.stream().map(NamedType::new).toList();
    }

    public static class NamedType {
        private static final String DEFAULT_INTERNAL_TYPE = "";
        private String name;
        private String type;
        private List<NamedType> components = new ArrayList<NamedType>();
        private String internalType = "";
        private boolean indexed;

        public NamedType() {
        }

        public NamedType(NamedType from) {
            this(from.name, from.type, from.indexed);
        }

        public NamedType(String name, String type) {
            this(name, type, false);
        }

        public NamedType(String name, String type, boolean indexed) {
            this(name, type, Collections.emptyList(), DEFAULT_INTERNAL_TYPE, indexed);
        }

        public NamedType(String name, String type, List<NamedType> components, String internalType, boolean indexed) {
            this.name = name;
            this.type = type;
            this.components = components;
            this.internalType = internalType;
            this.indexed = indexed;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getInternalType() {
            return this.internalType;
        }

        public void setInternalType(String internalType) {
            this.internalType = internalType;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public List<NamedType> getComponents() {
            return this.components;
        }

        public void setComponents(List<NamedType> components) {
            this.components = components;
        }

        public String structIdentifier() {
            return (this.internalType == null ? this.type : (this.internalType.isEmpty() ? this.type : this.internalType)) + this.components.stream().map(NamedType::structIdentifier).collect(Collectors.joining());
        }

        public int nestedness() {
            if (this.getComponents().isEmpty()) {
                return 0;
            }
            return 1 + this.getComponents().stream().mapToInt(NamedType::nestedness).max().getAsInt();
        }

        public boolean isDynamic() {
            if (this.getType().equals("string") || this.getType().equals("bytes") || this.getType().contains("[]")) {
                return true;
            }
            return this.components.stream().anyMatch(NamedType::isDynamic);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NamedType)) {
                return false;
            }
            NamedType namedType = (NamedType)o;
            if (this.isIndexed() != namedType.isIndexed()) {
                return false;
            }
            if (this.getName() != null ? !this.getName().equals(namedType.getName()) : namedType.getName() != null) {
                return false;
            }
            if (this.getComponents() != null ? !this.getComponents().equals(namedType.getComponents()) : namedType.getComponents() != null) {
                return false;
            }
            if (this.getInternalType() != null ? !this.getInternalType().equals(namedType.getInternalType()) : namedType.getInternalType() != null) {
                return false;
            }
            return this.getType() != null ? this.getType().equals(namedType.getType()) : namedType.getType() == null;
        }

        public int hashCode() {
            int result = this.getName() != null ? this.getName().hashCode() : 0;
            result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
            result = 31 * result + (this.isIndexed() ? 1 : 0);
            result = 31 * result + (this.getComponents() != null ? this.getComponents().hashCode() : 0);
            result = 31 * result + (this.getInternalType() != null ? this.getInternalType().hashCode() : 0);
            return result;
        }
    }
}

