/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.service;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.web3j.crypto.CryptoUtils;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.HSMPass;
import org.web3j.crypto.Sign;
import org.web3j.service.HSMRequestProcessor;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.MessageType;
import software.amazon.awssdk.services.kms.model.SignRequest;
import software.amazon.awssdk.services.kms.model.SignResponse;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.VerifyRequest;
import software.amazon.awssdk.services.kms.model.VerifyResponse;

public class HSMAwsKMSRequestProcessor
implements HSMRequestProcessor {
    private KmsClient kmsClient;
    private String keyID;

    public HSMAwsKMSRequestProcessor(KmsClient kmsClient, String keyID) {
        this.kmsClient = kmsClient;
        this.keyID = keyID;
    }

    public Sign.SignatureData callHSM(byte[] dataToSign, HSMPass pass) {
        byte[] dataHash = new byte[]{};
        try {
            dataHash = MessageDigest.getInstance("SHA-256").digest(dataToSign);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Algorithm SHA-256 is not available for the given data!");
        }
        SignRequest signRequest = (SignRequest)SignRequest.builder().keyId(this.keyID).message(SdkBytes.fromByteArray((byte[])dataHash)).messageType(MessageType.DIGEST).signingAlgorithm(SigningAlgorithmSpec.ECDSA_SHA_256).build();
        SignResponse signResult = this.kmsClient.sign(signRequest);
        ByteBuffer signatureBuffer = signResult.signature().asByteBuffer();
        byte[] signBytes = new byte[signatureBuffer.remaining()];
        signatureBuffer.get(signBytes);
        VerifyRequest verifyRequest = (VerifyRequest)VerifyRequest.builder().keyId(this.keyID).message(SdkBytes.fromByteArray((byte[])dataHash)).messageType(MessageType.DIGEST).signingAlgorithm(SigningAlgorithmSpec.ECDSA_SHA_256).signature(SdkBytes.fromByteArray((byte[])signBytes)).build();
        VerifyResponse verifyRequestResult = this.kmsClient.verify(verifyRequest);
        if (!verifyRequestResult.signatureValid().booleanValue()) {
            throw new RuntimeException("KMS signature is not valid!");
        }
        ECDSASignature signature = CryptoUtils.fromDerFormat((byte[])signBytes);
        return Sign.createSignatureData((ECDSASignature)signature, (BigInteger)pass.getPublicKey(), (byte[])dataHash);
    }
}

