/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx.gas;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthMaxPriorityFeePerGas;
import org.web3j.tx.gas.ContractEIP1559GasProvider;
import org.web3j.tx.gas.PriorityGasProvider;

public class DynamicEIP1559GasProvider
implements ContractEIP1559GasProvider,
PriorityGasProvider {
    private Web3j web3j;
    private long chainId;
    private final PriorityGasProvider.Priority priority;
    private final BigDecimal customMultiplier;
    private BigInteger maxGasLimit = BigInteger.valueOf(9000000L);

    public DynamicEIP1559GasProvider(Web3j web3j, long chainId) {
        this(web3j, chainId, PriorityGasProvider.Priority.NORMAL);
    }

    public DynamicEIP1559GasProvider(Web3j web3j, long chainId, PriorityGasProvider.Priority priority) {
        this(web3j, chainId, priority, BigDecimal.ONE);
    }

    public DynamicEIP1559GasProvider(Web3j web3j, long chainId, PriorityGasProvider.Priority priority, BigDecimal customMultiplier) {
        this.web3j = web3j;
        this.chainId = chainId;
        this.priority = priority;
        this.customMultiplier = customMultiplier;
    }

    @Override
    public long getChainId() {
        return this.chainId;
    }

    @Override
    public BigInteger getMaxFeePerGas() {
        try {
            BigInteger baseFee = this.web3j.ethGetBlockByNumber(DefaultBlockParameterName.LATEST, false).send().getBlock().getBaseFeePerGas();
            return baseFee.multiply(BigInteger.valueOf(2L)).add(this.getMaxPriorityFeePerGas());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get ethMaxFeePerGas");
        }
    }

    @Override
    public BigInteger getMaxPriorityFeePerGas() {
        try {
            EthMaxPriorityFeePerGas ethMaxPriorityFeePerGas = this.web3j.ethMaxPriorityFeePerGas().send();
            if (ethMaxPriorityFeePerGas.hasError()) {
                throw new RuntimeException("Error fetching ethMaxPriorityFeePerGas: " + ethMaxPriorityFeePerGas.getError().getMessage());
            }
            return ethMaxPriorityFeePerGas.getMaxPriorityFeePerGas();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get ethMaxPriorityFeePerGas");
        }
    }

    @Override
    public BigInteger getGasPrice() {
        return this.applyPriority(this.fetchCurrentGasPrice(), this.priority, this.customMultiplier);
    }

    @Override
    public BigInteger getGasLimit(Transaction transaction) {
        try {
            EthEstimateGas ethEstimateGas = this.web3j.ethEstimateGas(transaction).send();
            if (ethEstimateGas.hasError()) {
                throw new RuntimeException("Error estimating gas limit: " + ethEstimateGas.getError().getMessage());
            }
            return ethEstimateGas.getAmountUsed();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to estimate gas limit", e);
        }
    }

    @Override
    public BigInteger getGasLimit() {
        return this.maxGasLimit;
    }

    public void setMaxGasLimit(BigInteger gasLimit) {
        this.maxGasLimit = gasLimit;
    }

    private BigInteger fetchCurrentGasPrice() {
        try {
            EthGasPrice ethGasPrice = this.web3j.ethGasPrice().send();
            if (ethGasPrice.hasError()) {
                throw new RuntimeException("Error fetching gas price: " + ethGasPrice.getError().getMessage());
            }
            return ethGasPrice.getGasPrice();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch gas price", e);
        }
    }
}

