/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx.gas;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.PriorityGasProvider;

public class DynamicGasProvider
implements ContractGasProvider,
PriorityGasProvider {
    private final Web3j web3j;
    private final PriorityGasProvider.Priority priority;
    private final BigDecimal customMultiplier;
    private BigInteger maxGasLimit = BigInteger.valueOf(9000000L);

    public DynamicGasProvider(Web3j web3j) {
        this(web3j, PriorityGasProvider.Priority.NORMAL);
    }

    public DynamicGasProvider(Web3j web3j, PriorityGasProvider.Priority priority) {
        this(web3j, priority, BigDecimal.ONE);
    }

    public DynamicGasProvider(Web3j web3j, PriorityGasProvider.Priority priority, BigDecimal customMultiplier) {
        this.web3j = web3j;
        this.priority = priority;
        this.customMultiplier = customMultiplier;
    }

    @Override
    public BigInteger getGasPrice() {
        return this.applyPriority(this.fetchCurrentGasPrice(), this.priority, this.customMultiplier);
    }

    @Override
    public BigInteger getGasLimit() {
        return this.maxGasLimit;
    }

    public void setMaxGasLimit(BigInteger gasLimit) {
        this.maxGasLimit = gasLimit;
    }

    @Override
    public BigInteger getGasLimit(Transaction transaction) {
        try {
            EthEstimateGas ethEstimateGas = this.web3j.ethEstimateGas(transaction).send();
            if (ethEstimateGas.hasError()) {
                throw new RuntimeException("Error estimating gas limit: " + ethEstimateGas.getError().getMessage());
            }
            return ethEstimateGas.getAmountUsed();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to estimate gas limit", e);
        }
    }

    private BigInteger fetchCurrentGasPrice() {
        try {
            EthGasPrice ethGasPrice = this.web3j.ethGasPrice().send();
            if (ethGasPrice.hasError()) {
                throw new RuntimeException("Error fetching gas price: " + ethGasPrice.getError().getMessage());
            }
            return ethGasPrice.getGasPrice();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch gas price", e);
        }
    }
}

