/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx.gas;

import java.math.BigDecimal;
import java.math.BigInteger;

public interface PriorityGasProvider {
    default public BigInteger applyPriority(BigInteger baseGasPrice, Priority priority, BigDecimal customMultiplier) {
        return switch (priority.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> baseGasPrice.multiply(BigInteger.valueOf(2L));
            case 1 -> baseGasPrice;
            case 2 -> baseGasPrice.divide(BigInteger.valueOf(2L));
            case 3 -> {
                if (customMultiplier == null || customMultiplier.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new IllegalArgumentException("Custom multiplier must be a positive value");
                }
                yield new BigDecimal(baseGasPrice).multiply(customMultiplier).toBigInteger();
            }
        };
    }

    public static enum Priority {
        FAST,
        NORMAL,
        SLOW,
        CUSTOM;

    }
}

