/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.exception.CryptoWeb3jException;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class TransactionEncoder {
    public static byte[] signMessage(RawTransaction rawTransaction, Credentials credentials) {
        byte[] encodedTransaction = TransactionEncoder.encode(rawTransaction);
        Sign.SignatureData signatureData = Sign.signMessage(encodedTransaction, credentials.getEcKeyPair());
        return TransactionEncoder.encode(rawTransaction, signatureData);
    }

    public static byte[] signMessage(RawTransaction rawTransaction, long chainId, Credentials credentials) {
        if (rawTransaction.getType().isEip1559()) {
            return TransactionEncoder.signMessage(rawTransaction, credentials);
        }
        byte[] encodedTransaction = TransactionEncoder.encode(rawTransaction, chainId);
        Sign.SignatureData signatureData = Sign.signMessage(encodedTransaction, credentials.getEcKeyPair());
        Sign.SignatureData eip155SignatureData = TransactionEncoder.createEip155SignatureData(signatureData, chainId);
        return TransactionEncoder.encode(rawTransaction, eip155SignatureData);
    }

    @Deprecated
    public static byte[] signMessage(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        return TransactionEncoder.signMessage(rawTransaction, (long)chainId, credentials);
    }

    public static Sign.SignatureData createEip155SignatureData(Sign.SignatureData signatureData, long chainId) {
        BigInteger v = Numeric.toBigInt((byte[])signatureData.getV());
        v = v.subtract(BigInteger.valueOf(27L));
        v = v.add(BigInteger.valueOf(chainId).multiply(BigInteger.valueOf(2L)));
        v = v.add(BigInteger.valueOf(35L));
        return new Sign.SignatureData(v.toByteArray(), signatureData.getR(), signatureData.getS());
    }

    @Deprecated
    public static Sign.SignatureData createEip155SignatureData(Sign.SignatureData signatureData, byte chainId) {
        return TransactionEncoder.createEip155SignatureData(signatureData, (long)chainId);
    }

    public static byte[] encode(RawTransaction rawTransaction) {
        return TransactionEncoder.encode(rawTransaction, null);
    }

    public static byte[] encode(RawTransaction rawTransaction, long chainId) {
        if (!rawTransaction.getType().isLegacy()) {
            throw new CryptoWeb3jException("Incorrect transaction type. Tx type should be Legacy.");
        }
        Sign.SignatureData signatureData = new Sign.SignatureData(TransactionEncoder.longToBytes(chainId), new byte[0], new byte[0]);
        return TransactionEncoder.encode(rawTransaction, signatureData);
    }

    @Deprecated
    public static byte[] encode(RawTransaction rawTransaction, byte chainId) {
        return TransactionEncoder.encode(rawTransaction, (long)chainId);
    }

    public static byte[] encode(RawTransaction rawTransaction, Sign.SignatureData signatureData) {
        List<RlpType> values = TransactionEncoder.asRlpValues(rawTransaction, signatureData);
        RlpList rlpList = new RlpList(values);
        byte[] encoded = RlpEncoder.encode((RlpType)rlpList);
        if (rawTransaction.getType().isEip1559() || rawTransaction.getType().isEip2930()) {
            return ByteBuffer.allocate(encoded.length + 1).put(rawTransaction.getType().getRlpType()).put(encoded).array();
        }
        return encoded;
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static List<RlpType> asRlpValues(RawTransaction rawTransaction, Sign.SignatureData signatureData) {
        return rawTransaction.getTransaction().asRlpValues(signatureData);
    }
}

