/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.AccessListObject;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.LegacyTransaction;
import org.web3j.crypto.transaction.type.Transaction1559;
import org.web3j.crypto.transaction.type.Transaction2930;
import org.web3j.crypto.transaction.type.TransactionType;

public class RawTransaction {
    private final ITransaction transaction;

    protected RawTransaction(ITransaction transaction) {
        this.transaction = transaction;
    }

    protected RawTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        this(new LegacyTransaction(nonce, gasPrice, gasLimit, to, value, data));
    }

    public static RawTransaction createContractTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, BigInteger value, String init) {
        return new RawTransaction(LegacyTransaction.createContractTransaction(nonce, gasPrice, gasLimit, value, init));
    }

    public static RawTransaction createEtherTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value) {
        return new RawTransaction(LegacyTransaction.createEtherTransaction(nonce, gasPrice, gasLimit, to, value));
    }

    public static RawTransaction createEtherTransaction(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas) {
        return new RawTransaction(Transaction1559.createEtherTransaction(chainId, nonce, gasLimit, to, value, maxPriorityFeePerGas, maxFeePerGas));
    }

    public static RawTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, String data) {
        return RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, BigInteger.ZERO, data);
    }

    public static RawTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        return new RawTransaction(LegacyTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, data));
    }

    public static RawTransaction createTransaction(long chainId, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas) {
        return new RawTransaction(Transaction1559.createTransaction(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas));
    }

    public static RawTransaction createTransaction(long chainId, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data, List<AccessListObject> accessList) {
        return new RawTransaction(Transaction2930.createTransaction(chainId, nonce, gasPrice, gasLimit, to, value, data, accessList));
    }

    public BigInteger getNonce() {
        return this.transaction.getNonce();
    }

    public BigInteger getGasPrice() {
        return this.transaction.getGasPrice();
    }

    public BigInteger getGasLimit() {
        return this.transaction.getGasLimit();
    }

    public String getTo() {
        return this.transaction.getTo();
    }

    public BigInteger getValue() {
        return this.transaction.getValue();
    }

    public String getData() {
        return this.transaction.getData();
    }

    public TransactionType getType() {
        return this.transaction.getType();
    }

    public ITransaction getTransaction() {
        return this.transaction;
    }
}

