/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.crypto.KeyPair;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.parameters.BlockParameter;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.BlockResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionCompleteResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionHashResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptLogResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptRootResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptStatusResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionResult;
import org.hyperledger.besu.ethereum.api.query.BlockchainQueries;
import org.hyperledger.besu.ethereum.api.query.TransactionReceiptWithMetadata;
import org.hyperledger.besu.ethereum.core.AccessListEntry;
import org.hyperledger.besu.ethereum.core.Hash;
import org.hyperledger.besu.ethereum.core.Transaction;
import org.hyperledger.besu.ethereum.core.TransactionReceipt;
import org.hyperledger.besu.ethereum.core.Wei;
import org.hyperledger.besu.ethereum.mainnet.TransactionReceiptType;
import org.hyperledger.besu.ethereum.processing.TransactionProcessingResult;
import org.hyperledger.besu.ethereum.rlp.RLP;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.transaction.TransactionSimulatorResult;
import org.hyperledger.besu.ethereum.vm.OperationTracer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.datatypes.Address;
import org.web3j.evm.Configuration;
import org.web3j.evm.EmbeddedEthereum;
import org.web3j.evm.EmbeddedEthereumKt;
import org.web3j.evm.EmbeddedEthereumKt$sam$java_util_function_Function$0;
import org.web3j.evm.InMemoryBesuChain;
import org.web3j.evm.utils.TestAccountsConstants;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.AccessListObject;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u001c\u001a\u00020\fJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fJ\u000e\u0010$\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020%J\u000e\u0010&\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020'J\u0016\u0010(\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\"J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\fJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fJ\u000e\u00106\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u00108\u001a\u000209*\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/web3j/evm/EmbeddedEthereum;", "", "configuration", "Lorg/web3j/evm/Configuration;", "operationTracer", "Lorg/hyperledger/besu/ethereum/vm/OperationTracer;", "(Lorg/web3j/evm/Configuration;Lorg/hyperledger/besu/ethereum/vm/OperationTracer;)V", "blockchainQueries", "Lorg/hyperledger/besu/ethereum/api/query/BlockchainQueries;", "chain", "Lorg/web3j/evm/InMemoryBesuChain;", "estimateGas", "", "web3jTransaction", "Lorg/web3j/protocol/core/methods/request/Transaction;", "ethBlockByBlockResult", "Lorg/web3j/protocol/core/methods/response/EthBlock$Block;", "blockResult", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/BlockResult;", "fullTransactionObjects", "", "ethBlockByHash", "hash", "ethBlockByNumber", "blockNumber", "ethBlockFullTransactionObject", "", "Lorg/web3j/protocol/core/methods/response/EthBlock$TransactionObject;", "ethBlockNumber", "ethBlockTransactionHash", "Lorg/web3j/protocol/core/methods/response/EthBlock$TransactionHash;", "ethCall", "ethGetBalance", "w3jAddress", "Lorg/web3j/abi/datatypes/Address;", "defaultBlockParameter", "ethGetBlockTransactionCountByHash", "Lorg/hyperledger/besu/ethereum/core/Hash;", "ethGetBlockTransactionCountByNumber", "", "ethGetCode", "getResult", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/TransactionReceiptResult;", "receipt", "Lorg/hyperledger/besu/ethereum/api/query/TransactionReceiptWithMetadata;", "getTransactionCount", "Ljava/math/BigInteger;", "getTransactionReceipt", "Lorg/web3j/protocol/core/methods/response/TransactionReceipt;", "transactionHashParam", "mapTransactionReceiptLog", "Lorg/web3j/protocol/core/methods/response/Log;", "result", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/TransactionReceiptLogResult;", "processTransaction", "signedTransactionData", "toSignedBesuTx", "Lorg/hyperledger/besu/ethereum/core/Transaction;", "Companion", "web3j-evm"})
public final class EmbeddedEthereum {
    private final InMemoryBesuChain chain;
    private final BlockchainQueries blockchainQueries;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final String processTransaction(@NotNull Transaction web3jTransaction) {
        Intrinsics.checkNotNullParameter((Object)web3jTransaction, (String)"web3jTransaction");
        org.hyperledger.besu.ethereum.core.Transaction transaction = this.toSignedBesuTx(web3jTransaction);
        this.chain.processTransaction(transaction);
        String string = transaction.getHash().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transaction.hash.toHexString()");
        return string;
    }

    @NotNull
    public final String processTransaction(@NotNull String signedTransactionData) {
        org.hyperledger.besu.ethereum.core.Transaction transaction;
        Intrinsics.checkNotNullParameter((Object)signedTransactionData, (String)"signedTransactionData");
        org.hyperledger.besu.ethereum.core.Transaction transaction2 = transaction = org.hyperledger.besu.ethereum.core.Transaction.readFrom((RLPInput)RLP.input((Bytes)Bytes.fromHexString((CharSequence)signedTransactionData)));
        Intrinsics.checkNotNullExpressionValue((Object)transaction2, (String)"transaction");
        this.chain.processTransaction(transaction2);
        String string = transaction.getHash().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transaction.hash.toHexString()");
        return string;
    }

    private final org.hyperledger.besu.ethereum.core.Transaction toSignedBesuTx(Transaction $this$toSignedBesuTx) {
        String string;
        long nonce;
        long l;
        BigInteger chainId;
        BigInteger bigInteger;
        boolean bl = false;
        boolean bl2 = false;
        Transaction $this$with = $this$toSignedBesuTx;
        boolean bl3 = false;
        String string2 = $this$with.getChainId();
        if (string2 != null) {
            String string3 = string2;
            boolean bl4 = false;
            bigInteger = new BigInteger(string3);
        } else {
            bigInteger = chainId = this.chain.getChainId();
        }
        if ($this$with.getNonce() == null) {
            l = this.getTransactionCount(new Address($this$with.getFrom())).longValue();
        } else {
            String string4 = $this$with.getNonce();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"nonce");
            l = nonce = EmbeddedEthereum.Companion.hexToULong(string4);
        }
        if ((string = $this$with.getFrom()) == null) {
            string = "0x0";
        }
        String string5 = string;
        boolean bl5 = false;
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
        String from = string7;
        Transaction.Builder builder = org.hyperledger.besu.ethereum.core.Transaction.builder().gasLimit(EmbeddedEthereum.Companion.transactionGasLimitOrDefault($this$with));
        String string8 = $this$with.getGasPrice();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"gasPrice");
        Transaction.Builder builder2 = builder.gasPrice(Wei.of((long)EmbeddedEthereum.Companion.hexToULong(string8))).nonce(nonce).sender(org.hyperledger.besu.ethereum.core.Address.fromHexString((String)from)).to(org.hyperledger.besu.ethereum.core.Address.fromHexString((String)$this$with.getTo())).payload(Bytes.fromHexString((CharSequence)$this$with.getData()));
        String string9 = $this$with.getValue();
        if (string9 == null) {
            string9 = "0x0";
        }
        Transaction.Builder builder3 = builder2.value(Wei.of((UInt256)UInt256.fromHexString((String)string9))).chainId(chainId).guessType();
        KeyPair keyPair = TestAccountsConstants.INSTANCE.getTEST_ACCOUNTS().get(from);
        if (keyPair == null) {
            keyPair = (KeyPair)CollectionsKt.first((Iterable)TestAccountsConstants.INSTANCE.getTEST_ACCOUNTS().values());
        }
        org.hyperledger.besu.ethereum.core.Transaction transaction = builder3.signAndBuild(keyPair);
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"Transaction.builder()\n  \u2026first()\n                )");
        return transaction;
    }

    @NotNull
    public final BigInteger getTransactionCount(@NotNull Address w3jAddress) {
        Intrinsics.checkNotNullParameter((Object)w3jAddress, (String)"w3jAddress");
        long count = this.blockchainQueries.getTransactionCount(EmbeddedEthereumKt.access$asBesu(w3jAddress));
        BigInteger bigInteger = BigInteger.valueOf(count);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(count)");
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final org.web3j.protocol.core.methods.response.TransactionReceipt getTransactionReceipt(@NotNull String transactionHashParam) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)transactionHashParam, (String)"transactionHashParam");
        Hash hash = Hash.fromHexStringLenient((String)transactionHashParam);
        TransactionReceiptResult transactionReceiptResult = this.blockchainQueries.transactionReceiptByTransactionHash(hash).map((Function)new Function<TransactionReceiptWithMetadata, TransactionReceiptResult>(this){
            final /* synthetic */ EmbeddedEthereum this$0;

            public final TransactionReceiptResult apply(TransactionReceiptWithMetadata receipt) {
                TransactionReceiptWithMetadata transactionReceiptWithMetadata = receipt;
                Intrinsics.checkNotNullExpressionValue((Object)transactionReceiptWithMetadata, (String)"receipt");
                return EmbeddedEthereum.access$getResult(this.this$0, transactionReceiptWithMetadata);
            }
            {
                this.this$0 = embeddedEthereum;
            }
        }).orElse(null);
        if (transactionReceiptResult == null) {
            return null;
        }
        TransactionReceiptResult result2 = transactionReceiptResult;
        String blockHash = result2.getBlockHash();
        String blockNumber = result2.getBlockNumber();
        String contractAddress = result2.getContractAddress();
        String cumulativeGasUsed = result2.getCumulativeGasUsed();
        String from = result2.getFrom();
        String gasUsed = result2.getGasUsed();
        String effectiveGasPrice = result2.getEffectiveGasPrice();
        List list = result2.getLogs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.logs");
        Iterable iterable = list;
        EmbeddedEthereum embeddedEthereum = this;
        boolean $i$f$map = false;
        void var15_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            TransactionReceiptLogResult transactionReceiptLogResult = (TransactionReceiptLogResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Log log = embeddedEthereum.mapTransactionReceiptLog((TransactionReceiptLogResult)p1);
            collection.add(log);
        }
        List logs = (List)destination$iv$iv;
        String logsBloom = result2.getLogsBloom();
        String to = result2.getTo();
        String transactionHash = result2.getTransactionHash();
        String transactionIndex = result2.getTransactionIndex();
        String root = result2 instanceof TransactionReceiptRootResult ? ((TransactionReceiptRootResult)result2).getRoot() : null;
        String status = result2 instanceof TransactionReceiptStatusResult ? ((TransactionReceiptStatusResult)result2).getStatus() : null;
        return new org.web3j.protocol.core.methods.response.TransactionReceipt(transactionHash, transactionIndex, blockHash, blockNumber, cumulativeGasUsed, gasUsed, contractAddress, root, status, from, to, logs, logsBloom, "", "", effectiveGasPrice);
    }

    private final Log mapTransactionReceiptLog(TransactionReceiptLogResult result2) {
        boolean removed = result2.isRemoved();
        String logIndex = result2.getLogIndex();
        String transactionIndex = result2.getTransactionIndex();
        String transactionHash = result2.getTransactionHash();
        String blockHash = result2.getBlockHash();
        String blockNumber = result2.getBlockNumber();
        String address = result2.getAddress();
        String data = result2.getData();
        String type = null;
        List topics = result2.getTopics();
        return new Log(removed, logIndex, transactionIndex, transactionHash, blockHash, blockNumber, address, data, type, topics);
    }

    private final TransactionReceiptResult getResult(TransactionReceiptWithMetadata receipt) {
        TransactionReceipt transactionReceipt = receipt.getReceipt();
        Intrinsics.checkNotNullExpressionValue((Object)transactionReceipt, (String)"receipt.receipt");
        return transactionReceipt.getTransactionReceiptType() == TransactionReceiptType.ROOT ? (TransactionReceiptResult)new TransactionReceiptRootResult(receipt) : (TransactionReceiptResult)new TransactionReceiptStatusResult(receipt);
    }

    @NotNull
    public final String ethCall(@NotNull Transaction web3jTransaction) {
        Intrinsics.checkNotNullParameter((Object)web3jTransaction, (String)"web3jTransaction");
        Optional<TransactionSimulatorResult> result2 = this.chain.call(EmbeddedEthereumKt.access$asCallParameter(web3jTransaction));
        TransactionSimulatorResult transactionSimulatorResult = result2.get();
        Intrinsics.checkNotNullExpressionValue((Object)transactionSimulatorResult, (String)"result.get()");
        TransactionProcessingResult transactionProcessingResult = transactionSimulatorResult.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)transactionProcessingResult, (String)"result.get().result");
        String string = transactionProcessingResult.getOutput().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.get().result.output.toHexString()");
        return string;
    }

    @NotNull
    public final String estimateGas(@NotNull Transaction web3jTransaction) {
        Intrinsics.checkNotNullParameter((Object)web3jTransaction, (String)"web3jTransaction");
        Optional<TransactionSimulatorResult> result2 = this.chain.call(EmbeddedEthereumKt.access$asCallParameter(web3jTransaction));
        TransactionSimulatorResult transactionSimulatorResult = result2.get();
        Intrinsics.checkNotNullExpressionValue((Object)transactionSimulatorResult, (String)"result.get()");
        TransactionProcessingResult transactionProcessingResult = transactionSimulatorResult.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)transactionProcessingResult, (String)"result.get().result");
        return EmbeddedEthereum.Companion.longToHex(transactionProcessingResult.getEstimateGasUsedByTransaction());
    }

    @NotNull
    public final String ethBlockNumber() {
        return EmbeddedEthereum.Companion.longToHex(this.blockchainQueries.headBlockNumber());
    }

    @Nullable
    public final String ethGetBalance(@NotNull Address w3jAddress, @NotNull String defaultBlockParameter) {
        Intrinsics.checkNotNullParameter((Object)w3jAddress, (String)"w3jAddress");
        Intrinsics.checkNotNullParameter((Object)defaultBlockParameter, (String)"defaultBlockParameter");
        Optional optional = this.blockchainQueries.accountBalance(org.hyperledger.besu.ethereum.core.Address.fromHexString((String)w3jAddress.getValue()), this.blockchainQueries.headBlockNumber());
        Object object = ethGetBalance.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new EmbeddedEthereumKt$sam$java_util_function_Function$0(function1);
        }
        return optional.map((Function)object).orElse(null);
    }

    @Nullable
    public final EthBlock.Block ethBlockByHash(@NotNull String hash, boolean fullTransactionObjects) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Hash hash2 = Hash.fromHexString((String)hash);
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"Hash.fromHexString(hash)");
        Optional<BlockResult> maybeBlockResult = this.chain.ethBlockByHash(hash2, fullTransactionObjects);
        return maybeBlockResult.map((Function)new Function<BlockResult, EthBlock.Block>(this, fullTransactionObjects){
            final /* synthetic */ EmbeddedEthereum this$0;
            final /* synthetic */ boolean $fullTransactionObjects;

            @Nullable
            public final EthBlock.Block apply(BlockResult br) {
                BlockResult blockResult = br;
                Intrinsics.checkNotNullExpressionValue((Object)blockResult, (String)"br");
                return EmbeddedEthereum.access$ethBlockByBlockResult(this.this$0, blockResult, this.$fullTransactionObjects);
            }
            {
                this.this$0 = embeddedEthereum;
                this.$fullTransactionObjects = bl;
            }
        }).orElse(null);
    }

    @Nullable
    public final EthBlock.Block ethBlockByNumber(@NotNull String blockNumber, boolean fullTransactionObjects) {
        Intrinsics.checkNotNullParameter((Object)blockNumber, (String)"blockNumber");
        Optional<BlockResult> maybeBlockResult = this.chain.ethBlockByNumber(EmbeddedEthereum.Companion.hexToULong(blockNumber), fullTransactionObjects);
        return maybeBlockResult.map((Function)new Function<BlockResult, EthBlock.Block>(this, fullTransactionObjects){
            final /* synthetic */ EmbeddedEthereum this$0;
            final /* synthetic */ boolean $fullTransactionObjects;

            @Nullable
            public final EthBlock.Block apply(BlockResult br) {
                BlockResult blockResult = br;
                Intrinsics.checkNotNullExpressionValue((Object)blockResult, (String)"br");
                return EmbeddedEthereum.access$ethBlockByBlockResult(this.this$0, blockResult, this.$fullTransactionObjects);
            }
            {
                this.this$0 = embeddedEthereum;
                this.$fullTransactionObjects = bl;
            }
        }).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EthBlock.TransactionObject> ethBlockFullTransactionObject(BlockResult blockResult) {
        void $this$mapTo$iv$iv;
        List list = blockResult.getTransactions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"blockResult.transactions");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<AccessListObject> collection;
            void it;
            TransactionResult transactionResult = (TransactionResult)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionCompleteResult");
            }
            TransactionCompleteResult tcr = (TransactionCompleteResult)v1;
            String string = tcr.getHash();
            String string2 = tcr.getNonce();
            String string3 = tcr.getBlockHash();
            String string4 = tcr.getBlockNumber();
            String string5 = tcr.getTransactionIndex();
            String string6 = tcr.getFrom();
            String string7 = tcr.getTo();
            String string8 = tcr.getValue();
            String string9 = tcr.getGasPrice();
            String string10 = tcr.getGas();
            String string11 = tcr.getInput();
            String string12 = null;
            String string13 = null;
            String string14 = null;
            String string15 = tcr.getR();
            String string16 = tcr.getS();
            String string17 = tcr.getV();
            Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"tcr.v");
            long l = EmbeddedEthereum.Companion.hexToULong(string17);
            String string18 = tcr.getType();
            String string19 = tcr.getMaxFeePerGas();
            String string20 = tcr.getMaxPriorityFeePerGas();
            List list2 = tcr.getAccessList();
            if (list2 != null) {
                Collection<AccessListObject> collection3;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable2 = list2;
                String string21 = string20;
                String string22 = string19;
                String string23 = string18;
                long l2 = l;
                String string24 = string16;
                String string25 = string15;
                String string26 = string14;
                String string27 = string13;
                String string28 = string12;
                String string29 = string11;
                String string30 = string10;
                String string31 = string9;
                String string32 = string8;
                String string33 = string7;
                String string34 = string6;
                String string35 = string5;
                String string36 = string4;
                String string37 = string3;
                String string38 = string2;
                String string39 = string;
                boolean $i$f$map2 = false;
                void var37_34 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it2;
                    AccessListEntry accessListEntry = (AccessListEntry)item$iv$iv2;
                    collection3 = destination$iv$iv2;
                    boolean bl2 = false;
                    void v24 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"it");
                    AccessListObject accessListObject = new AccessListObject(v24.getAddress().toHexString(), CollectionsKt.mutableListOf((Object[])new String[]{it2.getStorageKeys().toString()}));
                    collection3.add(accessListObject);
                }
                collection3 = (List)destination$iv$iv2;
                string = string39;
                string2 = string38;
                string3 = string37;
                string4 = string36;
                string5 = string35;
                string6 = string34;
                string7 = string33;
                string8 = string32;
                string9 = string31;
                string10 = string30;
                string11 = string29;
                string12 = string28;
                string13 = string27;
                string14 = string26;
                string15 = string25;
                string16 = string24;
                l = l2;
                string18 = string23;
                string19 = string22;
                string20 = string21;
                collection = collection3;
            } else {
                collection = null;
            }
            Collection<AccessListObject> collection4 = collection;
            String string40 = string20;
            String string41 = string19;
            String string42 = string18;
            long l3 = l;
            String string43 = string16;
            String string44 = string15;
            String string45 = string14;
            String string46 = string13;
            String string47 = string12;
            String string48 = string11;
            String string49 = string10;
            String string50 = string9;
            String string51 = string8;
            String string52 = string7;
            String string53 = string6;
            String string54 = string5;
            String string55 = string4;
            String string56 = string3;
            String string57 = string2;
            String string58 = string;
            EthBlock.TransactionObject transactionObject = new EthBlock.TransactionObject(string58, string57, string56, string55, string54, string53, string52, string51, string50, string49, string48, string47, string46, string45, string44, string43, l3, string42, string41, string40, collection4);
            collection2.add(transactionObject);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EthBlock.TransactionHash> ethBlockTransactionHash(BlockResult blockResult) {
        void $this$mapTo$iv$iv;
        List list = blockResult.getTransactions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"blockResult.transactions");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TransactionResult transactionResult = (TransactionResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionHashResult");
            }
            TransactionHashResult thr = (TransactionHashResult)v1;
            EthBlock.TransactionHash transactionHash = new EthBlock.TransactionHash(thr.getHash());
            collection.add(transactionHash);
        }
        return (List)destination$iv$iv;
    }

    private final EthBlock.Block ethBlockByBlockResult(BlockResult blockResult, boolean fullTransactionObjects) {
        List<EthBlock.TransactionObject> transactionResults = fullTransactionObjects ? this.ethBlockFullTransactionObject(blockResult) : this.ethBlockTransactionHash(blockResult);
        return new EthBlock.Block(blockResult.getNumber(), blockResult.getHash(), blockResult.getParentHash(), blockResult.getNonce(), blockResult.getSha3Uncles(), blockResult.getLogsBloom(), blockResult.getTransactionsRoot(), blockResult.getStateRoot(), blockResult.getReceiptsRoot(), null, blockResult.getMiner(), null, blockResult.getDifficulty(), blockResult.getTotalDifficulty(), blockResult.getExtraData(), blockResult.getSize(), blockResult.getGasLimit(), blockResult.getGasUsed(), blockResult.getTimestamp(), transactionResults, null, null, blockResult.getBaseFeePerGas());
    }

    @NotNull
    public final String ethGetCode(@NotNull Address w3jAddress, @NotNull String defaultBlockParameter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)w3jAddress, (String)"w3jAddress");
        Intrinsics.checkNotNullParameter((Object)defaultBlockParameter, (String)"defaultBlockParameter");
        BlockParameter blockParameter = new BlockParameter(defaultBlockParameter);
        Optional optional = blockParameter.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"blockParameter.number");
        Optional blockNumber = optional;
        org.hyperledger.besu.ethereum.core.Address address = EmbeddedEthereumKt.access$asBesu(w3jAddress);
        if (blockNumber.isPresent()) {
            Object t = blockNumber.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"blockNumber.get()");
            object = this.blockchainQueries.getCode(address, ((Number)t).longValue());
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        } else if (blockParameter.isLatest()) {
            object = this.blockchainQueries.getCode(address, this.blockchainQueries.headBlockNumber());
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        } else if (blockParameter.isEarliest()) {
            object = this.blockchainQueries.getCode(address, 0L);
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        } else {
            object = this.blockchainQueries.getCode(address, this.blockchainQueries.headBlockNumber());
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        }
        return object;
    }

    @NotNull
    public final String ethGetBlockTransactionCountByHash(@NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        String string = Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(this.blockchainQueries.getTransactionCount(hash).intValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Numeric.encodeQuantity(B\u2026ionCount(hash).toLong()))");
        return string;
    }

    @NotNull
    public final String ethGetBlockTransactionCountByNumber(long blockNumber) {
        String string = Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(((Number)this.blockchainQueries.getTransactionCount(blockNumber).get()).intValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Numeric.encodeQuantity(\n\u2026)\n            )\n        )");
        return string;
    }

    public EmbeddedEthereum(@NotNull Configuration configuration, @NotNull OperationTracer operationTracer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)operationTracer, (String)"operationTracer");
        this.chain = new InMemoryBesuChain(configuration, operationTracer, null, null, 12, null);
        this.blockchainQueries = this.chain.getBlockchainQueries();
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(EmbeddedEthereum.class);
    }

    public static final /* synthetic */ TransactionReceiptResult access$getResult(EmbeddedEthereum $this, TransactionReceiptWithMetadata receipt) {
        return $this.getResult(receipt);
    }

    public static final /* synthetic */ EthBlock.Block access$ethBlockByBlockResult(EmbeddedEthereum $this, BlockResult blockResult, boolean fullTransactionObjects) {
        return $this.ethBlockByBlockResult(blockResult, fullTransactionObjects);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/web3j/evm/EmbeddedEthereum$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "hexToULong", "", "hex", "", "longToHex", "value", "transactionGasLimitOrDefault", "web3jTransaction", "Lorg/web3j/protocol/core/methods/request/Transaction;", "web3j-evm"})
    public static final class Companion {
        private final long hexToULong(String hex) {
            return UInt256.fromHexString((String)hex).toLong();
        }

        private final String longToHex(long value) {
            String string = UInt256.valueOf((long)value).toShortHexString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UInt256.valueOf(value).toShortHexString()");
            return string;
        }

        private final long transactionGasLimitOrDefault(Transaction web3jTransaction) {
            long l;
            if (web3jTransaction.getGas() == null) {
                l = 10000000L;
            } else {
                String string = web3jTransaction.getGas();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"web3jTransaction.gas");
                l = this.hexToULong(string);
            }
            return l;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

