/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.mavenplugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.web3j.codegen.SolidityFunctionWrapper;
import org.web3j.mavenplugin.Contract;
import org.web3j.mavenplugin.SourceDestination;
import org.web3j.mavenplugin.solidity.CompilerResult;
import org.web3j.mavenplugin.solidity.SolidityCompiler;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class JavaClassGeneratorMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDE = "**/*.sol";
    private static final String DEFAULT_PACKAGE = "org.web3j.model";
    private static final String DEFAULT_SOURCE_DESTINATION = "src/main/java";
    private static final String DEFAULT_SOLIDITY_SOURCES = "src/main/resources";
    private static final String DEFAULT_OUTPUT_FORMAT = "java";
    @Parameter(property="packageName", defaultValue="org.web3j.model")
    protected String packageName;
    @Parameter(property="sourceDestination", defaultValue="src/main/java")
    protected String sourceDestination;
    @Parameter(property="outputDirectory")
    protected SourceDestination outputDirectory = new SourceDestination();
    @Parameter(property="soliditySourceFiles")
    protected FileSet soliditySourceFiles = new FileSet();
    @Parameter(property="contract")
    protected Contract contract;
    @Parameter(property="nativeJavaType", defaultValue="true")
    protected boolean nativeJavaType;
    @Parameter(property="outputFormat", defaultValue="java")
    protected String outputFormat;

    private Path createPath(String destinationPath) throws IOException {
        Path path = Paths.get(destinationPath, this.packageName);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    private Map<String, Map<String, String>> extractContracts(String result) throws MojoExecutionException {
        try {
            ScriptEngine engine = new ScriptEngineManager(null).getEngineByName("nashorn");
            String script = "JSON.parse(JSON.stringify(" + result + "))";
            Map json = (Map)engine.eval(script);
            Map contracts = (Map)json.get("contracts");
            if (contracts == null) {
                this.getLog().warn((CharSequence)"no contracts found");
                return null;
            }
            HashMap<String, String> contractRemap = new HashMap<String, String>();
            for (String contractFilename : contracts.keySet()) {
                Map compilationTarget;
                Map contractMetadata = (Map)contracts.get(contractFilename);
                String metadata = (String)contractMetadata.get("metadata");
                if (metadata == null || metadata.length() == 0) {
                    contracts.remove(contractFilename);
                    continue;
                }
                this.getLog().debug((CharSequence)("metadata:" + metadata));
                String metadataScript = "JSON.parse(JSON.stringify(" + metadata + "))";
                Map metadataJson = (Map)engine.eval(metadataScript);
                Object settingsMap = metadataJson.get("settings");
                if (settingsMap != null && (compilationTarget = (Map)((Map)settingsMap).get("compilationTarget")) != null) {
                    for (Map.Entry entry : compilationTarget.entrySet()) {
                        String value = (String)entry.getValue();
                        contractRemap.put(contractFilename, value);
                    }
                }
                Map compiledContract = (Map)contracts.remove(contractFilename);
                String contractName = (String)contractRemap.get(contractFilename);
                contracts.put(contractName, compiledContract);
            }
            return contracts;
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("Could not parse SolC result", (Exception)e);
        }
    }

    private String parseSoliditySources(Collection<String> includedFiles) throws MojoExecutionException {
        if (includedFiles == null || includedFiles.isEmpty()) {
            return "{}";
        }
        CompilerResult result = SolidityCompiler.getInstance(this.getLog()).compileSrc(this.soliditySourceFiles.getDirectory(), includedFiles, SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.INTERFACE, SolidityCompiler.Options.METADATA);
        if (result.isFailed()) {
            throw new MojoExecutionException("Could not compile solidity files\n" + result.errors);
        }
        this.getLog().debug((CharSequence)("\t\tResult:\t" + result.output));
        if (result.errors.contains("Warning:")) {
            this.getLog().info((CharSequence)("\tCompile Warning:\n" + result.errors));
        } else {
            this.getLog().debug((CharSequence)("\t\tError: \t" + result.errors));
        }
        return result.output;
    }

    private void processContractFile(Collection<String> files) throws MojoExecutionException {
        String result = this.parseSoliditySources(files);
        this.processResult(result, "\tNo Contract found in files '" + files + "'");
    }

    public void execute() throws MojoExecutionException {
        String[] files;
        if (this.soliditySourceFiles.getDirectory() == null) {
            this.getLog().info((CharSequence)"No solidity directory specified, using default directory [src/main/resources]");
            this.soliditySourceFiles.setDirectory(DEFAULT_SOLIDITY_SOURCES);
        }
        if (this.soliditySourceFiles.getIncludes().isEmpty()) {
            this.getLog().info((CharSequence)"No solidity contracts specified, using the default [**/*.sol]");
            this.soliditySourceFiles.setIncludes(Collections.singletonList(DEFAULT_INCLUDE));
        }
        if ((files = new FileSetManager().getIncludedFiles(this.soliditySourceFiles)) != null) {
            this.processContractFile(Stream.of(files).filter(f -> {
                this.getLog().info((CharSequence)("Adding to process '" + f + "'"));
                return true;
            }).collect(Collectors.toList()));
        }
    }

    private void generatedAbi(Map<String, String> contractResult, String contractName) {
        if (!StringUtils.containsIgnoreCase((CharSequence)this.outputFormat, (CharSequence)"abi")) {
            return;
        }
        String abiJson = contractResult.get(SolidityCompiler.Options.ABI.getName());
        try {
            String filename = contractName + ".json";
            Path path = this.createPath(StringUtils.defaultString((String)this.outputDirectory.getAbi(), (String)this.sourceDestination));
            Files.write(Paths.get(path.toString(), filename), abiJson.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not build abi file for contract '" + contractName + "'"), (Throwable)e);
        }
    }

    private void generatedBin(Map<String, String> contractResult, String contractName) {
        if (!StringUtils.containsIgnoreCase((CharSequence)this.outputFormat, (CharSequence)"bin")) {
            return;
        }
        String binJson = contractResult.get(SolidityCompiler.Options.BIN.getName());
        try {
            String filename = contractName + ".bin";
            Path path = this.createPath(StringUtils.defaultString((String)this.outputDirectory.getBin(), (String)this.sourceDestination));
            Files.write(Paths.get(path.toString(), filename), binJson.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not build bin file for contract '" + contractName + "'"), (Throwable)e);
        }
    }

    private void generatedJavaClass(Map<String, String> results, String contractName) throws IOException, ClassNotFoundException {
        if (!StringUtils.containsIgnoreCase((CharSequence)this.outputFormat, (CharSequence)DEFAULT_OUTPUT_FORMAT)) {
            return;
        }
        new SolidityFunctionWrapper(this.nativeJavaType).generateJavaFiles(contractName, results.get(SolidityCompiler.Options.BIN.getName()), results.get(SolidityCompiler.Options.ABI.getName()), StringUtils.defaultString((String)this.outputDirectory.getJava(), (String)this.sourceDestination), this.packageName);
    }

    private void processResult(String result, String warnMsg) throws MojoExecutionException {
        Map<String, Map<String, String>> contracts = this.extractContracts(result);
        if (contracts == null) {
            this.getLog().warn((CharSequence)warnMsg);
            return;
        }
        for (String contractName : contracts.keySet()) {
            if (this.isFiltered(contractName)) {
                this.getLog().debug((CharSequence)("\tContract '" + contractName + "' is filtered"));
                continue;
            }
            try {
                Map<String, String> contractResult = contracts.get(contractName);
                this.generatedJavaClass(contractResult, contractName);
                this.generatedAbi(contractResult, contractName);
                this.generatedBin(contractResult, contractName);
                this.getLog().info((CharSequence)("\tBuilt Class for contract '" + contractName + "'"));
            }
            catch (IOException | ClassNotFoundException ioException) {
                this.getLog().error((CharSequence)("Could not build java class for contract '" + contractName + "'"), (Throwable)ioException);
            }
        }
    }

    private boolean isFiltered(String contractName) {
        if (this.contract == null) {
            return false;
        }
        if (this.contract.getExcludes() != null && !this.contract.getExcludes().isEmpty()) {
            return this.contract.getExcludes().contains(contractName);
        }
        if (this.contract.getIncludes() == null || this.contract.getIncludes().isEmpty()) {
            return false;
        }
        return !this.contract.getIncludes().contains(contractName);
    }
}

