/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.mavenplugin.solidity;

import java.util.regex.Matcher;
import org.apache.maven.plugin.MojoExecutionException;
import org.web3j.mavenplugin.solidity.Constant;

public class VersionMismatchException
extends MojoExecutionException {
    private final String solidityContractVersion;
    private final String solCVersion;

    public VersionMismatchException(String version, String message) {
        super("Could not compile solidity source file. Version mismatch.");
        this.solCVersion = version;
        Matcher matcher = Constant.SOLIDITY_VERSION_EXTRACT.matcher(message);
        this.solidityContractVersion = matcher.find() ? matcher.group(1) : null;
    }

    public String getSolCVersion() {
        return this.solCVersion;
    }

    public String getSolidityContractVersion() {
        return this.solidityContractVersion;
    }
}

