/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.container;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.DockerComposeContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.web3j.container.GenericService;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/web3j/container/KDockerComposeContainer;", "Lorg/testcontainers/containers/DockerComposeContainer;", "Lorg/web3j/container/GenericService;", "dockerComposePath", "", "serviceName", "containerPort", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "startService", "Lorg/web3j/protocol/Web3jService;", "web3j-unit"})
public class KDockerComposeContainer
extends DockerComposeContainer<KDockerComposeContainer>
implements GenericService {
    @NotNull
    private final String serviceName;
    private final int containerPort;

    public KDockerComposeContainer(@NotNull String dockerComposePath, @NotNull String serviceName, int containerPort) {
        Intrinsics.checkNotNullParameter((Object)dockerComposePath, (String)"dockerComposePath");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        File[] fileArray = new File[]{new File(dockerComposePath)};
        super(fileArray);
        this.serviceName = serviceName;
        this.containerPort = containerPort;
    }

    @Override
    @NotNull
    public Web3jService startService() {
        this.withLogConsumer(this.serviceName, KDockerComposeContainer::startService$lambda$0);
        this.withExposedService(this.serviceName, this.containerPort);
        this.start();
        Integer mappedPort = this.getServicePort(this.serviceName, this.containerPort);
        return (Web3jService)new HttpService("http://localhost:" + mappedPort);
    }

    private static final void startService$lambda$0(OutputFrame it) {
        System.out.print((Object)it.getUtf8String());
    }
}

