/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.helpers;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    private static final AtomicInteger factoryCount = new AtomicInteger();
    private final AtomicInteger threadCount = new AtomicInteger();
    private final ThreadFactory factory;
    private final String prefix;

    public NamingThreadFactory(ThreadFactory factory, String prefix) {
        this.factory = factory;
        this.prefix = prefix;
        factoryCount.incrementAndGet();
    }

    public NamingThreadFactory(String prefix) {
        this(Executors.defaultThreadFactory(), prefix);
    }

    @Override
    public Thread newThread(Runnable r) {
        this.threadCount.incrementAndGet();
        Thread thread = this.factory.newThread(r);
        thread.setName(this.threadName());
        return thread;
    }

    protected String threadName() {
        return String.format("%s-%d-%d-thread", this.prefix, factoryCount.intValue(), this.threadCount.intValue());
    }
}

