/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport'],function(q,l,C,V){"use strict";var P=C.extend("sap.m.ProgressIndicator",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None},displayValue:{type:"string",group:"Appearance",defaultValue:null},percentValue:{type:"float",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:sap.ui.core.TextDirection.Inherit}}}});P.prototype.onAfterRendering=function(){if(!!this.getHeight()){var a=this.$().height();this.$("textRight").css("line-height",a+"px");this.$("textLeft").css("line-height",a+"px");}};P.prototype.setPercentValue=function(p){var t=this;if(typeof(p)!=="number"||p<0||p>100){q.sap.log.error(this+": percentValue ("+p+") is not correct! It has to be a number between 0-100.");return this;}if(this.getPercentValue()!==p){this.setProperty("percentValue",p,true);this.$().addClass("sapMPIAnimate").attr("aria-valuenow",p).attr("aria-valuetext",this._getAriaValueText({fPercent:p}));var a=Math.abs(t.getPercentValue()-p)*20;var b=this.$("bar");b.animate({width:p+"%"},a,"linear",function(){t._setText.apply(t);t.$().removeClass("sapMPIAnimate");});}return this;};P.prototype._setText=function(){this.$().toggleClass("sapMPIValueGreaterHalf",this.getPercentValue()>50);return this;};P.prototype.setDisplayValue=function(d){this.setProperty("displayValue",d,true);var $=this.$("textLeft");var a=this.$("textRight");$.text(d);a.text(d);this.$().attr("aria-valuetext",this._getAriaValueText({sText:d}));return this;};P.prototype._getAriaValueText=function(p){p.sText=p.sText||this.getDisplayValue();p.fPercent=p.fPercent||this.getPercentValue();p.sStateText=p.sStateText||this._getStateText();var a=p.sText||p.fPercent+"%";if(p.sStateText){a+=" "+p.sStateText;}return a;};P.prototype._getStateText=function(){return V.getAdditionalText(this.getState());};return P;},true);
