/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/base/DataType','sap/ui/core/CSSColor','sap/ui/core/delegate/ItemNavigation','./Button','./Dialog','./library','./ColorPaletteRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,a,b,I,B,c,l,d,e,K,q){"use strict";var f;var g;var h=l.ButtonType;var i=a.getType("boolean");var j="sapMColorPaletteSquare";var S=5;var M=2;var k=15;var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");var m=C.extend("sap.m.ColorPalette",{metadata:{library:"sap.m",properties:{colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]}},aggregations:{_defaultColorButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_moreColorsButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}}});m.prototype.init=function(){this._oDefaultColor=null;this._bShowDefaultColorButton=false;this._bShowMoreColorsButton=false;this._oMoreColorsDialog=null;this._oItemNavigation=null;};m.prototype.exit=function(){if(this._oMoreColorsDialog){this._oMoreColorsDialog.destroy();delete this._oMoreColorsDialog;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};m.prototype.setColors=function(o){o=this.validateProperty("colors",o);if(o.length<M||o.length>k){throw new Error("Cannot set property 'colors' - array must has minimum 2 and maximum 15 elements");}return this.setProperty("colors",o);};m.prototype.ontap=function(E){var t=q(E.target),s,$;$=t.closest("."+j);if(!$.length){return;}s=$.attr("data-sap-ui-color");this._fireColorSelect(s,false,E);};m.prototype.onsaptabnext=m.prototype.onsaptabprevious=function(E){var o=this._getElementInfo(E.target);if(o.bIsMoreColorsButton){this.fireEvent("_colorNotSelected",{_originalEvent:E});return;}if(o.bIsDefaultColorButton){this._fireColorSelect(this._getDefaultColor(),true,E);return;}m.prototype.ontap.apply(this,arguments);};m.prototype.onsapspace=m.prototype.onsapenter=m.prototype.ontap;m.prototype.onsaphome=m.prototype.onsapend=function(E){var o=this._getElementInfo(E.target);if(o.bIsDefaultColorButton||o.bIsMoreColorsButton){E.preventDefault();E.stopImmediatePropagation(true);}};m.prototype.onAfterRendering=function(){this._ensureItemNavigation();};m.prototype._createDefaultColorButton=function(){return new B(this.getId()+"-btnDefaultColor",{width:"100%",type:h.Transparent,text:L.getText("COLOR_PALETTE_DEFAULT_COLOR"),visible:this._getShowDefaultColorButton(),press:function(E){this._fireColorSelect(this._getDefaultColor(),true,E);}.bind(this)});};m.prototype._getDefaultColor=function(){return this._oDefaultColor;};m.prototype._setDefaultColor=function(o){if(!b.isValid(o)){throw new Error("Cannot set internal property '_defaultColor' - invalid value: "+o);}this._oDefaultColor=o;return this;};m.prototype._getShowDefaultColorButton=function(){return this._bShowDefaultColorButton;};m.prototype._setShowDefaultColorButton=function(v){if(!i.isValid(v)){throw new Error("Cannot set internal property 'showDefaultColorButton' - invalid value: "+v);}this._bShowDefaultColorButton=v;if(v&&!this._getDefaultColorButton()){this.setAggregation("_defaultColorButton",this._createDefaultColorButton());}if(this._getDefaultColorButton()){this._getDefaultColorButton().setVisible(v);}return this;};m.prototype._getDefaultColorButton=function(){return this.getAggregation("_defaultColorButton");};m.prototype._createMoreColorsButton=function(){return new B(this.getId()+"-btnMoreColors",{width:"100%",type:h.Transparent,text:L.getText("COLOR_PALETTE_MORE_COLORS"),visible:this._getShowMoreColorsButton(),press:this._openColorPicker.bind(this)});};m.prototype._getShowMoreColorsButton=function(){return this._bShowMoreColorsButton;};m.prototype._setShowMoreColorsButton=function(v){if(!i.isValid(v)){throw new Error("Cannot set internal property 'showMoreColorsButton' - invalid value: "+v);}this._bShowMoreColorsButton=v;if(v&&!this._getMoreColorsButton()){this.setAggregation("_moreColorsButton",this._createMoreColorsButton());}if(this._getMoreColorsButton()){this._getMoreColorsButton().setVisible(v);}return this;};m.prototype._getMoreColorsButton=function(){return this.getAggregation("_moreColorsButton");};m.prototype._openColorPicker=function(){this.fireEvent("_beforeOpenColorPicker");this._ensureMoreColorsDialog().open();};m.prototype._ensureMoreColorsDialog=function(){if(!this._oMoreColorsDialog){this._oMoreColorsDialog=this._createMoreColorsDialog();}return this._oMoreColorsDialog;};m.prototype._createMoreColorsDialog=function(){var o=new c(this.getId()+"-moreColorsDialog",{contentWidth:D.system.phone?"":"29rem",stretch:!!D.system.phone,title:L.getText("COLOR_PALETTE_MORE_COLORS_TITLE")});this._ensureUnifiedLibrary();o.addContent(o._oColorPicker=new f({mode:g.HSL}));o.setBeginButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CONFIRM"),press:function(E){o.close();if(o._oColorPicker.getColorString()){this._fireColorSelect(o._oColorPicker.getColorString(),false,E);}}.bind(this)}));o.setEndButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CANCEL"),press:function(){o.close();}}));return o;};m.prototype._ensureUnifiedLibrary=function(){var u;if(!f){sap.ui.getCore().loadLibrary("sap.ui.unified");u=sap.ui.require("sap/ui/unified/library");f=sap.ui.requireSync("sap/ui/unified/ColorPicker");g=u.ColorPickerMode;}};m.prototype._focusFirstElement=function(){var F=this._getShowDefaultColorButton()?this._getDefaultColorButton().getDomRef():this._getAllSwatches()[0];F.focus();};m.prototype._fireColorSelect=function(o,p,O){this.fireColorSelect({value:o,defaultAction:p,_originalEvent:O});};m.prototype._ensureItemNavigation=function(){var o=[];if(!this._oItemNavigation){this._oItemNavigation=new n(this);this._oItemNavigation.setColumns(S);this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._onSwatchContainerBorderReached,this);}o=o.concat(this._getAllSwatches());this._oItemNavigation.setRootDomRef(this.getDomRef("swatchCont"));this._oItemNavigation.setItemDomRefs(o);};m.prototype._onSwatchContainerBorderReached=function(E){var N,s,H=["saphome","sapend"].indexOf(E.getParameter("event").type)>-1;if(E.getParameter(n.BorderReachedDirection)===n.BorderReachedDirectionForward){if(this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else if(!H&&this._getShowDefaultColorButton()){N=this._getDefaultColorButton();}else if(!H){N=this._getAllSwatches()[0];}}else{if(this._getShowDefaultColorButton()){N=this._getDefaultColorButton();}else if(!H&&this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else if(!H){s=this._getAllSwatches();N=s[this._oItemNavigation._getIndexOfTheFirstItemInLastRow()];}}if(N){N.focus();}return N;};m.prototype.onsapnext=function(E){var N,o=this._getElementInfo(E.target);if(!(o.bIsDefaultColorButton||o.bIsMoreColorsButton)){return;}E.preventDefault();E.stopImmediatePropagation(true);if(o.bIsDefaultColorButton){N=this._getAllSwatches()[0];}else{N=this._getShowDefaultColorButton()?this._getDefaultColorButton():this._getAllSwatches()[0];}N.focus();};m.prototype.onsapprevious=function(E){var N,F=this._getElementInfo(E.target),A;if(!(F.bIsDefaultColorButton||F.bIsMoreColorsButton)){return;}E.preventDefault();E.stopImmediatePropagation(true);A=this._getAllSwatches();if(F.bIsMoreColorsButton){N=E.keyCode===K.ARROW_UP?A[this._oItemNavigation._getIndexOfTheFirstItemInLastRow()]:A[A.length-1];}else{N=this._getShowMoreColorsButton()?this._getMoreColorsButton():A[this._oItemNavigation._getIndexOfTheFirstItemInLastRow()];}N.focus();};m.prototype._getAllSwatches=function(){return this.$().find("."+j).get();};m.prototype._getElementInfo=function(E){var o=this._getShowDefaultColorButton()&&e(E,this._getDefaultColorButton().getDomRef()),p=!o&&this._getShowMoreColorsButton()&&e(E,this._getMoreColorsButton().getDomRef()),r=!p&&!o&&q(E).hasClass(j);return{bIsDefaultColorButton:o,bIsMoreColorsButton:p,bIsASwatch:r};};var n=I.extend("sap.m.ItemNavigationHomeEnd",{constructor:function(){I.apply(this,arguments);this.setHomeEndColumnMode(true);this.fireEvent=function(N,E){var s;if(N===I.Events.BorderReached){s=n.BorderReachedDirectionBackward;if(["sapnext","sapend"].indexOf(E.event.type)>-1){s=n.BorderReachedDirectionForward;}E[n.BorderReachedDirection]=s;}I.prototype.fireEvent.apply(this,arguments);};}});n.BorderReachedDirection="direction";n.BorderReachedDirectionForward="BorderReachedDirectionForward";n.BorderReachedDirectionBackward="BorderReachedDirectionBackward";n.prototype.getColumns=function(){return this.iColumns;};n.prototype.onsapprevious=function(E){var o=e(this.getRootDomRef(),E.target),A=E.keyCode===K.ARROW_UP&&this.getFocusedIndex()===0;if(!o){return;}if(!A){I.prototype.onsapprevious.apply(this,arguments);return;}E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:0,event:E});};n.prototype.onsapnext=function(E){var o=e(this.getRootDomRef(),E.target),p,r,s;if(!o){return;}if(E.keyCode!==K.ARROW_DOWN){I.prototype.onsapnext.apply(this,arguments);return;}r=this.getFocusedIndex();s=this._getItemInfo(r);if(s.bIsLastItem&&s.bIsInTheLastColumn){E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:r,event:E});return;}if(s.bNextRowExists&&!s.bItemSameColumnNextRowExists){E.preventDefault();p=this.getItemDomRefs();p[p.length-1].focus();return;}I.prototype.onsapnext.apply(this,arguments);};n.prototype.onsaphome=function(E){var o=e(this.getRootDomRef(),E.target),p;if(!o){return;}p=this._getItemInfo(this.getFocusedIndex());if(!p.bIsInTheFirstColumn){I.prototype.onsaphome.apply(this,arguments);return;}E.preventDefault();if(p.bIsFirstItem){this.fireEvent(I.Events.BorderReached,{index:0,event:E});}else{this.getItemDomRefs()[0].focus();}};n.prototype.onsapend=function(E){var o=e(this.getRootDomRef(),E.target),p;if(!o){return;}p=this._getItemInfo(this.getFocusedIndex());if(!(p.bIsLastItem||p.bIsInTheLastColumn)){I.prototype.onsapend.apply(this,arguments);return;}E.preventDefault();if(p.bIsLastItem){this.fireEvent(I.Events.BorderReached,{index:this.getItemDomRefs().length-1,event:E});}else{this.getItemDomRefs()[this.getItemDomRefs().length-1].focus();}};n.prototype._getItemInfo=function(o){var p=this.getItemDomRefs().length,r=o===(p-1),s=p>this.getColumns()?this.getColumns():p,t=o%this.getColumns()===0,u=(o+1)%s===0,v=Math.floor(o/this.getColumns())+1,N,w;N=v*this.getColumns()<p;w=N&&(o+this.getColumns())<p;return{bIsFirstItem:o===0,bIsLastItem:r,bIsInTheLastColumn:u,bIsInTheFirstColumn:t,bNextRowExists:N,bItemSameColumnNextRowExists:w};};n.prototype._getIndexOfTheFirstItemInLastRow=function(){return Math.floor((this.getItemDomRefs().length-1)/this.getColumns())*this.getColumns();};m.prototype._ItemNavigation=n;m.prototype._ColorsHelper={RGB_TO_NAMED_COLORS_MAP:{"#FFB200":"gold","#FF8C00":"darkorange","#CD5C5C":"indianred","#8B008B":"darkmagenta","#6495ED":"cornflowerblue","#00BFFF":"deepskyblue","#008B8B":"darkcyan","#6B8E23":"olivedrab","#2F4F4F":"darkslategray","#F0FFFF":"azure","#FFFFFF":"white","#D3D3D3":"lightgray","#A9A9A9":"darkgray","#696969":"dimgray","#000000":"black"},NAME_COLORS_TO_RGB_MAP:{"gold":"#FFB200","darkorange":"#FF8C00","indianred":"#CD5C5C","darkmagenta":"#8B008B","cornflowerblue":"#6495ED","deepskyblue":"#00BFFF","darkcyan":"#008B8B","olivedrab":"#6B8E23","darkslategray":"#2F4F4F","azure":"#F0FFFF","white":"#FFFFFF","lightgray":"#D3D3D3","darkgray":"#A9A9A9","dimgray":"#696969","black":"#000000"},getNamedColor:function(s){var H="";if(!s||s.toLowerCase().indexOf("hsl")!==-1){return undefined;}if(s.indexOf("#")===-1){return this.NAME_COLORS_TO_RGB_MAP[s.toLowerCase()]?s.toLowerCase():undefined;}if(s.length===4){H=["#",s[1],s[1],s[2],s[2],s[3],s[3]].join("");}else{H=s;}H=H.toUpperCase();return this.RGB_TO_NAMED_COLORS_MAP[H];}};return m;});
