/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./library','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/core/LabelEnablement',"./ComboBoxTextFieldRenderer"],function(I,l,a,c,D,L,C){"use strict";var b=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_buttonLabelText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}}}});b.prototype.init=function(){I.prototype.init.apply(this,arguments);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.addEndIcon({id:this.getId()+"-arrow",src:"sap-icon://slim-arrow-down",noTabStop:true,alt:r.getText("COMBOBOX_BUTTON"),decorative:false});i.addAriaLabelledBy("");};b.prototype.getIcon=function(){return this.getAggregation("_endIcon")[0];};b.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);var r=L.getReferencingLabels(this)||[];r.forEach(function(s){if(this.getIcon().getAriaLabelledBy().indexOf(s)===-1){this.getIcon().addAssociation("ariaLabelledBy",s,true);}},this);};b.prototype.setShowButton=function(s){this.getIcon().setVisible(s);return this.setProperty("showButton",s,true);};b.prototype.getOpenArea=function(){return this.getIcon().getDomRef();};b.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}e.setMarked();var v=this.getValue(),V=v.length;this.setValue(v);this.selectText(V,V);};b.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};b.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};b.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_COMBO");return i;};return b;});
