/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/Icon','sap/ui/model/Filter','./FacetFilterRenderer',"sap/ui/events/KeyCodes","sap/base/assert","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/Selectors"],function(N,l,C,I,a,b,D,M,c,F,d,K,e,L,E,q){"use strict";var T=l.ToolbarDesign;var f=l.ListType;var g=l.ListMode;var h=l.FacetFilterListDataType;var B=l.ButtonType;var P=l.PlacementType;var m=l.FacetFilterType;var n=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:m.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});n.SCROLL_STEP=264;n.prototype.setType=function(t){var s=this.getAggregation("summaryBar");if(D.system.phone){this.setProperty("type",m.Light);s.setActive(true);}else{this.setProperty("type",t);s.setActive(t===m.Light);}if(t===m.Light){if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}}return this;};n.prototype.setShowReset=function(v){this.setProperty("showReset",v);var s=this.getAggregation("summaryBar");if(v){if(this.getShowSummaryBar()||this.getType()===m.Light){this._addResetToSummary(s);}}else{if(this.getShowSummaryBar()||this.getType()===m.Light){this._removeResetFromSummary(s);}}return this;};n.prototype.setShowSummaryBar=function(v){this.setProperty("showSummaryBar",v);if(v){var s=this.getAggregation("summaryBar");if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}s.setActive(this.getType()===m.Light);}return this;};n.prototype.setLiveSearch=function(v){this.setProperty("liveSearch",v);if(this._displayedList){var o=this._displayedList;var s=sap.ui.getCore().byId(o.getAssociation("search"));s.detachLiveChange(o._handleSearchEvent,o);if(v){s.attachLiveChange(o._handleSearchEvent,o);}}return this;};n.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}return i;};n.prototype.removeList=function(o){var i=M.prototype.removeAggregation.call(this,"lists",o);this._removeList(i);return i;};n.prototype.removeAggregation=function(){var o=M.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(o);}return o;};n.prototype.openFilterDialog=function(){var o=this._getFacetDialog();var i=this._getFacetDialogNavContainer();o.addContent(i);this.getLists().forEach(function(j){if(j.getMode()===g.MultiSelect){j._preserveOriginalActiveState();}});o.setInitialFocus(i.getPages()[0].getContent()[0].getItems()[0]);o.open();return this;};n.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this._getSummaryBar();this.setAggregation("resetButton",this._createResetButton());if(E.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(m.Light);}};n.prototype.exit=function(){var o;sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(i){o=sap.ui.getCore().byId(i);if(o){o.destroy();}});this._aOwnedLabels=null;}};n.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===m.Light){var s=this.getAggregation("summaryBar");var t=s.getContent()[0];t.setText(this._getSummaryText());t.setTooltip(this._getSummaryText());}sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);};n.prototype.onAfterRendering=function(){if(this.getType()!==m.Light&&!D.system.phone){sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);}if(this.getType()!==m.Light){this._startItemNavigation();}};n.prototype._startItemNavigation=function(){var o=this.getDomRef(),r=o.getElementsByClassName("sapMFFHead"),j=[];if(r.length>0){for(var i=0;i<r[0].childNodes.length;i++){if(r[0].childNodes[i].id.indexOf("ff")<0&&r[0].childNodes[i].id.indexOf("icon")<0&&r[0].childNodes[i].id.indexOf("add")<0){j.push(r[0].childNodes[i]);}if(r[0].childNodes[i].id.indexOf("add")>=0){j.push(r[0].childNodes[i]);}}}if(j!=""){this._aDomRefs=j;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new a();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=r;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(o);this.oItemNavigation.setItemDomRefs(j);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};n.prototype.onsapdelete=function(o){var i,j;if(this.getType()===m.Light){return;}if(!this.getShowPersonalization()){return;}i=sap.ui.getCore().byId(o.target.id);if(!i){return;}j=sap.ui.getCore().byId(i.getAssociation("list"));if(!j){return;}if(!j.getShowRemoveFacetIcon()){return;}j.removeSelections(true);j.setSelectedKeys();j.setProperty("active",false,true);this.invalidate();var t=this.$().find(":sapTabbable");q(t[t.length-1]).focus();var p=this.oItemNavigation.getFocusedIndex();q(o.target).blur();this.oItemNavigation.setFocusedIndex(p+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if(t[k].id.indexOf("add")>=0){q(t[k]).focus();}}}};n.prototype.onsaptabnext=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;if(o.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).focus();o.preventDefault();o.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};n.prototype.onsaptabprevious=function(o){if(this.getType()===m.Light){return;}if(o.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).focus();o.preventDefault();o.setMarked();return;}if(o.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=o.target.id){q(this._previousTarget).focus();o.preventDefault();o.setMarked();return;}if(o.target.id.indexOf("add")>=0||o.target.parentNode.className=="sapMFFHead"){this._previousTarget=o.target;q(this.$().find(":sapTabbable")[0]).focus();}};n.prototype.onsapend=function(o){if(this.getType()===m.Light){return;}if(this._addTarget!=null){q(this._addTarget).focus();o.preventDefault();o.setMarked();}else{q(this._aRows[this._aRows.length-1]).focus();o.preventDefault();o.setMarked();}this._previousTarget=o.target;};n.prototype.onsaphome=function(o){if(this.getType()===m.Light){return;}q(this._aRows[0]).focus();o.preventDefault();o.setMarked();this._previousTarget=o.target;};n.prototype.onsappageup=function(o){this._previousTarget=o.target;};n.prototype.onsappagedown=function(o){this._previousTarget=o.target;};n.prototype.onsapincreasemodifiers=function(o){if(this.getType()===m.Light){return;}if(o.which==K.ARROW_RIGHT){this._previousTarget=o.target;var i=this.oItemNavigation.getFocusedIndex()-1;var j=i+this._pageSize;q(o.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();}};n.prototype.onsapdecreasemodifiers=function(o){if(this.getType()===m.Light){return;}var i=0;if(o.which==K.ARROW_LEFT){this._previousTarget=o.target;i=this.oItemNavigation.getFocusedIndex()+1;var j=i-this._pageSize;q(o.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();}};n.prototype.onsapdownmodifiers=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;var i=0;i=this.oItemNavigation.getFocusedIndex()-1;var j=i+this._pageSize;q(o.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};n.prototype.onsapupmodifiers=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;var i=0;i=this.oItemNavigation.getFocusedIndex();if(i!=0){i=i+1;}var j=i-this._pageSize;q(o.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};n.prototype.onsapexpand=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;var i=this.oItemNavigation.getFocusedIndex()+1;q(o.target).blur();this.oItemNavigation.setFocusedIndex(i);this.focus();};n.prototype.onsapcollapse=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;var i=this.oItemNavigation.getFocusedIndex()-1;q(o.target).blur();this.oItemNavigation.setFocusedIndex(i);this.focus();};n.prototype.onsapdown=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;if(o.target.parentNode.className=="sapMFFResetDiv"){q(o.target).focus();o.preventDefault();o.setMarked();return;}};n.prototype.onsapup=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;if(o.target.parentNode.className=="sapMFFResetDiv"){q(o.target).focus();o.preventDefault();o.setMarked();}};n.prototype.onsapleft=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;if(o.target.parentNode.className=="sapMFFResetDiv"){q(o.target).focus();o.preventDefault();o.setMarked();}};n.prototype.onsapright=function(o){if(this.getType()===m.Light){return;}this._previousTarget=o.target;if(o.target.parentNode.className=="sapMFFResetDiv"){q(o.target).focus();o.preventDefault();o.setMarked();}};n.prototype.onsapescape=function(o){if(this.getType()===m.Light){return;}if(o.target.parentNode.className=="sapMFFResetDiv"){return;}var i=this._lastCategoryFocusIndex;q(o.target).blur();this.oItemNavigation.setFocusedIndex(i);this.focus();};n.prototype._getPopover=function(){var p=this.getAggregation("popover");if(!p){var t=this;p=new sap.m.Popover({placement:P.Bottom,beforeOpen:function(o){if(t._displayedList){t._displayedList._setSearchValue("");}this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList));}i(t._displayedList);},afterClose:function(o){t._addDelegateFlag=true;t._handlePopoverAfterClose();},horizontalScrolling:false});this.setAggregation("popover",p,true);p.setContentWidth("30%");p.addStyleClass("sapMFFPop");var i=function(o){if(!o){return;}var j=t._getFacetRemoveIcon(o);if(j){j._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(p);}else{p.destroyAggregation("footer");}return p;};n.prototype._handlePopoverAfterClose=function(){var p=this.getAggregation("popover"),o=this._displayedList;if(!p){return;}var i=this._getFacetRemoveIcon(o);if(i&&i._bTouchStarted){return;}this._restoreListFromDisplayContainer(p);this._displayRemoveIcon(false,o);o._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){setTimeout(function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;}.bind(this),0);}};n.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};n.prototype._openPopover=function(p,o){if(!p.isOpen()){var i=sap.ui.getCore().byId(o.getAssociation("list"));e(i,"The facet filter button should be associated with a list.");i.fireListOpen({});this._moveListToDisplayContainer(i,p);p.openBy(o);if(i.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,i);}if(i.getWordWrap()){p.setContentWidth("30%");}i._applySearch();}return this;};n.prototype._getAddFacetButton=function(){var o=this.getAggregation("addFacetButton");if(!o){var t=this;var o=new sap.m.Button(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:B.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(i){t.openFilterDialog();}});this.setAggregation("addFacetButton",o,true);}return o;};n.prototype._getButtonForList=function(o){if(this._buttons[o.getId()]){this._setButtonText(o);return this._buttons[o.getId()];}var t=this;var i=new sap.m.Button({type:B.Transparent,press:function(j){var k=this;var O=function(){var p=t._getPopover();t._openPopover(p,k);};if(o.getMode()===g.MultiSelect){o._preserveOriginalActiveState();}var p=t._getPopover();if(p.isOpen()){setTimeout(function(){if(p.isOpen()){return;}t._oOpenPopoverDeferred=q.Deferred();t._oOpenPopoverDeferred.promise().done(O);},100);}else{setTimeout(O.bind(this),100);}}});this._buttons[o.getId()]=i;this.addAggregation("buttons",i);i.setAssociation("list",o.getId(),true);this._setButtonText(o);return i;};n.prototype._setButtonText=function(o){var i=this._buttons[o.getId()];if(o._iAllItemsCount===undefined&&o.getMaxItemsCount()){o._iAllItemsCount=o.getMaxItemsCount();}if(i){var t="";var s=Object.getOwnPropertyNames(o._oSelectedKeys);var j=s.length;if(j===1){var S=o._oSelectedKeys[s[0]];t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[o.getTitle(),S]);}else if(j>0&&j===(o._iAllItemsCount?o._iAllItemsCount:0)){t=this._bundle.getText("FACETFILTER_ALL_SELECTED",[o.getTitle()]);}else if(j>0){t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[o.getTitle(),j]);}else{t=o.getTitle();}i.setText(t);}};n.prototype._getFacetRemoveIcon=function(o){var t=this,i=this._removeFacetIcons[o.getId()];if(!i){i=new c({src:I.getIconURI("sys-cancel"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){i._bPressed=true;}});i.addDelegate({ontouchstart:function(){i._bTouchStarted=true;i._bPressed=false;},ontouchend:function(){t._displayRemoveIcon(false,o);i._bTouchStarted=false;setTimeout(p.bind(this),100);}},true);var p=function(){if(i._bPressed){o.removeSelections(true);o.setSelectedKeys();o.setProperty("active",false,true);}t._handlePopoverAfterClose();};i.setAssociation("list",o.getId(),true);i.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[o.getId()]=i;this.addAggregation("removeFacetIcons",i);this._displayRemoveIcon(false,o);}return i;};n.prototype._displayRemoveIcon=function(i,o){if(this.getShowPersonalization()){var j=this._removeFacetIcons[o.getId()];if(i){j.removeStyleClass("sapMFFLHiddenRemoveIcon");j.addStyleClass("sapMFFLVisibleRemoveIcon");}else{j.removeStyleClass("sapMFFLVisibleRemoveIcon");j.addStyleClass("sapMFFLHiddenRemoveIcon");}}};n.prototype._getFacetDialogNavContainer=function(){var o=new N({autoFocus:false});var i=this._createFacetPage();o.addPage(i);o.setInitialPage(i);var t=this;o.attachAfterNavigate(function(j){var k=j.getParameters()["to"];var p=j.getParameters()['from'];if(p===i){var r=(t._displayedList.getMode()===g.MultiSelect)?k.getContent(0)[1].getItems()[0]:k.getContent(0)[0].getItems()[0];if(r){r.focus();}}if(k===i){p.destroySubHeader();e(t._displayedList===null,"Filter items list should have been placed back in the FacetFilter aggregation before page content is destroyed.");p.destroyContent();t._selectedFacetItem.invalidate();k.invalidate();t._selectedFacetItem.focus();t._selectedFacetItem=null;}});return o;};n.prototype._createFacetPage=function(){var o=this._createFacetList();var i=new sap.m.SearchField({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(j){var k=o.getBinding("items");if(k){var r=new F("text",sap.ui.model.FilterOperator.Contains,j.getParameters()["newValue"]);k.filter([r]);}}});var p=new sap.m.Page({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new sap.m.Bar({contentMiddle:i}),content:[o]});return p;};n.prototype._createFilterItemsPage=function(){var t=this;var p=new sap.m.Page({showNavButton:true,enableScrolling:true,navButtonPress:function(o){var i=o.getSource().getParent();t._navFromFilterItemsPage(i);}});return p;};n.prototype._getFilterItemsPage=function(o){var O=o.getPages()[1];if(O){o.removePage(O);O.destroy();}var p=this._createFilterItemsPage();o.addPage(p);return p;};n.prototype._createFilterItemsSearchFieldBar=function(o){var t=this;var s=true;if(o.getDataType()!=h.String){s=false;}var S=new sap.m.SearchField({value:o._getSearchValue(),width:"100%",enabled:s,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(j){t._displayedList._handleSearchEvent(j);}});if(this.getLiveSearch()){S.attachLiveChange(o._handleSearchEvent,o);}var i=new sap.m.Bar({contentMiddle:S});o.setAssociation("search",S);return i;};n.prototype._getFacetDialog=function(){var o=this.getAggregation("dialog");if(!o){var t=this;o=new sap.m.Dialog({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){t._addDelegateFlag=true;t._invalidateFlag=true;var i=this.getContent()[0];var j=i.getPages()[1];if(i.getCurrentPage()===j){var k=t._restoreListFromDisplayContainer(j);if(k.getMode()===g.MultiSelect){k._updateActiveState();}k._fireListCloseEvent();k._search("");}this.destroyAggregation("content",true);t.invalidate();},beginButton:new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){t._closeDialog();}}),contentHeight:"500px"});o.addStyleClass("sapMFFDialog");o.onsapentermodifiers=function(i){if(i.shiftKey&&!i.ctrlKey&&!i.altKey){var j=this.getContent()[0];t._navFromFilterItemsPage(j);}};this.setAggregation("dialog",o,true);}return o;};n.prototype._closeDialog=function(){var o=this.getAggregation("dialog");if(o&&o.isOpen()){o.close();this._fireConfirmEvent();}};n.prototype._closePopover=function(){var p=this.getAggregation("popover");if(p&&p.isOpen()){p.close();}};n.prototype._createFacetList=function(){var o=this._oFacetList=new sap.m.List({mode:g.None,items:{path:"/items",template:new sap.m.StandardListItem({title:"{text}",counter:"{count}",type:f.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var j=this._getMapFacetLists();var k=new sap.ui.model.json.JSONModel({items:j});if(j.length>100){k.setSizeLimit(j.length);}var t=this;o.attachUpdateFinished(function(){for(var i=0;i<o.getItems().length;i++){var p=this.getItems()[i];p.detachPress(t._handleFacetListItemPress,t);p.attachPress(t._handleFacetListItemPress,t);}});o.setModel(k);return o;};n.prototype.refreshFacetList=function(){this._oFacetList.getModel().setData({items:this._getMapFacetLists()});return this;};n.prototype._getMapFacetLists=function(){return this.getLists().map(function(o,i){return{text:o.getTitle(),count:o.getAllCount(),index:i};});};n.prototype._createSelectAllCheckboxBar=function(o){if(!o.getMultiSelect()){return null;}var s=o.getActive()&&o.getItems().length>0&&Object.getOwnPropertyNames(o._oSelectedKeys).length===o.getItems().length;var i=new sap.m.CheckBox(o.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:s,select:function(k){i.setSelected(k.getParameter("selected"));o._handleSelectAllClick(k.getParameter("selected"));}});o.setAssociation("allcheckbox",i);var j=new sap.m.Bar();j.addEventDelegate({ontap:function(k){if(k.srcControl===this){o._handleSelectAllClick(i.getSelected());}}},j);j.addContentLeft(i);j.addStyleClass("sapMFFCheckbar");return j;};n.prototype._handleFacetListItemPress=function(o){this._navToFilterItemsPage(o.getSource());};n.prototype._navToFilterItemsPage=function(o){this._selectedFacetItem=o;var i=this.getAggregation("dialog").getContent()[0];var j=o.getCustomData();e(j.length===1,"There should be exactly one custom data for the original facet list item index");var k=j[0].getValue();var p=this.getLists()[k];this._listIndexAgg=this.indexOfAggregation("lists",p);if(this._listIndexAgg==k){var r=this._getFilterItemsPage(i);p.fireListOpen({});this._moveListToDisplayContainer(p,r);r.setSubHeader(this._createFilterItemsSearchFieldBar(p));var s=this._createSelectAllCheckboxBar(p);if(s){r.insertContent(s,0);}r.setTitle(p.getTitle());i.to(r);}};n.prototype._navFromFilterItemsPage=function(o){var i=o.getPages()[1];var j=this._restoreListFromDisplayContainer(i);if(j.getMode()===g.MultiSelect){j._updateActiveState();}j._fireListCloseEvent();j._search("");this._selectedFacetItem.setCounter(j.getAllCount());o.backToTop();};n.prototype._moveListToDisplayContainer=function(o,i){this._listAggrIndex=this.indexOfAggregation("lists",o);e(this._listAggrIndex>-1,"The lists index should be valid.");M.prototype.removeAggregation.call(this,"lists",o,true);i.addAggregation("content",o,false);o.setAssociation("facetFilter",this,true);this._displayedList=o;};n.prototype._restoreListFromDisplayContainer=function(o){var i=o.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",i,this._listAggrIndex,i.getActive());this._listAggrIndex=-1;this._displayedList=null;return i;};n.prototype._getSequencedLists=function(){var k=-1;var s=[];var o=this.getLists();if(o.length>0){for(var i=0;i<o.length;i++){if(o[i].getActive()){if(o[i].getSequence()<-1){o[i].setSequence(-1);}else if(o[i].getSequence()>k){k=o[i].getSequence();}s.push(o[i]);}else if(!o[i].getRetainListSequence()){o[i].setSequence(-1);}}for(var j=0;j<s.length;j++){if(s[j].getSequence()<=-1){k+=1;s[j].setSequence(k);}}if(s.length>1){s.sort(function(p,r){return p.getSequence()-r.getSequence();});}}return s;};n.prototype._getSummaryBar=function(){var s=this.getAggregation("summaryBar");if(!s){var t=new sap.m.Text({maxLines:1});var i=this;s=new sap.m.Toolbar({content:[t],active:this.getType()===m.Light?true:false,design:T.Info,press:function(o){i.openFilterDialog();}});s._setRootAccessibilityRole("button");this.setAggregation("summaryBar",s);}return s;};n.prototype._createResetButton=function(){var t=this;var o=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(j){t._addDelegateFlag=true;t._invalidateFlag=true;t.fireReset();var k=t.getLists();for(var i=0;i<k.length;i++){k[i]._searchValue="";k[i]._applySearch();var p=k[i].getItems()[0];if(p){p.focus();}}t.invalidate();}});return o;};n.prototype._addOKButtonToPopover=function(p){var o=p.getFooter();if(!o){var t=this;var o=new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),width:"100%",press:function(){t._closePopover();}});p.setFooter(o);}return o;};n.prototype._getSummaryText=function(){var k=", ";var S=" ";var s="";var o=true;var p=this.getLists();if(p.length>0){for(var i=0;i<p.length;i++){var r=p[i];if(r.getActive()){var t=this._getSelectedItemsText(r);var u="";for(var j=0;j<t.length;j++){u=u+t[j]+k;}if(u){u=u.substring(0,u.lastIndexOf(k)).trim();if(o){s=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[r.getTitle(),u]);o=false;}else{s=s+S+this._bundle.getText("FACETFILTER_INFOBAR_AND")+S+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[r.getTitle(),u]);}}}}}if(!s){s=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return s;};n.prototype._getSelectedItemsText=function(o){var t=o.getSelectedItems().map(function(v){return v.getText();});o._oSelectedKeys&&Object.getOwnPropertyNames(o._oSelectedKeys).forEach(function(v){t.indexOf(o._oSelectedKeys[v])===-1&&t.push(o._oSelectedKeys[v]);});return t;};n.prototype._addResetToSummary=function(s){if(s.getContent().length===1){s.addContent(new sap.m.ToolbarSpacer({width:""}));var o=this._createResetButton();s.addContent(o);o.addStyleClass("sapUiSizeCompact");o.addStyleClass("sapMFFRefresh");o.addStyleClass("sapMFFBtnHoverable");}};n.prototype._removeResetFromSummary=function(s){if(s.getContent().length===3){var S=s.removeAggregation("content",1);S.destroy();var o=s.removeAggregation("content",1);o.destroy();}};n.prototype._removeList=function(o){if(o){var i=this._buttons[o.getId()];if(i){this.removeAggregation("buttons",i);i.destroy();}var r=this._removeFacetIcons[o.getId()];if(r){this.removeAggregation("removeIcons",r);r.destroy();}delete this._buttons[o.getId()];delete this._removeFacetIcons[o.getId()];}};n.prototype._getScrollingArrow=function(s){var A=null;var p={src:"sap-icon://navigation-"+s+"-arrow"};if(s==="left"){A=this.getAggregation("arrowLeft");if(!A){p.id=this.getId()+"-arrowScrollLeft";A=I.createControlByURI(p);var j=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<j.length;i++){A.addStyleClass(j[i]);A.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",A);}}else if(s==="right"){A=this.getAggregation("arrowRight");if(!A){p.id=this.getId()+"-arrowScrollRight";A=I.createControlByURI(p);var k=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<k.length;i++){A.addStyleClass(k[i]);A.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",A);}}else{L.error("Scrolling arrow name "+s+" is not valid");}return A;};n.prototype._checkOverflow=function(){var o=this.getDomRef("head"),$=q(o),i=this.$(),s=false,S=false,j=false,k=null,p=null,r=null;if(o){k=o.scrollLeft;p=o.scrollWidth;r=o.clientWidth;if(p>r){if(p-r==1){p=r;}else{j=true;}}i.toggleClass("sapMFFScrolling",j);i.toggleClass("sapMFFNoScrolling",!j);this._lastScrolling=j;if(!this._bRtl){s=k>0;S=(p>r)&&(p>k+r);}else{S=$.scrollLeftRTL()>0;s=$.scrollRightRTL()>0;}if((S!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){i.toggleClass("sapMFFNoScrollBack",!s);i.toggleClass("sapMFFNoScrollForward",!S);}}};n.prototype.onclick=function(o){var t=o.target.id;if(t){var i=this.getId(),j=o.target;o.preventDefault();if(t==i+"-arrowScrollLeft"){j.tabIndex=-1;j.focus();this._scroll(-n.SCROLL_STEP,500);}else if(t==i+"-arrowScrollRight"){j.tabIndex=-1;j.focus();this._scroll(n.SCROLL_STEP,500);}}};n.prototype._scroll=function(i,j){var o=this.getDomRef("head");var s=o.scrollLeft;if(!D.browser.internet_explorer&&this._bRtl){i=-i;}var S=s+i;q(o).stop(true,true).animate({scrollLeft:S},j);};n.prototype._enableTouchSupport=function(){var t=this;var i=function(o){var s=t.getType();if(s===m.Light){return;}o.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("head").scrollLeft;t.startTouchX=o.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var j=function(o){var s=t.getType();if(s===m.Light){return;}var p=o.touches[0].pageX-t.startTouchX;var r=t.getDomRef("head");var u=r.scrollLeft;var v=t.startScrollX-p;r.scrollLeft=v;t._bTouchNotMoved=false;var w=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(w>0){t._velocity=(v-u)/w;}o.preventDefault();};var k=function(o){var s=t.getType();if(s===m.Light){return;}if(t._bTouchNotMoved===false){o.preventDefault();var p=t.getDomRef("head");var r=50;var u=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var v=t._velocity*r;p.scrollLeft=p.scrollLeft+v;if(Math.abs(t._velocity)<u){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},r);}else if(t._bTouchNotMoved===true){t.onclick(o);o.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};return n;});
