/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Input','./Tokenizer','./Token','./ToggleButton','./List','./Popover','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','sap/ui/core/ResizeHandler','./MultiComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,C,a,b,T,c,d,L,P,l,E,e,f,D,g,R,M,h,K,j,k,m,q){"use strict";var n=l.ListType;var o=l.ListMode;var V=f.ValueState;var O=f.OpenState;var p=l.PlacementType;var r=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}}}});e.insertFontFaceStyle();E.apply(r.prototype,[true]);r.prototype.onsapend=function(i){sap.m.Tokenizer.prototype.onsapend.apply(this._oTokenizer,arguments);};r.prototype.onsaphome=function(i){sap.m.Tokenizer.prototype.onsaphome.apply(this._oTokenizer,arguments);};r.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();var s=this.getSelectableItems();var t=s[0];if(t&&this.isOpen()){this.getListItem(t).focus();return;}if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};r.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();if(this._oTokenizer.getSelectedTokens().length){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};r.prototype.onsapshow=function(i){var s=this.getList(),t=this.getPicker(),S=this.getSelectableItems(),u=this.getSelectedItems(),v,w=s.getItemNavigation(),x,y;y=q(document.activeElement).control()[0];if(y instanceof sap.m.Token){v=this._getItemByToken(y);}else{v=u.length?this._getItemByListItem(this.getList().getSelectedItems()[0]):S[0];}x=this.getItems().indexOf(v);if(w){w.setSelectedIndex(x);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=x;}t.setInitialFocus(s);a.prototype.onsapshow.apply(this,arguments);};r.prototype.onsaphide=r.prototype.onsapshow;r.prototype._selectItemByKey=function(s){var v,t,u,i,w,x=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(s){s.setMarked();}v=this._getUnselectedItems(x?"":this.getValue());for(i=0;i<v.length;i++){if(v[i].getText().toUpperCase()===this.getValue().toUpperCase()){u=v[i];w=true;break;}}if(w){t={item:u,id:u.getId(),key:u.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||(typeof this.getValue()==="string"&&u.getText().toLowerCase().startsWith(this.getValue().toLowerCase()))){if(this.getListItem(u).isSelected()){this.setValue('');}else{this.setSelection(t);}}}else{this._bPreventValueRemove=true;this._showWrongValueVisualEffect();}if(s){this.close();}};r.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var w=this.getDomRef().offsetWidth,A=parseInt(this.getDomRef("arrow").offsetWidth,10),i=parseInt(this.$().find(".sapMInputBaseInner").css("min-width"),10)||0,s=parseInt(this.$().find(".sapMInputBaseInner").css("padding-right"),10)||0;return w-(A+i+s)+"px";}else{return null;}};r.prototype.onsapenter=function(i){I.prototype.onsapenter.apply(this,arguments);if(this.getValue()){this._selectItemByKey(i);}};r.prototype.onsaptabnext=function(i){var s=this.getValue();if(s){var S=this._getUnselectedItemsStartingText(s);if(S.length===1){this._selectItemByKey(i);}else{this._showWrongValueVisualEffect();}}};r.prototype.onsapfocusleave=function(i){var s=this.getAggregation("picker"),t=this.isPlatformTablet(),u=sap.ui.getCore().byId(i.relatedControlId),F=u&&u.getFocusDomRef(),v=this.getValue();if(!s||!s.getFocusDomRef()||!F||!q.contains(s.getFocusDomRef(),F)){this.setValue(null);if(v){this.fireChangeEvent("",{value:v});}if(!(u instanceof c||i.srcControl instanceof c)){this._oTokenizer.scrollToEnd();}if(!q.contains(this.getDomRef(),document.activeElement)){this._oTokenizer._useCollapsedMode(true);}}if(s&&F){if(j(s.getFocusDomRef(),F)&&!t&&!this.isPickerDialog()){this.focus();}}};r.prototype.onfocusin=function(i){var s=this.getPicker();var t=false;var u=s.getFocusDomRef();var v=s.oPopup.getOpenState()===O.CLOSING;var w=this.getPickerType()==="Dropdown";if(w){t=u&&q.contains(u,i.relatedTarget);}if(this.getEditable()){this._oTokenizer._useCollapsedMode(false);this._oTokenizer.scrollToEnd();}if(i.target===this.getFocusDomRef()){this.getEditable()&&this.addStyleClass("sapMFocus");!v&&t&&this._handleInputValidation(i,false);}if(i.target===this.getOpenArea()&&w&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};r.prototype._handleItemTap=function(i){var t=q(i.target).control(0);if(!t.isA("sap.m.CheckBox")){this._bCheckBoxClicked=false;if(this.isOpen()&&!this._isListInSuggestMode()){this.close();}}};r.prototype._handleItemPress=function(i){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var s=this._getLastSelectedItem();if(s){this.getListItem(s).focus();}}};r.prototype._handleSelectionLiveChange=function(i){var s=i.getParameter("listItem");var t=i.getParameter("selected");var N=this._getItemByListItem(s);var u=this.isPickerDialog()?this.getPickerTextField():this;if(s.getType()==="Inactive"){return;}k(N,"The corresponding mapped item was not found on "+this);if(!N){return;}var v={item:N,id:N.getId(),key:N.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(t){this.fireChangeEvent(N.getText());this.setSelection(v);}else{this.fireChangeEvent(N.getText());this.removeSelection(v);}if(this._bCheckBoxClicked){u.setValue(this._sOldInput);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){s.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};r.prototype.onkeydown=function(i){a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bIsPasteEvent=(i.ctrlKey||i.metaKey)&&(i.which===K.V);if(this.getValue().length===0&&(i.ctrlKey||i.metaKey)&&(i.which===K.A)&&this._hasTokens()){this._oTokenizer.focus();this._oTokenizer.selectAllTokens(true);i.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}this._bDoTypeAhead=(i.which!==K.BACKSPACE)&&(i.which!==K.DELETE);};r.prototype.oninput=function(i){a.prototype.oninput.apply(this,arguments);var s=i.srcControl;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bIsPasteEvent){s.updateDomValue(this._sOldValue||"");return;}if(!this._bCompositionStart&&!this._bCompositionEnd){this._handleInputValidation(i,false);}if(this.isOpen()){setTimeout(this._highlightList.bind(this,this._sOldInput));}};r.prototype.filterItems=function(i){var F=this.fnFilter?this.fnFilter:a.DEFAULT_TEXT_FILTER;var s=[];i.items.forEach(function(t){var u=!!F(i.value,t,"getText");if(i.value===""){u=true;if(!this.bOpenedByKeyboardOrButton){return;}}var v=this.getListItem(t);if(v){v.setVisible(u);u&&s.push(t);}},this);return s;};r.prototype.onkeyup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};r.prototype._showWrongValueVisualEffect=function(){var s=this.getValueState();if(s===V.Error){return;}if(this.isPickerDialog()){this.getPickerTextField().setValueState(V.Error);setTimeout(this.getPickerTextField()["setValueState"].bind(this.getPickerTextField(),s),1000);}else{this.setValueState(V.Error);setTimeout(this["setValueState"].bind(this,s),1000);}};r.prototype._getReadOnlyPopover=function(){if(!this._oReadOnlyPopover){this._oReadOnlyPopover=this._createReadOnlyPopover();}return this._oReadOnlyPopover;};r.prototype._createReadOnlyPopover=function(){return new P({showArrow:true,placement:p.Auto,showHeader:false,contentMinWidth:"auto"}).addStyleClass("sapMMultiComboBoxReadOnlyPopover");};r.prototype.createPicker=function(s){var i=this.getAggregation("picker");if(i){return i;}i=this["create"+s]();this.setAggregation("picker",i,true);var t=this.getRenderer(),u=t.CSS_CLASS_MULTICOMBOBOX;i.setHorizontalScrolling(false).addStyleClass(t.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(u+"Picker").addStyleClass(u+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.getList());return i;};r.prototype.createPickerTextField=function(){var t=this;return new b({submit:function(i){var v=this.getValue();if(v){t.setValue(v);t._selectItemByKey();this.setValue(t._sOldInput);}}}).addEventDelegate({onfocusout:this._handleInputFocusOut},this);};r.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var i=this.getItems();var s=this.getList();if(s){this._synchronizeSelectedItemAndKey(i);s.destroyItems();this._clearTokenizer();this._fillList(i);if(s.getItemNavigation()){this._iFocusedIndex=s.getItemNavigation().getFocusedIndex();}this.setEditable(this.getEditable());}this._deregisterResizeHandler();};r.prototype._registerResizeHandler=function(){k(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};r.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};r.prototype._onResize=function(){this._oTokenizer.setMaxWidth(this._calculateSpaceForTokenizer());};r.prototype.onBeforeRenderingPicker=function(){var i=this["_onBeforeRendering"+this.getPickerType()];if(i){i.call(this);}};r.prototype.onAfterRenderingPicker=function(){var i=this["_onAfterRendering"+this.getPickerType()];if(i){i.call(this);}};r.prototype.onBeforeOpen=function(){var i=this["_onBeforeOpen"+this.getPickerType()];this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();if(i){i.call(this);}};r.prototype.onAfterOpen=function(){var i=this.getFocusDomRef();i&&i.setAttribute("aria-expanded","true");if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}this.closeValueStateMessage();};r.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};r.prototype.onAfterClose=function(){var u=!q.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),i=this.getFocusDomRef();i&&i.setAttribute("aria-expanded","false");this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.clearFilter();!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this._getFilterSelectedButton()&&this._getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this._oTokenizer._useCollapsedMode(u);};r.prototype._onBeforeOpenDialog=function(){};r.prototype._onBeforeOpenDropdown=function(){var i=this.getPicker(),s=this.getDomRef(),w;if(s&&i){w=(s.offsetWidth/parseFloat(l.BaseFontSize))+"rem";i.setContentMinWidth(w);}};r.prototype._decoratePopover=function(i){var t=this;i.open=function(){return this.openBy(t.getDomRef("content"));};};r.prototype.createDropdown=function(){var i=new P(this.getDropdownSettings());i.setInitialFocus(this);this._decoratePopover(i);return i;};r.prototype.createDialog=function(){var i=a.prototype.createDialog.apply(this,arguments),s=this._createFilterSelectedButton();i.getSubHeader().addContent(s);return i;};r.prototype._createFilterSelectedButton=function(){var i=e.getIconURI("multiselect-all"),s=this.getRenderer(),t=this;return new d({icon:i,press:t._filterSelectedItems.bind(this)}).addStyleClass(s.CSS_CLASS_MULTICOMBOBOX+"ToggleButton");};r.prototype._getFilterSelectedButton=function(){return this.getPicker().getSubHeader().getContent()[1];};r.prototype._filterSelectedItems=function(i,F){var s=i.oSource,t,u,v=this.getPickerTextField()?this.getPickerTextField().getValue():"",S=(s&&s.getPressed&&s.getPressed())||F,w=this.getVisibleItems(),x=this.getItems(),y=this.getSelectedItems();if(S){w.forEach(function(z){u=y.indexOf(z)>-1?true:false;t=this.getListItem(z);if(t){t.setVisible(u);}},this);}else{this.filterItems({value:v,items:x});}};r.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};r.prototype.createList=function(){var i=this.getRenderer();this._oList=new L({width:"100%",mode:o.MultiSelect,includeItemInSelection:true,rememberSelections:false}).addStyleClass(i.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(i.CSS_CLASS_MULTICOMBOBOX+"List").attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);this._oList.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};r.prototype.setSelection=function(i){if(i.item&&this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.listItemUpdated&&this.getListItem(i.item)){this.getList().setSelectedItem(this.getListItem(i.item),true);}var t=new sap.m.Token({key:i.key});t.setText(i.item.getText());t.setTooltip(i.item.getText());i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",t);this._oTokenizer.addToken(t);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",i.item,i.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,i.suppressInvalidate);if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:true});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};r.prototype.removeSelection=function(i){if(i.item&&!this.isItemSelected(i.item)){return;}if(!i.item){return;}this.removeAssociation("selectedItems",i.item,i.suppressInvalidate);var s=this.getKeys(this.getSelectedItems());this.setProperty("selectedKeys",s,i.suppressInvalidate);if(!i.listItemUpdated&&this.getListItem(i.item)){this.getList().setSelectedItem(this.getListItem(i.item),false);}if(!i.tokenUpdated){var t=this._getTokenByItem(i.item);i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this._oTokenizer.removeToken(t);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:false});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};r.prototype._synchronizeSelectedItemAndKey=function(s){if(!s.length){m.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}var S=this.getSelectedKeys()||this._aCustomerKeys;var t=this.getKeys(this.getSelectedItems());if(S.length){for(var i=0,u=null,v=null,w=null,x=S.length;i<x;i++){u=S[i];if(t.indexOf(u)>-1){if(this._aCustomerKeys.length&&(w=this._aCustomerKeys.indexOf(u))>-1){this._aCustomerKeys.splice(w,1);}continue;}v=this.getItemByKey(""+u);if(v){if(this._aCustomerKeys.length&&(w=this._aCustomerKeys.indexOf(u))>-1){this._aCustomerKeys.splice(w,1);}this.setSelection({item:v,id:v.getId(),key:v.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}return;}};r.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};r.prototype.updateItems=function(s){var i,t,u=this.getSelectedKeys();var U=a.prototype.updateItems.apply(this,arguments);t=this.getSelectedItems();i=(t.length===u.length)&&t.every(function(v){return v&&v.getKey&&u.indexOf(v.getKey())>-1;});if(!i){t=u.map(this.getItemByKey,this);this.setSelectedItems(t);}return U;};r.prototype._getSelectedItemsOf=function(s){for(var i=0,t=s.length,S=[];i<t;i++){if(this.getListItem(s[i]).isSelected()){S.push(s[i]);}}return S;};r.prototype._getLastSelectedItem=function(){var t=this._oTokenizer.getTokens();var i=t.length?t[t.length-1]:null;if(!i){return null;}return this._getItemByToken(i);};r.prototype._getOrderedSelectedItems=function(){var s=[];for(var i=0,t=this._oTokenizer.getTokens(),u=t.length;i<u;i++){s[i]=this._getItemByToken(t[i]);}return s;};r.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=sap.ui.getCore().byId(document.activeElement.id);if(this.getList()&&h(this.getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};r.prototype._getFocusedItem=function(){var i=this._getFocusedListItem();return this._getItemByListItem(i);};r.prototype._isRangeSelectionSet=function(i){var $=i.getDomRef();return $.indexOf(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"ItemRangeSelection")>-1?true:false;};r.prototype._hasTokens=function(){return this._oTokenizer.getTokens().length>0;};r.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};r.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};r.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};r.prototype._decorateListItem=function(i){i.addDelegate({onkeyup:function(s){var t=null;if(s.which==K.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();t=this._getLastSelectedItem();if(t){this.getListItem(t).focus();}return;}},onkeydown:function(s){var t=null,u=null;if(s.shiftKey&&s.which==K.ARROW_DOWN){u=this._getCurrentItem();t=this._getNextVisibleItemOf(u);}if(s.shiftKey&&s.which==K.ARROW_UP){u=this._getCurrentItem();t=this._getPreviousVisibleItemOf(u);}if(s.shiftKey&&s.which===K.SPACE){u=this._getCurrentItem();this._selectPreviousItemsOf(u);}if(t&&t!==u){if(this.getListItem(u).isSelected()){this.setSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(t);}else{this.removeSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(t);}return;}this._resetCurrentItem();if((s.ctrlKey||s.metaKey)&&s.which==K.A){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var S=this._getSelectedItemsOf(v);if(S.length!==v.length){v.forEach(function(t){this.setSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{v.forEach(function(t){this.removeSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);i.addEventDelegate({onsapbackspace:function(s){s.preventDefault();},onsapshow:function(s){s.setMarked();if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(s){this.onsapshow(s);},onsapenter:function(s){s.setMarked();this.close();},onsaphome:function(s){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var t=v[0];this.getListItem(t).focus();},onsapend:function(s){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var t=v[v.length-1];this.getListItem(t).focus();},onsapup:function(s){s.setMarked();s.preventDefault();var v=this.getSelectableItems();var t=v[0];var u=q(document.activeElement).control()[0];if(u===this.getListItem(t)){this.focus();s.stopPropagation(true);}},onfocusin:function(s){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(s){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(s){var t=this.getAggregation("picker");var u=sap.ui.getCore().byId(s.relatedControlId);if(t&&u&&j(t.getFocusDomRef(),u.getFocusDomRef())){if(s.srcControl){s.srcControl.focus();}}}},this);if(D.support.touch){i.addEventDelegate({ontouchstart:function(s){s.setMark("cancelAutoClose");}});}};r.prototype._handleInputFocusOut=function(){var i=this.isPickerDialog()?this.getPickerTextField():this,u=this._sOldInput||this._sOldValue||"";i.updateDomValue(u);};r.prototype._handleIndicatorPress=function(i){this._filterSelectedItems(i,true);this.focus();if(this.getEditable()){this.getPicker().open();}else{this._getReadOnlyPopover().openBy(this._oTokenizer._oIndicator);}if(this.isPickerDialog()){this._getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true;}else{setTimeout(this._oTokenizer["scrollToEnd"].bind(this._oTokenizer),0);}};r.prototype._createTokenizer=function(){var t=new sap.m.Tokenizer({tokens:[]}).attachTokenChange(this._handleTokenChange,this);t._setAdjustable(true);t._handleNMoreIndicatorPress(this._handleIndicatorPress.bind(this));t.setParent(this);t.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer,onfocusin:function(i){if(this.getEditable()&&q(i.target).hasClass("sapMToken")){t._useCollapsedMode(false);setTimeout(t["scrollToEnd"].bind(t),0);}}},this);return t;};r.prototype._onAfterRenderingTokenizer=function(){setTimeout(this._oTokenizer["scrollToEnd"].bind(this._oTokenizer),0);};r.prototype._handleTokenChange=function(i){var t=i.getParameter("type");var s=i.getParameter("token");var u=null;if(t!==sap.m.Tokenizer.TokenChangeType.Removed&&t!==sap.m.Tokenizer.TokenChangeType.Added){return;}if(t===sap.m.Tokenizer.TokenChangeType.Removed){u=(s&&this._getItemByToken(s));if(u&&this.isItemSelected(u)){this.removeSelection({item:u,id:u.getId(),key:u.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});!this.isPickerDialog()&&this.focus();this.fireChangeEvent("");}}};r.prototype.onAfterRenderingList=function(){var i=this.getList();if(this._iFocusedIndex!=null&&i.getItems().length>this._iFocusedIndex){i.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};r.prototype._highlightList=function(v){var i=[];this._oList.getItems().forEach(function(s){if(s.getDomRef()){i.push({ref:s.getDomRef().getElementsByClassName("sapMSLITitleOnly")[0],text:s.getTitle()});}});this.highLightList(v,i);};r.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated){this.getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};r.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);this._oTokenizer.setMaxWidth(this._calculateSpaceForTokenizer());this._registerResizeHandler();};r.prototype.onfocusout=function(i){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");a.prototype.onfocusout.apply(this,arguments);};r.prototype.onpaste=function(i){var s;if(window.clipboardData){s=window.clipboardData.getData("Text");}else{s=i.originalEvent.clipboardData.getData('text/plain');}var S=this._oTokenizer._parseString(s);if(S&&S.length>0){this.getSelectableItems().forEach(function(t){if(S.indexOf(t.getText())>-1){this.setSelection({item:t,id:t.getId(),key:t.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};r.prototype.onsapbackspace=function(i){if(!this.getEnabled()||!this.getEditable()){i.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}sap.m.Tokenizer.prototype.onsapbackspace.apply(this._oTokenizer,arguments);i.preventDefault();};r.prototype.onsapdelete=function(i){if(!this.getEnabled()||!this.getEditable()){return;}if(this.getValue()&&!this._isCompleteTextSelected()){return;}sap.m.Tokenizer.prototype.onsapdelete.apply(this._oTokenizer,arguments);};r.prototype.onsapnext=function(i){if(i.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===this._oTokenizer||this._oTokenizer.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};r.prototype.onsapprevious=function(i){if(this.getCursorPosition()===0&&!this._isCompleteTextSelected()){if(i.srcControl===this){sap.m.Tokenizer.prototype.onsapprevious.apply(this._oTokenizer,arguments);}}};r.prototype.ontap=function(i){a.prototype.ontap.apply(this,arguments);var s=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(this.isPickerDialog()&&s.contains(i.target)){this.open();}};r.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};r.prototype._getItemsStartingWithPerTerm=function(t,i){var s=[],u=i?this.getEnabledItems():this.getSelectableItems(),F=this.fnFilter?this.fnFilter:a.DEFAULT_TEXT_FILTER;u.forEach(function(v){if(F(t,v,"getText")){s.push(v);}},this);return s;};r.prototype._getItemsStartingWith=function(t,i){var s=[],u=i?this.getEnabledItems():this.getSelectableItems();u.forEach(function(v){if(typeof t==="string"&&t!==""&&v.getText().toLowerCase().startsWith(t.toLowerCase())){s.push(v);}},this);return s;};r.prototype._getUnselectedItemsStartingText=function(t){var i=[];this._getUnselectedItems().forEach(function(s){if(typeof t==="string"&&t!==""&&s.getText().toLowerCase().startsWith(t.toLowerCase())){i.push(s);}},this);return i;};r.prototype.getCursorPosition=function(){return this._$input.cursorPos();};r.prototype._isCompleteTextSelected=function(){if(!this.getValue().length){return false;}var i=this._$input[0];if(i.selectionStart!==0||i.selectionEnd!==this.getValue().length){return false;}return true;};r.prototype._selectPreviousItemsOf=function(i){var s;do{s=true;var t=this._getPreviousVisibleItemOf(i);if(t){var u=this.getListItem(t);if(u){s=this.getListItem(t).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=t;}while(!s);};r.prototype._getNextVisibleItemOf=function(i){var s=this.getSelectableItems();var t=s.indexOf(i)+1;if(t<=0||t>s.length-1){return null;}return s[t];};r.prototype._getPreviousVisibleItemOf=function(i){var s=this.getSelectableItems();var t=s.indexOf(i)-1;if(t<0){return null;}return s[t];};r.prototype._getNextUnselectedItemOf=function(i){var s=this._getUnselectedItems();var t=s.indexOf(i)+1;if(t<=0||t>s.length-1){return null;}return s[t];};r.prototype._getPreviousUnselectedItemOf=function(i){var s=this._getUnselectedItems();var t=s.indexOf(i)-1;if(t<0){return null;}return s[t];};r.prototype._getNextTraversalItem=function(){var i=this._getItemsStartingWithPerTerm(this.getValue());var s=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:s[0];};r.prototype._getPreviousTraversalItem=function(){var i=this._getItemsStartingWithPerTerm(this.getValue());if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var s=this._getUnselectedItems();if(s.length>0){return s[s.length-1];}else{return null;}}};r.prototype.findFirstEnabledItem=function(s){s=s||this.getItems();for(var i=0;i<s.length;i++){if(s[i].getEnabled()){return s[i];}}return null;};r.prototype.getVisibleItems=function(){for(var i=0,s,t=this.getItems(),v=[];i<t.length;i++){s=this.getListItem(t[i]);if(s&&s.getVisible()){v.push(t[i]);}}return v;};r.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};r.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!Array.isArray(i)){m.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(s){if(!(s instanceof g)&&(typeof s!=="string")){m.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof s==="string"){s=sap.ui.getCore().byId(s);}this.setSelection({item:s?s:null,id:s?s.getId():"",key:s?s.getKey():"",suppressInvalidate:true});},this);return this;};r.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};r.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};r.prototype.removeAllSelectedItems=function(){var i=[];var s=this.getAssociation("selectedItems",[]);s.forEach(function(t){var u=this.removeSelectedItem(t);if(u){i.push(u.getId());}},this);return i;};r.prototype.removeSelectedKeys=function(i){var s=[],t;if(!i||!i.length||!Array.isArray(i)){return s;}var u;i.forEach(function(v){u=this.getItemByKey(v);if(u){this.removeSelection({item:u?u:null,id:u?u.getId():"",key:u?u.getKey():"",fireChangeEvent:false,suppressInvalidate:true});s.push(u);}if(this._aCustomerKeys.length&&(t=this._aCustomerKeys.indexOf(v))>-1){this._aCustomerKeys.splice(t,1);}},this);return s;};r.prototype.setSelectedKeys=function(i){this.removeAllSelectedItems();this._aCustomerKeys=[];this.addSelectedKeys(i);return this;};r.prototype.addSelectedKeys=function(i){i=this.validateProperty("selectedKeys",i);i.forEach(function(s){var t=this.getItemByKey(s);if(t){this.addSelectedItem(t);}else if(s!=null){this._aCustomerKeys.push(s);}},this);return this;};r.prototype.getSelectedKeys=function(){var i=this.getSelectedItems()||[],s=[];i.forEach(function(t){s.push(t.getKey());},this);if(this._aCustomerKeys.length){s=s.concat(this._aCustomerKeys);}return s;};r.prototype._getUnselectedItems=function(){return q(this.getSelectableItems()).not(this.getSelectedItems()).get();};r.prototype.getSelectedItems=function(){var i=[],s=this.getAssociation("selectedItems")||[];s.forEach(function(t){var u=sap.ui.getCore().byId(t);if(u){i.push(u);}},this);return i;};r.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};r.prototype.getWidth=function(){return this.getProperty("width")||"100%";};r.prototype.setEditable=function(i){var s=this.getList();a.prototype.setEditable.apply(this,arguments);this._oTokenizer.setEditable(i);if(i){s.setMode(o.MultiSelect);this.getPicker().addContent(s);}else{s.setMode(o.None);this._getReadOnlyPopover().addContent(s);}return this;};r.prototype.clearFilter=function(){this.getItems().forEach(function(i){this.getListItem(i).setVisible(i.getEnabled()&&this.getSelectable(i));},this);};r.prototype._isListInSuggestMode=function(){return this.getList().getItems().some(function(i){return!i.getVisible()&&this._getItemByListItem(i).getEnabled();},this);};r.prototype._mapItemToListItem=function(i){if(!i){return null;}var s=this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Item";var t=(this.isItemSelected(i))?s+"Selected":"";var u=new sap.m.StandardListItem({type:n.Active,visible:i.getEnabled()}).addStyleClass(s+" "+t);u.setTooltip(i.getTooltip());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem",u);u.setTitle(i.getText());if(t){var v=new sap.m.Token({key:i.getKey()});v.setText(i.getText());v.setTooltip(i.getText());i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",v);this._oTokenizer.addToken(v,true);}this.setSelectable(i,i.getEnabled());this._decorateListItem(u);return u;};r.prototype._findMappedItem=function(s,t){for(var i=0,t=t||this.getItems(),u=t.length;i<u;i++){if(this.getListItem(t[i])===s){return t[i];}}return null;};r.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var t=this.getListItem(i);if(t){t.setVisible(s);}var u=this._getTokenByItem(i);if(u){u.setVisible(s);}};r.prototype.getSelectable=function(i){return i._bSelectable;};r.prototype._fillList=function(s){if(!s){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(v){if(v.srcControl.isSelected()){v.setMarked();}}};}for(var i=0,t,u=s.length;i<u;i++){t=this._mapItemToListItem(s[i]);t.removeEventDelegate(this._oListItemEnterEventDelegate);t.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this.getList().addAggregation("items",t,true);if(this.isItemSelected(s[i])){this.getList().setSelectedItem(t,true);}}};r.prototype._handleInputValidation=function(i,s){var v=i.target.value,S,t=this._sOldInput&&this._sOldInput.length>v.length,u,w,x;var y=s?q(i.target).control(0):i.srcControl;S=this._getItemsStartingWith(v,true);var z=this._getItemsStartingWithPerTerm(v,true);u=!!S.length;if(!u&&v!==""&&!z.length){this._handleFieldValidationState(y,s);return;}this._handleTypeAhead(v,S,y);w=this.getEnabledItems();if(this.isPickerDialog()){x=this._getFilterSelectedButton();if(x!=null&&x.getPressed()){x.setPressed(false);}}if(t){w=this.getItems();}this.filterItems({value:v,items:w});if((!this.getValue()||!u&&!z.length)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}this._sOldInput=v;};r.prototype._handleTypeAhead=function(v,i,s){var S=this.getSelectedItems();var t=i.filter(function(u){return S.indexOf(u)===-1;});if(this._bDoTypeAhead&&t.length){s.updateDomValue(t[0].getText());if(document.activeElement===s.getFocusDomRef()){s.selectText(v.length,s.getValue().length);}}};r.prototype._handleFieldValidationState=function(i,s){var u=s?this._sComposition:(this._sOldInput||this._sOldValue||"");i.updateDomValue(u);if(this._iOldCursorPos){q(i.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();};r.prototype.init=function(){this.createList();a.prototype.init.apply(this,arguments);this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this._aCustomerKeys=[];this._aInitiallySelectedItems=[];this._bCompositionStart=false;this._bCompositionEnd=false;this._sComposition="";this.attachBrowserEvent("compositionstart",function(){this._bCompositionStart=true;this._bCompositionEnd=false;},this);this.attachBrowserEvent("compositionend",function(i){this._bCompositionStart=false;this._bCompositionEnd=true;this._handleInputValidation(i,true);this._bCompositionEnd=false;this._sComposition=i.target.value;},this);};r.prototype.clearSelection=function(){this.removeAllSelectedItems();};r.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().addItem(this._mapItemToListItem(i));}return this;};r.prototype.insertItem=function(i,s){this.insertAggregation("items",i,s,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this.getList()){this.getList().insertItem(this._mapItemToListItem(i),s);}return this;};r.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(s){return s.getEnabled();});};r.prototype.getItemByKey=function(s){return this.findItem("key",s);};r.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this.getList()){this.getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};r.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};r.prototype.findItem=function(s,v){var t="get"+s.charAt(0).toUpperCase()+s.slice(1);for(var i=0,u=this.getItems();i<u.length;i++){if(u[i][t]()===v){return u[i];}}return null;};r.prototype._clearTokenizer=function(){this._oTokenizer.destroyAggregation("tokens",true);};r.prototype.getList=function(){return this._oList;};r.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oTokenizer){this._oTokenizer.destroy();this._oTokenizer=null;}};r.prototype.destroyItems=function(){this.destroyAggregation("items");if(this.getList()){this.getList().destroyItems();}this._oTokenizer.destroyTokens();return this;};r.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this.getList()){this.getList().removeAllItems();}return i;};r.prototype._getItemByListItem=function(i){return this._getItemBy(i,"ListItem");};r.prototype._getItemByToken=function(t){return this._getItemBy(t,"Token");};r.prototype._getItemBy=function(s,t){t=this.getRenderer().CSS_CLASS_COMBOBOXBASE+t;for(var i=0,u=this.getItems(),v=u.length;i<v;i++){if(u[i].data(t)===s){return u[i];}}return null;};r.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};r.prototype.getAccessibilityInfo=function(){var t=this.getSelectedItems().map(function(s){return s.getText();}).join(" ");var i=a.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");i.description=((i.description||"")+" "+t).trim();return i;};return r;});
