/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/fl/Persistence","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Cache","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/View","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/fl/context/ContextManager","sap/ui/core/Element","sap/base/strings/formatMessage","sap/base/Log"],function(q,P,C,U,L,a,V,b,F,c,d,J,X,e,E,f,g){"use strict";var h=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};h.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";h.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";h.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";h.PENDING="sap.ui.fl:PendingChange";h.PROCESSING="sap.ui.fl:ProcessingChange";h.variantTechnicalParameterName="sap-ui-fl-control-variant-id";h.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};h.prototype.getComponentName=function(){return this._sComponentName;};h.prototype.getAppVersion=function(){return this._sAppVersion;};h.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController._fillVariantModel();}return D;};h.prototype.createBaseChange=function(o,A){var i,j;var k=e._getContextIdsFromUrl();if(k.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No Application Component found - to offer flexibility. Valid relation to its owning application component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=k.length===1?k[0]:"";o.validAppVersions=this._getValidAppVersions(o);i=a.createInitialFileContent(o);j=new a(i);if(o.variantReference){j.setVariantReference(o.variantReference);}return j;};h.prototype.createChange=function(o,i){var j,k;if(!i){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=i.id||i.getId();if(!o.selector){o.selector={};}var A=i.appComponent||U.getAppComponentForControl(i);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}if(U.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);if(!l){throw new Error("Generated ID attribute found ('"+s+"'); provide a stable ID for the control as required by flexibility for assigning the changes.");}o.selector.id=l;o.selector.idIsLocal=true;}else{o.selector.id=s;o.selector.idIsLocal=false;}j=this.createBaseChange(o,A);var m=i.controlType||U.getControlType(i);if(!m){throw new Error("No control type found - the change handler can not be retrieved.");}k=this._getChangeHandler(j,m,i,J);if(k){k.completeChangeContent(j,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return j;};h.prototype.createVariant=function(v,A){var o,i;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=this._getValidAppVersions(v);i=V.createInitialFileContent(v);o=new V(i);return o;};h.prototype._getValidAppVersions=function(o){var A=this.getAppVersion();var v={creation:A,from:A};if(A&&o.developerMode&&o.scenario!==sap.ui.fl.Scenario.AdaptationProject&&o.scenario!==sap.ui.fl.Scenario.AppVariant){v.to=A;}return v;};h.prototype.addChange=function(o,i){var j=this.createChange(o,i);var A=U.getAppComponentForControl(i);this.addPreparedChange(j,A);return j;};h.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var O=U.getAppComponentForControl(A,true);var m=O&&O.getModel("$FlexVariants");m._addChange(o);}this._oChangePersistence.addChange(o,A,O);return o;};h.prototype.deleteChange=function(o,A){var O=U.getAppComponentForControl(A,true);this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){O.getModel("$FlexVariants")._removeChange(o);}};h.prototype.createAndApplyChange=function(o,i){var j=this.addChange(o,i);var p={modifier:J,appComponent:U.getAppComponentForControl(i),view:U.getViewForControl(i)};return this.checkTargetAndApplyChange(j,i,p).then(function(r){if(!r.success){var k=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(j);throw k;}}.bind(this));};h.prototype._checkDependencies=function(o,D,m,A,r){var R=this._checkChange(o,A);if(!R){return[];}r.push(o);var s=o.getId();var j=D[s]&&D[s].dependencies||[];for(var i=0,n=j.length;i<n;i++){var k=U.getChangeFromChangesMap(m,j[i]);R=this._checkDependencies(k,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};h.prototype._checkChange=function(o,A){var s;var S=o.getSelector();if(S.idIsLocal){s=A.createId(S.id);}else{s=S.id;}var i=sap.ui.getCore().byId(s);if(!i){return false;}var j=this._getFailedCustomDataJs(o,i,J).customDataEntries;if(j.indexOf(o.getId())>-1){return false;}return true;};h.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=Object.assign({},m.mDependencies);var i=m.mChanges;var j=i[o.getId()]||[];var A=this._getAppliedCustomData(undefined,o,J).customDataEntries;var k=U.getAppComponentForControl(o);var n=j.filter(function(l){return A.indexOf(l.getId())===-1;});var r=[];n.forEach(function(l){var s=this._checkDependencies(l,D,m.mChanges,k,[]);r=r.concat(s);},this);r=r.filter(function(l,s,t){return t.indexOf(l)===s;});r.forEach(function(w){if(!w.aPromiseFn){w.aPromiseFn=[];}p.push(new Promise(function(l,s){w.aPromiseFn.push({resolve:l,reject:s});}).catch(function(l){var s=l.getId&&m.mDependentChangesOnMe[l.getId()]||[];s.forEach(function(t){var u=U.getChangeFromChangesMap(i,t);if(u.aPromiseFn){u.aPromiseFn.forEach(function(v){v.reject(u);});}});Promise.resolve();}));},this);return Promise.all(p);};h.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};h.prototype.processXmlView=function(v,p){var o=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(o);var m=o.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};h.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};h.prototype._checkForDependentSelectorControls=function(o,p){var D=o.getDependentControlIdList(p.appComponent);D.forEach(function(s){var i=p.modifier._byId(s,p.view);if(!i){throw new Error("A dependent selector control of the flexibility change is not available.");}});};h.prototype._resolveGetChangesForView=function(p,i){var j=[];if(!Array.isArray(i)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(s,undefined,"sap.ui.fl.FlexController");return[];}i.forEach(function(o){try{var S=this._getSelectorOfChange(o);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var k=p.modifier.bySelector(S,p.appComponent,p.view);if(!k){throw new Error("A flexibility change tries to change a nonexistent control.");}this._checkForDependentSelectorControls(o,p);j.push(function(){return this.checkTargetAndApplyChange(o,k,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},o);}}.bind(this));}.bind(this));}catch(l){this._logApplyChangeError(l,o);}}.bind(this));return U.execPromiseQueueSequentially(j).then(function(){return p.view;});};h.prototype._logApplyChangeError=function(o,i){var D=i.getDefinition();var s=D.changeType;var t=D.selector.id;var j=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+j;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};h.prototype.checkTargetAndApplyChange=function(o,i,p){var x=p.modifier.targets==="xmlTree";var m=p.modifier;var s=m.getControlType(i);var j=this._getControlIfTemplateAffected(o,i,s,p);var k=this._getChangeHandler(o,j.controlType,j.control,m);var S;var r;if(!k){var l="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";U.log.warning(l);return new U.FakePromise({success:false,error:new Error(l)});}if(x&&o.getDefinition().jsOnly){return new U.FakePromise({success:false,error:new Error("Change can not be applied in XML. Retrying in JS.")});}var A=this._getAppliedCustomData(o,i,m);var n=A.customDataValue;var t=A.customData;if(!this._isChangeCurrentlyApplied(i,o,m,A)){var R=this.isChangeHandlerRevertible(o,j.control,k);return new U.FakePromise().then(function(){S=F.getInstanceOrUndef();if(!R&&S&&S._oSettings.recordUndo){if(x){throw new Error();}return new Promise(function(u){sap.ui.require(["sap/ui/rta/ControlTreeModifier"],function(v){if(!v){U.log.error("Please load 'sap/ui/rta' library if you want to record undo");}else{p.modifier=v;v.startRecordingUndo();r=v;}u();});});}}).then(function(){o.PROCESSING=o.PROCESSING?o.PROCESSING:true;var I=k.applyChange(o,j.control,p);if(j.bTemplateAffected){m.updateAggregation(i,o.getContent().boundAggregation);}return I;}).then(function(I){if(I instanceof E){i=I;A=this._getAppliedCustomData(o,i,m);n=A.customDataValue;t=A.customData;}if(!R&&S&&S._oSettings.recordUndo&&r){o.setUndoOperations(r.stopRecordingUndo());}var u=o.getId();var v=n?n+","+u:u;this._writeAppliedChangesCustomData(t,v,p,i);if(o.aPromiseFn){o.aPromiseFn.forEach(function(w){w.resolve(o);});}delete o.PROCESSING;o.APPLIED=true;return{success:true};}.bind(this)).catch(function(u){var v;this._setMergeError(true);var w="Change ''{0}'' could not be applied. Merge error detected while "+"processing the {1}.";if(x){v=this._getFailedCustomDataXml(o,i,m);w=f(w,[o.getId(),"XML tree"]);g.warning(w,u.stack||"");}else{v=this._getFailedCustomDataJs(o,i,m);w=f(w,[o.getId(),"JS control tree"]);g.error(w,u.stack||"");}var y=v.customData;v.customDataEntries.push(o.getId());var z=v.customDataEntries.join(",");if(x){this._writeFailedChangesCustomDataXml(y,z,p,i);}else{this._writeFailedChangesCustomDataJs(y,z,p,i);}if(o.aPromiseFn){o.aPromiseFn.forEach(function(B){B.reject(o);});}delete o.PROCESSING;return{success:false,error:u};}.bind(this));}return new U.FakePromise({success:true});};h.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,i,p,r){var A,j,I;var m=p.modifier;var s=m.getControlType(i);var k=this._getControlIfTemplateAffected(o,i,s,p);var l=this._getChangeHandler(o,k.controlType,k.control,m);var R;if(r&&!l){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return new U.FakePromise();}var n=o.getId();var t=this._getAppliedCustomData(o,i,m);A=t.customDataEntries;j=t.customData;I=A.indexOf(n);if(I===-1&&(o.PROCESSING||o.QUEUED)){R=new Promise(function(u,v){o.aPromiseFn=o.aPromiseFn||[];o.aPromiseFn.push({resolve:u,reject:v});}).then(function(v){return true;});}else{R=new U.FakePromise(false);}return R.then(function(u){if(r&&(u||(!u&&I>-1))){var v=l.revertChange(o,k.control,p);if(k.bTemplateAffected){m.updateAggregation(i,o.getContent().boundAggregation);}return v;}}).then(function(){t=this._getAppliedCustomData(o,i,m);A=t.customDataEntries;j=t.customData;I=A.indexOf(n);if(I>-1&&j){A.splice(I,1);this._writeAppliedChangesCustomData(j,A.join(),p,i);}}.bind(this)).catch(function(u){U.log.error("Change could not be reverted:",u);});};h.prototype._writeAppliedChangesCustomData=function(o,v,p,i){this._writeCustomData(o,v,p,i,h.appliedChangesCustomDataKey);};h.prototype._writeFailedChangesCustomDataXml=function(o,v,p,i){this._writeCustomData(o,v,p,i,h.failedChangesCustomDataKeyXml);};h.prototype._writeFailedChangesCustomDataJs=function(o,v,p,i){this._writeCustomData(o,v,p,i,h.failedChangesCustomDataKeyJs);};h.prototype._writeCustomData=function(o,v,p,i,s){var m=p.modifier;if(o){m.setProperty(o,"value",v);}else{var O=p.appComponent;var j=p.view;o=m.createControl("sap.ui.core.CustomData",O,j);m.setProperty(o,"key",s);m.setProperty(o,"value",v);m.insertAggregation(i,"customData",o,0,j);}};h.prototype._getAppliedCustomData=function(o,i,m){return this._getCustomData(o,i,m,h.appliedChangesCustomDataKey);};h.prototype._getFailedCustomDataXml=function(o,i,m){return this._getCustomData(o,i,m,h.failedChangesCustomDataKeyXml);};h.prototype._getFailedCustomDataJs=function(o,i,m){return this._getCustomData(o,i,m,h.failedChangesCustomDataKeyJs);};h.prototype._getCustomData=function(o,i,m,s){var j=m.getAggregation(i,"customData")||[];var r={customDataEntries:[]};j.some(function(k){var K=m.getProperty(k,"key");if(K===s){r.customData=k;r.customDataValue=m.getProperty(k,"value");r.customDataEntries=r.customDataValue.split(",");return true;}});return r;};h.prototype._handlePromiseChainError=function(v,o){U.log.error("Error processing view "+o+".");return v;};h.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};h.prototype._getChangeHandler=function(o,s,i,m){var j=o.getChangeType();var l=o.getLayer();return this._getChangeRegistry().getChangeHandler(j,s,i,m,l);};h.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};h.prototype._getControlIfTemplateAffected=function(o,i,s,p){var j=o.getDefinition();var m={};if(o.getContent().boundAggregation&&j.dependentSelector.originalSelector){var M=p.modifier;m.control=M.bySelector(j.dependentSelector.originalSelector,p.appComponent,p.view);m.controlType=M.getControlType(m.control);m.bTemplateAffected=true;}else{m.control=i;m.controlType=s;m.bTemplateAffected=false;}return m;};h.prototype.getComponentChanges=function(p,i){return this._oChangePersistence.getChangesForComponent(p,i);};h.prototype.checkForOpenDependenciesForControl=function(s,m,A){return this._oChangePersistence.checkForOpenDependenciesForControl(s,m,A);};h.prototype.isPersonalized=function(p){p=p||{};p.includeVariants=true;return this.getComponentChanges(p).then(function(v){var i=v==="userLevelVariantChangesExist"||v.some(function(o){return o.isUserDependent();});return!!i;});};h.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};h.prototype.resetChanges=function(l,G,o){return this._oChangePersistence.resetChanges(l,G).then(function(r){if(o){var m=o.getModel("$FlexVariants");if(m){m.updateHasherEntry({parameters:[],updateURL:true,component:o});}}return r;});};h.prototype.discardChanges=function(i,D){var A=U.getCurrentLayer(!!D);var I=0;var l;var o;l=i.length;while(I<i.length){o=i[I];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===i.length){I++;}else{l=i.length;}}return this._oChangePersistence.saveDirtyChanges();};h.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var j=o.mChanges[i]||[];return this.discardChanges(j,D);};h.prototype._setMergeError=function(){return F.getInstance().then(function(s){s.setMergeErrorOccured(true);});};h.prototype._isChangeCurrentlyApplied=function(o,i,m,j){if(!j){j=this._getAppliedCustomData(i,o,J);}var A=j.customDataEntries;var s=i.getId();return A.indexOf(s)>-1;};h.prototype._checkIfDependencyIsStillValid=function(A,m,s){var o=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);if(!o.APPLIED){return true;}var i=m.bySelector(o.getSelector(),A);if(!this._isChangeCurrentlyApplied(i,o,m)){return true;}return false;};h.prototype._applyChangesOnControl=function(G,A,o){var p=[];var m=G();var i=m.mChanges;var D=m.mDependencies;var j=m.mDependentChangesOnMe;var k=i[o.getId()]||[];var l={modifier:J,appComponent:A,view:U.getViewForControl(o)};k.forEach(function(n){if(n.APPLIED&&!this._isChangeCurrentlyApplied(o,n,l.modifier)){m=this._oChangePersistence.copyDependenciesFromInitialChangesMap(n,this._checkIfDependencyIsStillValid.bind(this,A,l.modifier));D=m.mDependencies;j=m.mDependentChangesOnMe;delete n.APPLIED;}if(!D[n.getId()]){n.QUEUED=true;p.push(function(){return this.checkTargetAndApplyChange(n,o,l).then(function(r){if(r.success){this._updateDependencies(D,j,n.getId());}delete n.QUEUED;}.bind(this));}.bind(this));}else{D[n.getId()][h.PENDING]=this.checkTargetAndApplyChange.bind(this,n,o,l);}}.bind(this));return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,j);}.bind(this));};h.prototype.getBoundApplyChangesOnControl=function(G,o){var B=this._applyChangesOnControl.bind(this,G,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};h.prototype.revertChangesOnControl=function(i,A){var p=[];i.forEach(function(o){p.push(function(){var s=this._getSelectorOfChange(o);var j=J.bySelector(s,A);var m={modifier:J,appComponent:A,view:U.getViewForControl(j)};return this._removeFromAppliedChangesAndMaybeRevert(o,j,m,true).then(function(){this._oChangePersistence._deleteChangeInMap(o);}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};h.prototype.isChangeHandlerRevertible=function(o,i,j){if(!j){var s=J.getControlType(i);j=this._getChangeHandler(o,s,i,J);}return!!(j&&typeof j.revertChange==="function");};h.prototype.applyVariantChanges=function(i,o){var A=U.getAppComponentForControl(o);var p=[];i.forEach(function(j){var m=this._oChangePersistence.getChangesMapForComponent().mChanges;var k=Object.keys(m).reduce(function(i,s){return i.concat(m[s]);},[]);this._oChangePersistence._addChangeAndUpdateDependencies(o,j,k.length,k);p.push(function(){var M=J;var s=this._getSelectorOfChange(j);var l=M.bySelector(s,A);if(!l){U.log.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,l);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};h.prototype.removeFromAppliedChangesOnControl=function(o,A,i){var p={modifier:J,appComponent:A,view:U.getViewForControl(i)};return this._removeFromAppliedChangesAndMaybeRevert(o,i,p,false);};h.prototype._updateControlsDependencies=function(D){var o;Object.keys(D).forEach(function(s){var i=D[s];if(i.controlsDependencies&&i.controlsDependencies.length>0){var l=i.controlsDependencies.length;while(l--){var I=i.controlsDependencies[l];o=sap.ui.getCore().byId(I);if(o){i.controlsDependencies.splice(l,1);}}}});};h.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};h.prototype._iterateDependentQueue=function(D,m){var A=[],i=[],p=[];this._updateControlsDependencies(D);Object.keys(D).forEach(function(s){var o=D[s];if(o[h.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)&&!o[h.PROCESSING]){o[h.PROCESSING]=true;p.push(function(){return o[h.PENDING]().then(function(r){if(r.success){i.push(s);A.push(o.changeObject.getId());}});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<i.length;j++){delete D[i[j]];}for(var k=0;k<A.length;k++){this._updateDependencies(D,m,A[k]);}return A;}.bind(this));};h.prototype._processDependentQueue=function(D,m){return this._iterateDependentQueue(D,m).then(function(A){if(A.length>0){return this._processDependentQueue(D,m);}}.bind(this));};return h;},true);
