/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Cache","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/base/ManagedObject","sap/ui/core/Component"],function(U,C,V,a,J,M,b){"use strict";var c=function(s,A,o){this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;this._mVariantManagement={};this._setChangeFileContent(o,{});this.sVariantTechnicalParameterName="sap-ui-fl-control-variant-id";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");};c.prototype.getComponentName=function(){return this._sComponentName;};c.prototype.getAppVersion=function(){return this._sAppVersion;};c.prototype._setChangeFileContent=function(o,t){var d=a.getEntry(this.getComponentName(),this.getAppVersion());if(Object.keys(this._mVariantManagement).length===0){this._mVariantManagement={};}if(o&&o.changes&&o.changes.variantSection){Object.keys(o.changes.variantSection).forEach(function(v){this._mVariantManagement[v]={};var e=o.changes.variantSection[v];var f=e.variants.concat();var s;var i=-1;f.forEach(function(g,h){if(g.content.fileName===v){i=h;}if(!g.content.content.favorite){g.content.content.favorite=true;}if(!g.content.content.visible){g.content.content.visible=true;}var T=g.content.content.title.match(/.i18n>(\w+)./);if(T){g.content.content.title=this._oResourceBundle.getText(T[1]);}this._applyChangesOnVariant(g);if(t&&Array.isArray(t[this.sVariantTechnicalParameterName])){t[this.sVariantTechnicalParameterName].some(function(u){if(g.content.fileName===u){s=g.content.fileName;return true;}});}}.bind(this));if(i>-1){var S=f.splice(i,1)[0];f.sort(this.compareVariants);f.splice(0,0,S);}this._mVariantManagement[v].variants=f;this._mVariantManagement[v].defaultVariant=v;if(s){this._mVariantManagement[v].currentVariant=s;}this._mVariantManagement[v].variantManagementChanges=o.changes.variantSection[v].variantManagementChanges;this._applyChangesOnVariantManagement(this._mVariantManagement[v]);}.bind(this));d.file.changes.variantSection=this._mVariantManagement;}};c.prototype._getChangeFileContent=function(){return this._mVariantManagement;};c.prototype.compareVariants=function(v,o){if(v.content.content.title.toLowerCase()<o.content.content.title.toLowerCase()){return-1;}else if(v.content.content.title.toLowerCase()>o.content.content.title.toLowerCase()){return 1;}else{return 0;}};c.prototype.getVariants=function(v){var d=this._mVariantManagement[v]&&this._mVariantManagement[v].variants;return d?d:[];};c.prototype.getVariant=function(v,s){var o;var d=this.getVariants(v);d.some(function(e,i){if(e.content.fileName===s){o=e;return true;}});return o;};c.prototype.getVariantChanges=function(v,s){var d=s||this._mVariantManagement[v].defaultVariant;var e=this.getVariants(v);var f=e.filter(function(o){return o.content.fileName===d;});return f.reduce(function(r,o){return o.controlChanges?r.concat(o.controlChanges):r;},[]);};c.prototype._getReferencedChanges=function(v,o){var r=[];if(o.content.variantReference){r=this.getVariantChanges(v,o.content.variantReference);return r.filter(function(R){return U.isLayerAboveCurrentLayer(R.layer)===-1;});}return r;};c.prototype.setVariantChanges=function(v,s,d){if(!v||!s||!Array.isArray(d)){U.log.error("Cannot set variant changes without Variant reference");return;}return this._mVariantManagement[v].variants.some(function(o,i){if(o.content.fileName===s){o.controlChanges=d;return true;}});};c.prototype._setVariantData=function(m,v,p){var d=this._mVariantManagement[v].variants;var o=d[p];Object.keys(m).forEach(function(P){if(o.content.content[P]){o.content.content[P]=m[P];}});if(o.content.fileName!==v){d.splice(p,1);var s=this._getIndexToSortVariant(d.slice(1),o);d.splice(s+1,0,o);return s+1;}else{d.splice(p,1,o);return p;}};c.prototype._updateChangesForVariantManagementInMap=function(o,v,A){var d=this._mVariantManagement[v];var s=o.changeType;if(o.fileType==="ctrl_variant_change"){d.variants.some(function(e){if(e.content.fileName===o.selector.id){if(!e.variantChanges[s]){e.variantChanges[s]=[];}if(A){e.variantChanges[s].push(o);}else{e.variantChanges[s].some(function(E,i){if(E.fileName===o.fileName){e.variantChanges[s].splice(i,1);return true;}});}return true;}});}else if(o.fileType==="ctrl_variant_management_change"){if(!d.variantManagementChanges){d.variantManagementChanges={};}if(!d.variantManagementChanges[s]){d.variantManagementChanges[s]=[];}if(A){d.variantManagementChanges[s].push(o);}else{d.variantManagementChanges[s].some(function(e,i){if(e.fileName===o.fileName){d.variantManagementChanges[s].splice(i,1);return true;}});}}};c.prototype.loadInitialChanges=function(){return Object.keys(this._mVariantManagement).reduce(function(i,v){var s=this._mVariantManagement[v].currentVariant?"currentVariant":"defaultVariant";var I=this.getVariant(v,this._mVariantManagement[v][s]);if(!I||!I.content.content.visible){this._mVariantManagement[v][s]=v;}return i.concat(this.getVariantChanges(v,this._mVariantManagement[v][s]));}.bind(this),[]);};c.prototype.getChangesForVariantSwitch=function(p){var d=this.getVariantChanges(p.variantManagementReference,p.currentVariantReference);var m=[],e=[];var o=p.component instanceof b?p.component:undefined;Object.keys(p.changesMap).forEach(function(f){p.changesMap[f].forEach(function(g){m=m.concat(g);e=e.concat(g.getId());});});d=d.reduce(function(f,g){var i=e.indexOf(g.fileName);if(i>-1){f=f.concat(m[i]);if(!o&&Array.isArray(p.component)){o=this._getComponentForChange(m[i],p.component);}}return f;}.bind(this),[]);var n=this.getVariantChanges(p.variantManagementReference,p.newVariantReference).map(function(f){return new C(f);});var r=[];if(n.length>0){r=d.slice();d.some(function(f){if(n[0]&&f.getId()===n[0].getId()){n.shift();r.shift();}else{return true;}});}else{r=d;}var s={aRevert:r.reverse(),aNew:n,component:o};return s;};c.prototype._getComponentForChange=function(o,d){var s=o.getSelector&&o.getSelector();var e;if(s){d.some(function(f){if(J.bySelector(s,f)instanceof M){e=f;return true;}});}return e;};c.prototype._applyChangesOnVariant=function(v){var m=v.variantChanges,A;Object.keys(m).forEach(function(s){switch(s){case"setTitle":A=this._getActiveChange(s,m);if(A){v.content.content.title=A.getText("title");}break;case"setFavorite":A=this._getActiveChange(s,m);if(A){v.content.content.favorite=A.getContent().favorite;}break;case"setVisible":A=this._getActiveChange(s,m);if(A){v.content.content.visible=A.getContent().visible;}break;default:U.log.error("No valid changes on variant "+v.content.content.title+" available");}}.bind(this));};c.prototype._applyChangesOnVariantManagement=function(v){var m=v.variantManagementChanges,A;if(Object.keys(m).length>0){A=this._getActiveChange("setDefault",m);if(A){v.defaultVariant=A.getContent().defaultVariant;}}};c.prototype._getActiveChange=function(s,m){var l=m[s].length-1;if(l>-1){return new C(m[s][l]);}return false;};c.prototype._fillVariantModel=function(){var v={};Object.keys(this._mVariantManagement).forEach(function(k){v[k]={defaultVariant:this._mVariantManagement[k].defaultVariant,variants:[]};if(this._mVariantManagement[k].currentVariant){v[k].currentVariant=this._mVariantManagement[k].currentVariant;}this.getVariants(k).forEach(function(o,i){v[k].variants[i]=JSON.parse(JSON.stringify({key:o.content.fileName,title:o.content.content.title,layer:o.content.layer,favorite:o.content.content.favorite,visible:o.content.content.visible}));});}.bind(this));return v;};c.prototype.updateCurrentVariantInMap=function(v,n){this._mVariantManagement[v].currentVariant=n;};c.prototype.addChangeToVariant=function(o,v,s){var n=this.getVariantChanges(v,s);var d=n.map(function(o){return o.fileName;});var i=d.indexOf(o.getDefinition().fileName);if(i===-1){n.push(o.getDefinition());return this.setVariantChanges(v,s,n);}return false;};c.prototype.removeChangeFromVariant=function(o,v,s){var n=this.getVariantChanges(v,s);n.forEach(function(d,i){var e=new C(d);if(e.getId&&(e.getId()===o.getId())){n.splice(i,1);}});return this.setVariantChanges(v,s,n);};c.prototype.addVariantToVariantManagement=function(v,s){var d=this._mVariantManagement[s].variants.slice().splice(1);var i=this._getIndexToSortVariant(d,v);if(v.content.variantReference){var r=this._getReferencedChanges(s,v);v.controlChanges=r.concat(v.controlChanges);}this._mVariantManagement[s].variants.splice(i+1,0,v);return i+1;};c.prototype._getIndexToSortVariant=function(v,o){var i=0;v.some(function(e,d){if(this.compareVariants(o,e)<0){i=d;return true;}i=d+1;}.bind(this));return i;};c.prototype.removeVariantFromVariantManagement=function(v,s){var i;var f=this._mVariantManagement[s].variants.some(function(o,d){var e=new V(o);if(e.getId()===v.getId()){i=d;return true;}});if(f){this._mVariantManagement[s].variants.splice(i,1);}return i;};c.prototype.resetMap=function(){this._mVariantManagement={};};return c;},true);
