/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','./library','sap/ui/core/library','sap/ui/core/ResizeHandler','sap/ui/core/RenderManager','./SplitterRenderer',"sap/base/Log","sap/ui/thirdparty/jquery"],function(C,l,c,R,a,S,L,q){"use strict";var O=c.Orientation;var b=C.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designtime:"sap/ui/layout/designtime/Splitter.designtime"}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");b.prototype.init=function(){this._needsInvalidation=false;this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=this._delayedResize.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._switchOrientation();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners();this._bUseIconForSeparator=true;};b.prototype.exit=function(){this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar;};b.prototype.triggerResize=function(f){if(f){this._resize();}else{this._delayedResize();}};b.prototype.getCalculatedSizes=function(){return this._calculatedSizes;};b.prototype.enableAutoResize=function(t){if(t&&!this._autoResize){return;}this._autoResize=true;var f=this;sap.ui.getCore().attachInit(function(){f._resizeHandlerId=R.register(f,f._resizeCallback);});this._delayedResize();};b.prototype.disableAutoResize=function(t){R.deregister(this._resizeHandlerId);if(!t){this._autoResize=false;}};b.prototype.enableLiveResize=function(){this._liveResize=true;this.$().toggleClass("sapUiLoSplitterAnimated",false);};b.prototype.disableLiveResize=function(){this._liveResize=false;this.$().toggleClass("sapUiLoSplitterAnimated",true);};b.prototype.enableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","0");this._enableKeyboardListeners();};b.prototype.disableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","-1");this._disableKeyboardListeners();};b.prototype.onBeforeRendering=function(){this._switchOrientation();};b.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._$SplitterOverlay.detach();this._resize();};b.prototype.onLayoutDataChange=function(){this._delayedResize();};b.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};b.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);};b.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var B=parseInt(j.target.id.substr((I+"-splitbar-").length),10);var $=q(j.target);var m=this.getCalculatedSizes();var f=this._bHorizontal?$.innerWidth():$.innerHeight();var g=this._getContentAreas();var o=g[B].getLayoutData();var h=g[B+1].getLayoutData();if(!o.getResizable()||!h.getResizable()){d(t);return;}var k=0-f;for(var i=0;i<=B;++i){k+=m[i]+f;}this._move={start:p,relStart:k,barNum:B,bar:q(j.target),c1Size:m[B],c1MinSize:o?parseInt(o.getMinSize(),10):0,c2Size:m[B+1],c2MinSize:h?parseInt(h.getMinSize(),10):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};b.prototype._onBarMove=function(j){if(j.preventDefault){j.preventDefault();}var E=j;if(j.changedTouches&&j.changedTouches[0]){E=j.changedTouches[0];}var p=E[this._moveCord];var D=(p-this._move.start);if(this.getOrientation()==O.Horizontal&&this._bRtl){D=-D;}var f=this._move.c1Size+D;var g=this._move.c2Size-D;var i=(f>=0&&g>=0&&f>=this._move.c1MinSize&&g>=this._move.c2MinSize);if(i){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+D);if(this._liveResize){var m=(this._move["start"]-E[this._moveCord]);if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,false);}}};b.prototype._onBarMoveEnd=function(j){this._ignoreMouse=false;this._ignoreTouch=false;var E=j;if(j.changedTouches&&j.changedTouches[0]){E=j.changedTouches[0];}var p=E[this._moveCord];var m=this._move["start"]-p;if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,true);this._move["bar"].css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);if(this._move.bar){this._move.bar.focus();}};b.prototype._resizeContents=function(i,p,f){if(isNaN(p)){L.warning("Splitter: Received invalid resizing values - resize aborted.");return;}var g=this._getContentAreas();var o=g[i].getLayoutData();var h=g[i+1].getLayoutData();var s=o.getSize();var j=h.getSize();var $=this.$("content-"+i);var k=this.$("content-"+(i+1));var n=this._move.c1Size+p;var N=this._move.c2Size-p;var m=parseInt(o.getMinSize(),10);var M=parseInt(h.getMinSize(),10);var D;if(n<m){D=m-n;p+=D;n=m;N-=D;}else if(N<M){D=M-N;p-=D;N=M;n-=D;}if(f){if(s==="auto"&&j!=="auto"){h.setSize(N+"px");}else if(s!=="auto"&&j==="auto"){o.setSize(n+"px");}else{o.setSize(n+"px");h.setSize(N+"px");}}else{$.css(this._sizeType,n+"px");k.css(this._sizeType,N+"px");}};b.prototype._delayedResize=function(D){if(D===undefined){D=0;}if(this.getDomRef()){clearTimeout(this._resizeTimeout);setTimeout(this["_resize"].bind(this),D);}};b.prototype._resizeBars=function(f){var i,B;var $=this.$();for(i=0;i<f.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeTypeNot,"");}for(i=0;i<f.length-1;++i){B=this.$("splitbar-"+i);var s=this._bHorizontal?$.height():$.width();B.css(this._sizeType,"");B.css(this._sizeTypeNot,s+"px");}};b.prototype._resize=function(){var D=this.getDomRef();if(!D||a.getPreserveAreaRef().contains(D)){return;}var i=0,B;var f=this._getContentAreas();this._resizeBars(f);var o=this.getCalculatedSizes();this._recalculateSizes();var n=this.getCalculatedSizes();var s=false;for(i=0;i<n.length;++i){if(n[i]!==0){s=true;break;}}if(!s){this._delayedResize(100);return;}var g=true;for(i=0;i<f.length;++i){var $=this.$("content-"+i);var h=f[i];$.css(this._sizeType,n[i]+"px");$.css(this._sizeTypeNot,"");var j=h.getLayoutData();var k=j&&j.getResizable();if(i>0){var m=k&&g;B=this.$("splitbar-"+(i-1));B.toggleClass("sapUiLoSplitterNoResize",!m);B.attr("tabindex",m&&this._keyboardEnabled?"0":"-1");}g=k;}this._resizeBars(f);if(_(o,n)){this.fireResize({oldSizes:o,newSizes:n});}};b.prototype._calculateAvailableContentSize=function(s){var i=0;var $=this.$();var f=this._bHorizontal?$.innerWidth():$.innerHeight();var A=0;var h=false;for(i=0;i<s.length;++i){var g=s[i];if(g.indexOf("%")>-1){A++;}if(s[i]=="auto"){h=true;}}A+=h?1:0;f-=A;var j=s.length-1;var k=0;for(i=0;i<j;++i){k+=this._bHorizontal?this.$("splitbar-"+i).innerWidth():this.$("splitbar-"+i).innerHeight();}return Math.max(0,f-k);};b.prototype._recalculateSizes=function(){var i,s,o,f,g;var h=[];var j=this._getContentAreas();for(i=0;i<j.length;++i){o=j[i].getLayoutData();s=o?o.getSize():"auto";h.push(s);}this._calculatedSizes=[];var A=this._calculateAvailableContentSize(h);var k=[];var m=[];var p=[];var n=A;for(i=0;i<h.length;++i){s=h[i];var t;if(s.indexOf("px")>-1){t=parseInt(s,10);n-=t;this._calculatedSizes[i]=t;}else if(s.indexOf("%")>-1){p.push(i);}else if(h[i]=="auto"){o=j[i].getLayoutData();if(o&&parseInt(o.getMinSize(),10)!=0){m.push(i);}else{k.push(i);}}else{L.error("Illegal size value: "+h[i]);}}var w=false;if(n<0){w=true;n=0;}var P=p.length;for(i=0;i<P;++i){g=p[i];f=Math.floor((parseFloat(h[g])/100)*A);this._calculatedSizes[g]=f;n-=f;}A=n;if(A<0){w=true;A=0;}f=Math.floor(A/(m.length+k.length),0);var u=m.length;for(i=0;i<u;++i){g=m[i];var M=parseInt(j[g].getLayoutData().getMinSize(),10);if(M>f){this._calculatedSizes[g]=M;A-=M;}else{this._calculatedSizes[g]=f;A-=f;}}if(A<0){w=true;A=0;}n=A;var v=k.length;f=Math.floor(A/v,0);for(i=0;i<v;++i){g=k[i];this._calculatedSizes[g]=f;n-=f;}if(w){L.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}};b.prototype._switchOrientation=function(){this._bHorizontal=this.getOrientation()===O.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right";}else{this._sizeDir="left";}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left";}var t=this.$();t.toggleClass("sapUiLoSplitterH",this._bHorizontal);t.toggleClass("sapUiLoSplitterV",!this._bHorizontal);};b.prototype._onKeyboardResize=function(t,s,E){var B=this.getId()+"-splitbar-";if(!E||!E.target||!E.target.id||E.target.id.indexOf(B)!==0){return;}var i=999999;var f=parseInt(E.target.id.substr(B.length),10);var m=this.getCalculatedSizes();this._move.c1Size=m[f];this._move.c2Size=m[f+1];var g=0;switch(t){case"inc":g=s;break;case"incMore":g=s*10;break;case"dec":g=0-s;break;case"decMore":g=0-s*10;break;case"max":g=i;break;case"min":g=0-i;break;default:L.warn("[Splitter] Invalid keyboard resize type");break;}this._resizeContents(f,g,true);};b.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};b.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false;};b.prototype._getText=function(k,A){return(r?r.getText(k,A):k);};function _(s,f){if(s===f){return false;}if(!s||!f||s.length===undefined||f.length===undefined){return true;}if(s.length!=f.length){return true;}for(var i=0;i<s.length;++i){if(s[i]!==f[i]){return true;}}return false;}function d(t){var p=function(E){E.preventDefault();};var A=null;A=function(){document.removeEventListener("touchend",A);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",A);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",A);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",A);document.addEventListener("mousemove",p);}}function e(o){var f=o.getLayoutData();if(f&&(!f.getResizable||!f.getSize||!f.getMinSize)){L.warning("Content \""+o.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");f=null;}if(!f){o.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}b.prototype.invalidate=function(o){var f=(o&&this.indexOfContentArea(o)!=-1)||(o&&o instanceof sap.ui.core.CustomData&&o.getWriteToDom())||(o===undefined);if(f||this._needsInvalidation){this._needsInvalidation=false;C.prototype.invalidate.apply(this,arguments);}};b.prototype.setOrientation=function(o){var v=this.setProperty("orientation",o,true);this._switchOrientation();this._delayedResize();this.$().find(".sapUiLoSplitterBar").attr("aria-orientation",this._bHorizontal?"vertical":"horizontal");return v;};b.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",this.getProperty("width"));return this;};b.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",this.getProperty("height"));return this;};b.prototype.addContentArea=function(o){this._needsInvalidation=true;e(o);return this.addAggregation("contentAreas",o);};b.prototype.removeContentArea=function(o){this._needsInvalidation=true;return this.removeAggregation("contentAreas",o);};b.prototype.removeAllContentArea=function(){this._needsInvalidation=true;return this.removeAllAggregation("contentAreas");};b.prototype.destroyContentArea=function(){this._needsInvalidation=true;return this.destroyAggregation("contentAreas");};b.prototype.insertContentArea=function(o,i){this._needsInvalidation=true;e(o);return this.insertAggregation("contentAreas",o,i);};b.prototype._getContentAreas=function(){return this.getContentAreas();};return b;});
