/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Context','sap/ui/model/FilterType','sap/ui/model/ListBinding','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/Filter','sap/ui/model/odata/OperationMode','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterProcessor','sap/ui/model/Sorter','sap/ui/model/SorterProcessor',"sap/base/util/array/diff","sap/base/util/uid","sap/base/util/deepEqual","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery"],function(C,F,L,O,a,b,c,d,e,f,S,g,h,u,k,l,m,q){"use strict";var n=L.extend("sap.ui.model.odata.v2.ODataListBinding",{constructor:function(M,P,i,s,j,r){L.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.iLength=0;this.bPendingChange=false;this.aAllKeys=null;this.aKeys=[];this.sCountMode=(r&&r.countMode)||this.oModel.sDefaultCountMode;this.sOperationMode=(r&&r.operationMode)||this.oModel.sDefaultOperationMode;this.bCreatePreliminaryContext=(r&&r.createPreliminaryContext)||M.bPreliminaryContext;this.bUsePreliminaryContext=(r&&r.usePreliminaryContext)||M.bPreliminaryContext;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.bPendingRefresh=false;this.sGroupId=undefined;this.sRefreshGroupId=undefined;this.bLengthRequested=false;this.bUseExtendedChangeDetection=true;this.bFaultTolerant=r&&r.faultTolerant;this.bLengthFinal=false;this.iLastEndIndex=0;this.aLastContexts=null;this.aLastContextData=null;this.bInitial=true;this.mRequestHandles={};this.oCountHandle=null;this.bSkipDataEvents=false;this.bUseExpandedList=false;this.oCombinedFilter=null;this.oModel.checkFilterOperation(this.aApplicationFilters);if(r&&(r.batchGroupId||r.groupId)){this.sGroupId=r.groupId||r.batchGroupId;}this.iThreshold=(r&&r.threshold)||0;this.bThresholdRejected=false;if(this.sCountMode==a.None){this.bThresholdRejected=true;}var U=this.checkExpandedList();if(!U){this.resetData();}},metadata:{publicMethods:["getLength"]}});n.prototype.getContexts=function(s,j,t){if(this.bInitial){return[];}if(!this.bLengthFinal&&this.sOperationMode==c.Auto&&(this.sCountMode==a.Request||this.sCountMode==a.Both)){if(!this.bLengthRequested){this._getLength();this.bLengthRequested=true;}return[];}if(!this.bLengthFinal&&!this.bPendingRequest&&!this.bLengthRequested){this._getLength();this.bLengthRequested=true;}this.iLastLength=j;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0;}if(!j){j=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<j){j=this.iLength;}}if(!t){t=0;}if(this.sOperationMode==c.Auto){if(this.iThreshold>=0){t=Math.max(this.iThreshold,t);}}var r=true,v=this._getContexts(s,j),w=[],x;if(this.useClientMode()){if(!this.aAllKeys&&!this.bPendingRequest&&this.oModel.getServiceMetadata()){this.loadData();v.dataRequested=true;}}else{x=this.calculateSection(s,j,t,v);r=v.length!==j&&!(this.bLengthFinal&&v.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&x.length>0&&(r||j<x.length)){this.loadData(x.startIndex,x.length);v.dataRequested=true;}}}if(this.bRefresh){this.bRefresh=false;}else{for(var i=0;i<v.length;i++){w.push(this.getContextData(v[i]));}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){v.diff=h(this.aLastContextData,w);}}this.iLastEndIndex=s+j;this.aLastContexts=v.slice(0);this.aLastContextData=w.slice(0);}return v;};n.prototype.getCurrentContexts=function(){return this.aLastContexts||[];};n.prototype.getEntryKey=function(i){return i.getPath();};n.prototype.getEntryData=function(i){return JSON.stringify(i.getObject(this.mParameters));};n.prototype._getContexts=function(s,j){var r=[],t,K;if(!s){s=0;}if(!j){j=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<j){j=this.iLength;}}for(var i=s;i<s+j;i++){K=this.aKeys[i];if(!K){break;}t=this.oModel.getContext('/'+K);r.push(t);}return r;};n.prototype.calculateSection=function(s,r,t,v){var w,x,P,y,R,z={},K;x=s;w=0;for(var i=s;i>=Math.max(s-t,0);i--){K=this.aKeys[i];if(!K){y=i+1;break;}}for(var j=s+r;j<s+r+t;j++){K=this.aKeys[j];if(!K){P=j;break;}}R=s-y;if(y&&s>t&&R<t){if(v.length!==r){x=s-t;}else{x=y-t;}w=t;}x=Math.max(x,0);if(x===s){x+=v.length;}if(v.length!==r){w+=r-v.length;}R=P-s-r;if(R===0){w+=t;}if(P&&R<t&&R>0){if(x>s){x=P;w+=t;}}if(this.bLengthFinal&&this.iLength<(w+x)){w=this.iLength-x;}z.startIndex=x;z.length=w;return z;};n.prototype.setContext=function(i){var r,j=i&&i.bCreated,s=i&&i.isRefreshForced(),U=i&&i.isUpdated(),P=i&&i.isPreliminary();if(this.bInitial||!this.isRelative()){return;}if(P&&!this.bUsePreliminaryContext){return;}if(U&&this.bUsePreliminaryContext){this._fireChange({reason:d.Context});return;}if(C.hasChanged(this.oContext,i)){this.oContext=i;r=this.oModel.resolve(this.sPath,this.oContext);if(!this._checkPathType()){l.error("List Binding is not bound against a list for "+r);}if(!r||j){if(this.aAllKeys||this.aKeys.length>0||this.iLength>0){this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:d.Context});}return;}this._initSortersFilters();if(this.checkExpandedList()&&!s){this._fireChange({reason:d.Context});}else{this._refresh();}}};n.prototype.checkExpandedList=function(s){var r=!!this.oModel.resolve(this.sPath,this.oContext),R=this.oModel._getObject(this.sPath,this.oContext);if(!r||R===undefined||(this.sOperationMode===c.Server&&(this.aApplicationFilters.length>0||this.aFilters.length>0||this.aSorters.length>0))){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false;}else{this.bUseExpandedList=true;if(Array.isArray(R)){if(!s&&(this.oModel._isReloadNeeded("/"+R[0],this.mParameters)||this.oModel._isReloadNeeded("/"+R[R.length-1],this.mParameters))){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false;}this.aExpandRefs=R;this.aAllKeys=R;this.iLength=R.length;this.bLengthFinal=true;this.bDataAvailable=true;this.applyFilter();this.applySort();}else{this.aExpandRefs=undefined;this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true;}return true;}};n.prototype.updateExpandedList=function(K){if(this.aExpandRefs){for(var i=0;i<K.length;i++){this.aExpandRefs[i]=K[i];}this.aExpandRefs.length=K.length;}};n.prototype.useClientMode=function(){return(this.sOperationMode===c.Client||this.sOperationMode===c.Auto&&!this.bThresholdRejected||this.sOperationMode!==c.Server&&this.bUseExpandedList);};n.prototype.loadData=function(s,j){var t=this,I=false,G=u(),r;if(s||j){this.sRangeParams="$skip="+s+"&$top="+j;this.iStartIndex=s;}else{s=this.iStartIndex;}var P=[];if(this.sRangeParams&&!this.useClientMode()){P.push(this.sRangeParams);}if(this.sSortParams){P.push(this.sSortParams);}if(this.sFilterParams&&!this.useClientMode()){P.push(this.sFilterParams);}if(this.sCustomParams){P.push(this.sCustomParams);}if(this.sCountMode==a.InlineRepeat||!this.bLengthFinal&&(this.sCountMode===a.Inline||this.sCountMode===a.Both)){P.push("$inlinecount=allpages");I=true;}function v(D){if(I&&D.__count){t.iLength=parseInt(D.__count,10);t.bLengthFinal=true;if(t.sOperationMode==c.Auto){if(t.iLength<=t.mParameters.threshold){t.bThresholdRejected=false;}else{t.bThresholdRejected=true;delete t.mRequestHandles[G];t.bPendingRequest=false;t.bNeedsUpdate=true;return;}}}if(t.useClientMode()){t.aKeys=[];q.each(D.results,function(i,y){t.aKeys[i]=t.oModel._getKey(y);});t.updateExpandedList(t.aKeys);t.aAllKeys=t.aKeys.slice();t.iLength=t.aKeys.length;t.bLengthFinal=true;t.applyFilter();t.applySort();}else{if(D.results.length>0){q.each(D.results,function(i,y){t.aKeys[s+i]=t.oModel._getKey(y);});if(t.iLength<s+D.results.length){t.iLength=s+D.results.length;t.bLengthFinal=false;}if(!D.__next&&(D.results.length<j||j===undefined)){t.iLength=s+D.results.length;t.bLengthFinal=true;}}else{if(t.bFaultTolerant&&D.__next){t.iLength=s;t.bLengthFinal=true;}if(s===0){t.iLength=0;t.aKeys=[];t.bLengthFinal=true;}if(s===t.iLength){t.bLengthFinal=true;}}}delete t.mRequestHandles[G];t.bPendingRequest=false;t.bNeedsUpdate=true;t.bIgnoreSuspend=true;t.oModel.callAfterUpdate(function(){t.fireDataReceived({data:D});});}function E(i){var A=i.statusCode==0;delete t.mRequestHandles[G];t.bPendingRequest=false;if(t.bFaultTolerant){t.iLength=t.aKeys.length;t.bLengthFinal=true;t.bDataAvailable=true;}else if(!A){t.aKeys=[];t.aAllKeys=[];t.iLength=0;t.bLengthFinal=true;t.bDataAvailable=true;t._fireChange({reason:d.Change});}if(!t.bSkipDataEvents){t.fireDataReceived();}}var w=this.sPath,x=this.oContext;if(this.isRelative()){w=this.oModel.resolve(w,x);}if(w){this.bPendingRequest=true;if(!this.bSkipDataEvents){this.fireDataRequested();}this.bSkipDataEvents=false;r=this.sRefreshGroup?this.sRefreshGroup:this.sGroupId;this.mRequestHandles[G]=this.oModel.read(w,{groupId:r,urlParameters:P,success:v,error:E});}};n.prototype.isLengthFinal=function(){return this.bLengthFinal;};n.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength;}else{var A=this.iLastThreshold||this.iLastLength||10;return this.iLength+A;}};n.prototype._getLength=function(){var t=this;var G;if(this.sCountMode!==a.Request&&this.sCountMode!==a.Both){return;}var P=[];if(this.sFilterParams&&this.sOperationMode!=c.Auto){P.push(this.sFilterParams);}if(this.mParameters&&this.mParameters.custom){var i={custom:{}};q.each(this.mParameters.custom,function(r,v){i.custom[r]=v;});P.push(this.oModel.createCustomParams(i));}function _(D){t.iLength=parseInt(D,10);t.bLengthFinal=true;t.bLengthRequested=true;t.oCountHandle=null;if(t.sOperationMode==c.Auto){if(t.iLength<=t.mParameters.threshold){t.bThresholdRejected=false;}else{t.bThresholdRejected=true;}t._fireChange({reason:d.Change});}}function j(E){delete t.mRequestHandles[s];var r="Request for $count failed: "+E.message;if(E.response){r+=", "+E.response.statusCode+", "+E.response.statusText+", "+E.response.body;}l.warning(r);}var s=this.oModel.resolve(this.sPath,this.oContext);if(s){s=s+"/$count";G=this.sRefreshGroup?this.sRefreshGroup:this.sGroupId;this.oCountHandle=this.oModel.read(s,{withCredentials:this.oModel.bWithCredentials,groupId:G,urlParameters:P,success:_,error:j});}};n.prototype.refresh=function(i,G){if(typeof i==="string"){G=i;i=false;}this.sRefreshGroup=G;this._refresh(i);this.sRefreshGroup=undefined;};n.prototype._refresh=function(j,r,E){var s=false,t=this.isRelative()&&this.oContext&&this.oContext.bCreated;if(t){return;}this.bPendingRefresh=false;if(!j){if(E){var R=this.oModel.resolve(this.sPath,this.oContext);if(R){var v=this.oModel.oMetadata._getEntityTypeByPath(R);if(v&&(v.entityType in E)){s=true;}}}if(r&&!s){q.each(this.aKeys,function(i,K){if(K in r){s=true;return false;}});}if(!r&&!E){s=true;}}if(j||s){if(this.bSuspended&&!this.bIgnoreSuspend&&!j){this.bPendingRefresh=true;return;}this.abortPendingRequest(true);this.resetData();this._fireRefresh({reason:d.Refresh});}};n.prototype._fireRefresh=function(P){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",P);}};n.prototype._checkPathType=function(){var P=this.oModel.resolve(this.sPath,this.oContext);if(P){if(!this._mPathType||!this._mPathType[P]){this._mPathType={};var i=P.lastIndexOf("/");var t,E;if(i>1){E=this.oModel.oMetadata._getEntityTypeByPath(P.substring(0,i));if(E){t=this.oModel.oMetadata._getEntityAssociationEnd(E,P.substring(i+1));if(t&&t.multiplicity==="*"){this._mPathType[P]=true;}}}else if(i===0){var M,N=P.substring(1);M=this.oModel.oMetadata._findEntitySetByName(N);if(M){this._mPathType[P]=true;}}}return!!this._mPathType[P];}return true;};n.prototype.initialize=function(){var i=this.isRelative()&&this.oContext&&this.oContext.bCreated;if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.bInitial&&!i){if(!this._checkPathType()){l.error("List Binding is not bound against a list for "+this.oModel.resolve(this.sPath,this.oContext));}this.bInitial=false;this._initSortersFilters();if(!this.bSuspended){if(this.bDataAvailable){this._fireChange({reason:d.Change});}else{this._fireRefresh({reason:d.Refresh});}}}return this;};n.prototype.checkUpdate=function(i,j){var r=this.sChangeReason?this.sChangeReason:d.Change,s=false,t,v=this,w;if((this.bSuspended&&!this.bIgnoreSuspend&&!i)||this.bPendingRequest){return false;}this.bIgnoreSuspend=false;if(this.bPendingRequest){return;}if(!i&&!this.bNeedsUpdate){w=this.aExpandRefs;var x=this.aKeys.slice();var E=this.checkExpandedList(true);if(!E&&this.useClientMode()){this.applyFilter();this.applySort();}if(!k(w,this.aExpandRefs)){s=true;}else if(j){if(this.aKeys.length!==x.length){s=true;}else{for(var K in j){if(this.aKeys.indexOf(K)>-1||x.indexOf(K)>-1){s=true;break;}}}}else{s=true;}if(s&&this.aLastContexts){s=false;var y=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!==y.length){s=true;}else{q.each(this.aLastContextData,function(I,z){t=v.getContextData(y[I]);if(z!==t){s=true;return false;}});}}}if(i||s||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:r});}this.sChangeReason=undefined;};n.prototype.resetData=function(){this.aKeys=[];this.aAllKeys=null;this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;this.bLengthRequested=false;this.bThresholdRejected=false;if(this.sCountMode==a.None){this.bThresholdRejected=true;}};n.prototype.abortPendingRequest=function(A){if(!q.isEmptyObject(this.mRequestHandles)){this.bSkipDataEvents=true;q.each(this.mRequestHandles,function(P,r){r.abort();});if(A&&this.oCountHandle){this.oCountHandle.abort();}this.mRequestHandles={};this.bPendingRequest=false;}};n.prototype.getDownloadUrl=function(s){var P=[],i;if(s){P.push("$format="+encodeURIComponent(s));}if(this.sSortParams){P.push(this.sSortParams);}if(this.sFilterParams){P.push(this.sFilterParams);}if(this.sCustomParams){P.push(this.sCustomParams);}i=this.oModel.resolve(this.sPath,this.oContext);if(i){return this.oModel._createRequestUrl(i,null,P);}};n.prototype.sort=function(s,r){var i=false;this.bIgnoreSuspend=true;if(!s){s=[];}if(s instanceof S){s=[s];}this.aSorters=s;if(!this.useClientMode()){this.createSortParams(s);}if(!this.bInitial){this.addComparators(s,true);if(this.useClientMode()){if(this.aAllKeys){if(s.length==0){this.applyFilter();}else{this.applySort();}this._fireChange({reason:d.Sort});}else{this.sChangeReason=d.Sort;}}else{this.aKeys=[];this.abortPendingRequest(false);this.sChangeReason=d.Sort;this._fireRefresh({reason:this.sChangeReason});}this._fireSort({sorter:s});i=true;}if(r){return i;}else{return this;}};n.prototype.addComparators=function(E,s){var P,t,i=this.oEntityType,j;if(!i){l.warning("Cannot determine sort/filter comparators, as entitytype of the collection is unkown!");return;}E.forEach(function(r){if(r.aFilters){this.addComparators(r.aFilters);}else if(!r.fnCompare){P=this.oModel.oMetadata._getPropertyMetadata(i,r.sPath);t=P&&P.type;m(P,"PropertyType for property "+r.sPath+" of EntityType "+i.name+" not found!");j=O.getComparator(t);if(s){r.fnCompare=o(j);}else{r.fnCompare=j;p(t,r);}}}.bind(this));};function o(i){return function(v,V){if(v===V){return 0;}if(v===null){return-1;}if(V===null){return 1;}return i(v,V);};}function p(t,i){switch(t){case"Edm.Decimal":case"Edm.Int64":if(typeof i.oValue1=="number"){i.oValue1=i.oValue1.toString();}if(typeof i.oValue2=="number"){i.oValue2=i.oValue2.toString();}break;case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":if(typeof i.oValue1=="string"){i.oValue1=parseInt(i.oValue1,10);}if(typeof i.oValue2=="string"){i.oValue2=parseInt(i.oValue2,10);}break;case"Edm.Float":case"Edm.Single":case"Edm.Double":if(typeof i.oValue1=="string"){i.oValue1=parseFloat(i.oValue1);}if(typeof i.oValue2=="string"){i.oValue2=parseFloat(i.oValue2);}break;default:}}n.prototype.applySort=function(){var t=this,i;this.aKeys=g.apply(this.aKeys,this.aSorters,function(r,P){i=t.oModel.getContext('/'+r);return t.oModel.getProperty(P,i);});};n.prototype.createSortParams=function(s){this.sSortParams=O.createSortParams(s);};n.prototype.filter=function(i,s,r){var j=false;this.bIgnoreSuspend=true;if(!i){i=[];}if(i instanceof e){i=[i];}this.oModel.checkFilterOperation(i);if(s===F.Application){this.aApplicationFilters=i;}else{this.aFilters=i;}if(!this.aFilters||!Array.isArray(this.aFilters)){this.aFilters=[];}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)){this.aApplicationFilters=[];}this.convertFilters();this.oCombinedFilter=f.combineFilters(this.aFilters,this.aApplicationFilters);if(!this.useClientMode()){this.createFilterParams(this.oCombinedFilter);}if(!this.bInitial){this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters);if(this.useClientMode()){if(this.aAllKeys){this.applyFilter();this.applySort();this._fireChange({reason:d.Filter});}else{this.sChangeReason=d.Filter;}}else{this.resetData();this.abortPendingRequest(true);this.sChangeReason=d.Filter;this._fireRefresh({reason:this.sChangeReason});}if(s===F.Application){this._fireFilter({filters:this.aApplicationFilters});}else{this._fireFilter({filters:this.aFilters});}j=true;}if(r){return j;}else{return this;}};n.prototype.convertFilters=function(){this.aFilters=this.aFilters.map(function(i){return i instanceof b?i.convert():i;});this.aApplicationFilters=this.aApplicationFilters.map(function(i){return i instanceof b?i.convert():i;});};n.prototype.applyFilter=function(){var t=this,i;this.aKeys=f.apply(this.aAllKeys,this.oCombinedFilter,function(r,P){i=t.oModel.getContext('/'+r);return t.oModel.getProperty(P,i);});this.iLength=this.aKeys.length;};n.prototype.createFilterParams=function(i){this.sFilterParams=O.createFilterParams(i,this.oModel.oMetadata,this.oEntityType);};n.prototype._initSortersFilters=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oEntityType=this._getEntityType();this.addComparators(this.aSorters,true);this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters);this.convertFilters();this.oCombinedFilter=f.combineFilters(this.aFilters,this.aApplicationFilters);if(!this.useClientMode()){this.createSortParams(this.aSorters);this.createFilterParams(this.oCombinedFilter);}};n.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var E=this.oModel.oMetadata._getEntityTypeByPath(r);m(E,"EntityType for path "+r+" could not be found!");return E;}return undefined;};n.prototype.resume=function(){this.bIgnoreSuspend=false;this.bSuspended=false;if(this.bPendingRefresh){this._refresh();}else{this.checkUpdate();}};n.prototype.suspend=function(){if(this.bInitial){this.bPendingRefresh=true;}L.prototype.suspend.apply(this,arguments);};return n;});
