/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RenameHandler','sap/ui/rta/Utils','sap/ui/dt/ElementOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/OverlayUtil','sap/ui/dt/Util','sap/ui/fl/changeHandler/BaseTreeModifier','sap/ui/fl/Utils','sap/ui/fl/variants/VariantManagement','sap/ui/base/ManagedObject','sap/m/delegate/ValueStateMessage','sap/ui/rta/command/CompositeCommand',"sap/base/Log"],function(P,R,U,E,O,a,D,B,f,V,M,b,C,L){"use strict";E.prototype._variantManagement=undefined;E.prototype.getVariantManagement=function(){return this._variantManagement;};E.prototype.setVariantManagement=function(k){this._variantManagement=k;};E.prototype.hasVariantManagement=function(){return this._variantManagement?true:false;};var c=P.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string",variantManagementControlOverlay:{type:"any"}},associations:{},events:{}}});c.MODEL_NAME="$FlexVariants";c.prototype.registerElementOverlay=function(o){var d=o.getElement(),m=this._getVariantModel(d),v;P.prototype.registerElementOverlay.apply(this,arguments);if(!m){return;}if(d instanceof V){var A=d.getFor(),e;v=B.getSelector(d,f.getComponentForControl(d)).id;if(!A||(Array.isArray(A)&&A.length===0)){o.setVariantManagement(v);return;}if(!this._isPersonalizationMode()){m._setModelPropertiesForControl(v,true,d);m.checkUpdate(true);}e=!Array.isArray(A)?[A]:A;e.forEach(function(s){var g=s instanceof M?s:sap.ui.getCore().byId(s),h=O.getOverlay(g);this._propagateVariantManagement(h,v);}.bind(this));o.attachEvent("editableChange",R._manageClickEvent,this);}else if(!o.getVariantManagement()){v=this._getVariantManagementFromParent(o);if(v){o.setVariantManagement(v);o.attachEvent("editableChange",R._manageClickEvent,this);}}};c.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer==="USER";};c.prototype._propagateVariantManagement=function(p,v){var e=[];p.setVariantManagement(v);e=a.getAllChildOverlays(p);e.forEach(function(o){e=e.concat(this._propagateVariantManagement(o,v));}.bind(this));return e;};c.prototype._getVariantManagementFromParent=function(o){var v=o.getVariantManagement();if(!v&&o.getParentElementOverlay()){return this._getVariantManagementFromParent(o.getParentElementOverlay());}return v;};c.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);var m;var v;var d=o.getElement();if(d instanceof V){m=this._getVariantModel(d);v=o.getVariantManagement();m._setModelPropertiesForControl(v,false,d);m.checkUpdate(true);}this.removeFromPluginsList(o);P.prototype.deregisterElementOverlay.apply(this,arguments);};c.prototype._getVariantModel=function(e){var A=f.getAppComponentForControl(e,true);return A?A.getModel(c.MODEL_NAME):undefined;};c.prototype._isEditable=function(o){if(this._isPersonalizationMode()){return false;}return this._isVariantManagementControl(o);};c.prototype._isVariantManagementControl=function(o){var e=o.getElement();var A=e.getAssociation("for");return!!(A&&e instanceof V);};c.prototype.isVariantSwitchAvailable=function(e){return this._isVariantManagementControl(e);};c.prototype.isVariantSwitchEnabled=function(e){var o=e[0];var v=[];if(this._isVariantManagementControl(o)){var d=o.getElement(),s=o.getVariantManagement?o.getVariantManagement():undefined;if(!s){return false;}var m=this._getVariantModel(d);if(m){v=m.getData()[s].variants.reduce(function(r,h){if(h.visible){return r.concat(h);}else{return r;}},[]);}var g=v.length>1;return g;}else{return false;}};c.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};c.prototype.isRenameAvailable=function(e){return this._isVariantManagementControl(e);};c.prototype.isRenameEnabled=function(e){return this._isVariantManagementControl(e[0]);};c.prototype.isVariantDuplicateAvailable=function(e){return this._isVariantManagementControl(e);};c.prototype.isVariantDuplicateEnabled=function(e){var o=e[0];var v=o.getVariantManagement?o.getVariantManagement():undefined;if(!v||!this._isVariantManagementControl(o)){return false;}return true;};c.prototype.isVariantConfigureAvailable=function(e){return this._isVariantManagementControl(e);};c.prototype.isVariantConfigureEnabled=function(e){return this._isVariantManagementControl(e[0]);};c.prototype.switchVariant=function(t,n,s){var d=t.getDesignTimeMetadata(),T=t.getElement();this.getCommandFactory().getCommandFor(T,"switch",{targetVariantReference:n,sourceVariantReference:s},d).then(function(S){this.fireElementModified({"command":S});}.bind(this)).catch(function(m){throw D.createError("ControlVariant#switchVariant",m,"sap.ui.rta");});};c.prototype.renameVariant=function(e){var o=e[0];this.setVariantManagementControlOverlay(o);this.startEdit(o);};c.prototype.startEdit=function(v){var o=v.getElement(),d=v.getDesignTimeMetadata().getData().variantRenameDomRef;var e=o.getTitle();var p=e.getText();var h=R.startEdit.bind(this,{overlay:v,domRef:d,pluginMethodName:"plugin.ControlVariant.startEdit"});if(v._triggerDuplicate){var s=this._getVariantTitleForCopy(p,v.getVariantManagement(),this._getVariantModel(o).getData());o.getTitle().setText(s);v.attachEventOnce("geometryChanged",function(){h();},this);}else{h();}};c.prototype.stopEdit=function(r){if(this._oEditedOverlay._triggerDuplicate){this._oEditedOverlay.getElementInstance().getTitle().getBinding("text").refresh(true);if(!this._oEditedOverlay.hasStyleClass("sapUiRtaErrorBg")){delete this._oEditedOverlay._triggerDuplicate;}}R._stopEdit.call(this,r,"plugin.ControlVariant.stopEdit");};c.prototype.isBusy=function(){return this._bPreventMenu;};c.prototype._createDuplicateCommand=function(p){return this.getCommandFactory().getCommandFor(p.element,"duplicate",{sourceVariantReference:p.currentVariantReference,newVariantTitle:p.newVariantTitle},p.designTimeMetadata,p.variantManagementReference);};c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this),o=this._oEditedOverlay,d=o.getDesignTimeMetadata(),r=o.getElement(),m=this._getVariantModel(r),e,v=o.getVariantManagement(),T=this.getOldValue()!==t,n=T||o._triggerDuplicate,i=n?m._getVariantTitleCount(t,v):0,g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta"),s=m.getCurrentVariantReference(v);o.removeStyleClass("sapUiRtaErrorBg");if(this._oValueStateMessage){this._oValueStateMessage.getPopup().attachEventOnce("closed",function(){r.$().css("z-index",1);this._oValueStateMessage.destroy();delete this._oValueStateMessage;},this);this._oValueStateMessage.close();}if(t==='\xa0'){e="BLANK_ERROR_TEXT";}else if(i>0){e="DUPLICATE_ERROR_TEXT";}else if(n){return this._createSetTitleCommand({text:t,element:r,designTimeMetadata:d,variantManagementReference:v}).then(function(S){if(o._triggerDuplicate){return this._createDuplicateCommand({currentVariantReference:s,designTimeMetadata:d,variantManagementReference:v,element:r,newVariantTitle:this.getOldValue()}).then(function(j){return new C({commands:[j]});}).then(function(j){return T?j.addCommand(S):j;});}else{return S;}}.bind(this)).then(function(j){this.fireElementModified({"command":j});}.bind(this)).catch(function(j){throw D.createError("ControlVariant#_emitLabelChangeEvent",j,"sap.ui.rta");});}else{L.info("Control Variant title unchanged");return Promise.resolve();}if(e){var h=g.getText(e);this._prepareOverlayForValueState(o,h);o.addStyleClass("sapUiRtaErrorBg");return Promise.resolve(U._showMessageBox("ERROR","BLANK_DUPLICATE_TITLE_TEXT",e).then(function(){var j=function(){this._oValueStateMessage=new b(o);this._oValueStateMessage.getPopup().attachEventOnce("opened",function(k){k.getSource()._deactivateFocusHandle();});this._oValueStateMessage.open();this.startEdit(o);}.bind(this);return j;}.bind(this)));}};c.prototype._getVariantTitleForCopy=function(s,v,d){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var e=r.getText("VARIANT_COPY_SINGLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)");var g=r.getText("VARIANT_COPY_MULTIPLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)").replace("\\{1\\}","([0-9]+)");var h=new RegExp(e+"+");var i=new RegExp(g);var t;var I=g.lastIndexOf("(.*)")>g.lastIndexOf("([0-9]+)")?1:2;var j=(I===1)?2:1;var T=0;if(i.test(s)){t=i.exec(s)[j];}else{t=h.test(s)?h.exec(s)[1]:s;}var k=[];d[v].variants.forEach(function(o){if(o.visible){k=i.test(o.title)?i.exec(o.title):h.exec(o.title);if(!k){return;}if(k.length===3&&t===k[j]){T=k[I]?(parseInt(k[I],10)+1):T;}else if(k.length===2&&t===k[1]){T=T===0?1:T;}}});return T>0?r.getText("VARIANT_COPY_MULTIPLE_TEXT",[t,T]):r.getText("VARIANT_COPY_SINGLE_TEXT",[t]);};c.prototype._createSetTitleCommand=function(p){this._$oEditableControlDomRef.text(p.text);return this.getCommandFactory().getCommandFor(p.element,"setTitle",{newText:p.text},p.designTimeMetadata,p.variantManagementReference).catch(function(m){L.error("Error during rename : ",m);});};c.prototype._prepareOverlayForValueState=function(o,v){o.getValueState=function(){return"Error";};o.getValueStateText=function(){return v;};o.getDomRefForValueStateMessage=function(){return this.$();};};c.prototype.configureVariants=function(e){var o=e[0];var v=o.getElement();var s=o.getVariantManagement();var m=this._getVariantModel(v);var d=o.getDesignTimeMetadata();m.manageVariants(v,s,this.getCommandFactory().getFlexSettings().layer).then(function(g){return this.getCommandFactory().getCommandFor(v,"configure",{control:v,changes:g},d,s);}.bind(this)).then(function(g){this.fireElementModified({"command":g});}.bind(this)).catch(function(g){throw D.createError("ControlVariant#configureVariants",g,"sap.ui.rta");});};c.prototype.getMenuItems=function(e){var o=e[0];var m=[];if(this.isRenameAvailable(o)){m.push({id:"CTX_VARIANT_SET_TITLE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_RENAME'),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"});}if(this.isVariantDuplicateAvailable(o)){m.push({id:"CTX_VARIANT_DUPLICATE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_DUPLICATE'),handler:function(e){e[0]._triggerDuplicate=true;this.renameVariant(e);}.bind(this),enabled:this.isVariantDuplicateEnabled.bind(this),rank:220,icon:"sap-icon://duplicate"});}if(this.isVariantConfigureAvailable(o)){m.push({id:"CTX_VARIANT_MANAGE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_MANAGE'),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"});}if(this.isVariantSwitchAvailable(o)){var d=this._getVariantModel(o.getElement());var s=o.getVariantManagement();var S=d.getData()[s].variants.reduce(function(r,v){if(v.visible){var g=d.getData()[s].currentVariant===v.key;var i={id:v.key,text:v.title,icon:g?"sap-icon://accept":"blank",enabled:!g};return r.concat(i);}else{return r;}},[]);m.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),handler:function(e,p){var g=p.eventItem.data();var t=e[0];var n=g.key;var h=d.getData()[s].currentVariant;return this.switchVariant(t,n,h);}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:S,rank:240,icon:"sap-icon://switch-views"});}return m;};return c;},true);
