/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery",'sap/ui/base/ManagedObject','sap/m/Dialog','sap/m/Popover','sap/m/InstanceManager','sap/ui/core/Popup','sap/ui/dt/OverlayRegistry','sap/ui/dt/Overlay','sap/ui/dt/Util','sap/ui/fl/Utils','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/core/Element'],function(q,M,D,P,I,a,O,b,d,f,C,c,E){"use strict";var F={"add":"_activateFocusHandle","remove":"_deactivateFocusHandle"};var e=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});e.prototype.init=function(){this._oModalState=new Map();};e.prototype._overrideInstanceFunctions=function(){this._applyPopupMethods(this._createPopupOverlays);this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};e.prototype.getRelevantPopups=function(){var o,g;o=I.getOpenDialogs();g=I.getOpenPopovers();var r={aDialogs:this._getValidatedPopups(o),aPopovers:this._getValidatedPopups(g)};return r;};e.prototype._getValidatedPopups=function(o){o=o.filter(function(p){return this._isPopupAdaptable(p);}.bind(this));return(o.length>0)?o:false;};e.prototype._isComponentInsidePopup=function(p){return q.isArray(p.getContent())?p.getContent().some(function(o){if(o instanceof c){return this.oRtaRootAppComponent===this._getAppComponentForControl(sap.ui.getCore().getComponent(o.getComponent()));}}.bind(this)):false;};e.prototype._isSupportedPopup=function(p){return(p instanceof sap.m.Dialog||p instanceof sap.m.Popover);};e.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=sap.ui.getCore().byId(r.getRootControl());this.oRtaRootAppComponent=this._getAppComponentForControl(R);this._overrideInstanceFunctions();var m=this._onModeChange.bind(this);r.attachModeChanged(m);}};e.prototype._onModeChange=function(o){var n=o.getParameters().mode;var A=function(m,p){if(m==='navigation'){p.oPopup[this._getFocusEventName("add")]();p.oPopup.setModal(this._oModalState.get(p.oPopup));}else{p.oPopup[this._getFocusEventName("remove")]();p.oPopup.setModal(true);}};n==='navigation'?this._applyPatchesToOpenPopups(d.curry(A)(n)):this._removePatchesToOpenPopups(d.curry(A)(n));};e.prototype._applyPatchesToOpenPopups=function(g){this._applyPopupMethods(g,true);};e.prototype._removePatchesToOpenPopups=function(g){this._applyPopupMethods(g);};e.prototype._getFocusEventName=function(o){return F[o];};e.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};e.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){p.attachAfterOpen(this._createPopupOverlays,this);this.fireOpen(p);}return v;}.bind(this);};e.prototype._applyPopupMethods=function(p,g){var r=this.getRelevantPopups();Object.keys(r).forEach(function(k){if(r[k]){if(g){if(r[k][0].oPopup.oContent){r[k][0].oPopup.oContent.focus();}}r[k].forEach(function(o){p.call(this,o);}.bind(this));}}.bind(this));};e.prototype._applyPopupPatch=function(p){var o=b.getOverlayContainer();var g=p.oPopup;var A=[g.oContent.getDomRef(),o.get(0)].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){A.push(this.getRta().getToolbar().getDomRef());}g.setAutoCloseAreas(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=g.onAfterRendering;}g.onAfterRendering=function(){var v=this.fnOriginalPopupOnAfterRendering.apply(g,arguments);g[this._getFocusEventName("remove")]();return v;}.bind(this);this._oModalState.set(g,g.getModal());if(this.getRta().getMode()==='adaptation'){g[this._getFocusEventName("remove")]();g.setModal(true);}};e.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};e.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(p);this._oModalState.delete(p.oPopup);this.fireClose(p);}return v;}.bind(this);};e.prototype._getAppComponentForControl=function(o){var g,A;if(o instanceof C){g=o;}else{g=this._getComponentForControl(o);}if(g){A=f.getAppComponentForControl(g);}return A;};e.prototype._getComponentForControl=function(o){var g,r,p;if(o){g=C.getOwnerComponentFor(o);if(!g&&typeof o.getParent==="function"&&o.getParent()instanceof E){p=o.getParent();}else if(g){p=g;}if(p){r=this._getComponentForControl(p);}}return r?r:g;};e.prototype._createPopupOverlays=function(o){if(!o){return;}var p=(o instanceof E)?o:o.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};e.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyPatchesToOpenPopups(this._removePopupPatch);};e.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};e.prototype._isPopupAdaptable=function(p){if(p.isPopupAdaptationAllowed&&!p.isPopupAdaptationAllowed()){return false;}var o=this._getAppComponentForControl(p);return(this.oRtaRootAppComponent===o||this._isComponentInsidePopup(p))&&this._isSupportedPopup(p);};e.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;};return e;},true);
