/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/History","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader"],function(q,M,A,C,E,H,a,I,b,D,c,d,R){"use strict";var f=null;var m=null;var g=M.extend("sap.ui.support.Main",{constructor:function(){if(!m){var t=this;this._oCore=null;this._oAnalyzer=new A();this._oAnalyzer.onNotifyProgress=function(i){a.publish(c.ON_PROGRESS_UPDATE,{currentProgress:i});};M.apply(this,arguments);q.sap.support={analyze:function(o,r){if(R._rulesCreated){return m.analyze(o,r);}return R._oMainPromise.then(function(){return m.analyze(o,r);});},getLastAnalysisHistory:function(){var h=this.getAnalysisHistory();if(q.isArray(h)&&h.length>0){return h[h.length-1];}else{return null;}},getAnalysisHistory:function(){if(t._oAnalyzer.running()){return null;}return b.getHistory();},getFormattedAnalysisHistory:function(F){if(t._oAnalyzer.running()){return"";}return b.getFormattedHistory(F);}};var e=document.createEvent("CustomEvent");e.initCustomEvent("supportToolLoaded",true,true,{});}else{q.sap.log.warning("Only one support tool allowed");return m;}}});g.prototype._isInIframe=function(){try{return window.self!==window.top;}catch(e){return true;}};g.prototype.startPlugin=function(s){if(this._pluginStarted){return;}this._pluginStarted=true;var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t._supportModeConfig=s=s||o.getConfiguration().getSupportMode();t._setCommunicationSubscriptions();var F=t._isInIframe()&&s.indexOf("frame-force-ui")!==-1;t._oCore=o;t._oDataCollector=new D(o);t._oCoreFacade=C(o);t._oExecutionScope=null;t._createCoreSpies();o.attachLibraryChanged(R._onLibraryChanged);if(!s||s.indexOf("silent")===-1||F){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(e){f=e;f.injectFrame(s);a.onMessageChecks.push(function(h){return h.origin===f.getFrameOrigin();});a.onMessageChecks.push(function(h){return h.data._frameIdentifier===f.getFrameIdentifier();});a.onMessageChecks.push(function(h){var i=f.getFrameUrl();i=i.replace(/\.\.\//g,'');return h.data._origin.indexOf(i)>-1;});});}else{R.updateRuleSets(function(){t.fireEvent("ready");});}},stopPlugin:function(){f._stop();t._pluginStarted=false;t._oCore=null;t._oCoreFacade=null;t._oDataCollector=null;t._oExecutionScope=null;}});};g.prototype._createCoreSpies=function(){var t=this,n=500;this._fnDirtyTimeoutHandle=null;var s=function(N){var o=t._oCore[N];t._oCore[N]=function(){o.apply(t._oCore,arguments);clearTimeout(t._fnDirtyTimeoutHandle);t._fnDirtyTimeoutHandle=setTimeout(function(){a.publish(c.ON_CORE_STATE_CHANGE);},n);};};s("registerElement");s("deregisterElement");};g.prototype._setCommunicationSubscriptions=function(){if(this._supportModeConfig.indexOf("silent")<0){a.subscribe(c.OPEN_URL,function(u){var w=window.open(u,"_blank");w.focus();},this);a.subscribe(c.ON_DOWNLOAD_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(h){h.downloadReportZip(e);});},this);a.subscribe(c.HIGHLIGHT_ELEMENT,function(i){var $=sap.ui.getCore().byId(i).$();$.css("background-color","red");},this);a.subscribe(c.TREE_ELEMENT_MOUSE_ENTER,function(e){H.highlight(e);},this);a.subscribe(c.TREE_ELEMENT_MOUSE_OUT,function(){H.hideHighLighter();},this);a.subscribe(c.TOGGLE_FRAME_HIDDEN,function(h){f.toggleHide(h);},this);}a.subscribe(c.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version);},this);a.subscribe(c.GET_AVAILABLE_COMPONENTS,function(){a.publish(c.POST_AVAILABLE_COMPONENTS,Object.keys(this._oCore.mObjects.component));},this);a.subscribe(c.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.selectedRules);},this);a.subscribe(c.ON_INIT_ANALYSIS_CTRL,function(){R.updateRuleSets(function(){a.publish(c.POST_APPLICATION_INFORMATION,{versionInfo:sap.ui.getVersionInfo()});this.fireEvent("ready");}.bind(this));},this);a.subscribe(c.ON_SHOW_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(h){h.openReport(e);});},this);a.subscribe(c.LOAD_RULESETS,function(e){R.loadAdditionalRuleSets(e.aLibNames);},this);a.subscribe(c.REQUEST_RULES_MODEL,function(e){if(e){a.publish(c.GET_RULES_MODEL,I.getTreeTableViewModel(e));}},this);a.subscribe(c.REQUEST_ISSUES,function(i){if(i){var e=I.groupIssues(i),h=I.getIssuesViewModel(e);a.publish(c.GET_ISSUES,{groupedIssues:e,issuesModel:h});}},this);a.subscribe(c.GET_NON_LOADED_RULE_SETS,function(e){R.fetchNonLoadedRuleSets(e.loadedRulesets);},this);};g.prototype.analyze=function(e,r){var t=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return;}e=e||{type:"global"};r=r||R.getAllRuleDescriptors();if(!this._isExecutionScopeValid(e)){return;}a.publish(c.ON_ANALYZE_STARTED);if(e.selectors){this._mapExecutionScope(e);}this._oAnalyzer.reset();this.setExecutionScope(e);I.clearIssues();this._setSelectedRules(r);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){t._done();});};g.prototype._isExecutionScopeValid=function(e){var o=sap.ui.getCore(),s=[],h=false,i;if(E.possibleScopes.indexOf(e.type)===-1){q.sap.log.error("Invalid execution scope type. Type must be one of the following: "+E.possibleScopes.join(", "));return false;}if(e.type=="subtree"){if(e.parentId){s.push(e.parentId);}else if(q.isArray(e.selectors)){q.merge(s,e.selectors);}else if(e.selectors){s.push(e.selectors);}for(i=0;i<s.length;i++){if(o.byId(s[i])){h=true;break;}}if(!h){a.publish(c.POST_MESSAGE,{message:"Set a valid element ID."});return false;}}return true;};g.prototype.setExecutionScope=function(s){this._oExecutionScope=E(this._oCore,s);};g.prototype._setSelectedRules=function(r){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!r){return;}if(!Array.isArray(r)){r=[r];}r.forEach(function(o){var e,h;if(!o.libName||!o.ruleId){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return;}e=R.getRuleSet(o.libName);if(!e||!e.ruleset){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+o.libName);return;}h=e.ruleset.getRules();if(!h||!h[o.ruleId]){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+o.ruleId+" for library "+o.libName);return;}this._aSelectedRules.push(h[o.ruleId]);this._oSelectedRulesIds[o.ruleId]=true;},this);};g.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors;}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0];}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors];}else if(Array.isArray(e.selectors)){e.components=e.selectors;}}delete e.selectors;};g.prototype._done=function(){a.publish(c.ON_ANALYZE_FINISH,{issues:I.getIssuesModel(),elementTree:this._createElementTree(),elapsedTime:this._oAnalyzer.getElapsedTimeString()});b.saveAnalysis(this);};g.prototype._createElementTree=function(){var e=this._copyElementsStructure(),h=[];this._setContextElementReferences(e);for(var i in e){if(e[i].skip){continue;}h.push(e[i]);}return[{content:h,id:"WEBPAGE",name:"WEBPAGE"}];};g.prototype._setContextElementReferences=function(o){var e=this._oCore.mElements;for(var h in o){var i=o[h],p=e[h]==undefined?undefined:e[h].getParent();if(e[h]instanceof sap.ui.core.ComponentContainer){var j=e[h],k=j.getComponent();if(k){i.content.push(o[k]);o[k].skip=true;}}if(p){var l=p.getId();if(!o[l]){continue;}o[l].content.push(o[h]);o[h].skip=true;}}};g.prototype._copyElementsStructure=function(){var e={},t=this;var h=function(k,l){for(var i in k){if(k.hasOwnProperty(i)){var n=k[i];var o={content:[],id:n.getId(),name:(l==undefined)?n.getMetadata().getName():l};e[n.getId()]=o;}}};h(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(i){if(i instanceof sap.ui.core.ComponentContainer){var k=i.getComponent(),l=t._oCore.mObjects.component[k];if(l){h([l],"sap-ui-component");}}});switch(this._oExecutionScope._getType()){case"global":h(this._oCoreFacade.getUIAreas(),"sap-ui-area");h(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var p=this._oExecutionScope._getContext().parentId;h([this._oCore.mElements[p]]);break;case"components":var j=this._oExecutionScope._getContext().components;j.forEach(function(i){h([t._oCore.mObjects.component[i]],"sap-ui-component");});break;}return e;};g.prototype._getReportData=function(r){var i=I.groupIssues(I.getIssuesModel()),e=R.getRuleSets(),s=this._oSelectedRulesIds;return{issues:i,technical:this._oDataCollector.getTechInfoJSON(),application:this._oDataCollector.getAppInfo(),rules:I.getRulesViewModel(e,s,i),scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:r.executionScopes,executionScopeTitle:r.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:r.analysisDurationTitle,abap:b.getFormattedHistory(sap.ui.support.HistoryFormats.Abap),name:d.SUPPORT_ASSISTANT_NAME};};var m=new g();return m;},true);
