/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/HTML","sap/ui/core/ResizeHandler","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/ui/core/Icon","sap/ui/core/theming/Parameters","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/library","./ColorPickerRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/Global"],function(L,a,H,R,G,b,V,c,I,P,e,D,f,g,h,q){"use strict";var j=f.ValueState;var k=L.ColorPickerMode,l=L.ColorPickerDisplayMode;var m=a.extend("sap.ui.unified.ColorPicker",{metadata:{library:"sap.ui.unified",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:k.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:l.Default}},aggregations:{_grid:{type:"sap.ui.layout.Grid",group:"Appearance",multiple:false,visibility:"hidden"},_invisibleTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});var B="",s=sap.ui.resource('sap.ui.unified','img/ColorPicker/Alphaslider_BG.png'),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),o=L.ColorPickerHelper,F=o.factory,n={};Object.defineProperties(n,{RGB:{value:"RGB"},CPResponsiveClass:{value:"sapUnifiedColorPicker"},CPMatrixClass:{value:"sapUiColorPicker-ColorPickerMatrix"},HSLClass:{value:"sapUiColorPickerHSL"},LabelClass:{value:"sapUiColorPicker-ColorPickerLabels"},UnitLabelClass:{value:"sapUiCPUnitLabel"},HEXClass:{value:"sapUiColorPicker-ColorPickerHexField"},LeftColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsLeft"},RightColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsRight"},SliderClass:{value:"sapUiColorPicker-ColorPickerSlider"},AlphaSliderClass:{value:"sapUiColorPicker-ColorPickerAlphaSlider"},OutputSelectorClass:{value:"sapUiColorPickerHSL-RB"},OutputSelectorRowClass:{value:"sapUiColorPicker-RBRow"},CPBoxClass:{value:"sapUiColorPicker-ColorPickerBox"},CPCircleClass:{value:"sapUiColorPicker-ColorPickerCircle"},LastColumnClass:{value:"sapUiColorPicker-ColorPickerLastColumn"},HideForHSVClass:{value:"hideForHSV"},HideForHSLClass:{value:"hideForHSL"},OldColorClass:{value:"sapUiColorPicker-ColorPickerOldColor"},NewColorClass:{value:"sapUiColorPicker-ColorPickerNewColor"},SwatchesClass:{value:"sapUiColorPicker-swatches"},Colors:{value:{aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgrey:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkslategrey:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dimgrey:'696969',dodgerblue:'1e90ff',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',grey:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslategray:'778899',lightslategrey:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32',transparent:'00000000'}}});m.prototype.init=function(){if(D.browser.firefox){B="-moz-linear-gradient";}else if(D.browser.msie){B="-ms-linear-gradient";}else if(D.browser.webkit){B="-webkit-linear-gradient";}else{B="linear-gradient";}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:"#ffffff",old:"#ffffff"};this.sHexString="ffffff";this.$CPBox=null;this.$CPCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.data("sap-ui-fastnavgroup","true",true);this.bResponsive=o.isResponsive();var d=this.bResponsive?"_sap_ui_unified_ColorPicker_CircleSize":"_sap_ui_commons_ColorPicker_CircleSize";this._iCPCursorSize=parseInt(P.get(d),10);this._processChanges=this._processHSVChanges;this._bHSLMode=false;if(this.getDisplayMode()===l.Simplified){n.HideForDisplay.value=".hideDisplay";}this.bPressed=true;};var p=a.extend("sap.ui.unified._ColorPickerBox",{metadata:{events:{select:{parameters:{value:{type:"int"},saturation:{type:"int"}}},resize:{parameters:{size:{type:"int"}}}}},init:function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();},exit:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},getWidth:function(){return this.$().width();},getOffset:function(){return this.$().offset();},onBeforeRendering:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},onAfterRendering:function(){this._handle=this.$().find("> div."+n.CPCircleClass);this._sResizeListener=R.register(this.getDomRef(),this.handleResize.bind(this));},handleResize:function(E){this.fireResize({size:E.size.width});},getHandle:function(){return this._handle;},ontouchstart:function(E){this.handleTouch(E);},ontouchend:function(E){this.handleTouch(E);},ontouchmove:function(E){this.handleTouch(E);},handleTouch:function(E){var v=this.calculateValuesFromEvent(E);if(v){this.fireSelect(v);}},calculateValuesFromEvent:function(E){var x=E.offsetX,y=E.offsetY,i,d=i=this.getWidth(),t,O;E.preventDefault&&E.preventDefault();if(!x){t=E.targetTouches?E.targetTouches[0]:E;if(!t||!t.pageX){t=E;if((!t||!t.pageX)&&E.changedTouches){t=E.changedTouches[0];}}if(!t.pageX){return false;}O=this.getOffset();x=t.pageX-O.left;y=t.pageY-O.top;}x=Math.min(Math.max(x,0),d);y=Math.min(Math.max(y,0),i);if(this.bRtl){x=d-x;}return{value:x/d*100,saturation:(1-y/i)*100};},renderer:function(d,C){d.write("<div");d.addClass(n.CPBoxClass);d.writeControlData(C);d.writeClasses();d.write(">");d.write("<div");d.writeAttribute("id",C.getId()+"-cpCur");d.addClass(n.CPCircleClass);d.writeClasses();d.write("></div>");d.write("</div>");}});m.prototype._createRowFromInput=function(i,t,d,u){var T=r.getText(t),v;v=new c({content:[F.createLabel({text:d,tooltip:T,labelFor:i}).addStyleClass(n.LabelClass),i.setTooltip(T)]});if(u){v.addContent(F.createLabel({text:u,labelFor:i}).addStyleClass(n.UnitLabelClass).addStyleClass(n.LabelClass));}return v;};m.prototype._updateColorStringProperty=function(d,i){var t=this._getCSSColorString();this.setProperty('colorString',t,true);if(i){this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:t});}if(d){this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:t});}};m.prototype._handleCPBoxSelectEvent=function(E){var v=E.getParameter("value"),d=E.getParameter("saturation");this.oSatField.setValue(d);if(this._bHSLMode){this.oLitField.setValue(v);}else{this.oValField.setValue(v);}this._processChanges();this._updateColorStringProperty(false,true);};m.prototype._handleCPBoxResizeEvent=function(E){this._iCPBoxSize=E.getParameter("size");this._updateCursorPosition();};m.prototype._handleCPBoxTouchEndEvent=function(E){this._updateColorStringProperty(true,false);};m.prototype._createInteractionControls=function(){var i=this.getId(),d,A;this.oCPBox=new p(i+"-cpBox",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)});this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)});this.oHexField=F.createInput(i+"-hxF",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this)}).addStyleClass(n.HEXClass);this.oRedField=F.createInput(i+"-rF",{value:this.Color.r,change:this._handleRedValueChange.bind(this)}).addStyleClass(n.LeftColumnInputClass);this.oGreenField=F.createInput(i+"-gF",{value:this.Color.g,change:this._handleGreenValueChange.bind(this)}).addStyleClass(n.LeftColumnInputClass);this.oBlueField=F.createInput(i+"-bF",{value:this.Color.b,change:this._handleBlueValueChange.bind(this)}).addStyleClass(n.LeftColumnInputClass);this.oHueField=F.createInput(i+"-hF",{value:this.Color.h,change:this._handleHueValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oSatField=F.createInput(i+"-sF",{value:this.Color.s,change:this._handleSatValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oLitField=F.createInput(i+"-lF",{value:this.Color.l,change:this._handleLitValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oAlphaField=F.createInput(i+"-aF",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oAlphaFieldHSL=F.createInput(i+"-aFHSL",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oValField=F.createInput(i+"-vF",{value:this.Color.v,change:this._handleValValueChange.bind(this)}).addStyleClass(n.RightColumnInputClass);this.oRGBorHSLRBGroup=F.createRadioButtonGroup({columns:2,buttons:[F.createRadioButtonItem({text:n.RGB}),F.createRadioButtonItem({text:L.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)}).addStyleClass(n.OutputSelectorClass);if(this.bResponsive){this.oRGBorHSLRBUnifiedGroup=new sap.m.RadioButtonGroup({buttons:[new sap.m.RadioButton(),new sap.m.RadioButton()]});}d=new e({text:r.getText("COLORPICKER_HUE_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",d,true);this.oSlider=F.createSlider(i+"-hSLD",{max:360,step:1,tooltip:r.getText("COLORPICKER_HUE"),value:parseInt(this.oHueField.getValue(),10)}).addStyleClass(n.SliderClass).addAriaLabelledBy(d);this.oSlider.attachEvent("liveChange","liveChange",this._handleSliderChange.bind(this));this.oSlider.attachEvent("change","change",this._handleSliderChange.bind(this));A=new e({text:r.getText("COLORPICKER_ALPHA_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",A,true);this.oAlphaSlider=F.createSlider(i+"-aSLD",{max:1,value:1,step:0.01,tooltip:r.getText("COLORPICKER_ALPHA")}).addStyleClass(n.AlphaSliderClass).addAriaLabelledBy(A);this.oAlphaSlider.attachEvent("liveChange","liveChange",this._handleAlphaSliderChange.bind(this));this.oAlphaSlider.attachEvent("change","change",this._handleAlphaSliderChange.bind(this));};m.prototype._createLayout=function(){var i=this.getId(),d;if(this._bLayoutControlsCreated){return;}this._createInteractionControls();this.oCPBoxGD=new b({span:"L6 M6 S12"});this.icOne=new b({span:"L3 M3 S6"});this.icTwo=new b({span:"L3 M3 S6"});this.swatches=new b({span:"L3 M3 S12"});this.rbg=new b({span:"L6 M8 S12"});if(this.bResponsive){d=this._createUnifiedColorPicker(d,i);}else{d=this._createCommonsColorPicker(d,i);}this.setAggregation("_grid",d,true);this._bLayoutControlsCreated=true;this._adaptControlToLibrary();};m.prototype._adaptControlToLibrary=function(){var d;if(!this._bLayoutControlsCreated){return;}d=this.getAggregation("_grid");if(this.bResponsive){if(!D.system.phone&&!q('html').hasClass("sapUiMedia-Std-Phone")){d._setBreakPointTablet(400);}d.addStyleClass(n.CPResponsiveClass);}else{d.setProperty("hSpacing",0,true);d.setProperty("vSpacing",0,true);this.oCPBoxGD.setSpanS(5);this.icOne.setSpanS(4);this.icTwo.setSpanS(3);this.rbg.setSpanS(8);}};m.prototype._updateControlVisualState=function(){var d=this.getAggregation("_grid");if(!d){return;}if(this.bResponsive){if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanM(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanM(3).setLinebreak(false);}}else{if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanS(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanS(3).setLinebreak(false);}}};m.prototype._processChanges=function(){};m.prototype.setMode=function(M,S){this._bLayoutControlsCreated=false;switch(M){case L.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case L.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:h.error("Control must have a valid mode set to work correct");break;}this._bHSLMode=M===L.ColorPickerMode.HSL;return this.setProperty("mode",M,S);};m.prototype.setDisplayMode=function(d){this._bLayoutControlsCreated=false;return this.setProperty("displayMode",d,false);};m.prototype._cleanup=function(){var C=[this.getAggregation("_grid"),this.oCPBox,this.oHLayoutDefault,this.oHLayoutLarge,this.oHLayoutSwatches,this.oHexField,this.oRedField,this.oGreenField,this.oBlueField,this.oHueField,this.oSatField,this.oLitField,this.oAlphaField,this.oAlphaFieldHSL,this.oValField,this.oSlider,this.oAlphaSlider,this.oRGBorHSLRBGroup,this.oRGBorHSLRBUnifiedGroup,this.oLabelRGB,this.oLabelRGBA,this.oLabelHSL,this.oLabelHSV,this.oLabelHSLA,this.oLabelHSVA,this.oCPBoxGD,this.icOne,this.icTwo,this.rbg,this.swatches,this.comparissonFields,this.slidersComparissonFields,this.oSliderPhone,this.oAlphaSliderPhone];C.forEach(function(d){if(d){d.destroy();}},this);this._bLayoutControlsCreated=false;};m.prototype.exit=function(){this._cleanup();};m.prototype.onBeforeRendering=function(){this._cleanup();this._createLayout();this._updateControlVisualState();this._updateColorString();};m.prototype._updateColorString=function(){this._parseColorString(this.getColorString());this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);if(this.bResponsive){this.oRGBorHSLRBUnifiedGroup.setSelectedIndex(this.Color.formatHSL?1:0);}else{this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0);}}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oAlphaField.setValue(this.Color.a);}this._updateColorStringProperty(true,true);};m.prototype.isColor=function(C){return this._parseColorString(C,true);};m.prototype._handleSliderChange=function(E,d){var i=parseInt(this.oSlider.getValue(),10);this.oHueField.setValue(i);this._processChanges();this._updateColorStringProperty(d==="change",d==="liveChange");};m.prototype._handleAlphaSliderChange=function(E,d){this.Color.a=this.oAlphaSlider.getValue();if(this._bHSLMode){this.oAlphaField.setValue(this.Color.a);}if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(d==="change",d==="liveChange");};m.prototype._getValueInRange=function(v,M,i){if(isNaN(v)){v=0;}return Math.min(Math.max(v,M),i);};m.prototype._handleAlphaValueChange=function(){var d=parseFloat(this.oAlphaField.getValue(),10);d=this._getValueInRange(d,0,1);this.Color.a=d;this.oAlphaField.setValue(d);this.oAlphaSlider.setValue(d);if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(true,true);};m.prototype._handleRGBorHSLValueChange=function(){var u=this.oRGBorHSLRBUnifiedGroup;this.Color.formatHSL=u?u.getSelectedIndex()===1:this.oRGBorHSLRBGroup.getSelectedIndex()===1;this._updateColorStringProperty(true,true);};m.prototype._handleHueValueChange=function(){var d=parseInt(this.oHueField.getValue(),10);d=this._getValueInRange(d,0,360);this.oHueField.setValue(d);this.oSlider.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};m.prototype._handleSatValueChange=function(){var d=parseInt(this.oSatField.getValue(),10);d=this._getValueInRange(d,0,100);this.oSatField.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};m.prototype._handleValValueChange=function(){var v=parseInt(this.oValField.getValue(),10);v=this._getValueInRange(v,0,100);this.oValField.setValue(v);this._processHSVChanges();this._updateColorStringProperty(true,true);};m.prototype._handleLitValueChange=function(){var d=parseInt(this.oLitField.getValue(),10);d=this._getValueInRange(d,0,100);this.oLitField.setValue(d);this._processHSLChanges();this._updateColorStringProperty(true,true);};m.prototype._handleRedValueChange=function(){var d=parseInt(this.oRedField.getValue(),10);d=this._getValueInRange(d,0,255);this.oRedField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};m.prototype._handleGreenValueChange=function(){var d=parseInt(this.oGreenField.getValue(),10);d=this._getValueInRange(d,0,255);this.oGreenField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};m.prototype._handleBlueValueChange=function(){var d=parseInt(this.oBlueField.getValue(),10);d=this._getValueInRange(d,0,255);this.oBlueField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};m.prototype._processHSVChanges=function(){var d=parseInt(this.oHueField.getValue(),10);var i=parseInt(this.oSatField.getValue(),10);var v=parseInt(this.oValField.getValue(),10);this._calculateRGB(d,i,v);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=d;this.Color.s=i;this.Color.v=v;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};m.prototype._processHSLChanges=function(){var i=parseInt(this.oHueField.getValue(),10),S=parseInt(this.oSatField.getValue(),10),d=parseInt(this.oLitField.getValue(),10);if(i>360){i%=360;}this._calculateRGB(i,S,d);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=i;this.Color.s=S;this.Color.l=d;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};m.prototype._processRGBChanges=function(){var d=Math.round(parseInt(this.oRedField.getValue(),10)),i=Math.round(parseInt(this.oGreenField.getValue(),10)),t=Math.round(parseInt(this.oBlueField.getValue(),10)),u=(d+i+t)===765;this._calculateHEX(d,i,t);this.oHexField.setValue(this.sHexString);if(this._bHSLMode){this._calculateHSL(d,i,t);this.oLitField.setValue(this.Color.l);}else{if(!u){this._calculateHSV(d,i,t);}this.oValField.setValue(this.Color.v);}if(!u){this.oHueField.setValue(this.Color.h);}this.oSatField.setValue(this.Color.s);this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.Color.r=d;this.Color.g=i;this.Color.b=t;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};m.prototype._handleHexValueChange=function(){var d=this.oHexField.getValue().toLowerCase(),i=1,t;if(d.substr(0,1)==='#'){d=d.substr(1);}t=/^([0-9a-fA-F]{8})$/;if(t.test(d)!==false){i=Number((parseInt(d.substr(6,2),16)/255).toFixed(2));d=d.substr(0,6);}t=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(t.test(d)===false){this.oHexField.setValueState(j.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);if(this._bHSLMode){this.oLitField.setEnabled(false);this.oAlphaField.setEnabled(false);}else{this.oValField.setEnabled(false);}return;}else if(this.oHexField.getValueState()===j.Error){this.oHexField.setValueState(j.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);if(this._bHSLMode){this.oLitField.setEnabled(true);this.oAlphaField.setEnabled(true);}else{this.oValField.setEnabled(true);}}if(d.length===3){d=d.charAt(0)+d.charAt(0)+d.charAt(1)+d.charAt(1)+d.charAt(2)+d.charAt(2);}this._processHexChanges(d);this.oHexField.setValue(d);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(1);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.oAlphaSlider.setValue(i);this.Color.a=i;if(this._bHSLMode){this.oAlphaField.setValue(i);}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();this._updateColorStringProperty(true,true);};m.prototype._processHexChanges=function(d){this._convertRGB(d);if(this._bHSLMode){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b);}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b);}this.Color.hex="#"+d.toLowerCase();};m.prototype._updateAlphaBackground=function(){var d=[this.Color.r,this.Color.g,this.Color.b].join(","),i=B+"(left,rgba("+d+",0),rgba("+d+",1)),url("+s+")";if(this.lastAlphaSliderGradient!==i){this.oAlphaSlider.$().find(this.bResponsive?".sapMSliderInner":".sapUiSliBar").css("background-image",i);this.lastAlphaSliderGradient=i;}};m.prototype._updateCursorPosition=function(){var x,y;if(!this._iCPBoxSize){return;}if(this._bHSLMode){x=Math.round(this.oLitField.getValue()*this._iCPBoxSize/100.0);}else{x=Math.round(this.oValField.getValue()*this._iCPBoxSize/100.0);}if(sap.ui.getCore().getConfiguration().getRTL()){x=this._iCPBoxSize-x;}y=Math.round((1-this.oSatField.getValue()/100.0)*this._iCPBoxSize);x=Math.round(Math.max(x,0)-this._iCPCursorSize/2.0-1.0);y=Math.round(Math.max(y,0)-this._iCPCursorSize/2.0-1.0);this.$CPCur.css("left",x).css("top",y);};m.prototype._calculateRGB=function(d,S,v){var t,u,w,M,x,C,i;if(this._bHSLMode){this._calculateRGBAdvanced(d,S,v);return;}d%=360;d/=60;S/=100;v/=100;C=v*S;x=C*(1-Math.abs(d%2-1));M=v-C;t=0;u=0;w=0;i=Math.floor(d);switch(i){case 0:t=C;u=x;break;case 1:t=x;u=C;break;case 2:u=C;w=x;break;case 3:u=x;w=C;break;case 4:t=x;w=C;break;case 5:t=C;w=x;break;default:t=0;w=0;u=0;break;}this.RGB.r=Math.floor((t+M)*255);this.RGB.g=Math.floor((u+M)*255);this.RGB.b=Math.floor((w+M)*255);};m.prototype._calculateRGBAdvanced=function(d,S,t){var u,v,w,M,x,X,y,z,i;d=this._getValueInRange(d,0,360);d%=360;if(S>100){S=1;}else if(S<0){S=0;}else{S=S/100;}if(t>100){t=1;}else if(t<0){t=0;}else{t=t/100;}z=S*(1-Math.abs(2*t-1));y=255*(t-0.5*z);X=z*(1-Math.abs((d/60)%2-1));i=Math.floor(d/60);x=y+255*X;M=y+255*z;switch(i){case 0:u=M;v=x;w=y;break;case 1:u=x;v=M;w=y;break;case 2:u=y;v=M;w=x;break;case 3:u=y;v=x;w=M;break;case 4:u=x;v=y;w=M;break;case 5:u=M;v=y;w=x;break;default:u=0;v=0;w=0;break;}this.RGB.r=Math.round(u);this.RGB.g=Math.round(v);this.RGB.b=Math.round(w);};m.prototype._getCSSColorString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")";}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)";}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")";}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")";}};m.prototype._calculateHEX=function(i,d,t){var u=i.toString(16),v=d.toString(16),w=t.toString(16);if(u.length===1){u='0'+u;}if(v.length===1){v='0'+v;}if(w.length===1){w='0'+w;}this.sHexString=(u+v+w).toLowerCase();};m.prototype._calculateHSV=function(i,d,t){var u=Math.max(Math.max(i,d),t),v=Math.min(Math.min(i,d),t),w=u-v,x=Math.round(u*100/255),y=u===0.0?0:(100*w/u),z=0;if(y===0){z=0;}else if(i===u){z=60.0*(d-t)/w;}else if(d===u){z=120.0+60.0*(t-i)/w;}else if(t===u){z=240.0+60.0*(i-d)/w;}if(z<0.0){z+=359.9;}z=Math.round(z);y=Math.round(y);this.Color.h=z;this.Color.s=y;this.Color.v=x;};m.prototype._calculateHSL=function(i,t,u){var v=Math.max(i,t,u),w=Math.min(i,t,u),d=(v-w)/255,x=(v+w)/510,y=1-Math.abs(2*x-1),z=(x===0.0)?0:d/y,A=(y!==0)?z:0,E=0;x=Math.round(x*100);A=Math.round(A*100);if(x===0||A===0||(i+t+u===765)){E=0;}else{var C=v-w;if(v===i){E=((t-u)/C)%6;}if(v===t){E=(u-i)/C+2;}if(v===u){E=(i-t)/C+4;}if(C===0){E=0;}E*=60;if(E<0){E+=360;}}if(E!==0||this.Color.h!==360){this.Color.h=Math.round(E);}this.Color.s=A;this.Color.l=x;};m.prototype._convertRGB=function(d){this.Color.r=parseInt(d.substr(0,2),16);this.Color.g=parseInt(d.substr(2,2),16);this.Color.b=parseInt(d.substr(4,2),16);};m.prototype._updateGradientBoxBackground=function(i){if(this._bHSLMode){this._calculateRGBAdvanced(i,100,50);}else{this._calculateRGB(i,100,100);}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$CPBox.css('background-color','rgb('+[this.RGB.r,this.RGB.g,this.RGB.b].join(",")+')');};m.prototype._updateSelColorBackground=function(){this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',this._getCSSColorString());};m.prototype._parseColorString=function(C,d){var i;if(C.substr(0,1)==='#'){C=C.substr(1);}C=C.trim().toLowerCase();i=this._parseColorName(C);if(i){if(d){return true;}if(i.length===8){this.Color.a=this.Color.oldA=Number((parseInt(i.substr(6,2),16)/255).toFixed(2));i=i.substring(0,6);}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(C)){if(d){return true;}if(C.length===3){i=C[0]+C[0]+C[1]+C[1]+C[2]+C[2];}else{i=C;}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(C.substr(0,3)==='rgb'){return this._parseRGB(C,d);}if(this._bHSLMode){return this._parseHSL(C,d);}else if(C.substr(0,3)==='hsv'){return this._parseHSV(C,d);}return false;};m.prototype._parseHSV=function(C,d){var i=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),)(((\d{1,2})|(100)),)((\d{1,2})|(100))$/,t,u,S,v;C=C.substr(3).replace("(",'').replace(")",'').split(' ').join('');if(i.test(C)===true){if(d){return true;}t=C.split(",");u=parseInt(t[0],10);S=parseInt(t[1],10);v=parseInt(t[2],10);this._calculateRGB(u,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=u;this.Color.s=S;this.Color.v=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;return true;}return false;};m.prototype._parseHSL=function(C,d){var i,t=C.substr(0,4),u,v,S,w,A;if(t==="hsla"){u=true;}else if(t==="hsl("){u=false;}else{return false;}C=C.substr(u?4:3).replace("(",'').replace(")",'').split(' ').join('');i=C.split(",");v=parseInt(i[0],10);S=parseFloat(i[1]);w=parseFloat(i[2]);if(u){A=parseFloat(i[3]);}else{if(i[3]&&parseFloat(i[3])>=0){return false;}A=1;}S=(S<1&&S>0)?S*100:S;w=(w<1&&w>0)?w*100:w;if((v>=0&&v<=360)&&(S>=0&&S<=100)&&(w>=0&&w<=100)&&(A>=0&&A<=1)){if(d){return true;}this._calculateRGB(v,S,w);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=v;this.Color.s=S;this.Color.l=w;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.oldA=A;this.Color.formatHSL=true;}else{return false;}return true;};m.prototype._parseRGB=function(C,d){var v,i,t,u;i=C.substring(0,4);if(i==="rgba"){u=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),)([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1])$/;t=true;}else if(i.substring(0,3)==="rgb"){u=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])))$/;t=false;}else{return false;}C=C.substr(t?4:3).replace("(",'').replace(")",'').split(' ').join('');if(u.test(C)){if(d){return true;}v=C.split(",");this._calculateHEX(parseInt(v[0],10),parseInt(v[1],10),parseInt(v[2],10));this._processHexChanges(this.sHexString);this.Color.old=this.Color.hex;if(t){this.Color.a=this.Color.oldA=parseFloat(v[3]);}return true;}if(this._bHSLMode){this.Color.formatHSL=false;}return false;};m.prototype._parseColorName=function(C){return n.Colors[C];};m.prototype.onAfterRendering=function(){var d=this._getCSSColorString(),i=this.getParent();this.$CPBox=this.oCPBox.$();this.$CPCur=this.oCPBox.getHandle();this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',d);this.$().find(".sapUiColorPicker-ColorPickerOldColor").css('background-color',d);this._updateGradientBoxBackground(this.Color.h);this._iCPBoxSize=this.oCPBox.getWidth();this._updateCursorPosition();if(this._bHSLMode){this._updateAlphaBackground();}this.oSlider.iShiftGrip=Math.round(q(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(q(this.oAlphaSlider.oGrip).outerWidth()/2);if(i&&i.getMetadata().getName()==="sap.m.Dialog"){i.addStyleClass("colorPickerDialog");}};m.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b};};m.prototype._getConstants=function(){return n;};m.prototype._createCommonsColorPicker=function(d,i){d=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this.oCPBoxGD),new V({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED","R:"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN","G:"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE","B:"),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","#:")],layoutData:this.icOne}),new V({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE","H:"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","S:","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","L:","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","A:").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE","V:").addStyleClass(n.HideForHSLClass)],layoutData:this.icTwo}).addStyleClass(n.LastColumnClass),new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")})],layoutData:this.swatches}).addStyleClass(n.SwatchesClass),new c({content:[F.createLabel({text:"Output:",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this.rbg}).addStyleClass(n.HideForHSVClass).addStyleClass(n.OutputSelectorRowClass),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})),this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12"}))]}).addStyleClass(n.CPMatrixClass);return d;};m.prototype._createUnifiedColorPicker=function(d,i){var t=this.getDisplayMode(),C;this.oLabelRGB=F.createLabel({text:"R G B"});this.oLabelRGBA=F.createLabel({text:"R G B A"});this.oLabelHSL=F.createLabel({text:"H S L"});this.oLabelHSV=F.createLabel({text:"H S V"});this.oLabelHSLA=F.createLabel({text:"H S L A"});this.oLabelHSVA=F.createLabel({text:"H S V A"});this.oLabelRGB.addStyleClass("colorModeLabels");this.oLabelRGBA.addStyleClass("colorModeLabels");this.oLabelHSL.addStyleClass("colorModeLabels");this.oLabelHSV.addStyleClass("colorModeLabels");this.oLabelHSLA.addStyleClass("colorModeLabels");this.oLabelHSVA.addStyleClass("colorModeLabels");C=new V({content:[new c({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED").addStyleClass("noMargin"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE"),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin")]}),new c({content:[this.oLabelRGBA]}),new c({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE",""," ").addStyleClass("noMargin"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE",""," ").addStyleClass(n.HideForHSLClass),this._createRowFromInput(this.oAlphaFieldHSL,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin")]}).addStyleClass("defaultPickerDisplayNone"),new c({content:[this.oLabelHSLA.addStyleClass(n.HideForHSVClass),this.oLabelHSVA.addStyleClass(n.HideForHSLClass)]}).addStyleClass("defaultPickerDisplayNone")]});this.oHLayoutDefault=new c({content:[C,new V({content:new sap.m.Button(i+"-toggleMode",{type:D.system.phone?"Default":"Transparent",tooltip:"Toggle color mode",icon:"sap-icon://source-code",press:function(E){this.bPressed=!this.bPressed;C.getContent()[0].toggleStyleClass("defaultPickerDisplayNone",this.bPressed);C.getContent()[1].toggleStyleClass("defaultPickerDisplayNone",this.bPressed);C.getContent()[2].toggleStyleClass("defaultPickerDisplayNone",!this.bPressed);C.getContent()[3].toggleStyleClass("defaultPickerDisplayNone",!this.bPressed);}})})],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass("colors");this.comparissonFields=new V({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")})]}).addStyleClass("comparisonFields");this.slidersComparissonFields=new c({content:[new V({content:[this.oSlider.setLayoutData(this.oSliderPhone=new b({span:"L6 M6 S12",linebreak:true})),t!==l.Simplified?this.oAlphaSlider.setLayoutData(this.oAlphaSliderPhone=new b({span:"L6 M6 S12",linebreak:true})):this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","").addStyleClass("simplifiedHex"),t==l.Simplified?new c({content:[F.createLabel({text:"Hex"})]}):null]}).addStyleClass("phoneSliders"),this.comparissonFields]}).addStyleClass("phoneContent");if(D.system.phone&&!q('html').hasClass("sapUiMedia-Std-Tablet")){d=new G({content:[this.oCPBox.setLayoutData(this.oCPBoxGD).addStyleClass("sapUiColorPickerCPBoxGrid")]}).addStyleClass(n.CPMatrixClass).addStyleClass("phoneGrid");if(t!==l.Large){d.addContent(this.slidersComparissonFields);}else{d.addContent(this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})));d.addContent(this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})));d.addContent(new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")}),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","Hex")],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass(n.SwatchesClass));d.addContent(this.oHLayoutLarge=new c({content:[new V({content:[this.oRGBorHSLRBUnifiedGroup]}),new V({content:[new c({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE")]}),new c({content:[this.oLabelRGB]}),new c({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE",""," "),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE").addStyleClass(n.HideForHSLClass)]}),new c({content:[this.oLabelHSL.addStyleClass(n.HideForHSVClass),this.oLabelHSV.addStyleClass(n.HideForHSLClass)]})]}),new V({content:[this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin"),F.createLabel({text:"A"}).addStyleClass("labelA")]})],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass("colors"));}if(t!==l.Simplified&&t!==l.Large){d.addContent(this.oHLayoutDefault);}}else{d=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this.oCPBoxGD).addStyleClass("sapUiColorPickerCPBoxGrid"),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true}))]}).addStyleClass(n.CPMatrixClass);if(t!==l.Simplified){d.addContent(this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})));}d.addContent(this.oHLayoutSwatches=new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")}),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","Hex")],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass(n.SwatchesClass));if(t===l.Default){d.addContent(this.oHLayoutDefault);}if(t===l.Large){d.addContent(this.oHLayoutLarge=new c({content:[new V({content:[this.oRGBorHSLRBUnifiedGroup]}),new V({content:[new c({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE")]}),new c({content:[this.oLabelRGB]}),new c({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE",""," "),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE").addStyleClass(n.HideForHSLClass)]}),new c({content:[this.oLabelHSL.addStyleClass(n.HideForHSVClass),this.oLabelHSV.addStyleClass(n.HideForHSLClass)]})]}),new V({content:[this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","").addStyleClass("hsvMargin"),F.createLabel({text:"A"}).addStyleClass("labelA")]})],layoutData:new b({span:"L6 M8 S12",linebreak:true})}).addStyleClass("colors"));}}return d;};return m;});
