/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/commons/ListBox','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./library',"./ExactListRenderer",'jquery.sap.dom'],function(q,L,C,P,a,l,E){"use strict";var b=C.extend("sap.ui.ux3.ExactList",{metadata:{library:"sap.ui.ux3",properties:{showClose:{type:"boolean",group:"Misc",defaultValue:false},topTitle:{type:"string",group:"Misc",defaultValue:null},topHeight:{type:"int",group:"Appearance",defaultValue:290}},aggregations:{subLists:{type:"sap.ui.ux3.ExactList",multiple:true,singularName:"subList"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},associations:{data:{type:"sap.ui.ux3.ExactAttribute",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}}}}});(function(){L.extend("sap.ui.ux3.ExactList.LB",{init:function(){L.prototype.init.apply(this,arguments);this.setAllowMultiSelect(true);this.setDisplayIcons(true);this.addStyleClass("sapUiUx3ExactLstLb");},invalidate:function(){L.prototype.invalidate.apply(this,arguments);if(!this.bInvalidated&&this.getParent()){this.getParent().invalidate();}this.bInvalidated=true;},_handleUserActivation:function(i){i.metaKey=true;L.prototype._handleUserActivation.apply(this,[i]);},onclick:function(i){L.prototype.onclick.apply(this,arguments);this.getParent().onclick(i);},onAfterRendering:function(){L.prototype.onAfterRendering.apply(this,arguments);this.bInvalidated=false;var s=this.getParent();var G=this.getItems();var I=s._isTop();var H=false;for(var i=0;i<G.length;i++){var J=G[i];var K=sap.ui.getCore().byId(J.getKey());var M=J.$();H=false;if(I||(!K||!K.getShowSubAttributesIndicator_Computed())){M.addClass("sapUiUx3ExactLstNoIco");H=I;}else{H=true;}if(H&&!I){M.attr("aria-label",s._rb.getText(M.hasClass("sapUiLbxISel")?"EXACT_LST_LIST_ITEM_SEL_ARIA_LABEL":"EXACT_LST_LIST_ITEM_ARIA_LABEL",[J.getText()]));}}var N=s._bRTL?"left":"right";q(".sapUiLbxITxt",this.getDomRef()).css("margin-"+N,20+q.sap.scrollbarSize().width+"px");q(".sapUiLbxIIco",this.getDomRef()).css(N,5+q.sap.scrollbarSize().width+"px");q(this.getDomRef()).attr("tabindex","-1");var O;if(I){O=s.getTopTitle();}else{O=s._rb.getText("EXACT_LST_LIST_ARIA_LABEL",[s._iLevel,s._getAtt().getText()]);}q(this.getFocusDomRef()).attr("aria-label",O).attr("aria-expanded","true");this.oItemNavigation.iActiveTabIndex=-1;this.oItemNavigation.setSelectedIndex(-1);this.oItemNavigation.onsapnext=function(Q){if(Q.keyCode!=q.sap.KeyCodes.ARROW_DOWN){return;}sap.ui.core.delegate.ItemNavigation.prototype.onsapnext.apply(this,arguments);};this.oItemNavigation.onsapprevious=function(Q){if(Q.keyCode!=q.sap.KeyCodes.ARROW_UP){return;}sap.ui.core.delegate.ItemNavigation.prototype.onsapprevious.apply(this,arguments);};},renderer:"sap.ui.commons.ListBoxRenderer"});b.prototype.init=function(){var i=this;this._iLevel=0;this._bCollapsed=false;this._bIsFirstRendering=true;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._lb=new b.LB(this.getId()+"-lb",{select:function(s){p(i);var K=s.getParameter("selectedItem").getKey();var G=sap.ui.getCore().byId(K);var S=s.getParameter("selectedIndex");if(i._lb.isIndexSelected(S)){G.setProperty("selected",true,true);var H=z(i,G);if(H){var I=h(i,G);if(I<0){i.addSubList(H);}else{i.insertSubList(H,I);}}}else{A(i,G,S);}D(i)._selectionChanged(G);}});this.addAggregation("controls",this._lb);this._closeHandle=q.proxy(this.onForceVerticalClose,this);};b.prototype.exit=function(){if(this.bIsDestroyed){return;}B(this);this._lb.removeAllItems();this._lb=null;this._closeHandle=null;this._scrollCheckHandle=null;this._rb={getText:function(){return"";}};this._oTopList=null;if(this._dirtyListsCleanupTimer){q.sap.clearDelayedCall(this._dirtyListsCleanupTimer);this._dirtyListsCleanupTimer=null;this._dirtyLists=null;}};b.prototype.getFocusDomRef=function(){if(this._isTop()&&this.$().hasClass("sapUiUx3ExactLstTopHidden")){return this.getDomRef("foc");}return this._bCollapsed?this.getDomRef("head"):this._lb.getFocusDomRef();};b.prototype.onBeforeRendering=function(){this._oTopList=null;if(!this._bIsFirstRendering){return;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();if(!this._isTop()){this._bCollapsed=true;this._oCollapseStyles={"cntnt":"margin-"+(this._bRTL?"right":"left")+":"+a.get("sapUiUx3ExactLstCollapseWidth")+";border-top-width:0px;","lst":"width:0px;"};}else{this._bIsFirstRendering=false;}};b.prototype.onAfterRendering=function(){var i=this;var I=this._isTop();if(!this._iCurrentWidth){this._iCurrentWidth=this._getAtt().getWidth();}if(I){this._iScrollWidthDiff=-1;this.onCheckScrollbar();this.$("lst").css("bottom",q.sap.scrollbarSize().height+"px");this.$("cntnt").bind("scroll",function(s){if(s.target.id===i.getId()+"-cntnt"&&s.target.scrollTop!=0){s.target.scrollTop=0;}});}if(!this._bCollapsed){n(this,this._iCurrentWidth);}p(this);if(this._bIsFirstRendering){this._bIsFirstRendering=false;v(this,false,null,true);}else{r(this);w(this);}if(this._bRefreshList){this._bRefreshList=false;setTimeout(function(){i._lb.invalidate();},0);}};b.prototype.onfocusin=function(i){if(i.target===this.getDomRef()){this.getFocusDomRef().focus();}var $=this.$("head");if(this._isTop()){$.attr("tabindex","-1");this.$("foc").attr("tabindex","-1");if(!d(this)&&i.target===$[0]){this.getFocusDomRef().focus();}if(this.$().hasClass("sapUiUx3ExactLstTopHidden")&&i.target===this.getDomRef("foc")){var s=this.getSubLists();if(s.length>0){s[0].getFocusDomRef().focus();}}}if(!i.__exactHandled){$.addClass("sapUiUx3ExactLstHeadFocus");i.__exactHandled=true;}};b.prototype.onfocusout=function(i){var $=this.$("head");if(this._isTop()){$.attr("tabindex","0");this.$("foc").attr("tabindex","0");}$.removeClass("sapUiUx3ExactLstHeadFocus");};b.prototype.onclick=function(i){var s=this._lb.getScrollTop();if(q(i.target).attr("id")==this.getId()+"-exp"){x(this);this.focus();i.stopPropagation();}else if(q(i.target).attr("id")==this.getId()+"-close"){y(this);}else if(q(i.target).attr("id")==this.getId()+"-hide"){v(this,!this._bCollapsed,i);}else if(this._isTop()&&d(this)&&q.sap.containsOrEquals(this.$("head")[0],i.target)){f(this,i,false);return;}else if(!q.sap.containsOrEquals(this.$("cntnt")[0],i.target)){this.focus();}this._lb.setScrollTop(s);};b.prototype.onkeydown=function(i){function _(i,T){if(q(T).hasClass("sapUiUx3ExactLstFoc")){return;}if(T){T.focus();}i.preventDefault();i.stopPropagation();}switch(i.keyCode){case q.sap.KeyCodes.ENTER:case q.sap.KeyCodes.SPACE:if(this._isTop()&&d(this)&&q.sap.containsOrEquals(this.$("head")[0],i.target)){f(this,i,true);}break;case q.sap.KeyCodes.DELETE:if(!this._isTop()&&this.getShowClose()){y(this);_(i,this.getParent().getFocusDomRef());}break;case q.sap.KeyCodes.NUMPAD_MINUS:if(i.shiftKey){if(!this._bCollapsed){n(this,this._iCurrentWidth-10);_(i);}}else if(!this._bCollapsed){v(this,true,i);}break;case q.sap.KeyCodes.NUMPAD_PLUS:if(i.shiftKey){if(!this._bCollapsed){n(this,this._iCurrentWidth+10);_(i);}}else if(this._bCollapsed){v(this,false,i);}break;case q.sap.KeyCodes.TAB:if(this._iLevel==0){var H=d(this);if(!i.shiftKey&&H&&q.sap.containsOrEquals(this.$("head")[0],i.target)){_(i,this.getFocusDomRef());}else if(q.sap.containsOrEquals(this.getFocusDomRef(),i.target)){if(i.shiftKey&&H){_(i,this.$("head")[0]);}else if(!i.shiftKey){var s=c(this);if(s){_(i,s.getFocusDomRef());}}}return;}if(this._iLevel==1){var s=null;if(i.shiftKey){if(q.sap.containsOrEquals(this.$("cntnt")[0],i.target)){s=this;}else{s=g(this);}}else{s=c(this);}if(s){_(i,s.getFocusDomRef());}i.stopPropagation();}break;case q.sap.KeyCodes.ARROW_LEFT:case q.sap.KeyCodes.ARROW_RIGHT:var s=null;if(this._iLevel>=1){if((this._bRTL&&i.keyCode===q.sap.KeyCodes.ARROW_LEFT)||(!this._bRTL&&i.keyCode===q.sap.KeyCodes.ARROW_RIGHT)){s=c(this,true);}else{s=g(this,true);}if(s){_(i,s.getFocusDomRef());}i.stopPropagation();}break;}};b.prototype.onmousedown=function(i){if(i.target.id===this.getId()+"-rsz"){q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiUx3ExactLstRSzGhost\" style =\" z-index:"+P.getNextZIndex()+"\" ></div>");q(document.body).bind("selectstart."+this.getId(),o);var H=!!sap.ui.Device.browser.internet_explorer?q(document.body):this.$("ghost");H.bind("mouseup."+this.getId(),q.proxy(m,this)).bind("mousemove."+this.getId(),q.proxy(k,this));this._iStartDragX=i.pageX;this._iStartWidth=this.$("lst").width();this.$("rsz").addClass("sapUiUx3ExactLstRSzDrag");}};b.prototype.onForceVerticalClose=function(i){if(i.type=="mousedown"||i.type=="click"||i.type=="dblclick"||i.type=="focusin"||i.type=="focusout"||i.type=="keydown"||i.type=="keypress"||i.type=="keyup"||i.type=="mousedown"||i.type=="mouseup"){var R=this.$("lst");if(!q.sap.containsOrEquals(R[0],i.target)||i.target.tagName=="BODY"){if(R.hasClass("sapUiUx3ExactLstExpanded")){this._oPopup.close(true);}}}};b.prototype.onCheckScrollbar=function(i){this._scrollCheckTimer=null;var s=this.$("cntnt");var G=s[0];if(G){var N=G.scrollWidth-G.clientWidth;if(this._iScrollWidthDiff!=N){this._iScrollWidthDiff=N;if(N<=0){s.css({"overflow-x":"hidden","bottom":q.sap.scrollbarSize().height+"px"});}else{s.css({"overflow-x":"scroll","bottom":"0px"});}}this._scrollCheckTimer=q.sap.delayedCall(300,this,this.onCheckScrollbar);}};b.prototype.insertSubList=function(s,i){this.insertAggregation("subLists",s,i);if(s){t(s,this._iLevel+1);}return this;};b.prototype.addSubList=function(s){this.addAggregation("subLists",s);if(s){t(s,this._iLevel+1);}return this;};b.prototype.setData=function(s){if(s!=null&&typeof(s)!="string"){s=s.getId();}if(s){this.setAssociation("data",s);s=this._getAtt();this._lb.removeAllItems();if(!s){return this;}var G=s.getAttributesInternal(true);var S=[];var H=[];for(var i=0;i<G.length;i++){var I=F(G[i]);this._lb.addItem(I);if(G[i].getSelected()){var J=z(this,G[i]);if(J){H.push(J);}S.push(I.getKey());}}this._lb.setSelectedKeys(S);var O=this.getSubLists();for(var i=0;i<O.length;i++){var K=q.inArray(O[i],H);if(K>=0){if(s.getListOrder()!=sap.ui.ux3.ExactOrder.Fixed){H.splice(K,1);}}else{O[i]._lb.removeAllItems();O[i].destroy();}}if(s.getListOrder()===sap.ui.ux3.ExactOrder.Fixed){this.removeAllSubLists();}for(var i=0;i<H.length;i++){this.addSubList(H[i]);}var M=this;s.setChangeListener({id:M.getId(),_notifyOnChange:function(T,N){if(T==="width"){if(M._getAtt()===N&&M.getDomRef()){n(M,N.getWidth());}return;}var Q=D(M);if(!Q._dirtyLists){Q._dirtyLists={};}if(!Q._dirtyLists[M.getId()]){Q._dirtyLists[M.getId()]=M;}if(!Q._dirtyListsCleanupTimer){Q._dirtyListsCleanupTimer=q.sap.delayedCall(0,Q,function(){this._dirtyListsCleanupTimer=null;q.each(this._dirtyLists,function(i,J){if(J._lb&&J.getParent()){if(!J._isTop()){J.getParent().setData(J.getParent().getData());}else{J.setData(J.getData());}}});this._dirtyLists=null;},[]);}}});}return this;};b.prototype.setShowClose=function(s){if(this._isTop()){this.setProperty("showClose",s);}return this;};b.prototype.getShowClose=function(){return D(this).getProperty("showClose");};b.prototype.getTopTitle=function(){var T=this.getProperty("topTitle");return T?T:this._rb.getText("EXACT_BRWSR_LST_TITLE");};b.prototype._getAtt=function(){return sap.ui.getCore().byId(this.getData());};b.prototype._isTop=function(){return!(this.getParent()instanceof b);};b.prototype._selectionChanged=function(i){if(!this._isTop()){return;}i=sap.ui.getCore().byId(i.getId());var _=function(H,R){if(!H.getSelected()){return;}R.push(H);var V=H.getAttributesInternal();for(var G=0;G<V.length;G++){_(V[G],R);}};var s=[];var T=this._getAtt().getAttributesInternal();for(var G=0;G<T.length;G++){_(T[G],s);}this.fireAttributeSelected({attribute:i,allAttributes:s});};b.prototype._closeAll=function(){if(!this._isTop()){return;}var s=this;var G=function(){s._getAtt()._clearSelection();s._lb.clearSelection();s.fireAttributeSelected({attribute:undefined,allAttributes:[]});};var H=this.getSubLists();if(H.length>0){for(var i=0;i<H.length;i++){y(H[i],true,i==H.length-1?G:null);}}else{G();}};var g=function(i,s){function G(K){var M=K.getParent();var N=M.getSubLists();var O=M.indexOfSubList(K)-1;if(O>=0){return N[O];}return null;}function H(K){var S=K.getSubLists();if(S.length>0){return H(S[S.length-1]);}return K;}if(i._iLevel==0){return null;}else if(i._iLevel==1){if(s){return null;}var I=G(i);if(I){return I;}return i.getParent();}else if(i._iLevel>1){var I=G(i);if(I){return H(I);}var J=i.getParent();if(J._iLevel>=1){return J;}}return null;};var c=function(i,s){function G(J){var K=J.getParent();var M=K.getSubLists();var O=K.indexOfSubList(J)+1;if(O<M.length){return M[O];}return null;}function H(J){var S=J.getSubLists();if(S.length>0){return S[0];}return null;}function I(J){var K=G(J);if(K){return K;}var M=J.getParent();if(M._iLevel>(s?1:0)){return I(M);}else{return null;}}if(i._iLevel==0){return H(i);}else if(i._iLevel==1){return s?H(i):G(i);}else if(i._iLevel>1){var N=H(i);if(N){return N;}return I(i);}return null;};var f=function(i,s,K){i.fireEvent("_headerPress",{kexboard:K,domRef:i.$("head")});s.stopPropagation();};var d=function(i){return!e(i)&&i.$().hasClass("sapUiUx3ExactLstTopActive");};var e=function(i){return i.$().hasClass("sapUiUx3ExactLstTopHidden");};var h=function(s,G){if(s._getAtt().getListOrder()!=sap.ui.ux3.ExactOrder.Fixed){return-1;}var H=s._getAtt().getAttributes();var I=0;for(var i=0;i<H.length;i++){if(H[i]===G){break;}if(H[i].getChangeListener()){I++;}}return I;};var r=function(i){if(u(i)){i.$("lst").addClass("sapUiUx3ExactLstLstExp");if(!i._oPopup){var s=function(G){i._handleEvent(G);};i._oPopup=new P();if(!sap.ui.Device.browser.firefox){i._oPopup._fixPositioning=function(G,R){P.prototype._fixPositioning.apply(this,arguments);if(R){var $=this._$();var O=q(G.of);var H=0;if(G.offset){H=parseInt(G.offset.split(" ")[0],10);}$.css("right",(q(window).width()-O.outerWidth()-O.offset().left+H)+"px");}};}i._oPopup.open=function(){var G=i.$("lst");j(G,false,-1,function(R){G.addClass("sapUiUx3ExactLstExpanded");i.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true,false));i.__sOldHeight=G.css("height");G.css("height",i.__sOldHeight);var H=i.$("head");var I=q(i._lb.getDomRef());var J=I[0].scrollHeight+i.$("exp").height()+I.outerHeight()-I.height()+1;var M=q(window).height()-parseInt(I.offset().top,10)+q(window).scrollTop()-H.outerHeight();var T=Math.min(J,M);i._oPopup.setContent(G[0]);var O=a.get()["sapUiUx3ExactLst"+(i._isTop()?"Root":"")+"ExpandOffset"]||"0 0";P.prototype.open.apply(i._oPopup,[0,P.Dock.BeginTop,P.Dock.BeginBottom,H[0],O,"none none"]);i._bPopupOpened=true;return T;},function(R){G.addClass("sapUiUx3ExactLstExpandedBL");u(i);i.getFocusDomRef().focus();q.sap.bindAnyEvent(i._closeHandle);R.bind(q.sap.ControlEvents.join(" "),s);});};i._oPopup.close=function(S){var G=i.$("lst");G.removeClass("sapUiUx3ExactLstExpandedBL");j(G,false,i.__sOldHeight,function(R){q.sap.unbindAnyEvent(i._closeHandle);R.unbind(q.sap.ControlEvents.join(" "),s);G.removeClass("sapUiUx3ExactLstExpanded");i.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false,false));},function(R){R.detach();G.removeClass("sapUiShd");R.attr("style","width:"+i._iCurrentWidth+"px;");q(i.getDomRef()).prepend(R);i._oPopup.setContent(null);i._bPopupOpened=undefined;i.__sOldHeight=null;if(i._isTop()){R.css("bottom",q.sap.scrollbarSize().height+"px");}u(i);P.prototype.close.apply(i._oPopup,[0]);if(!S){i.getFocusDomRef().focus();}});};}}};var j=function(R,W,V,i,s){if(i){var G=i(R);if(G!=undefined){V=G;}}var _=s?function(){s(R);}:function(){};if(q.fx.off){if(W){R.width(V);}else{R.height(V);}_();}else{var H=W?{width:V}:{height:V};R.stop(true,true).animate(H,200,'linear',_);}};var o=function(i){i.preventDefault();i.stopPropagation();return false;};var k=function(i){var s=i.pageX;var G=this._bRTL?(this._iStartDragX-s):(s-this._iStartDragX);n(this,this._iStartWidth+G);};var m=function(i){q(document.body).unbind("selectstart."+this.getId()).unbind("mouseup."+this.getId()).unbind("mousemove."+this.getId());this.$("ghost").remove();this.$("rsz").removeClass("sapUiUx3ExactLstRSzDrag");this._iStartWidth=undefined;this._iStartDragX=undefined;this.focus();};var n=function(i,W){W=sap.ui.ux3.ExactAttribute._checkWidth(W);var s=i._bRTL?"right":"left";i._iCurrentWidth=W;i._getAtt()._setWidth(i._iCurrentWidth);i.$("lst").css("width",W+"px");i.$("rsz").css(s,(W-4)+"px");if(i._isTop()){if(!e(i)){i.$("head").css("width",W+"px");i.$("cntnt").css(s,(W+8)+"px");i.$("scroll").css(s,(W+8)+"px");}}else{if(!i.$().hasClass("sapUiUx3ExactLstCollapsed")){i.$("cntnt").css("margin-"+s,W+"px");}}};var p=function(i){var s=i._getAtt();if(s&&!i._isTop()){i.$("head-txt").html(q.sap.encodeHTML(s.getText())+"<span class=\"sapUiUx3ExactLstHeadInfo\">&nbsp;("+i._lb.getSelectedIndices().length+"/"+i._lb.getItems().length+")</span>");}};var t=function(s,G){s._iLevel=G;var H=s.getSubLists();for(var i=0;i<H.length;i++){t(H[i],G+1);}};var u=function(i){if(i._lb){var s=q(i._lb.getDomRef());i.$("lst").removeClass("sapUiUx3ExactLstScroll");if(s.length>0&&s.outerHeight()<s[0].scrollHeight){i.$("lst").addClass("sapUiUx3ExactLstScroll");return true;}}return false;};var v=function(i,s,G,S){if(G){G.preventDefault();G.stopPropagation();}if(i._isTop()){return;}if(i._bCollapsed!=s){var H=!!G;var I={};I["margin-"+(i._bRTL?"right":"left")]=(i._bCollapsed?(i._iCurrentWidth+"px"):a.get("sapUiUx3ExactLstCollapseWidth"));I["border-top-width"]=(i._bCollapsed?a.get("sapUiUx3ExactLstContentTop"):"0px");var $=i.$("cntnt");if(q.fx.off){for(var J in I){$.css(J,I[J]);}}else{$.stop(true,true).animate(I,200,'linear');}if(i._bCollapsed){j(i.$("lst"),true,i._iCurrentWidth+"px",function(){q(i.getDomRef()).removeClass("sapUiUx3ExactLstCollapsed");i.$("head").css("overflow","hidden");},function(R){i.$("hide").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true,true)).attr("title",i._rb.getText("EXACT_LST_LIST_COLLAPSE"));if(H){i.focus();}var N=i.$("head");i.$("head-txt").removeAttr("style");N.removeAttr("style");R.removeAttr("style");r(i);n(i,i._iCurrentWidth);w(i);N.removeAttr("role");N.removeAttr("aria-label");N.removeAttr("aria-expanded");var O=i._getAtt();if(O&&O._scrollToAttributeId){O.scrollTo(sap.ui.getCore().byId(O._scrollToAttributeId));}});i._oCollapseStyles=undefined;}else{i._oCollapseStyles={};j(i.$("lst"),true,0,null,function(){q(i.getDomRef()).addClass("sapUiUx3ExactLstCollapsed");i.$("hide").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false,true)).attr("title",i._rb.getText("EXACT_LST_LIST_EXPAND"));if(H){i.focus();}w(i);var N=i.$("head");N.attr("role","region");N.attr("aria-label",i._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[i._iLevel,i._getAtt().getText()]));N.attr("aria-expanded","false");});var K=[];for(var J in I){K.push(J,":",I[J],";");}i._oCollapseStyles["cntnt"]=K.join("");i._oCollapseStyles["lst"]="width:0px;";}i._bCollapsed=!i._bCollapsed;}if(S){return;}var M=i.getParent();if(!i._isTop()&&M&&M._isTop&&!M._isTop()){v(M,s);}};var w=function(s){if(s._bCollapsed){var W=s.$("cntnt").height()-50;var $=s.$("head-txt");$.css("width",W+"px");}var S=s.getSubLists();for(var i=0;i<S.length;i++){w(S[i]);}};var x=function(i){var s=i.$("lst");if(s.hasClass("sapUiUx3ExactLstExpanded")){i._oPopup.close();}else{i._oPopup.open();}};var y=function(i,s,G){var H=function(R){if(!s){var J=i._getAtt();var S=J.getParent().indexOfAttribute(J);A(i.getParent(),J,S,true);p(i.getParent());D(i)._selectionChanged(J);}i.destroy();if(G){G();}};var I=i.getDomRef();if(I){j(q(I),true,0,function(R){R.css("overflow","hidden");},H);}else{H();}};var z=function(i,s){if(s.getSelected()){var G=s.getAttributesInternal(true);if(G.length>0){var S;if(s.getChangeListener()){S=sap.ui.getCore().byId(s.getChangeListener().id);}else{S=new b();}S.setData(s);return S;}}return null;};var A=function(s,G,S,H){s._lb.removeSelectedIndex(S);G._clearSelection();if(!H){var I=s.getSubLists();for(var i=0;i<I.length;i++){if(I[i].getData()===G.getId()){y(I[i],true);}}}};var B=function(i){var s=i._getAtt();if(s&&s.getChangeListener()&&s.getChangeListener().id===i.getId()){s.setChangeListener(null);}};var D=function(i){if(i._isTop()){return i;}if(!i._oTopList){i._oTopList=D(i.getParent());}return i._oTopList;};var F=function(i){var I;if(i.__oItem){I=i.__oItem;if(I.getText()!=i.getText()){I.setText(i.getText());}if(I.getKey()!=i.getId()){I.setKey(i.getId());}}else{I=new sap.ui.core.ListItem({text:i.getText(),key:i.getId()});i.exit=function(){if(sap.ui.ux3.ExactAttribute.prototype.exit){sap.ui.ux3.ExactAttribute.prototype.exit.apply(i,[]);}this.__oItem.destroy();this.__oItem=null;};i.__oItem=I;}return I;};}());return b;},true);
