/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Bar','./Button','./InstanceManager','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/delegate/ScrollEnablement','sap/ui/core/theming/Parameters','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/library','sap/ui/core/Element','sap/ui/core/ResizeHandler','./PopoverRenderer',"sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/dom/getScrollbarSize","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/control"],function(B,a,I,l,C,P,S,b,D,M,c,E,R,d,f,q,g,K,L){"use strict";var h=l.PopupHelper;var O=c.OpenState;var j=l.PlacementType;var k=C.extend("sap.m.Popover",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Behavior",defaultValue:j.Right},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},title:{type:"string",group:"Appearance",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},offsetX:{type:"int",group:"Appearance",defaultValue:0},offsetY:{type:"int",group:"Appearance",defaultValue:0},showArrow:{type:"boolean",group:"Appearance",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentMinWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enableScrolling:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},horizontalScrolling:{type:"boolean",group:"Misc",defaultValue:true},bounce:{type:"boolean",group:"Behavior",defaultValue:null},resizable:{type:"boolean",group:"Dimension",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.ui.core.Control",multiple:false},subHeader:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},beginButton:{type:"sap.ui.core.Control",multiple:false},endButton:{type:"sap.ui.core.Control",multiple:false}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}}},designtime:"sap/m/designtime/Popover.designtime"}});k._bIOS7=D.os.ios&&D.os.version>=7&&D.os.version<8&&D.browser.name==="sf";k.prototype.init=function(){this._arrowOffsetThreshold=4;this._marginTopInit=false;this._marginTop=48;this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._minDimensions={width:100,height:32};this._$window=q(window);this._initialWindowDimensions={};this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setAutoClose(true);this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this._placements=[j.Top,j.Right,j.Bottom,j.Left,j.Vertical,j.Horizontal,j.Auto,j.VerticalPreferedTop,j.VerticalPreferedBottom,j.HorizontalPreferedLeft,j.HorizontalPreferedRight,j.VerticalPreferredTop,j.VerticalPreferredBottom,j.HorizontalPreferredLeft,j.HorizontalPreferredRight,j.PreferredRightOrFlip,j.PreferredLeftOrFlip,j.PreferredTopOrFlip,j.PreferredBottomOrFlip];this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];this._offsets=["0 -18","18 0","0 18","-18 0"];this._arrowOffset=18;this._followOfTolerance=32;this._scrollContentList=[sap.m.NavContainer,sap.m.Page,sap.m.ScrollContainer];this._fnAdjustPositionAndArrow=q.proxy(this._adjustPositionAndArrow,this);this._fnOrientationChange=q.proxy(this._onOrientationChange,this);this._fnFollowOf=q.proxy(function(i){var o=i.lastOfRect,r=i.currentOfRect;if(!D.system.desktop||(Math.abs(o.top-r.top)<=this._followOfTolerance&&Math.abs(o.left-r.left)<=this._followOfTolerance)||(Math.abs(o.top+o.height-r.top-r.height)<=this._followOfTolerance&&Math.abs(o.left+o.width-r.left-r.width)<=this._followOfTolerance)){this.oPopup._applyPosition(this.oPopup._oLastPosition,true);}else{this.close();}},this);this.setFollowOf(true);this._oRestoreFocusDelegate={onBeforeRendering:function(){var A=q(document.activeElement),o=A.control(0);this._sFocusControlId=o&&o.getId();},onAfterRendering:function(){if(this._sFocusControlId&&!f(this.getDomRef(),document.activeElement)){sap.ui.getCore().byId(this._sFocusControlId).focus();}}};var t=this;this.oPopup._applyPosition=function(p,F){var e=this.getOpenState(),o;if(e===O.CLOSING||e===O.CLOSED){return;}if(F){t._storeScrollPosition();}t._clearCSSStyles();var i=t._placements.indexOf(t.getPlacement());if(i>3&&!t._bPosCalced){t._calcPlacement();return;}t._bPosCalced=false;if(t._oOpenBy instanceof E){p.of=t._getOpenByDomRef();}if(!p.of){L.warning("sap.m.Popover: in function applyPosition, the openBy element doesn't have any DOM output. "+t);return;}if(!f(document.documentElement,p.of)&&p.of.id){o=q(document.getElementById(p.of.id));if(o){p.of=o;}else{L.warning("sap.m.Popover: in function applyPosition, the openBy element's DOM is already detached from DOM tree and can't be found again by the same id. "+t);return;}}var r=q(p.of).rect();if(F&&t._$window.height()==t._initialWindowDimensions.height&&(r.top+r.height<=0||r.top>=t._$window.height()||r.left+r.width<=0||r.left>=t._$window.width())){t.close();return;}var s=t.getDomRef("scroll");if(!D.system.desktop){q(window).scrollLeft(0);}t._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,p);t._fnAdjustPositionAndArrow();t._restoreScrollPosition();t._registerContentResizeHandler(s);};this.oPopup.close=function(e){var i=typeof e==="boolean";var m=t.oPopup.getOpenState();if(e!==true&&(this.touchEnabled||!this._isFocusInsidePopup())&&this.isOpen()&&!(m===O.CLOSED||m===O.CLOSING)){t.fireBeforeClose({openBy:t._oOpenBy});}t._deregisterContentResizeHandler();P.prototype.close.apply(this,i?[]:arguments);t.removeDelegate(t._oRestoreFocusDelegate);};};k.prototype.onBeforeRendering=function(){var n,p;if(!this._initialWindowDimensions.width||!this._initialWindowDimensions.height){this._initialWindowDimensions={width:this._$window.width(),height:this._$window.height()};}if(!this.getHorizontalScrolling()&&!this.getVerticalScrolling()){this._forceDisableScrolling=true;}else if(!this._bVScrollingEnabled&&!this._bHScrollingEnabled&&this._hasSingleScrollableContent()){this._forceDisableScrolling=true;L.info("VerticalScrolling and horizontalScrolling in sap.m.Popover with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else{this._forceDisableScrolling=false;}if(!this._forceDisableScrolling){if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}}if(this._bContentChanged){this._bContentChanged=false;n=this._getSingleNavContent();p=this._getSinglePageContent();if(n&&!this.getModal()&&!D.support.touch&&!q.sap.simulateMobileOnDesktop){n.attachEvent("afterNavigate",function(e){if(this.getDomRef()){this.getDomRef().focus();}},this);}if(n||p){p=p||n.getCurrentPage();if(p&&p._getAnyHeader){this.addStyleClass("sapMPopoverWithHeaderCont");}if(n){n.attachEvent("navigate",function(e){var o=e.getParameter("to");if(o instanceof sap.m.Page){this.$().toggleClass("sapMPopoverWithHeaderCont",!!o._getAnyHeader());}},this);}}}};k.prototype.onAfterRendering=function(){var $,e,i;if(!this._marginTopInit&&this.getShowArrow()){this._marginTop=2;if(this._oOpenBy){$=q(this._getOpenByDomRef());if(!($.closest("header.sapMIBar").length>0)){e=$.closest(".sapMPage");if(e.length>0){i=e.children("header.sapMIBar");if(i.length>0){this._marginTop+=i.outerHeight();}}}this._marginTopInit=true;}}};k.prototype.exit=function(){this._deregisterContentResizeHandler();D.resize.detachHandler(this._fnOrientationChange);I.removePopoverInstance(this);this.removeDelegate(this._oRestoreFocusDelegate);this._oRestoreFocusDelegate=null;if(this.oPopup){this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._internalHeader){this._internalHeader.destroy();this._internalHeader=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}};k.prototype.openBy=function(o,s){var p=this.oPopup,e=this.oPopup.getOpenState(),F=this._getInitialFocusId(),i,m,n,r;i=(o.getDomRef&&o.getDomRef())||o;r=q(i).closest(".sapUiSizeCompact");n=b.get("_sap_m_Popover_ForceCompactArrowOffset")==="true";this._bSizeCompact=l._bSizeCompact||!!r.length||this.hasStyleClass("sapUiSizeCompact");this._bUseCompactArrow=this._bSizeCompact||n;this._adaptPositionParams();if(e===O.OPEN||e===O.OPENING){if(this._oOpenBy===o){return this;}else{var t=function(){p.detachClosed(t,this);this.openBy(o);};p.attachClosed(t,this);this.close();return this;}}if(!o){return this;}if(D.support.touch){D.resize.attachHandler(this._fnOrientationChange);}if(!this._oOpenBy||o!==this._oOpenBy){this._oOpenBy=o;}this.fireBeforeOpen({openBy:this._oOpenBy});p.attachOpened(this._handleOpened,this);p.attachClosed(this._handleClosed,this);p.setInitialFocusId(F);m=this._placements.indexOf(this.getPlacement());if(m>-1){i=this._getOpenByDomRef();if(!i){L.error("sap.m.Popover id = "+this.getId()+": is opened by a control which isn't rendered yet.");return this;}p.setAutoCloseAreas([o]);p.setContent(this);if(m<=3){p.setPosition(this._myPositions[m],this._atPositions[m],i,this._calcOffset(this._offsets[m]),"fit");}else{p._oPosition.of=i;}var u=this;var v=function(){if(p.getOpenState()===O.CLOSING){if(u._sOpenTimeout){clearTimeout(u._sOpenTimeout);u._sOpenTimeout=null;}u._sOpenTimeout=setTimeout(v,150);}else{u._oPreviousFocus=P.getCurrentFocusInfo();p.open();u.addDelegate(u._oRestoreFocusDelegate,u);if(!s){I.addPopoverInstance(u);}}};v();}else{L.error(this.getPlacement()+"is not a valid value! It can only be top, right, bottom or left");}return this;};k.prototype.close=function(){var e=this.oPopup.getOpenState(),s,A;if(e===O.CLOSED||e===O.CLOSING){return this;}this.fireBeforeClose({openBy:this._oOpenBy});this.oPopup.close(true);if(this._oPreviousFocus){A=document.activeElement||{};s=(this._oPreviousFocus.sFocusId===sap.ui.getCore().getCurrentFocusedControlId())||(this._oPreviousFocus.sFocusId===A.id);if(!s){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;}}return this;};k.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen();};k.prototype.setFollowOf=function(v){if(v){this.oPopup.setFollowOf(this._fnFollowOf);}else{this.oPopup.setFollowOf(false);}return this;};k.prototype._clearCSSStyles=function(){var s=this.getDomRef().style,$=this.$("cont"),e=$.children(".sapMPopoverScroll"),o=$[0].style,i=e[0].style,m=this.getContentWidth(),n=this.getContentHeight(),p=this.$("arrow"),w,W;if(m.indexOf("%")>0){w=this._$window.width();m=h.calcPercentageSize(m,w);}if(n.indexOf("%")>0){W=this._$window.height();n=h.calcPercentageSize(n,W);}o.width=m||"";o.height=n||"";o.maxWidth="";o.maxHeight="";s.left="";s.right="";s.top="";s.bottom="";s.width="";s.height="";i.width="";i.display="";p.removeClass("sapMPopoverArrRight sapMPopoverArrLeft sapMPopoverArrDown sapMPopoverArrUp sapMPopoverCrossArr sapMPopoverFooterAlignArr sapMPopoverHeaderAlignArr sapContrast sapContrastPlus");p.css({left:"",top:""});};k.prototype._onOrientationChange=function(){var e=this.oPopup.getOpenState();if(!(e===O.OPEN||e===O.OPENING)){return;}this.oPopup._applyPosition(this.oPopup._oLastPosition,true);};k.prototype._handleOpened=function(){var t=this;this.oPopup.detachOpened(this._handleOpened,this);if(!D.support.touch){setTimeout(function(){!t.bIsDestroyed&&D.resize.attachHandler(t._fnOrientationChange);},0);}var F=this._getInitialFocusId(),o=sap.ui.getCore().byId(F),e=(F?window.document.getElementById(F):null);if(o&&o.getFocusDomRef()){o.getFocusDomRef().focus();}else if(!o&&e){e.focus();}this.fireAfterOpen({openBy:this._oOpenBy});};k.prototype._handleClosed=function(){this.oPopup.detachClosed(this._handleClosed,this);D.resize.detachHandler(this._fnOrientationChange);I.removePopoverInstance(this);if(!this.oPopup._bModal&&!D.system.desktop&&document.activeElement&&!q(document.activeElement).is(":visible")){document.activeElement.blur();}this.fireAfterClose({openBy:this._oOpenBy});};k.prototype.onfocusin=function(e){var s=e.target,$=this.$();if(s.id===this.getId()+"-firstfe"){var o=$.lastFocusableDomRef();if(o){o.focus();}}else if(s.id===this.getId()+"-lastfe"){var F=$.firstFocusableDomRef();if(F){F.focus();}}};k.prototype.onkeydown=function(e){var o=K,i=e.which||e.keyCode,A=e.altKey;if(i===o.ESCAPE||(A&&i===o.F4)){if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this.close();e.stopPropagation();e.preventDefault();}};k.prototype.onmousedown=function(o){var r=sap.ui.getCore().getConfiguration().getRTL();if(!o.target.classList.contains("sapMPopoverResizeHandle")){return;}var $=q(document);var i=this.$();var t=this;i.addClass('sapMPopoverResizing');o.preventDefault();o.stopPropagation();var m={x:o.pageX,y:o.pageY,width:i.width(),height:i.height()};$.on("mousemove.sapMPopover",function(e){var w,n;if(r){w=m.width+m.x-e.pageX;n=m.height+(m.y-e.pageY);}else{w=m.width+e.pageX-m.x;n=m.height+(m.y-e.pageY);}t.setContentWidth(Math.max(w,t._minDimensions.width)+'px');t.setContentHeight(Math.max(n,t._minDimensions.height)+'px');});$.on("mouseup.sapMPopover",function(){i.removeClass("sapMPopoverResizing");$.off("mouseup.sapMPopover, mousemove.sapMPopover");});};k.prototype._hasSingleNavContent=function(){return!!this._getSingleNavContent();};k.prototype._getSingleNavContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1&&e[0]instanceof sap.m.NavContainer){return e[0];}else{return null;}};k.prototype._getSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1&&e[0]instanceof sap.m.Page){return e[0];}else{return null;}};k.prototype._hasSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1&&e[0]instanceof sap.m.Page){return true;}else{return false;}};k.prototype._hasSingleScrollableContent=function(){var e=this._getAllContent(),i;while(e.length===1&&e[0]instanceof sap.ui.core.mvc.View){e=e[0].getContent();}if(e.length===1){for(i=0;i<this._scrollContentList.length;i++){if(e[0]instanceof this._scrollContentList[i]){return true;}}return false;}else{return false;}};k.prototype._getOffsetX=function(){var F=this.getPlacement(),i=0;if(this._bHorizontalFlip){var p=this._getOpenByDomRef();var H=p!==undefined;var e=H?p.getBoundingClientRect().width:0;i=F===j.PreferredRightOrFlip?Math.abs(e):-Math.abs(e);}var r=sap.ui.getCore().getConfiguration().getRTL();var o=i*(r?-1:1)+this.getOffsetX()*(r?-1:1);return o;};k.prototype._getOffsetY=function(){var F=this.getPlacement(),i=0;if(this._bVerticalFlip){var p=this._getOpenByDomRef();var H=p!==undefined;var e=H?p.getBoundingClientRect().height:0;i=F==="PreferredTopOrFlip"?-Math.abs(e):Math.abs(e);}return i+this.getOffsetY();};k.prototype._calcOffset=function(o){var i=this._getOffsetX(),e=this._getOffsetY();var p=o.split(" ");var o=(parseInt(p[0],10)+i)+" "+(parseInt(p[1],10)+e);return o;};k.prototype._calcPlacement=function(){var p=this.getPlacement();var o=this._getOpenByDomRef();switch(p){case j.Auto:this._calcAuto();break;case j.Vertical:case j.VerticalPreferedTop:case j.VerticalPreferredTop:case j.VerticalPreferedBottom:case j.VerticalPreferredBottom:case j.PreferredTopOrFlip:case j.PreferredBottomOrFlip:this._calcVertical();break;case j.Horizontal:case j.HorizontalPreferedLeft:case j.HorizontalPreferredLeft:case j.HorizontalPreferedRight:case j.HorizontalPreferredRight:case j.PreferredRightOrFlip:case j.PreferredLeftOrFlip:this._calcHorizontal();break;}this._bPosCalced=true;var i=this._placements.indexOf(this._oCalcedPos);this.oPopup.setPosition(this._myPositions[i],this._atPositions[i],o,this._calcOffset(this._offsets[i]),"fit");};k.prototype._getDocHeight=function(){var e=document.body,i=document.documentElement;return Math.max(e.scrollHeight,e.offsetHeight,i.clientHeight,i.offsetHeight);};k.prototype._calcVertical=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=this.getPlacement()===j.VerticalPreferedTop||this.getPlacement()===j.VerticalPreferredTop;var e=this.getPlacement()===j.VerticalPreferedBottom||this.getPlacement()===j.VerticalPreferredBottom;var i=this.getPlacement()===j.PreferredTopOrFlip;var m=this.getPlacement()===j.PreferredBottomOrFlip;var n=H?$[0].getBoundingClientRect().top:0;var o=H?$[0].getBoundingClientRect().height:0;var r=this._getOffsetY();var t=n-this._marginTop+r;var s=this.$().outerHeight();var u=this._getDocHeight()-($.offset().top+o+this._marginBottom+r);if(p&&t>s+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=j.Top;}else if(i){if(t>s+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=j.Top;}else{this._bVerticalFlip=true;this._oCalcedPos=j.Bottom;}}else if(e&&u>s+this._arrowOffset){this._oCalcedPos=j.Bottom;this._bVerticalFlip=false;}else if(m){if(u>s+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=j.Bottom;}else{this._bVerticalFlip=true;this._oCalcedPos=j.Top;}}else if(t>u){this._oCalcedPos=j.Top;}else{this._oCalcedPos=j.Bottom;}};k.prototype._calcHorizontal=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=this.getPlacement()===j.HorizontalPreferedLeft||this.getPlacement()===j.HorizontalPreferredLeft;var e=this.getPlacement()===j.HorizontalPreferedRight||this.getPlacement()===j.HorizontalPreferredRight;var i=H?$[0].getBoundingClientRect().left:0;var m=H?$[0].getBoundingClientRect().width:0;var o=this._getOffsetX();var n=i-this._marginLeft+o;var r=i+m;var s=this._$window.width()-r-this._marginRight-o;var t=this.$().outerWidth();var u=this.getPlacement()===j.PreferredLeftOrFlip;var v=this.getPlacement()===j.PreferredRightOrFlip;var w=sap.ui.getCore().getConfiguration().getRTL();if(p&&n>t+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=w?j.Right:j.Left;}else if(u){if(n>t+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=w?j.Right:j.Left;}else{this._bHorizontalFlip=true;this._oCalcedPos=w?j.Left:j.Right;}}else if(e&&s>t+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=w?j.Left:j.Right;}else if(v){if(s>t+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=w?j.Left:j.Right;}else{this._bHorizontalFlip=true;this._oCalcedPos=w?j.Right:j.Left;}}else if(n>s){this._oCalcedPos=w?j.Right:j.Left;}else{this._oCalcedPos=w?j.Left:j.Right;}};k.prototype._calcAuto=function(){if(this._$window.width()>this._$window.height()){if(this._checkHorizontal()){this._calcHorizontal();}else if(this._checkVertical()){this._calcVertical();}else{this._calcBestPos();}}else{if(this._checkVertical()){this._calcVertical();}else if(this._checkHorizontal()){this._calcHorizontal();}else{this._calcBestPos();}}};k.prototype._checkHorizontal=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=H?$[0].getBoundingClientRect().left:0;var i=H?$[0].getBoundingClientRect().width:0;var o=this._getOffsetX();var e=p-this._marginLeft+o;var m=p+i;var r=this._$window.width()-m-this._marginRight-o;var n=this.$();var w=n.outerWidth()+this._arrowOffset;if((w<=e)||(w<=r)){return true;}};k.prototype._checkVertical=function(){var $=q(this._getOpenByDomRef());var H=$[0]!==undefined;var p=H?$[0].getBoundingClientRect().top:0;var i=H?$[0].getBoundingClientRect().height:0;var o=this._getOffsetY();var t=p-this._marginTop+o;var e=this._getDocHeight()-$.offset().top-i-this._marginBottom-o;var m=this.$();var n=m.outerHeight()+this._arrowOffset;if((n<=t)||(n<=e)){return true;}};k.prototype._calcBestPos=function(){var $=this.$();var H=$.outerHeight();var w=$.outerWidth();var r=sap.ui.getCore().getConfiguration().getRTL();var e=q(this._getOpenByDomRef());var i=e[0]!==undefined;var p=i?e[0].getBoundingClientRect().left:0;var m=i?e[0].getBoundingClientRect().top:0;var n=i?e[0].getBoundingClientRect().width:0;var o=i?e[0].getBoundingClientRect().height:0;var s=this._getOffsetX();var t=this._getOffsetY();var T=m-this._marginTop+t;var u=this._getDocHeight()-e.offset().top-o-this._marginBottom-t;var v=p-this._marginLeft+s;var x=p+n;var y=this._$window.width()-x-this._marginRight-s;var z=H*w;var A;var F;if((this._$window.height()-this._marginTop-this._marginBottom)>=H){A=H;}else{A=this._$window.height()-this._marginTop-this._marginBottom;}if((this._$window.width()-this._marginLeft-this._marginRight)>=w){F=w;}else{F=this._$window.width()-this._marginLeft-this._marginRight;}var G=(A*(v))/z;var J=(A*(y))/z;var N=(F*(T))/z;var Q=(F*(u))/z;var U=Math.max(G,J);var V=Math.max(N,Q);if(U>V){if(U===G){this._oCalcedPos=r?j.Right:j.Left;}else if(U===J){this._oCalcedPos=r?j.Left:j.Right;}}else if(V>U){if(V===N){this._oCalcedPos=j.Top;}else if(V===Q){this._oCalcedPos=j.Bottom;}}else if(V===U){if(this._$window.height()>this._$window.width()){if(V===N){this._oCalcedPos=j.Top;}else if(V===Q){this._oCalcedPos=j.Bottom;}}else{if(U===G){this._oCalcedPos=r?j.Right:j.Left;}else if(U===J){this._oCalcedPos=r?j.Left:j.Right;}}}};k.outerWidth=function(e,i){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().width;}return q(e).outerWidth(!!i);};k.outerHeight=function(e,i){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().height;}return q(e).outerHeight(!!i);};k.prototype._getPositionParams=function($,e,i,m){var o=window.getComputedStyle($[0]),n=window.getComputedStyle(i[0]),s=this.getDomRef().clientHeight!=this.getDomRef().scrollHeight?g().width:0,p={};p._$popover=$;p._$parent=q(this._getOpenByDomRef());p._$arrow=e;p._$content=i;p._$scrollArea=m;p._$header=$.children(".sapMPopoverHeader");p._$subHeader=$.children(".sapMPopoverSubHeader");p._$footer=$.children(".sapMPopoverFooter");p._fWindowTop=this._$window.scrollTop();p._fWindowRight=this._$window.width();p._fWindowBottom=(k._bIOS7&&D.orientation.landscape&&window.innerHeight)?window.innerHeight:this._$window.height();p._fWindowLeft=this._$window.scrollLeft();p._fDocumentWidth=p._fWindowLeft+p._fWindowRight;p._fDocumentHeight=p._fWindowTop+p._fWindowBottom;p._fArrowHeight=e.outerHeight(true);p._fWidth=k.outerWidth($[0]);p._fWidthInner=p._$scrollArea?(p._$scrollArea.width()+s):0;p._fHeight=k.outerHeight($[0]);p._fHeaderHeight=p._$header.length>0?p._$header.outerHeight(true):0;p._fSubHeaderHeight=p._$subHeader.length>0?p._$subHeader.outerHeight(true):0;p._fFooterHeight=p._$footer.length>0?p._$footer.outerHeight(true):0;p._fOffset=$.offset();p._fOffsetX=this._getOffsetX();p._fOffsetY=this._getOffsetY();p._fMarginTop=p._fWindowTop+this._marginTop;p._fMarginRight=this._marginRight;p._fMarginBottom=this._marginBottom;p._fMarginLeft=p._fWindowLeft+this._marginLeft;p._fPopoverBorderTop=parseFloat(o.borderTopWidth);p._fPopoverBorderRight=parseFloat(o.borderRightWidth);p._fPopoverBorderBottom=parseFloat(o.borderBottomWidth);p._fPopoverBorderLeft=parseFloat(o.borderLeftWidth);p._fContentMarginTop=parseFloat(n.marginTop);p._fContentMarginBottom=parseFloat(n.marginBottom);return p;};k.prototype._recalculateMargins=function(s,p){var r=sap.ui.getCore().getConfiguration().getRTL();switch(s){case j.Left:if(r){p._fMarginLeft=p._$parent.offset().left+k.outerWidth(p._$parent[0],false)+this._arrowOffset-p._fOffsetX;}else{p._fMarginRight=p._fDocumentWidth-p._$parent.offset().left+this._arrowOffset-p._fOffsetX;}break;case j.Right:if(r){p._fMarginRight=p._fDocumentWidth-k.outerWidth(p._$parent[0],false)-p._$parent.offset().left+this._arrowOffset;}else{p._fMarginLeft=p._$parent.offset().left+k.outerWidth(p._$parent[0],false)+this._arrowOffset+p._fOffsetX;}break;case j.Top:p._fMarginBottom=p._fDocumentHeight-p._$parent.offset().top+this._arrowOffset-p._fOffsetY;break;case j.Bottom:p._fMarginTop=p._$parent.offset().top+k.outerHeight(p._$parent[0],false)+this._arrowOffset+p._fOffsetY;break;}};k.prototype._getPopoverPositionCss=function(p){var i,r,t,e,m=p._fDocumentWidth-p._fOffset.left-p._fWidth,n=p._fDocumentHeight-p._fOffset.top-p._fHeight,o=(p._fDocumentWidth-p._fMarginRight-p._fMarginLeft)<p._fWidth,s=(p._fDocumentHeight-p._fMarginTop-p._fMarginBottom)<p._fHeight,u=p._fOffset.left<p._fMarginLeft,v=this.getVerticalScrolling()&&(p._fWidth!==p._fWidthInner)?g().width:0,w=m<(p._fMarginRight+v),x=p._fOffset.top<p._fMarginTop,y=n<p._fMarginBottom,z=sap.ui.getCore().getConfiguration().getRTL();if(o){i=p._fMarginLeft;r=p._fMarginRight;}else{if(u){i=p._fMarginLeft;if(z){r="";}}else if(w){r=p._fMarginRight;i="";}}if(s){t=p._fMarginTop;e=p._fMarginBottom;}else{if(x){t=p._fMarginTop;}else if(y){e=p._fMarginBottom;t="";}}var A={top:t,bottom:e-p._fWindowTop,left:i,right:typeof r==="number"?r-p._fWindowLeft:r};return A;};k.prototype._getContentDimensionsCss=function(p){var o={},A=p._$content.height(),m=this._getMaxContentWidth(p),i=this._getMaxContentHeight(p);i=Math.max(i,0);o["max-width"]=m+"px";if(this.getContentHeight()||(A>i)){o["height"]=Math.min(i,A)+"px";}else{o["height"]="";o["max-height"]=i+"px";}return o;};k.prototype._getMaxContentWidth=function(p){return p._fDocumentWidth-p._fMarginLeft-p._fMarginRight-p._fPopoverBorderLeft-p._fPopoverBorderRight;};k.prototype._getMaxContentHeight=function(p){return p._fDocumentHeight-p._fMarginTop-p._fMarginBottom-p._fHeaderHeight-p._fSubHeaderHeight-p._fFooterHeight-p._fContentMarginTop-p._fContentMarginBottom-p._fPopoverBorderTop-p._fPopoverBorderBottom;};k.prototype._isHorizontalScrollbarNeeded=function(p){return this.getHorizontalScrolling()&&(p._$scrollArea.outerWidth(true)<=p._$content.width());};k.prototype._getArrowOffsetCss=function(s,p){var i,r=sap.ui.getCore().getConfiguration().getRTL();p._fWidth=p._$popover.outerWidth();p._fHeight=p._$popover.outerHeight();if(s===j.Left||s===j.Right){i=p._$parent.offset().top-p._$popover.offset().top-p._fPopoverBorderTop+p._fOffsetY+0.5*(k.outerHeight(p._$parent[0],false)-p._$arrow.outerHeight(false));i=Math.max(i,this._arrowOffsetThreshold);i=Math.min(i,p._fHeight-this._arrowOffsetThreshold-p._$arrow.outerHeight());return{"top":i};}else if(s===j.Top||s===j.Bottom){if(r){i=p._$popover.offset().left+k.outerWidth(p._$popover[0],false)-(p._$parent.offset().left+k.outerWidth(p._$parent[0],false))+p._fPopoverBorderRight+p._fOffsetX+0.5*(k.outerWidth(p._$parent[0],false)-p._$arrow.outerWidth(false));i=Math.max(i,this._arrowOffsetThreshold);i=Math.min(i,p._fWidth-this._arrowOffsetThreshold-p._$arrow.outerWidth(false));return{"right":i};}else{i=p._$parent.offset().left-p._$popover.offset().left-p._fPopoverBorderLeft+p._fOffsetX+0.5*(k.outerWidth(p._$parent[0],false)-p._$arrow.outerWidth(false));i=Math.max(i,this._arrowOffsetThreshold);i=Math.min(i,p._fWidth-this._arrowOffsetThreshold-p._$arrow.outerWidth(false));return{"left":i};}}};k.prototype._getArrowPositionCssClass=function(s){switch(s){case j.Left:return"sapMPopoverArrRight";case j.Right:return"sapMPopoverArrLeft";case j.Top:return"sapMPopoverArrDown";case j.Bottom:return"sapMPopoverArrUp";}};k.prototype._getArrowStyleCssClass=function(p){var A=p._$arrow.position(),F=p._$footer.position(),n=this._getSingleNavContent(),o=this._getSinglePageContent(),i=0;if(n||o){o=o||n.getCurrentPage();if(o){i=o._getAnyHeader().$().outerHeight();}}if((A.top+p._fArrowHeight)<(p._fHeaderHeight+p._fSubHeaderHeight)||((A.top+p._fArrowHeight)<i)){return"sapMPopoverHeaderAlignArr";}else if((A.top<(p._fHeaderHeight+p._fSubHeaderHeight))||(A.top<i)||(p._$footer.length&&((A.top+p._fArrowHeight)>F.top)&&(A.top<F.top))){return"sapMPopoverCrossArr";}else if(p._$footer.length&&(A.top>F.top)){return"sapMPopoverFooterAlignArr";}};k.prototype._getCalculatedPlacement=function(){return this._oCalcedPos||this.getPlacement();};k.prototype._adjustPositionAndArrow=function(){var e=this.oPopup.getOpenState();if(!(e===O.OPEN||e===O.OPENING)){return;}var $=this.$(),i=this.$("arrow"),m=this.$("cont"),n=this.$("scroll"),s=this._getCalculatedPlacement(),p=this._getPositionParams($,i,m,n);this._recalculateMargins(s,p);var o=this._getPopoverPositionCss(p),r=this._getContentDimensionsCss(p),H=this._isHorizontalScrollbarNeeded(p);$.css(o);m.css(r);if(H){n.css("display","block");}if(this.getShowArrow()){var A=this._getArrowOffsetCss(s,p),t=this._getArrowPositionCssClass(s),u,U;i.removeAttr("style");i.css(A);i.addClass(t);if(s===j.Top&&p._$footer&&p._$footer.size()){U=true;}if(s===j.Left||s===j.Right){u=this._getArrowStyleCssClass(p);if(u){i.addClass(u);if(u==="sapMPopoverFooterAlignArr"){U=true;}}}if(U){i.addClass("sapContrast sapContrastPlus");}$.css("overflow","visible");}this._afterAdjustPositionAndArrowHook();};k.prototype._adaptPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=18;this._offsets=["0 -18","18 0","0 18","-18 0"];if(this._bUseCompactArrow){this._arrowOffset=9;this._offsets=["0 -9","9 0","0 9","-9 0"];}this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"];}};k.prototype._afterAdjustPositionAndArrowHook=function(){};k.prototype._isPopupElement=function(o){var p=this._getOpenByDomRef();return!!(q(o).closest(sap.ui.getCore().getStaticAreaRef()).length)||!!(q(o).closest(p).length);};k.prototype._getAnyHeader=function(){if(this.getCustomHeader()){return this.getCustomHeader();}else{if(this.getShowHeader()){this._createInternalHeader();return this._internalHeader;}}};k.prototype._createInternalHeader=function(){if(!this._internalHeader){var t=this;this._internalHeader=new B(this.getId()+"-intHeader");this.setAggregation("_internalHeader",this._internalHeader);this._internalHeader.addEventDelegate({onAfterRendering:function(){t._restoreFocus();}});return true;}else{return false;}};k.prototype._animation=function(A,r){var t=null;var T=function(){r.off("webkitTransitionEnd transitionend");clearTimeout(t);setTimeout(function(){A();});};r.on("webkitTransitionEnd transitionend",T);t=setTimeout(T,this._getAnimationDuration());};k.prototype._getAnimationDuration=function(){return 300;};k.prototype._openAnimation=function(r,i,o){var t=this;setTimeout(function(){r.css("display","block");t._animation(function(){if(!t.oPopup||t.oPopup.getOpenState()!==O.OPENING){return;}o();},r);},D.browser.firefox?50:0);};k.prototype._closeAnimation=function(r,i,e){r.addClass("sapMPopoverTransparent");this._animation(function(){e();r.removeClass("sapMPopoverTransparent");},r);};k.prototype._getInitialFocusId=function(){return this.getInitialFocus()||this._getFirstVisibleButtonId()||this._getFirstFocusableContentElementId()||this.getId();};k.prototype._getFirstVisibleButtonId=function(){var o=this.getBeginButton(),e=this.getEndButton(),s="";if(o&&o.getVisible()){s=o.getId();}else if(e&&e.getVisible()){s=e.getId();}return s;};k.prototype._getFirstFocusableContentElementId=function(){var r="";var $=this.$("cont");var F=$.firstFocusableDomRef();if(F){r=F.id;}return r;};k.prototype._restoreFocus=function(){if(this.isOpen()){var F=this._getInitialFocusId(),o=sap.ui.getCore().byId(F),e=(F?window.document.getElementById(F):null);if(o&&o.getFocusDomRef()){o.getFocusDomRef().focus();}else if(!o&&e){e.focus();}}};k.prototype._registerContentResizeHandler=function(s){if(!this._sResizeListenerId){this._sResizeListenerId=R.register(s||this.getDomRef("scroll"),this._fnOrientationChange);}};k.prototype._deregisterContentResizeHandler=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}};k.prototype._storeScrollPosition=function(){var $=this.$("cont");if($.length>0){this._oScrollPosDesktop={x:$.scrollLeft(),y:$.scrollTop()};}};k.prototype._restoreScrollPosition=function(){if(!this._oScrollPosDesktop){return;}var $=this.$("cont");if($.length>0){$.scrollLeft(this._oScrollPosDesktop.x).scrollTop(this._oScrollPosDesktop.y);this._oScrollPosDesktop=null;}};k.prototype._repositionOffset=function(){var e=this.oPopup.getOpenState(),o,p;if(!(e===O.OPEN)){return this;}o=this.oPopup._oLastPosition;p=this._placements.indexOf(this.getPlacement());if(p===-1){return this;}if(p<4){o.offset=this._calcOffset(this._offsets[p]);this.oPopup._applyPosition(o);}else{this._calcPlacement();}return this;};k.prototype._getOpenByDomRef=function(){if(!this._oOpenBy){return null;}if(this._oOpenBy instanceof E){return(this._oOpenBy.getPopupAnchorDomRef&&this._oOpenBy.getPopupAnchorDomRef())||this._oOpenBy.getFocusDomRef();}else{return this._oOpenBy;}};k.prototype._getAccessibilityOptions=function(){var A,m={};m.role="dialog";if(this.getShowHeader()&&this._getAnyHeader()){A=Array.prototype.concat(this._getAnyHeader().getId(),this.getAssociation("ariaLabelledBy",[]));m.labelledby=A.join(' ');}return m;};k.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._bVerticalFlip=false;this._bHorizontalFlip=false;var i=this._placements.indexOf(p);if(i<=3){this._oCalcedPos=p;}return this;};k.prototype.setTitle=function(t){this.setProperty("title",t,true);if(this._headerTitle){this._headerTitle.setText(t);}else{this._headerTitle=new sap.m.Title(this.getId()+"-title",{text:this.getTitle(),level:"H2"});this._createInternalHeader();this._internalHeader.addContentMiddle(this._headerTitle);}return this;};k.prototype.setBeginButton=function(o){var e=this.getBeginButton();if(e===o){return this;}this._createInternalHeader();this._beginButton=o;if(o){if(e){this._internalHeader.removeAggregation("contentLeft",e,true);}this._internalHeader.addAggregation("contentLeft",o);}else{this._internalHeader.removeContentLeft(e);}return this;};k.prototype.setEndButton=function(o){var e=this.getEndButton();if(e===o){return this;}this._createInternalHeader();this._endButton=o;if(o){if(e){this._internalHeader.removeAggregation("contentRight",e,true);}this._internalHeader.insertAggregation("contentRight",o,1,true);this._internalHeader.invalidate();}else{this._internalHeader.removeContentRight(e);}return this;};k.prototype.setLeftButton=function(v){if(!(v instanceof a)){v=sap.ui.getCore().byId(v);}this.setBeginButton(v);return this.setAssociation("leftButton",v);};k.prototype.setRightButton=function(v){if(!(v instanceof a)){v=sap.ui.getCore().byId(v);}this.setEndButton(v);return this.setAssociation("rightButton",v);};k.prototype.setShowHeader=function(v){if(v===this.getShowHeader()||this.getCustomHeader()){return this;}if(v){if(this._internalHeader){this._internalHeader.$().show();}}else{if(this._internalHeader){this._internalHeader.$().hide();}}this.setProperty("showHeader",v,true);return this;};k.prototype.setModal=function(m,s){if(m===this.getModal()){return this;}this.oPopup.setModal(m,q.trim("sapMPopoverBLayer "+s||""));this.setProperty("modal",m,true);return this;};k.prototype.setOffsetX=function(v){this.setProperty("offsetX",v,true);return this._repositionOffset();};k.prototype.setOffsetY=function(v){this.setProperty("offsetY",v,true);return this._repositionOffset();};k.prototype.setEnableScrolling=function(v){this.setHorizontalScrolling(v);this.setVerticalScrolling(v);var o=this.getEnableScrolling();if(o===v){return this;}this.setProperty("enableScrolling",v,true);return this;};k.prototype.setVerticalScrolling=function(v){this._bVScrollingEnabled=v;var o=this.getVerticalScrolling();if(o===v){return this;}this.$().toggleClass("sapMPopoverVerScrollDisabled",!v);this.setProperty("verticalScrolling",v,true);if(this._oScroller){this._oScroller.setVertical(v);}return this;};k.prototype.setHorizontalScrolling=function(v){this._bHScrollingEnabled=v;var o=this.getHorizontalScrolling();if(o===v){return this;}this.$().toggleClass("sapMPopoverHorScrollDisabled",!v);this.setProperty("horizontalScrolling",v,true);if(this._oScroller){this._oScroller.setHorizontal(v);}return this;};k.prototype.setResizable=function(v){if(!D.system.desktop){v=false;}return this.setProperty("resizable",v,true);};k.prototype.getScrollDelegate=function(){return this._oScroller;};k.prototype.setAggregation=function(A,o,s){if(A==="beginButton"||A==="endButton"){var F="set"+A.charAt(0).toUpperCase()+A.slice(1);return this[F](o);}else{return C.prototype.setAggregation.apply(this,arguments);}};k.prototype.getAggregation=function(A,o){if(A==="beginButton"||A==="endButton"){var s=this["_"+A];return s||o||null;}else{return C.prototype.getAggregation.apply(this,arguments);}};k.prototype.destroyAggregation=function(A,s){var o=q(document.activeElement).control(0);if(A==="beginButton"||A==="endButton"){var e=this["_"+A];if(e){e.destroy();this["_"+A]=null;}}else{C.prototype.destroyAggregation.apply(this,arguments);}o&&o.getDomRef()?o.focus():this.focus();return this;};k.prototype.invalidate=function(o){if(this.isOpen()){C.prototype.invalidate.apply(this,arguments);}return this;};k.prototype.addAggregation=function(A,o,s){if(A==="content"){this._bContentChanged=true;}C.prototype.addAggregation.apply(this,arguments);};k.prototype._getAllContent=function(){return this.getContent();};k.prototype._applyContextualSettings=function(){M.prototype._applyContextualSettings.call(this,M._defaultContextualSettings);};return k;});
