ace.define("ace/mode/forth_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text_highlight_rules").TextHighlightRules;var F=function(){this.$rules={start:[{include:'#forth'}],'#comment':[{token:'comment.line.double-dash.forth',regex:'(?:^|\\s)--\\s.*$',comment:'line comments for iForth'},{token:'comment.line.backslash.forth',regex:'(?:^|\\s)\\\\[\\s\\S]*$',comment:'ANSI line comment'},{token:'comment.line.backslash-g.forth',regex:'(?:^|\\s)\\\\[Gg] .*$',comment:'gForth line comment'},{token:'comment.block.forth',regex:'(?:^|\\s)\\(\\*(?=\\s|$)',push:[{token:'comment.block.forth',regex:'(?:^|\\s)\\*\\)(?=\\s|$)',next:'pop'},{defaultToken:'comment.block.forth'}],comment:'multiline comments for iForth'},{token:'comment.block.documentation.forth',regex:'\\bDOC\\b',caseInsensitive:true,push:[{token:'comment.block.documentation.forth',regex:'\\bENDDOC\\b',caseInsensitive:true,next:'pop'},{defaultToken:'comment.block.documentation.forth'}],comment:'documentation comments for iForth'},{token:'comment.line.parentheses.forth',regex:'(?:^|\\s)\\.?\\( [^)]*\\)',comment:'ANSI line comment'}],'#constant':[{token:'constant.language.forth',regex:'(?:^|\\s)(?:TRUE|FALSE|BL|PI|CELL|C/L|R/O|W/O|R/W)(?=\\s|$)',caseInsensitive:true},{token:'constant.numeric.forth',regex:'(?:^|\\s)[$#%]?[-+]?[0-9]+(?:\\.[0-9]*e-?[0-9]+|\\.?[0-9a-fA-F]*)(?=\\s|$)'},{token:'constant.character.forth',regex:'(?:^|\\s)(?:[&^]\\S|(?:"|\')\\S(?:"|\'))(?=\\s|$)'}],'#forth':[{include:'#constant'},{include:'#comment'},{include:'#string'},{include:'#word'},{include:'#variable'},{include:'#storage'},{include:'#word-def'}],'#storage':[{token:'storage.type.forth',regex:'(?:^|\\s)(?:2CONSTANT|2VARIABLE|ALIAS|CONSTANT|CREATE-INTERPRET/COMPILE[:]?|CREATE|DEFER|FCONSTANT|FIELD|FVARIABLE|USER|VALUE|VARIABLE|VOCABULARY)(?=\\s|$)',caseInsensitive:true}],'#string':[{token:'string.quoted.double.forth',regex:'(ABORT" |BREAK" |\\." |C" |0"|S\\\\?" )([^"]+")',caseInsensitive:true},{token:'string.unquoted.forth',regex:'(?:INCLUDE|NEEDS|REQUIRE|USE)[ ]\\S+(?=\\s|$)',caseInsensitive:true}],'#variable':[{token:'variable.language.forth',regex:'\\b(?:I|J)\\b',caseInsensitive:true}],'#word':[{token:'keyword.control.immediate.forth',regex:'(?:^|\\s)\\[(?:\\?DO|\\+LOOP|AGAIN|BEGIN|DEFINED|DO|ELSE|ENDIF|FOR|IF|IFDEF|IFUNDEF|LOOP|NEXT|REPEAT|THEN|UNTIL|WHILE)\\](?=\\s|$)',caseInsensitive:true},{token:'keyword.other.immediate.forth',regex:'(?:^|\\s)(?:COMPILE-ONLY|IMMEDIATE|IS|RESTRICT|TO|WHAT\'S|])(?=\\s|$)',caseInsensitive:true},{token:'keyword.control.compile-only.forth',regex:'(?:^|\\s)(?:-DO|\\-LOOP|\\?DO|\\?LEAVE|\\+DO|\\+LOOP|ABORT\\"|AGAIN|AHEAD|BEGIN|CASE|DO|ELSE|ENDCASE|ENDIF|ENDOF|ENDTRY\\-IFERROR|ENDTRY|FOR|IF|IFERROR|LEAVE|LOOP|NEXT|RECOVER|REPEAT|RESTORE|THEN|TRY|U\\-DO|U\\+DO|UNTIL|WHILE)(?=\\s|$)',caseInsensitive:true},{token:'keyword.other.compile-only.forth',regex:'(?:^|\\s)(?:\\?DUP-0=-IF|\\?DUP-IF|\\)|\\[|\\[\'\\]|\\[CHAR\\]|\\[COMPILE\\]|\\[IS\\]|\\[TO\\]|<COMPILATION|<INTERPRETATION|ASSERT\\(|ASSERT0\\(|ASSERT1\\(|ASSERT2\\(|ASSERT3\\(|COMPILATION>|DEFERS|DOES>|INTERPRETATION>|OF|POSTPONE)(?=\\s|$)',caseInsensitive:true},{token:'keyword.other.non-immediate.forth',regex:'(?:^|\\s)(?:\'|<IS>|<TO>|CHAR|END-STRUCT|INCLUDE[D]?|LOAD|NEEDS|REQUIRE[D]?|REVISION|SEE|STRUCT|THRU|USE)(?=\\s|$)',caseInsensitive:true},{token:'keyword.other.warning.forth',regex:'(?:^|\\s)(?:~~|BREAK:|BREAK"|DBG)(?=\\s|$)',caseInsensitive:true}],'#word-def':[{token:['keyword.other.compile-only.forth','keyword.other.compile-only.forth','meta.block.forth','entity.name.function.forth'],regex:'(:NONAME)|(^:|\\s:)(\\s)(\\S+)(?=\\s|$)',caseInsensitive:true,push:[{token:'keyword.other.compile-only.forth',regex:';(?:CODE)?',caseInsensitive:true,next:'pop'},{include:'#constant'},{include:'#comment'},{include:'#string'},{include:'#word'},{include:'#variable'},{include:'#storage'},{defaultToken:'meta.block.forth'}]}]};this.normalizeRules();};F.metaData={fileTypes:['frt','fs','ldr','fth','4th'],foldingStartMarker:'/\\*\\*|\\{\\s*$',foldingStopMarker:'\\*\\*/|^\\s*\\}',keyEquivalent:'^~F',name:'Forth',scopeName:'source.forth'};o.inherits(F,T);e.ForthHighlightRules=F;});ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(r,e,a){"use strict";var o=r("../../lib/oop");var R=r("../../range").Range;var B=r("./fold_mode").FoldMode;var F=e.FoldMode=function(c){if(c){this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+c.start));this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+c.end));}};o.inherits(F,B);(function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/;this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/;this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/;this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/;this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/;this._getFoldWidgetBase=this.getFoldWidget;this.getFoldWidget=function(s,f,b){var l=s.getLine(b);if(this.singleLineBlockCommentRe.test(l)){if(!this.startRegionRe.test(l)&&!this.tripleStarBlockCommentRe.test(l))return"";}var c=this._getFoldWidgetBase(s,f,b);if(!c&&this.startRegionRe.test(l))return"start";return c;};this.getFoldWidgetRange=function(s,f,b,c){var l=s.getLine(b);if(this.startRegionRe.test(l))return this.getCommentRegionBlock(s,l,b);var m=l.match(this.foldingStartMarker);if(m){var i=m.index;if(m[1])return this.openingBracketBlock(s,m[1],b,i);var d=s.getCommentFoldRange(b,i+m[0].length,1);if(d&&!d.isMultiLine()){if(c){d=this.getSectionRange(s,b);}else if(f!="all")d=null;}return d;}if(f==="markbegin")return;var m=l.match(this.foldingStopMarker);if(m){var i=m.index+m[0].length;if(m[1])return this.closingBracketBlock(s,m[1],b,i);return s.getCommentFoldRange(b,i,-1);}};this.getSectionRange=function(s,b){var l=s.getLine(b);var c=l.search(/\S/);var d=b;var f=l.length;b=b+1;var g=b;var m=s.getLength();while(++b<m){l=s.getLine(b);var i=l.search(/\S/);if(i===-1)continue;if(c>i)break;var h=this.getFoldWidgetRange(s,"all",b);if(h){if(h.start.row<=d){break;}else if(h.isMultiLine()){b=h.end.row;}else if(c==i){break;}}g=b;}return new R(d,f,g,s.getLine(g).length);};this.getCommentRegionBlock=function(s,l,b){var c=l.search(/\s*$/);var d=s.getLength();var f=b;var g=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;var h=1;while(++b<d){l=s.getLine(b);var m=g.exec(l);if(!m)continue;if(m[1])h--;else h++;if(!h)break;}var i=b;if(i>f){return new R(f,c,i,l.length);}};}).call(F.prototype);});ace.define("ace/mode/forth",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/forth_highlight_rules","ace/mode/folding/cstyle"],function(r,e,m){"use strict";var o=r("../lib/oop");var T=r("./text").Mode;var F=r("./forth_highlight_rules").ForthHighlightRules;var a=r("./folding/cstyle").FoldMode;var M=function(){this.HighlightRules=F;this.foldingRules=new a();this.$behaviour=this.$defaultBehaviour;};o.inherits(M,T);(function(){this.lineCommentStart="--";this.blockComment=null;this.$id="ace/mode/forth";}).call(M.prototype);e.Mode=M;});
