/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['../base/Object','../base/ManagedObject','./ElementMetadata','../Device',"sap/ui/performance/trace/Interaction","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery"],function(B,M,E,D,I,L,a,q){"use strict";var b=M.extend("sap.ui.core.Element",{metadata:{stereotype:"element","abstract":true,publicMethods:["getId","getMetadata","getTooltip_AsString","getTooltip_Text","getModel","setModel","hasModel","bindElement","unbindElement","getElementBinding","prop","getLayoutData","setLayoutData"],library:"sap.ui.core",aggregations:{tooltip:{name:"tooltip",type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false},customData:{name:"customData",type:"sap.ui.core.CustomData",multiple:true,singularName:"customData"},layoutData:{name:"layoutData",type:"sap.ui.core.LayoutData",multiple:false,singularName:"layoutData"},dependents:{name:"dependents",type:"sap.ui.core.Element",multiple:true},dragDropConfig:{name:"dragDropConfig",type:"sap.ui.core.dnd.DragDropBase",multiple:true,singularName:"dragDropConfig"}}},constructor:function(i,s){M.apply(this,arguments);},renderer:null},E);b.defineClass=function(c,s,m){return B.defineClass(c,s,m||E);};b.prototype.getInterface=function(){return this;};b.prototype._handleEvent=function(e){var t=this,h="on"+e.type;function c(d){var i,l,o;if(d&&(l=d.length)>0){d=l===1?d:d.slice();for(i=0;i<l;i++){if(e.isImmediateHandlerPropagationStopped()){return;}o=d[i].oDelegate;if(o[h]){o[h].call(d[i].vThis===true?t:d[i].vThis||o,e);}}}}c(this.aBeforeDelegates);if(e.isImmediateHandlerPropagationStopped()){return;}if(this[h]){this[h](e);}c(this.aDelegates);};b.prototype.init=function(){};b.prototype.exit=function(){};b.create=M.create;b.prototype.toString=function(){return"Element "+this.getMetadata().getName()+"#"+this.sId;};b.prototype.getDomRef=function(s){return(((s?this.getId()+"-"+s:this.getId()))?window.document.getElementById(s?this.getId()+"-"+s:this.getId()):null);};b.prototype.$=function(s){return q(this.getDomRef(s));};b.prototype.isActive=function(){return this.oParent&&this.oParent.isActive();};b.prototype.prop=function(p,v){var P=this.getMetadata().getAllSettings()[p];if(P){if(arguments.length==1){return this[P._sGetter]();}else{this[P._sMutator](v);return this;}}};b.prototype.insertDependent=function(e,i){return this.insertAggregation("dependents",e,i,true);};b.prototype.addDependent=function(e){return this.addAggregation("dependents",e,true);};b.prototype.removeDependent=function(e){return this.removeAggregation("dependents",e,true);};b.prototype.removeAllDependents=function(){return this.removeAllAggregation("dependents",true);};b.prototype.destroyDependents=function(){return this.destroyAggregation("dependents",true);};b.prototype.rerender=function(){if(this.oParent){this.oParent.rerender();}};b.prototype.getUIArea=function(){return this.oParent?this.oParent.getUIArea():null;};b.prototype.destroy=function(s){if(this.bIsDestroyed){return;}b._updateFocusInfo(this);M.prototype.destroy.call(this,s);if(s!=="KeepDom"||this.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){this.$().remove();}else{L.debug("DOM is not removed on destroy of "+this);}};b.prototype.fireEvent=function(e,p,A,c){if(this.hasListeners(e)){I.notifyStepStart(this);}if(typeof p==='boolean'){c=A;A=p;p=null;}p=p||{};p.id=p.id||this.getId();if(b._trackEvent){b._trackEvent(e,this);}return M.prototype.fireEvent.call(this,e,p,A,c);};b._trackEvent=undefined;b.prototype.addDelegate=function(d,c,t,C){a(d,"oDelegate must be not null or undefined");if(!d){return this;}this.removeDelegate(d);if(typeof c==="object"){C=t;t=c;c=false;}if(typeof t==="boolean"){C=t;t=undefined;}(c?this.aBeforeDelegates:this.aDelegates).push({oDelegate:d,bClone:!!C,vThis:((t===this)?true:t)});return this;};b.prototype.removeDelegate=function(d){var i;for(i=0;i<this.aDelegates.length;i++){if(this.aDelegates[i].oDelegate==d){this.aDelegates.splice(i,1);i--;}}for(i=0;i<this.aBeforeDelegates.length;i++){if(this.aBeforeDelegates[i].oDelegate==d){this.aBeforeDelegates.splice(i,1);i--;}}return this;};b.prototype.addEventDelegate=function(d,t){return this.addDelegate(d,false,t,true);};b.prototype.removeEventDelegate=function(d){return this.removeDelegate(d);};b.prototype.getFocusDomRef=function(){return this.getDomRef()||null;};b.prototype.focus=function(){var F=this.getFocusDomRef();if(F){F.focus();}};b.prototype.getFocusInfo=function(){return{id:this.getId()};};b.prototype.applyFocusInfo=function(F){this.focus();return this;};b.prototype._refreshTooltipBaseDelegate=function(t){var T=sap.ui.require('sap/ui/core/TooltipBase');if(T){var o=this.getTooltip();if(o instanceof T){this.removeDelegate(o);}if(t instanceof T){t._currentControl=this;this.addDelegate(t);}}};b.prototype.setTooltip=function(t){this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t);return this;};b.prototype.getTooltip=function(){return this.getAggregation("tooltip");};b.runWithPreprocessors=M.runWithPreprocessors;b.prototype.getTooltip_AsString=function(){var t=this.getTooltip();if(typeof t==="string"||t instanceof String){return t;}return undefined;};b.prototype.getTooltip_Text=function(){var t=this.getTooltip();if(t&&typeof t.getText==="function"){return t.getText();}return t;};(function(){var g=function(e,k){var d=e.getAggregation("customData");if(d){for(var i=0;i<d.length;i++){if(d[i].getKey()==k){return d[i];}}}return null;};var s=function(e,k,v,w){if(v===null){var d=g(e,k);if(!d){return;}var c=e.getAggregation("customData").length;if(c==1){e.destroyAggregation("customData",true);}else{e.removeAggregation("customData",d,true);d.destroy();}}else{var C=sap.ui.requireSync('sap/ui/core/CustomData');var d=g(e,k);if(d){d.setValue(v);d.setWriteToDom(w);}else{var d=new C({key:k,value:v,writeToDom:w});e.addAggregation("customData",d,true);}}};b.prototype.data=function(){var c=arguments.length;if(c==0){var d=this.getAggregation("customData"),r={};if(d){for(var i=0;i<d.length;i++){r[d[i].getKey()]=d[i].getValue();}}return r;}else if(c==1){var e=arguments[0];if(e===null){this.destroyAggregation("customData",true);return this;}else if(typeof e=="string"){var h=g(this,e);return h?h.getValue():null;}else if(typeof e=="object"){for(var k in e){s(this,k,e[k]);}return this;}else{throw new Error("When data() is called with one argument, this argument must be a string, an object or null, but is "+(typeof e)+":"+e+" (on UI Element with ID '"+this.getId()+"')");}}else if(c==2){s(this,arguments[0],arguments[1]);return this;}else if(c==3){s(this,arguments[0],arguments[1],arguments[2]);return this;}else{throw new Error("data() may only be called with 0-3 arguments (on UI Element with ID '"+this.getId()+"')");}};})();b.prototype.clone=function(s,l){var c=M.prototype.clone.apply(this,arguments);for(var i=0;i<this.aDelegates.length;i++){if(this.aDelegates[i].bClone){c.aDelegates.push(this.aDelegates[i]);}}for(var i=0;i<this.aBeforeDelegates.length;i++){if(this.aBeforeDelegates[i].bClone){c.aBeforeDelegates.push(this.aBeforeDelegates[i]);}}if(this._sapui_declarativeSourceInfo){c._sapui_declarativeSourceInfo=q.extend({},this._sapui_declarativeSourceInfo);}return c;};b.prototype.findElements=M.prototype.findAggregatedObjects;function f(e){var l=e.getParent();if(l){var o=q.Event("LayoutDataChange");o.srcControl=e;l._handleEvent(o);}}b.prototype.setLayoutData=function(l){this.setAggregation("layoutData",l,true);f(this);return this;};b.prototype.destroyLayoutData=function(){this.destroyAggregation("layoutData",true);f(this);return this;};b.prototype.bindElement=M.prototype.bindObject;b.prototype.unbindElement=M.prototype.unbindObject;b.prototype.getElementBinding=M.prototype.getObjectBinding;b.prototype._getFieldGroupIds=function(){var F;if(this.getMetadata().hasProperty("fieldGroupIds")){F=this.getFieldGroupIds();}if(!F||F.length==0){var p=this.getParent();if(p&&p._getFieldGroupIds){return p._getFieldGroupIds();}}return F||[];};b.prototype.getDomRefForSetting=function(s){var S=this.getMetadata().getAllSettings()[s];if(S&&S.selector){var d=this.getDomRef();if(d){d=d.parentNode;if(d&&d.querySelector){var c=S.selector.replace(/\{id\}/g,this.getId().replace(/(:|\.)/g,'\\$1'));return d.querySelector(c);}}}return null;};b.prototype._getMediaContainerWidth=function(){if(typeof this._oContextualSettings==="undefined"){return undefined;}return this._oContextualSettings.contextualWidth;};b.prototype._getCurrentMediaContainerRange=function(n){var w=this._getMediaContainerWidth();n=n||D.media.RANGESETS.SAP_STANDARD;return D.media.getCurrentRange(n,w);};b.prototype._onContextualSettingsChanged=function(){var w=this._getMediaContainerWidth(),s=w!==undefined,p=s^!!this._bUsingContextualWidth,l=this._aContextualWidthListeners||[];if(p){if(s){l.forEach(function(o){D.media.detachHandler(o.callback,o.listener,o.name);});}else{l.forEach(function(o){D.media.attachHandler(o.callback,o.listener,o.name);});}this._bUsingContextualWidth=s;}l.forEach(function(o){var m=this._getCurrentMediaContainerRange(o.name);if(m.from!==o.media.from){o.media=m;o.callback.call(o.listener||window,m);}},this);};b.prototype._attachMediaContainerWidthChange=function(F,l,n){n=n||D.media.RANGESETS.SAP_STANDARD;this._aContextualWidthListeners=this._aContextualWidthListeners||[];this._aContextualWidthListeners.push({callback:F,listener:l,name:n,media:this._getCurrentMediaContainerRange(n)});if(!this._bUsingContextualWidth){D.media.attachHandler(F,l,n);}};b.prototype._detachMediaContainerWidthChange=function(F,l,n){var o;n=n||D.media.RANGESETS.SAP_STANDARD;if(!this._aContextualWidthListeners){return;}for(var i=0,c=this._aContextualWidthListeners.length;i<c;i++){o=this._aContextualWidthListeners[i];if(o.callback===F&&o.listener===l&&o.name===n){if(!this._bUsingContextualWidth){D.media.detachHandler(F,l,n);}this._aContextualWidthListeners.splice(i,1);break;}}};return b;});
