/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/XMLCompositeMetadata','sap/ui/model/base/ManagedObjectModel','sap/ui/model/json/JSONModel','sap/ui/core/Fragment','sap/ui/base/ManagedObject','sap/ui/base/DataType','sap/ui/model/resource/ResourceModel','sap/base/Log','sap/ui/performance/Measurement'],function(q,C,X,M,J,F,a,D,R,L,b){"use strict";var x="sap.ui.core.XMLComposite";function r(o,t,d){var k,A,i,e,m={},n;if(o&&o instanceof a){for(var E in o.mEventRegistry){m[E]=[];e=o.mEventRegistry[E];for(i=0;i<e.length;i++){n=q.extend({},e[i]);if(n.oListener==t){n.oListener=d;}m[E].push(n);}}o.mEventRegistry=m;for(k in o.mAggregations){A=o.mAggregations[k];if(!Array.isArray(A)){A=[A];}for(i=0;i<A.length;i++){r(A[i],t,d);}}}}var c=C.extend("sap.ui.core.XMLComposite",{metadata:{interfaces:["sap.ui.core.IDScope"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%',invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},displayBlock:{type:"boolean",group:"Appearance",defaultValue:true,invalidate:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden",invalidate:true}}},constructor:function(i,s){this._bIsCreating=true;C.apply(this,arguments);delete this._bIsCreating;},renderer:function(o,d){L.debug("Start rendering '"+d.sId,x);b.start(d.getId()+"---renderControl","Rendering of "+d.getMetadata().getName(),["rendering","control"]);o.write("<div");o.writeControlData(d);o.writeAccessibilityState(d);if(!d.getDisplayBlock()&&(d.getWidth()!=="100%"||d.getHeight()!=="100%")){o.addStyle("display","inline-block");}o.writeClasses();if(d.getHeight()){o.addStyle("height",d.getHeight());}if(d.getWidth()){o.addStyle("width",d.getWidth());}o.writeStyles();o.write(">");var e=d._renderingContent?d._renderingContent():d._getCompositeAggregation();if(e){o.renderControl(e);}o.write("</div>");b.end(d.getId()+"---renderControl");L.debug("Stop rendering '"+d.sId,x);}},X);c.prototype.clone=function(){var o=a.prototype.clone.apply(this,arguments);var d=o._renderingContent?o._renderingContent():o._getCompositeAggregation();r(d,this,o);o.oPropagatedProperties=this.oPropagatedProperties;o._bIsClone=true;return o;};c.prototype.byId=function(i){return sap.ui.getCore().byId(F.createId(this.getId(),i));};c.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}return this._oManagedObjectModel;};c.prototype.getSuppressInvalidateAggregation=function(n,s){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(!A){return true;}s=m._suppressInvalidate(A,s);return s;};c.prototype.setProperty=function(n,v,s){var m=this.getMetadata(),p=m.getProperty(n);if(!p){return this;}s=this.getMetadata()._suppressInvalidate(p,s);return C.prototype.setProperty.apply(this,[n,v,s]);};c.prototype.setAggregation=function(n,o,s){return C.prototype.setAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};c.prototype.addAggregation=function(n,o,s){return C.prototype.addAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};c.prototype.insertAggregation=function(n,o,i,s){return C.prototype.insertAggregation.apply(this,[n,o,i,this.getSuppressInvalidateAggregation(n,s)]);};c.prototype.removeAggregation=function(n,o,s){return C.prototype.removeAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};c.prototype.removeAllAggregation=function(n,s){return C.prototype.removeAllAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};c.prototype.destroyAggregation=function(n,s){return C.prototype.destroyAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};c.prototype.updateAggregation=function(n,s){var A=this.getMetadata().getAggregation(n);if(A&&A.type==="TemplateMetadataContext"){this.invalidate();return;}C.prototype.updateAggregation.apply(this,arguments);};c.prototype.setVisible=function(v){this.setProperty("visible",v);if(this.getParent()){this.getParent().invalidate();}return this;};c.prototype._destroyCompositeAggregation=function(){var o=this._getCompositeAggregation();if(o){o.destroy("KeepDom");}return this;};c.prototype.updateBindings=function(){if(this._bIsCreating){return;}var o=C.prototype.updateBindings.apply(this,arguments);for(var n in this.mBindingInfos){var A=this.getMetadata().getAggregation(n);if(A&&A.multiple&&!A._doesNotRequireFactory&&this.isBound(n)&&!this.getBinding(n)){this[A._sDestructor]();}}return o;};c.prototype._getCompositeAggregation=function(){var s=this.getMetadata().getCompositeAggregationName();return this.getAggregation(s);};c.prototype._setCompositeAggregation=function(n){var s=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel();}if(Array.isArray(n)){this.setAggregation(s,null);return;}if(n){if(!n.enhanceAccessibilityState){n.enhanceAccessibilityState=function(e,A){this.enhanceAccessibilityState(e,A);}.bind(this);}n.setModel(this._oManagedObjectModel,"$"+this.alias);n.bindObject("$"+this.alias+">/");var o=this._getResourceModel();if(o){n.setModel(o,"$"+this.alias+".i18n");}}this.setAggregation(s,n);};c.mResourceModels={};c.getLibraryResourceModel=function(l){var o=c.mResourceModels[l];if(!o){o=new R({bundleName:l+".messagebundle",async:true});c.mResourceModels[l]=o;}return o;};c.prototype._getResourceModel=function(){if(this.resourceModel){return this.resourceModel;}if(this.messageBundle){this.resourceModel=new R({bundleName:this.messageBundle,async:true});return this.resourceModel;}else{this.sLibraryName=this.sLibraryName||this.getMetadata().getLibraryName();if(this.sLibraryName){return c.getLibraryResourceModel(this.sLibraryName);}}};c.prototype.getResourceBundle=function(){var o=this._getResourceModel();return o?o.getResourceBundle():null;};c.prototype.destroy=function(){C.prototype.destroy.apply(this,arguments);if(this.resourceModel){this.resourceModel.destroy();}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();}};c.prototype._initCompositeSupport=function(s){var m=this.getMetadata(),A=m.getCompositeAggregationName(),i=false;if(s&&A&&s[A]){var n=s[A];if(n instanceof a){this._setCompositeAggregation(n);i=true;}else if(n.localName==="FragmentDefinition"){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:s[A],oController:this}));i=true;}delete s[A];}if(!i){this._destroyCompositeAggregation();this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:this.getMetadata()._fragment,oController:this}));}this._bIsInitialized=true;};c.prototype.enhanceAccessibilityState=function(e,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){return p.enhanceAccessibilityState(this,A);}return A;};c.prototype.getFocusDomRef=function(){var o=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return o.getFocusDomRef();};c.prototype.getFocusInfo=function(){var o=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return o.getFocusInfo();};c.prototype.getIdForLabel=function(){var o=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return o.getIdForLabel();};return c;});
