/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/base/strings/escapeRegExp","sap/base/assert","sap/ui/thirdparty/jquery"],function(B,L,a,e,b,q){"use strict";var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});var r=/0+(\.0+)?/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.getInstance=function(F,l){return this.getFloatInstance(F,l);};N.getFloatInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.FLOAT);o.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,i,F);return o;};N.getIntegerInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.INTEGER);o.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,i,F);return o;};N.getCurrencyInstance=function(F,l){var o=this.createInstance(F,l),C=F&&F.currencyContext,i=this.getLocaleFormatOptions(o.oLocaleData,n.CURRENCY,C);o.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,i,F);return o;};N.getUnitInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.UNIT);o.oFormatOptions=q.extend(false,{},this.oDefaultUnitFormat,i,F);return o;};N.getPercentInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.PERCENT);o.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,i,F);return o;};N.createInstance=function(F,l){var o=Object.create(this.prototype),P;if(F instanceof L){l=F;F=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}o.oLocale=l;o.oLocaleData=a.getInstance(l);o.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);q.each(P,function(s,O){F[s]=O;});}if(F.emptyString!==undefined){b(typeof F.emptyString!=="string","The format option 'emptyString' can not be with type 'string'");b(F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return o;};N.getLocaleFormatOptions=function(l,t,C){var o,s;switch(t){case n.PERCENT:s=l.getPercentPattern();break;case n.CURRENCY:s=l.getCurrencyPattern(C);break;case n.UNIT:s=l.getDecimalPattern();break;default:s=l.getDecimalPattern();}o=this.parseNumberPattern(s);o.plusSign=l.getNumberSymbol("plusSign");o.minusSign=l.getNumberSymbol("minusSign");o.decimalSeparator=l.getNumberSymbol("decimal");o.groupingSeparator=l.getNumberSymbol("group");o.percentSign=l.getNumberSymbol("percentSign");o.pattern=s;switch(t){case n.FLOAT:case n.PERCENT:o.minFractionDigits=0;o.maxFractionDigits=99;break;case n.INTEGER:o.minFractionDigits=0;o.maxFractionDigits=0;o.groupingEnabled=false;break;case n.CURRENCY:o.minFractionDigits=undefined;o.maxFractionDigits=undefined;break;}return o;};N.parseNumberPattern=function(F){var M=0,k=0,l=0,G=false,o=0,s=0,S=F.indexOf(";"),t={Integer:0,Fraction:1},u=t.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var C=F[i];switch(C){case",":if(G){o=s;s=0;}G=true;break;case".":u=t.Fraction;break;case"0":if(u===t.Integer){M++;if(G){s++;}}else{k++;l++;}break;case"#":if(u===t.Integer){if(G){s++;}}else{l++;}break;}}if(!o){o=s;s=0;}return{minIntegerDigits:M,minFractionDigits:k,maxFractionDigits:l,groupingEnabled:G,groupingSize:o,groupingBaseSize:s};};N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",F="",G="",s="",k="",P="",l=0,o=0,t=0,u=0,w=v<0,D=-1,O=q.extend({},this.oFormatOptions),x=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",y,S,z,A,U,C;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{C=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(C);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){z=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(z,O,this.oLocaleData,I);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(x.minFractionDigits===undefined&&x.maxFractionDigits===undefined&&x.decimals===undefined&&x.precision===undefined&&x.pattern===undefined){O.precision=2;}if(x.maxFractionDigits===undefined&&x.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if(O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,j(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var E=this.oLocaleData.getCurrencyDigits(M);if(O.maxFractionDigits===undefined){O.maxFractionDigits=E;}if(O.minFractionDigits===undefined){O.minFractionDigits=E;}}if(typeof v==="number"){v=f(v,O.maxFractionDigits,O.roundingMode);}if(v==0){w=false;}k=this.convertToDecimal(v);if(k=="NaN"){return k;}if(w){k=k.substr(1);}D=k.indexOf(".");if(D>-1){i=k.substr(0,D);F=k.substr(D+1);}else{i=k;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits){F=F.substr(0,O.maxFractionDigits);}o=i.length;if(O.groupingEnabled){if(I){var H=[3,2,2],J,K=0;l=i.length;while(l>0){J=H[K%3];l-=J;if(K>0){G=O.groupingSeparator+G;}if(l<0){J+=l;l=0;}G=i.substr(l,J)+G;K++;}}else{t=O.groupingSize;u=O.groupingBaseSize||t;l=Math.max(o-u,0)%t||t;G=i.substr(0,l);while(o-l>=u){G+=O.groupingSeparator;G+=i.substr(l,t);l+=t;}G+=i.substr(l);}}else{G=i;}if(w){s=O.minusSign;}s+=G;if(F){s+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){A=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,A);s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){A=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=d("short",S.key,A);}else{P=this.oLocaleData.getCurrencyFormat("short",S.key,A);}P=P.replace(/'.'/g,".");}y=P.split(";");if(y.length===2){P=w?y[1]:y[0];if(w){s=s.substring(1);}}if(!O.currencyCode){M=this.oLocaleData.getCurrencySymbol(M);}s=this._composeCurrencyResult(P,s,M,{showMeasure:O.showMeasure,negative:w,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;s=P.replace(/[0#.,]+/,s);s=s.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){A=this.oLocaleData.getPluralCategory(i+"."+F);b(A,"Cannot find plural category for "+(i+"."+F));var Q=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!Q){b(Q,"The given unit '"+M+"' is not part of the allowed unit types: ["+O.allowedUnits.join(",")+"].");return"";}if(U){P=U["unitPattern-count-"+A];if(!P){P=U["unitPattern-count-other"];}b(P,"Cannot find pattern 'unitPattern-count-"+A+"' in '"+M+"'");if(!P){return"";}s=P.replace("{0}",s);}else{b(U,"Unit '"+M+"' is unknown");return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};N.prototype._composeCurrencyResult=function(P,F,M,o){var s=o.minusSign;P=P.replace(/[0#.,]+/,F);if(o.showMeasure&&M){var i="\u00a4",k={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},l=P.indexOf(i),t=l<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(t),C=(t==="after"?M.charAt(M.length-1):M.charAt(0)),u,v=k[S.currencyMatch],w=k[S.surroundingMatch],I;P=P.replace(i,M);u=(t==="after"?P.charAt(l+M.length):P.charAt(l-1));if(v&&v.test(C)&&w&&w.test(u)){if(t==="after"){I=l+M.length;}else{I=l;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(o.negative&&t==="after"){s="\ufeff"+o.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(o.negative){P=P.replace(/-/,s);}return P;};N.prototype.parse=function(v){var o=this.oFormatOptions,P=h(o.plusSign+o.minusSign),G=h(o.groupingSeparator),D=h(o.decimalSeparator),s="^\\s*(["+P+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",k="^\\s*(["+P+"]?[0-9"+G+"]+)\\s*$",l=new RegExp(G,"g"),t=new RegExp(D,"g"),u=this.oLocaleData.getNumberSymbol("percentSign"),I=o.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",w,x,y,z,A,M,C,E=0,S,F;if(v===""){F=o.emptyString;if(o.parseAsString&&(o.emptyString===0||isNaN(o.emptyString))){F=o.emptyString+"";}if(o.type===n.CURRENCY){return[F,undefined];}else{return F;}}C=o.type===n.PERCENT?o.pattern:this.oLocaleData.getPercentPattern();if(C.charAt(0)==="%"){s=s.slice(0,1)+"%?"+s.slice(1);}else if(C.charAt(C.length-1)==="%"){s=s.slice(0,s.length-1)+"%?"+s.slice(s.length-1);}var U;if(o.type===n.UNIT){var H;if(o.customUnits&&typeof o.customUnits==="object"){H=o.customUnits;}else{H=this.oLocaleData.getUnitFormats();}b(H,"Unit patterns cannot be loaded");if(o.allowedUnits){var J={};for(var i=0;i<o.allowedUnits.length;i++){var K=o.allowedUnits[i];J[K]=H[K];}H=J;}var O=p(H,v);U=O.cldrCode;if(U.length===1){M=U[0];}else if(U.length===0){b(U.length===1,"Cannot find unit for input: '"+(v)+"'");return null;}else{b(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(v)+"'");M=undefined;}v=O.numberValue||v;}v=v.replace(/\s/g,"");S=c(v,this.oLocaleData,I);if(S){v=S.number;}if(o.isInteger&&!S){w=new RegExp(k);}else if(o.type===n.CURRENCY){z="[^\\d\\s+-]*";y="(?:^("+z+")"+s.substring(1,s.length-1)+"$)|(?:^"+s.substring(1,s.length-1)+"("+z+")\\s*$)";w=new RegExp(y);}else{w=new RegExp(s);}if(!w.test(v)){return o.type===n.CURRENCY||o.type===n.UNIT?null:NaN;}if(o.type===n.CURRENCY){A=w.exec(v);if(A[2]){v=A[2];M=A[1]||undefined;}else{v=A[3];M=A[4]||undefined;}if(M&&!o.showMeasure){return null;}if(M){M=this.oLocaleData.getCurrencyCodeBySymbol(M)||M;}}v=v.replace(l,"");v=v.replace(o.plusSign,"+");v=v.replace(o.minusSign,"-");v=v.replace(/^\+/,"");if(S){v=v.replace(t,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(o.isInteger){E=o.parseAsString?v:parseInt(v,10);}else{v=v.replace(t,".");if(v.indexOf(u)!==-1){x=true;v=v.replace(u,"");}E=o.parseAsString?v:parseFloat(v);if(x){E=N._shiftDecimalPoint(E,-2);}}if(o.parseAsString){E=N._shiftDecimalPoint(v,0);}if(o.type===n.CURRENCY||o.type===n.UNIT){return[E,M];}return E;};N.prototype.convertToDecimal=function(v){var V=""+v,k,s,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var l=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);k=l[1]=="-";s=l[2].replace(/\./g,"");D=l[3]?l[3].length:0;F=l[4]?l[4].length:0;E=parseInt(l[5],10);if(E>0){if(E<F){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(k){V="-"+V;}return V;};N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var s=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),S;if(s&&s.formatString){S=s.formatString.replace(r,"").replace(/'.'/g,".").trim();if(S){return S;}}};N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=E[1]?(+E[1]+s):s;return+(E[0]+"e"+s);}else if(typeof v==="string"){if(parseFloat(v)===0&&s>=0){return v;}v=E[0];var D=v.indexOf("."),A,i,k;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+s;if(A<=0){v=v.padStart(v.length-A+1,'0');A=1;}else if(A>=v.length-1){v=v.padEnd(A+1,'0');A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);k=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return i+(k?("."+k):"");}else{return null;}};function g(v,o,l,I){var s,k,K,C,S=o.style,P=o.precision!==undefined?o.precision:2;if(S!="short"&&S!="long"){return undefined;}for(var i=0;i<15;i++){k=Math.pow(10,i);if(f(Math.abs(v)/k,P-1)<10){break;}}K=k.toString();if(I){C=d(S,K,"other",true);}else{C=l.getDecimalFormat(S,K,"other");}if(!C||C=="0"){return undefined;}else{s={};s.key=K;s.formatString=C;var t=C.match(r);if(t){s.valueSubString=t[0];var u=s.valueSubString.indexOf(".");if(u==-1){s.decimals=0;s.magnitude=k*Math.pow(10,1-s.valueSubString.length);}else{s.decimals=s.valueSubString.length-u-1;s.magnitude=k*Math.pow(10,1-u);}}else{return undefined;}}return s;}function c(v,l,I){var s,F=1,k=10,P=l.getPluralCategories(),C,o={number:undefined,factor:F},G=function(u,k,S,w){if(w){C=d(S,k.toString(),u,true);}else{C=l.getDecimalFormat(S,k.toString(),u);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var x=C.match(r);if(x){var V=x[0];var U=C.replace(V,"");if(!U){return;}var y=v.indexOf(U);if(y>=0){s=v.replace(U,"");s=s.replace(/\u200F/g,"");F=k;F*=Math.pow(10,1-V.length);if(o.number===undefined||s.length<o.number.length){o.number=s;o.factor=F;}}}}};["long","short"].forEach(function(S){k=10;while(k<1e15){for(var i=0;i<P.length;i++){var t=P[i];G(t,k,S);}k=k*10;}});if(I&&!s){k=10;while(k<1e15){for(var i=0;i<P.length;i++){var t=P[i];G(t,k,"short",true);}k=k*10;}}if(!s){return;}return o;}function d(s,k,P,D){var F,o={"short":{"1000-one":"¤0000","1000-other":"¤0000","10000-one":"¤00000","10000-other":"¤00000","100000-one":"¤0 Lk","100000-other":"¤0 Lk","1000000-one":"¤00 Lk","1000000-other":"¤00 Lk","10000000-one":"¤0 Cr","10000000-other":"¤0 Cr","100000000-one":"¤00 Cr","100000000-other":"¤00 Cr","1000000000-one":"¤000 Cr","1000000000-other":"¤000 Cr","10000000000-one":"¤0000 Cr","10000000000-other":"¤0000 Cr","100000000000-one":"¤00000 Cr","100000000000-other":"¤00000 Cr","1000000000000-one":"¤0 Lk Cr","1000000000000-other":"¤0 Lk Cr","10000000000000-one":"¤00 Lk Cr","10000000000000-other":"¤00 Lk Cr","100000000000000-one":"¤0 Cr Cr","100000000000000-other":"¤0 Cr Cr"}};s="short";if(P!=="one"){P="other";}F=o[s][k+"-"+P];if(F&&D){F=F.substr(1);}return F;}function f(v,M,s){if(typeof v!=="number"){return NaN;}s=s||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M,10);if(typeof s==="function"){v=s(v,M);}else{if(!M){return m[s](v);}v=N._shiftDecimalPoint(m[s](N._shiftDecimalPoint(v,M)),-M);}return v;}function h(s){return s.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}function j(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}function p(u,v){var o={numberValue:undefined,cldrCode:[]};var i;var U,k;for(U in u){for(k in u[U]){if(k.indexOf("unitPattern")===0){var s=u[U][k];var C=s.indexOf("{0}")>-1;if(C){s="^"+e(s).replace("\\{0\\}","(.+)")+"$";var l=new RegExp(s);var t=l.exec(v);if(t&&t[1]){if(i===undefined||t[1].length<i){i=t[1].length;o.numberValue=t[1];o.cldrCode=[U];}else if(t[1].length===i&&o.cldrCode.indexOf(U)===-1){o.cldrCode.push(U);}}}else if(s===v){o.cldrCode=[U];var w;if(k.endsWith("-zero")){w="0";}else if(k.endsWith("-one")){w="1";}else if(k.endsWith("-two")){w="2";}o.numberValue=w;return o;}}}}return o;}return N;});
