/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/SyncPromise","./_Batch","./_GroupLock","./_Helper","./_V2Requestor","sap/base/util/deepEqual","sap/ui/thirdparty/jquery"],function(S,_,a,b,c,d,q){"use strict";var B={"Accept":"multipart/mixed"},e;function f(r,G){var h=r.mBatchQueue[G];if(h[0].length===0&&h.length===1){delete r.mBatchQueue[G];}}function g(h){var r;h=h.toLowerCase();for(r in this.headers){if(r.toLowerCase()===h){return this.headers[r];}}}function R(s,h,Q,m){this.mBatchQueue={};this.mHeaders=h||{};this.oModelInterface=m;this.sQueryParams=b.buildQuery(Q);this.mRunningChangeRequests={};this.oSecurityTokenPromise=null;this.sServiceUrl=s;}R.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};R.prototype.mPredefinedPartHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true"};R.prototype.mPredefinedRequestHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};R.prototype.batchRequestSent=function(G,h){if(h){if(G in this.mRunningChangeRequests){this.mRunningChangeRequests[G]+=1;}else{this.mRunningChangeRequests[G]=1;}}};R.prototype.batchResponseReceived=function(G,h){if(h){this.mRunningChangeRequests[G]-=1;if(this.mRunningChangeRequests[G]===0){delete this.mRunningChangeRequests[G];}}};R.prototype.buildQueryString=function(m,Q,D,s){return b.buildQuery(this.convertQueryOptions(m,Q,D,s));};R.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangesByFilter(function(){return true;},G);};R.prototype.cancelChangesByFilter=function(F,G){var C=false,t=this;function h(s){var j=t.mBatchQueue[s],o,k,E,i;k=j[0];for(i=k.length-1;i>=0;i--){o=k[i];if(o.$cancel&&F(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);k.splice(i,1);C=true;}}f(t,s);}if(G){if(this.mBatchQueue[G]){h(G);}}else{for(G in this.mBatchQueue){h(G);}}return C;};R.prototype.convertExpand=function(E,s){var k,r=[],t=this;if(!E||typeof E!=="object"){throw new Error("$expand must be a valid object");}k=Object.keys(E);if(s){k=k.sort();}k.forEach(function(h){var v=E[h];if(v&&typeof v==="object"){r.push(t.convertExpandOptions(h,v,s));}else{r.push(h);}});return r.join(",");};R.prototype.convertExpandOptions=function(E,v,s){var h=[];this.doConvertSystemQueryOptions(undefined,v,function(o,O){h.push(o+'='+O);},undefined,s);return h.length?E+"("+h.join(";")+")":E;};R.prototype.convertQueryOptions=function(m,Q,D,s){var C={};if(!Q){return undefined;}this.doConvertSystemQueryOptions(m,Q,function(k,v){C[k]=v;},D,s);return C;};R.prototype.convertResourcePath=function(r){return r;};R.prototype.doCheckVersionHeader=function(G,r,v){var o=G("OData-Version"),D=!o&&G("DataServiceVersion");if(D){throw new Error("Expected 'OData-Version' header with value '4.0' but received"+" 'DataServiceVersion' header with value '"+D+"' in response for "+this.sServiceUrl+r);}if(o==="4.0"||!o&&v){return;}throw new Error("Expected 'OData-Version' header with value '4.0' but received value '"+o+"' in response for "+this.sServiceUrl+r);};R.prototype.doConvertResponse=function(r,m){return r;};R.prototype.doConvertSystemQueryOptions=function(m,Q,r,D,s){var t=this;Object.keys(Q).forEach(function(k){var v=Q[k];if(D&&k[0]==='$'){return;}switch(k){case"$expand":v=t.convertExpand(v,s);break;case"$select":if(Array.isArray(v)){v=s?v.sort().join(","):v.join(",");}break;default:}r(k,v);});};R.prototype.fetchMetadata=function(m){return this.oModelInterface.fnFetchMetadata(m);};R.prototype.fetchTypeForPath=function(m,A){return this.fetchMetadata(m+(A?"/$Type":"/"));};R.prototype.formatPropertyAsLiteral=function(v,p){return b.formatLiteral(v,p.$Type);};R.prototype.getGroupSubmitMode=function(G){return this.oModelInterface.fnGetGroupProperty(G,"submit");};R.prototype.getPathAndAddQueryOptions=function(p,o,P){var A=[],n,N={},h,t=this;p=p.slice(1,-5);if(o.$Parameter){o.$Parameter.forEach(function(h){N[h.$Name]=h;});}if(o.$kind==="Function"){for(n in P){h=N[n];if(h){if(h.$IsCollection){throw new Error("Unsupported collection-valued parameter: "+n);}A.push(encodeURIComponent(n)+"="+encodeURIComponent(t.formatPropertyAsLiteral(P[n],h)));}}p+="("+A.join(",")+")";}else{for(n in P){if(!(n in N)){delete P[n];}}}return p;};R.prototype.getServiceUrl=function(){return this.sServiceUrl;};R.prototype.hasPendingChanges=function(){var G,p;for(G in this.mBatchQueue){p=this.mBatchQueue[G][0].some(function(r){return r.$cancel;});if(p){return true;}}return Object.keys(this.mRunningChangeRequests).length>0;};R.prototype.isActionBodyOptional=function(){return false;};R.prototype.isChangeSetOptional=function(){return true;};R.prototype.ready=function(){return S.resolve();};R.prototype.refreshSecurityToken=function(o){var t=this;if(!this.oSecurityTokenPromise){if(o!==this.mHeaders["X-CSRF-Token"]){return Promise.resolve();}this.oSecurityTokenPromise=new Promise(function(r,h){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:{"X-CSRF-Token":"Fetch"}}).then(function(D,T,j){t.mHeaders["X-CSRF-Token"]=j.getResponseHeader("X-CSRF-Token");t.oSecurityTokenPromise=null;r();},function(j,T,E){t.oSecurityTokenPromise=null;h(b.createError(j));});});}return this.oSecurityTokenPromise;};R.prototype.relocate=function(C,o,n){var r=this.mBatchQueue[C],t=this,F=r&&r[0].some(function(h,i){if(h.body===o){t.request(h.method,h.url,new a(n),h.headers,o,h.$submit,h.$cancel).then(h.$resolve,h.$reject);r[0].splice(i,1);f(t,C);return true;}});if(!F){throw new Error("Request not found in group '"+C+"'");}};R.prototype.removePatch=function(p){var C=this.cancelChangesByFilter(function(o){return o.$promise===p;});if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.removePost=function(G,o){var C=this.cancelChangesByFilter(function(h){return h.body===o;},G);if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.reportBoundMessages=function(r,p,C){this.oModelInterface.fnReportBoundMessages(r,p,C);};R.prototype.reportUnboundMessages=function(r,m){this.oModelInterface.fnReportUnboundMessages(r,JSON.parse(m||null));};R.prototype.request=function(m,r,G,h,p,s,C,M){var E,i=G&&G.getGroupId()||"$direct",P,o,t=this;if(i==="$cached"){E=new Error("Unexpected request: "+m+" "+r);E.$cached=true;throw E;}if(G){G.unlock();}r=this.convertResourcePath(r);if(this.getGroupSubmitMode(i)!=="Direct"){P=new Promise(function(j,k){var l=t.mBatchQueue[i];if(!l){l=t.mBatchQueue[i]=[[]];if(t.oModelInterface.fnOnCreateGroup){t.oModelInterface.fnOnCreateGroup(i);}}o={method:m,url:r,headers:q.extend({},t.mPredefinedPartHeaders,t.mHeaders,h,t.mFinalHeaders),body:p,$cancel:C,$metaPath:M,$reject:k,$resolve:j,$submit:s};if(m==="GET"){l.push(o);}else{l[0].push(o);}});o.$promise=P;return P;}if(s){s();}return this.sendRequest(m,r,q.extend({},h,this.mFinalHeaders),JSON.stringify(e.cleanPayload(p))).then(function(j){t.reportUnboundMessages(j.resourcePath,j.messages);return t.doConvertResponse(j.body,M);});};R.prototype.sendBatch=function(r){var o=_.serializeBatchRequest(r);return this.sendRequest("POST","$batch"+this.sQueryParams,q.extend(o.headers,B),o.body).then(function(h){if(h.messages!==null){throw new Error("Unexpected 'sap-messages' response header for batch request");}return _.deserializeBatchResponse(h.contentType,h.body);});};R.prototype.sendRequest=function(m,r,h,p){var s=this.sServiceUrl+r,t=this;return new Promise(function(i,j){function k(I){var o=t.mHeaders["X-CSRF-Token"];return q.ajax(s,{data:p,headers:q.extend({},t.mPredefinedRequestHeaders,t.mHeaders,h),method:m}).then(function(l,T,n){try{t.doCheckVersionHeader(n.getResponseHeader,r,!l);}catch(E){j(E);return;}t.mHeaders["X-CSRF-Token"]=n.getResponseHeader("X-CSRF-Token")||t.mHeaders["X-CSRF-Token"];i({body:l,contentType:n.getResponseHeader("Content-Type"),messages:n.getResponseHeader("sap-messages"),resourcePath:r});},function(l,T,E){var C=l.getResponseHeader("X-CSRF-Token");if(!I&&l.status===403&&C&&C.toLowerCase()==="required"){t.refreshSecurityToken(o).then(function(){k(true);},j);}else{j(b.createError(l));}});}if(t.oSecurityTokenPromise&&m!=="GET"){return t.oSecurityTokenPromise.then(k);}return k();});};R.prototype.submitBatch=function(G){var C=[],h,p,r=this.mBatchQueue[G],t=this;function m(p,j){var k,P,s;if(p&&p.method==="PATCH"&&j.method==="PATCH"&&p.url===j.url&&d(p.headers,j.headers)){P=p.body;k=j.body;for(s in P){if(P[s]===null&&k[s]&&typeof k[s]==="object"){return undefined;}}return q.extend(true,P,k);}return undefined;}function v(r,j){var k;r.forEach(function(l,n){var E,s,u=j[n];if(Array.isArray(u)){v(l,u);}else if(!u){E=new Error("HTTP request was not processed because the previous request failed");E.cause=k;l.$reject(E);}else if(u.status>=400){u.getResponseHeader=g;k=b.createError(u);i(k,l);}else if(u.responseText){s=JSON.parse(u.responseText);try{t.doCheckVersionHeader(g.bind(u),l.url,true);t.reportUnboundMessages(l.url,u.headers["sap-messages"]);l.$resolve(t.doConvertResponse(s,l.$metaPath));}catch(w){l.$reject(w);}}else{t.reportUnboundMessages(l.url,u.headers["sap-messages"]);l.$resolve();}});}function o(j){if(Array.isArray(j)){j.forEach(o);}else if(j.$submit){j.$submit();}}function i(E,j){if(Array.isArray(j)){j.forEach(i.bind(null,E));}else{j.$reject(E);}}if(!r){return Promise.resolve();}delete this.mBatchQueue[G];o(r);r[0].forEach(function(j){var M=m(p,j);if(M){p.body=M;j.$resolve(p.$promise);}else{C.push(j);p=j;}});if(C.length===0){r.splice(0,1);}else if(C.length===1&&this.isChangeSetOptional()){r[0]=C[0];}else{r[0]=C;}h=C.length>0;this.batchRequestSent(G,h);return this.sendBatch(e.cleanBatch(r)).then(function(j){t.batchResponseReceived(G,h);v(r,j);}).catch(function(E){var j=new Error("HTTP request was not processed because $batch failed");function k(r){r.forEach(function(l){if(Array.isArray(l)){k(l);}else{l.$reject(j);}});}t.batchResponseReceived(G,h);j.cause=E;k(r);throw E;});};e={cleanBatch:function(r){r.forEach(function(o){if(Array.isArray(o)){e.cleanBatch(o);}else{o.body=e.cleanPayload(o.body);}});return r;},cleanPayload:function(p){var r=p;if(r){Object.keys(r).forEach(function(k){if(k.indexOf("@$ui5.")===0){if(r===p){r=q.extend({},p);}delete r[k];}});}return r;},create:function(s,m,h,Q,o){var r=new R(s,h,Q,m);if(o==="2.0"){c(r);}return r;}};return e;},false);
