/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/dt/Plugin','sap/ui/fl/Utils','sap/ui/fl/registry/ChangeRegistry','sap/ui/dt/OverlayRegistry','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementOverlay','sap/ui/fl/changeHandler/JsControlTreeModifier','sap/ui/base/ManagedObject'],function(P,F,C,O,a,E,J,M){"use strict";E.prototype._bElementHasStableId=undefined;E.prototype.getElementHasStableId=function(){return this._bElementHasStableId;};E.prototype.setElementHasStableId=function(h){this._bElementHasStableId=h;};E.prototype.hasElementStableId=function(){return this._bElementHasStableId?true:false;};var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});B.prototype._isEditable=function(){};var _=function(e){var p=e.getParameters();var r;var o=sap.ui.getCore().byId(p.id);if((p.type==="propertyChanged"&&p.name==="visible")){r=this._getRelevantOverlays(o);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="overlayRendered"){this.evaluateEditable([o],{onRegistration:true});}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}};B.prototype._detachReevaluationEditable=function(o){o.detachElementModified(_,this);};B.prototype._attachReevaluationEditable=function(o){var g=function(e){if(e.getSource().getGeometry()&&e.getSource().getGeometry().visible){this.evaluateEditable([o],{onRegistration:true});o.detachEvent('geometryChanged',g,this);}};o.attachElementModified(_,this);if(!o.getGeometry()||!o.getGeometry().visible){o.attachEvent('geometryChanged',g,this);}};B.prototype._getRelevantOverlays=function(o,A){var d=o.getRelevantOverlays();if(d.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var e=o.getAggregationOverlay(A).getChildren();e=e.filter(function(f){return r.indexOf(f)===-1;});r=r.concat(e);}o.setRelevantOverlays(r);return r;}return d;};function b(e){return e.some(function(s){var S=O.getOverlay(s);return S&&a.isInAggregationBinding(S,s.sParentAggregationName);});}B.prototype.evaluateEditable=function(o,p){var d=this.getDesignTime()?this.getDesignTime().getPlugins():[];var s=d.some(function(f){return f.isBusy&&f.isBusy();});if(s){return;}var e;o.forEach(function(f){var i=false;var S=f.getDesignTimeMetadata().getStableElements(f);if(S[0]instanceof M){i=b(S);}if(i){e=false;}else{e=f.getElement()&&f.getDesignTimeMetadata()&&this._isEditable(f,p);}if(e!==undefined&&e!==null){if(typeof e==="boolean"){this._modifyPluginList(f,e);}else{this._modifyPluginList(f,e.asChild,false);this._modifyPluginList(f,e.asSibling,true);}}}.bind(this));};B.prototype._modifyPluginList=function(o,i,d){if(i){this.addToPluginsList(o,d);}else{this.removeFromPluginsList(o,d);}};B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var d=o.getEditableByPlugins();return d.indexOf(p)>-1;};B.prototype.registerElementOverlay=function(o){this.evaluateEditable([o],{onRegistration:true});this._attachReevaluationEditable(o);};B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);this._detachReevaluationEditable(o);};B.prototype.hasStableId=function(o){if(!o){return false;}if(!o.getDesignTimeMetadata()){return false;}if(o.getElementHasStableId()===undefined){var s=o.getDesignTimeMetadata().getStableElements(o);var u=s.length>0?s.some(function(S){var d=S.id||S;if(!F.checkControlId(d,S.appComponent)){return c(o,S);}}):true;o.setElementHasStableId(!u);}return o.hasElementStableId();};function c(o,s){var A=a.getAggregationInformation(o,o.getElement().sParentAggregationName);if(!A.templateId){return true;}else{return!F.checkControlId(A.templateId,s.appComponent);}}B.prototype.getVariantManagementReference=function(o,A,f,s){var e;if(!s){e=o.getElement();}else{e=s;}var r;if((A.changeOnRelevantContainer||f)&&!s){r=o.getRelevantContainer();}else{r=e;}var v;if(o.getVariantManagement&&this._hasVariantChangeHandler(A.changeType,r)){v=o.getVariantManagement();}return v;};B.prototype._hasVariantChangeHandler=function(s,e){var o=this._getChangeHandler(s,e);return(o&&o.revertChange);};B.prototype.checkAggregationsOnSelf=function(o,A,p){var d=o.getDesignTimeMetadata();var e=o.getElement();var i=false;var f=d.getActionDataFromAggregations(A,o.getElement());var g=f.filter(function(j){if(j&&p){return j.aggregation===p;}else{return true;}})[0];var s=g?g.changeType:null;var h=g&&g.changeOnRelevantContainer;if(h){e=o.getRelevantContainer();var r=O.getOverlay(e);if(!this.hasStableId(r)){return false;}}if(s&&this.hasChangeHandler(s,e)){i=true;}return i;};B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};B.prototype.hasChangeHandler=function(s,e){return!!this._getChangeHandler(s,e);};B.prototype._getChangeHandler=function(s,e,d){if(!d){d=e.getMetadata().getName();}var l=this.getCommandFactory().getFlexSettings().layer;return C.getInstance().getChangeHandler(s,d,e,J,l);};B.prototype.isAvailable=function(){return P.prototype.isAvailable.apply(this,arguments);};B.prototype._checkRelevantContainerStableID=function(A,e){if(A.changeOnRelevantContainer){var r=e.getRelevantContainer();var R=O.getOverlay(r);if(!this.hasStableId(R)){return false;}}return true;};return B;},true);
