/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/formatter","sap/ui/support/supportRules/Constants","sap/m/OverflowToolbarAssociativePopoverControls"],function($,B,J,C,S,E,I,c,f,a,O){"use strict";var i={severityIcons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return B.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1000,formatter:f,onInit:function(){this.model=S;this.setCommunicationSubscriptions();this.getView().setModel(this.model);this.clearFilters();this._initElementTree();this.treeTable=this.byId("issuesList");this.issueTable=this.byId("issueTable");this.toolHeader=this.byId('toolHeader');this.toolHeader.removeStyleClass('sapTntToolHeader sapContrast sapContrastPlus');this.model.setProperty("/bEnabledFilterButton",false);var t=this.toolHeader._getPopover();t.removeStyleClass('sapTntToolHeaderPopover sapContrast sapContrastPlus');O._mSupportedControls["sap.ui.layout.VerticalLayout"]={canOverflow:true,listenForEvents:[],noInvalidationProps:[]};},setCommunicationSubscriptions:function(){C.subscribe(c.ON_ANALYZE_FINISH,function(d){var t=this;var p={};t.data=d;d.issues.forEach(function(b){if(!b.context||!b.context.id){return;}if(!p[b.context.id]){p[b.context.id]=[b.name];}else{p[b.context.id].push(b.name);}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",d.issues);this.model.setProperty('/analyzePressed',true);this.model.setProperty("/issuesCount",this.data.issues.length);this.model.setProperty("/selectedIssue",null);this.elementTree.setData({controls:d.elementTree,issuesIds:p});this.clearFilters();},this);C.subscribe(c.GET_ISSUES,function(d){this.structuredIssuesModel=d.groupedIssues;this.model.setProperty("/issues",d.issuesModel);if(d.issuesModel[0]){this._setSelectedRule(d.issuesModel[0][0]);this.treeTable.setSelectedIndex(1);this.issueTable.setSelectedIndex(0);}},this);},_initElementTree:function(){var t=this;this.elementTree=new E(null,{onIssueCountClicked:function(s){t.clearFilters();t.model.setProperty("/elementFilter",s);t.updateIssuesVisibility();},onHoverChanged:function(h){C.publish(c.TREE_ELEMENT_MOUSE_ENTER,h);},onMouseOut:function(){C.publish(c.TREE_ELEMENT_MOUSE_OUT);}});},onAfterRendering:function(){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId());},clearFilters:function(){this.model.setProperty("/severityFilter",a.FILTER_VALUE_ALL);this.model.setProperty("/categoryFilter",a.FILTER_VALUE_ALL);this.model.setProperty("/elementFilter",a.FILTER_VALUE_ALL);this.model.setProperty("/audienceFilter",a.FILTER_VALUE_ALL);if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight();}this.model.setProperty("/bEnabledFilterButton",false);this.updateIssuesVisibility();},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection();},onIssuePressed:function(e){var s=this.model.getProperty("/selectedIssue");this.elementTree.setSelectedElement(s.context.id,false);},onRowSelectionChanged:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject(),v=a.MAX_VISIBLE_ISSUES_FOR_RULE;if(s.type==="rule"){this._setSelectedRule(s);}else{this.model.setProperty("/selectedIssue",null);}if(s.issueCount<v){v=s.issueCount;}this.model.setProperty("/visibleRowCount",v);}},openDocumentation:function(e){var l=sap.ui.getCore().byId(e.mParameters.id),u=l.getBindingContext().getProperty("href");C.publish(c.OPEN_URL,u);},updateIssuesVisibility:function(){if(this.data){var b=this.data.issues.filter(this.filterIssueListItems,this);C.publish(c.REQUEST_ISSUES,b);this.model.setProperty("/visibleIssuesCount",b.length);}this.setToolbarHeight();},filterIssueListItems:function(b){var s=this.model.getProperty("/severityFilter"),d=b.severity===s||s===a.FILTER_VALUE_ALL,e=this.model.getProperty("/categoryFilter"),g=$.inArray(e,b.categories)>-1||e===a.FILTER_VALUE_ALL,h=this.model.getProperty("/elementFilter"),j=h===b.context.id||h===a.FILTER_VALUE_ALL,k=this.model.getProperty("/audienceFilter"),l=$.inArray(k,b.audiences)>-1||k===a.FILTER_VALUE_ALL,m=s===a.FILTER_VALUE_ALL&&e===a.FILTER_VALUE_ALL&&k===a.FILTER_VALUE_ALL&&h===a.FILTER_VALUE_ALL;this.model.setProperty("/bEnabledFilterButton",!m);return d&&g&&j&&l;},setToolbarHeight:function(){this.model.setProperty("/filterBarHeight","4rem");},onReportPress:function(e){var o=e.getParameter("item"),b=o.getText(),d=this._getReportData();if(b==='View'){C.publish(c.ON_SHOW_REPORT_REQUEST,d);}else{C.publish(c.ON_DOWNLOAD_REPORT_REQUEST,d);}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")};},onRowSelection:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject();this.elementTree.setSelectedElement(s.context.id,false);this.model.setProperty("/selectedIssue/details",s.details);}},_setSelectedRule:function(s){var b,d;if(this.model.getProperty("/visibleIssuesCount")>0){b=this.structuredIssuesModel[s.ruleLibName][s.ruleId];d=jQuery.extend(true,{},s);d.issues=b;d.resolutionUrls=b[0].resolutionUrls;this.issueTable.setSelectedIndex(0);this.model.setProperty("/selectedIssue/details",d.details);this.model.setProperty("/selectedIssue",d);this._setIconAndColorToIssue(d.issues);}else{this.model.setProperty("/selectedIssue",null);}},_setIconAndColorToIssue:function(b){b.forEach(function(e){switch(e.severity){case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:e.severityIcon=i.severityIcons.Low;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR;break;case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:e.severityIcon=i.severityIcons.Medium;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR;break;case a.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:e.severityIcon=i.severityIcons.High;e.severityColor=a.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR;break;}});}});});
