/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/support/supportRules/ui/models/SelectionUtils","sap/ui/support/supportRules/ui/models/PresetsUtils","sap/ui/core/Fragment","sap/m/MessageToast","sap/m/MessageBox","sap/ui/support/supportRules/ui/models/Documentation","sap/ui/core/ValueState","sap/ui/support/supportRules/util/Utils"],function(B,S,P,F,M,a,D,V,U){"use strict";var C={SELECT_FRAGMENT_ID:"presetsSelect",EXPORT_FRAGMENT_ID:"presetExport",IMPORT_FRAGMENT_ID:"presetImport"};var b=B.extend("sap.ui.support.supportRules.ui.controllers.PresetsController",{constructor:function(m,v){B.call(this);this.oModel=m;this.oView=v;}});b.prototype.openPresetVariant=function(){var o=this.oView.byId("presetVariantBtn");o.focus();if(!this._oPresetsPopover){this._oPresetsPopover=sap.ui.xmlfragment(C.SELECT_FRAGMENT_ID,"sap.ui.support.supportRules.ui.views.Presets",this);this.oView.addDependent(this._oPresetsPopover);}if(!this._oPresetsPopover.isOpen()){this._oPresetsPopover.setInitialFocus(F.byId(C.SELECT_FRAGMENT_ID,"select").getSelectedItem().getId());this._oPresetsPopover.openBy(o);}else{this._oPresetsPopover.close();}};b.prototype.onPresetChange=function(e){var p=e.getParameter("listItem").getBindingContext().getPath();this._applyPreset(this.oModel.getProperty(p));};b.prototype.onPresetItemPress=function(){this._oPresetsPopover.close();};b.prototype.onPresetItemDelete=function(e){var p=e.getSource().getBindingContext().getPath(),d=this.oModel.getProperty(p);var c=this.oModel.getProperty("/selectionPresets");var i=c.indexOf(d);if(i!==-1){c.splice(i,1);}if(d.selected){c[0].selected=true;this._applyPreset(c[0]);}if(P.isPersistingAllowed()){P.persistSelectionPresets();}this.oModel.setProperty("/selectionPresets",c);};b.prototype.onImportPress=function(){if(!this._oImportDialog){this._oImportDialog=sap.ui.xmlfragment(C.IMPORT_FRAGMENT_ID,"sap.ui.support.supportRules.ui.views.PresetImport",this);this.oView.addDependent(this._oImportDialog);}this._oImportDialog.open();};b.prototype.onImportFileChange=function(e){var f=e.getSource(),r=new FileReader();if(!f.getValue()){return;}this._clearImportErrors();r.onloadend=this.onImportFileLoaded.bind(this);r.onerror=this.onImportFileError.bind(this);r.readAsText(e.getParameter("files")[0],"UTF-8");};b.prototype.onImportFileMismatch=function(e){this._clearImportErrors();this._reportImportFileError("Invalid file type \""+e.getParameter("mimeType")+"\". Please, import a valid \"application/json\" file.",e.getParameter("fileName"));};b.prototype.onImportFileError=function(e){this._reportImportFileError("Error while reading file: \""+e.target.error+"\".");};b.prototype.onImportFileLoaded=function(e){var f=this._tryParseImportFile(e.target.result);if(f){this._clearImportErrors();if(!f.id){f.id=U.generateUuidV4();}if(f.dateExported){f.dateExported=new Date(f.dateExported);}this.oModel.setProperty("/currentImportData",f);if(!this._isAlreadyImported(f.id)){F.byId(C.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(true);}}};b.prototype.onImportCancelPress=function(){this._oImportDialog.close();};b.prototype.onImportFinalizePress=function(){var i=this.oModel.getProperty("/currentImportData"),m="";this._importPreset(i);m="The Rule Preset \""+i.title+"\" was successfully imported.";if(!P.isPersistingAllowed()){m+=" This import can be stored for your next visit if you check "+"\"I agree to use local storage persistency\" from Support Assistant settings.";}this._oImportDialog.close();M.show(m,{width:"50%"});};b.prototype.onImportDialogClose=function(){this._clearImportErrors();F.byId(C.IMPORT_FRAGMENT_ID,"fileUpload").setValue(null);this.oModel.setProperty("/currentImportData",null);F.byId(C.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(false);};b.prototype.onExportPress=function(){var c=this.oModel.getProperty("/selectionPresetsCurrent");if(!c.selections.length){a.error("Cannot export Rule Preset without selections.");return;}this.oModel.setProperty("/currentExportData",{"id":(c.isMySelection||c.isSystemPreset)?"":c.id,"title":c.title,"descriptionValue":c.description,"dateExportedForDisplay":new Date(),"isMySelection":c.isMySelection});if(!this._oExportDialog){this._oExportDialog=sap.ui.xmlfragment(C.EXPORT_FRAGMENT_ID,"sap.ui.support.supportRules.ui.views.PresetExport",this);this._oExportDialog.attachAfterClose(function(){this._clearValidationState();}.bind(this));this.oView.addDependent(this._oExportDialog);this.initializeExportValidations();}this._oExportDialog.open();};b.prototype.initializeExportValidations=function(){var i=this._getInputsToValidate();i.forEach(function(I){F.byId(C.EXPORT_FRAGMENT_ID,I.id).attachChange(function(e){this._changeHandler(e,I.validateMessage);}.bind(this));},this);};b.prototype._changeHandler=function(e,v){this._validateInput(e.getSource(),v);};b.prototype._validateForm=function(){var r=true,i=this._getInputsToValidate();i.forEach(function(I){var o=F.byId(C.EXPORT_FRAGMENT_ID,I.id);if(!this._validateInput(o,I.validateMessage)){r=false;}},this);return r;};b.prototype._validateInput=function(i,v){var o=i.getBinding("value"),s=V.None,c=true;try{if(i.getRequired()&&!i.getValue().trim()){throw{name:"RequiredException",message:i.getLabels()[0].getText()+" is required."};}if(o&&o.getType()){o.getType().validateValue(i.getValue());}}catch(e){var m=e.message;if(e.name==="ValidateException"&&v){m=v;}i.setValueStateText(m);s=V.Error;c=false;}i.setValueState(s);return c;};b.prototype._getInputsToValidate=function(){return[{id:"title"},{id:"presetId",validateMessage:"Invalid value. Possible characters are: a-z A-Z 0-9 - . _"}];};b.prototype._clearValidationState=function(){var i=this._getInputsToValidate();i.forEach(function(I){F.byId(C.EXPORT_FRAGMENT_ID,I.id).setValueState(V.None);});};b.prototype.onExportCancelPress=function(){this._oExportDialog.close();};b.prototype.onExportFinalizePress=function(){var i=F.byId(C.EXPORT_FRAGMENT_ID,"presetId").getValue(),t=F.byId(C.EXPORT_FRAGMENT_ID,"title").getValue(),d=F.byId(C.EXPORT_FRAGMENT_ID,"description").getValue();if(!this._validateForm()){return;}if(!i){i=U.generateUuidV4();}P.exportSelectionsToFile(i,t,d,S.getSelectedRules());M.show("The Rule Preset \""+t+"\" was successfully exported.",{width:"50%"});this._oExportDialog.close();};b.prototype.openHelp=function(){D.openTopic("3fc864acf926406194744375aa464fe7");};b.prototype._reportImportFileError=function(m,e){var E=F.byId(C.IMPORT_FRAGMENT_ID,"fileError"),f=F.byId(C.IMPORT_FRAGMENT_ID,"fileUpload"),o=F.byId(C.IMPORT_FRAGMENT_ID,"fileName"),i=F.byId(C.IMPORT_FRAGMENT_ID,"importBtn");E.setText(m).setVisible(true);o.addStyleClass("sapUiSupportToolError");this.oModel.setProperty("/currentImportData",{fileName:e||f.getValue()});i.setEnabled(false);};b.prototype._isAlreadyImported=function(p){var c=this.oModel.getProperty("/selectionPresets"),e=c.some(function(o){return o.id===p;});if(e){F.byId(C.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("A preset with ID '"+p+"' is already imported.").setVisible(true);F.byId(C.IMPORT_FRAGMENT_ID,"presetId").addStyleClass("sapUiSupportToolError");return true;}else{return false;}};b.prototype._clearImportErrors=function(){F.byId(C.IMPORT_FRAGMENT_ID,"fileError").setText("").setVisible(false);F.byId(C.IMPORT_FRAGMENT_ID,"fileName").removeStyleClass("sapUiSupportToolError");F.byId(C.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("").setVisible(false);F.byId(C.IMPORT_FRAGMENT_ID,"presetId").removeStyleClass("sapUiSupportToolError");};b.prototype._tryParseImportFile=function(f){var o={};var i="The file cannot be uploaded. Please, choose an \"application/json\" file exported from the Support Assistant.";try{o=JSON.parse(f);}catch(e){this._reportImportFileError(i);return false;}var E=[];if(!P.isValidSelectionImport(o,E)){this._reportImportFileError(i);return false;}o.fileName=F.byId(C.IMPORT_FRAGMENT_ID,"fileUpload").getValue();return o;};b.prototype._importPreset=function(i){var p=this.oModel.getProperty("/selectionPresets");var o={"id":i.id,"title":i.title,"description":i.description,"dateExported":i.dateExported,"version":i.version,"selections":i.selections};p.forEach(function(d){d.selected=false;});o.selected=true;p.push(o);this._applyPreset(o);};b.prototype._applyPreset=function(p){this.oModel.setProperty("/selectionPresetsCurrent",p);S.setSelectedRules(p.selections);if(P.isPersistingAllowed()){P.persistSelectionPresets();}};return b;});
