/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/thirdparty/jquery"],function(C,L,I,a,U,l,D,c,b,T,d,e,q){"use strict";var f=c.CalendarType;var g=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});g.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:f.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};g.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){clearTimeout(this._sInvalidateTimes);}};g.prototype.onAfterRendering=function(){_.call(this);};g.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!d(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){y.call(this,true);s.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}}};g.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){w.call(this);}else{this._sInvalidateTimes=setTimeout(w.bind(this),0);}}};g.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};g.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};g.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};g.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};g.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};g.prototype.setDate=function(i){n.call(this,i,false);return this;};g.prototype._setDate=function(i){var z=a._createLocalDate(i,true);this.setProperty("date",z,true);this._oUTCDate=i;};g.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};g.prototype.setStartDate=function(S){a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};g.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};g.prototype.displayDate=function(i){n.call(this,i,true);return this;};g.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};g.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var z=new b(i);this._oLocaleData=L.getInstance(z);}return this._oLocaleData;};g.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var z=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},z);}return this._oFormatLong;};g.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var z=new b(i);var A=this.getIntervalMinutes();var B=this._getLocaleData();var P;this._oFormatTimeAmPm=undefined;if(A%60==0){P=B.getPreferredHourSymbol();if(B.getTimePattern("short").search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},z);}}else{P=B.getTimePattern("short");P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},z);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},z);}return this._oFormatTime;};g.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var z=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},z);}return this._oFormatDate;};g.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};g.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};g.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};g.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};g.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};g.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};g.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};g.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};g.prototype._checkDateSelected=function(z){if(!(z instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var A=this.getSelectedDates();var M=new U(z.getTime());M=this._getIntervalStart(M);var B=M.getTime();for(var i=0;i<A.length;i++){var R=A[i];var E=R.getStartDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}var G=R.getEndDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);H=G.getTime();}if(B==F&&!G){S=1;break;}else if(B==F&&G){S=2;if(G&&B==H){S=5;}break;}else if(G&&B==H){S=3;break;}else if(G&&B>F&&B<H){S=4;break;}if(this.getSingleSelection()){break;}}return S;};g.prototype._getDateType=function(z){if(!(z instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var A;var S=this.getSpecialDates();var M=new U(z.getTime());M=this._getIntervalStart(M);var B=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var E=R.getStartDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}var G=R.getEndDate();var H=0;if(G){G=a._createUniversalUTCDate(G,undefined,true);G=this._getIntervalStart(G);G.setUTCMinutes(G.getUTCMinutes()+this.getIntervalMinutes()-1);H=G.getTime();}else if(E.getUTCHours()==0&&E.getUTCMinutes()==0&&E.getUTCSeconds()==0&&E.getUTCMilliseconds()==0){G=new U(E.getTime());G.setUTCDate(G.getUTCDate()+1);H=G.getTime();}if((B==F&&!G)||(B>=F&&B<=H)){A={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return A;};g.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var z=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(z<P._oMinDate.getTime()||z>P._oMaxDate.getTime()){return false;}}return true;};g.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){y.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);s.call(this,F,true);this._bMoveChange=true;}}};g.prototype.onmouseup=function(E){if(this._bMouseMove){y.call(this,true);var F=this._getDate();var z=this._oItemNavigation.getItemDomRefs();for(var i=0;i<z.length;i++){var $=q(z[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var A=q(E.target);if(A.hasClass("sapUiCalItemText")){A=A.parent();}if(A.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(A.attr("data-sap-time"),true).getTime());}s.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;v.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;v.call(this);}};g.prototype.onsapselect=function(E){var S=s.call(this,this._getDate());if(S){v.call(this);}E.stopPropagation();E.preventDefault();};g.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};g.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};g.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};g.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var z=a._createUniversalUTCDate(i,undefined,true);if(z.getTime()>=S.getTime()&&z.getTime()<E.getTime()){return true;}else{return false;}};g.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};g.prototype._getIntervalStart=function(i){var z=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=z){S.setUTCMinutes(S.getUTCMinutes()+M);}var A=new U(S.getTime());A.setUTCMinutes(A.getUTCMinutes()-M);return A;};function _(){var z=this._getDate();var Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);var A=0;var R=this.$("times").get(0);var B=this.$("times").children(".sapUiCalItem");for(var i=0;i<B.length;i++){var $=q(B[i]);if($.attr("data-sap-time")===Y){A=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,h,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,j,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(B);this._oItemNavigation.setFocusedIndex(A);this._oItemNavigation.setPageSize(B.length);}function h(i){var z=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var A=this._oItemNavigation.getItemDomRefs();var $=q(A[z]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){m.call(this,E,F,z);}}function j(i){var z=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();m.call(this,E,F,z);}}function k(i){var E=i.getParameter("event");var z=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*z);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*z);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}function m(E,F,i){if(E.button){return;}var S=s.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){y.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){x.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}function n(i,N){a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);var F=true;if(!e(this.getDate(),i)){var z=a._createUniversalUTCDate(i,undefined,true);z=this._getIntervalStart(z);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=z;}if(this.getDomRef()){if(F){o.call(this,this._oUTCDate,N);}else{p.call(this,N);}}}function o(z,N){var Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);var A=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<A.length;i++){$=q(A[i]);if($.attr("data-sap-time")==Y){if(document.activeElement!=A[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}function p(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}r.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}function r(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}function s(z,M){if(!this._checkTimeEnabled(z)){return false;}var S=this.getSelectedDates();var A;var B=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var E=this;var F;if(P&&P.getSelectedDates){E=P;}if(this.getSingleSelection()){if(S.length>0){A=S[0];F=A.getStartDate();if(F){F=a._createUniversalUTCDate(F,undefined,true);F=this._getIntervalStart(F);}}else{A=new sap.ui.unified.DateRange();E.addAggregation("selectedDates",A,true);}if(this.getIntervalSelection()&&(!A.getEndDate()||M)&&F){var G;if(z.getTime()<F.getTime()){G=F;F=z;if(!M){A.setProperty("startDate",a._createLocalDate(new Date(F.getTime()),true),true);A.setProperty("endDate",a._createLocalDate(new Date(G.getTime()),true),true);}}else if(z.getTime()>=F.getTime()){G=z;if(!M){A.setProperty("endDate",a._createLocalDate(new Date(G.getTime()),true),true);}}t.call(this,F,G);}else{t.call(this,z);A.setProperty("startDate",a._createLocalDate(new Date(z.getTime()),true),true);A.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var H=this._checkDateSelected(z);if(H>0){for(i=0;i<S.length;i++){F=S[i].getStartDate();if(F){F=a._createUniversalUTCDate(F,undefined,true);F=this._getIntervalStart(F);if(z.getTime()==F.getTime()){E.removeAggregation("selectedDates",i,true);break;}}}}else{A=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(z.getTime()),true)});E.addAggregation("selectedDates",A,true);}Y=this._oFormatYyyyMMddHHmm.format(z.getJSDate(),true);for(i=0;i<B.length;i++){$=q(B[i]);if($.attr("data-sap-time")==Y){if(H>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}function t(S,E){var z=this._oItemNavigation.getItemDomRefs();var $;var i=0;var A=false;var B=false;if(!E){var Y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<z.length;i++){$=q(z[i]);A=false;B=false;if($.attr("data-sap-time")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");A=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}u.call(this,$,A,B);}}else{var F;for(i=0;i<z.length;i++){$=q(z[i]);A=false;B=false;F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");A=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&F.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");B=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&F.getTime()>S.getTime()&&F.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&F.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");B=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}u.call(this,$,A,B);}}}function u($,S,E){if(!this.getIntervalSelection()){return;}var z="";var A=[];var B=this.getId();var F=false;z=$.attr("aria-describedby");if(z){A=z.split(" ");}var G=-1;var H=-1;for(var i=0;i<A.length;i++){var J=A[i];if(J==(B+"-Start")){G=i;}if(J==(B+"-End")){H=i;}}if(G>=0&&!S){A.splice(G,1);F=true;if(H>G){H--;}}if(H>=0&&!E){A.splice(H,1);F=true;}if(G<0&&S){A.push(B+"-Start");F=true;}if(H<0&&E){A.push(B+"-End");F=true;}if(F){z=A.join(" ");$.attr("aria-describedby",z);}}function v(){if(this._bMouseMove){y.call(this,true);}this.fireSelect();}function w(){this._sInvalidateTimes=undefined;p.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}function x(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}function y(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}return g;});
