/*
 * Decompiled with CFR 0.152.
 */
package fr.dutra.tools.maven.deptree.core;

import fr.dutra.tools.maven.deptree.core.AbstractLineBasedParser;
import fr.dutra.tools.maven.deptree.core.Node;
import fr.dutra.tools.maven.deptree.core.ParseException;
import java.io.IOException;
import java.io.Reader;

public class TextParser
extends AbstractLineBasedParser {
    @Override
    public Node parse(Reader reader) throws ParseException {
        try {
            this.lines = this.splitLines(reader);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        if (this.lines.isEmpty()) {
            return null;
        }
        return this.parseInternal(0);
    }

    private Node parseInternal(int depth) {
        Node node = this.parseLine();
        ++this.lineIndex;
        while (this.lineIndex < this.lines.size() && this.computeDepth((String)this.lines.get(this.lineIndex)) > depth) {
            Node child = this.parseInternal(depth + 1);
            if (node == null) continue;
            node.addChildNode(child);
        }
        return node;
    }

    private int computeDepth(String line) {
        return this.getArtifactIndex(line) / 3;
    }

    private Node parseLine() {
        String line = (String)this.lines.get(this.lineIndex);
        String artifact = line.contains("active project artifact:") ? this.extractActiveProjectArtifact() : this.extractArtifact(line);
        return this.parseArtifactString(artifact);
    }

    private String extractArtifact(String line) {
        return line.substring(this.getArtifactIndex(line));
    }

    private int getArtifactIndex(String line) {
        block3: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case ' ': 
                case '+': 
                case '-': 
                case '\\': 
                case '|': 
                case '\u00b3': 
                case '\u00c0': 
                case '\u00c3': 
                case '\u00c4': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return -1;
    }
}

